/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.command;

import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.command.Command;
import com.ibm.ram.internal.cli.command.SearchCommand;
import com.ibm.ram.internal.cli.commandline.CommandLine;
import com.ibm.ram.internal.cli.commandline.Option;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class RetireCommand
extends Command {
    public static final String NAME = "retire";

    public RetireCommand(String[] args) {
        super(args);
    }

    @Override
    public IStatus execute() {
        Status status = this.getRAMSession();
        if (!status.isOK()) {
            return status;
        }
        List<AssetIdentification> assetIdList = SearchCommand.getAssetIdentification(this.ramSession, this.packageId, this.packageVersion, this.queryString, true, -1);
        if (assetIdList.isEmpty()) {
            String message = this.packageVersion != null && !this.packageVersion.isEmpty() ? MessageFormat.format(Messages.getString("GetCommand.3"), this.packageId, this.packageVersion) : MessageFormat.format(Messages.getString("GetCommand.9"), this.packageId);
            status = new Status(4, this.getClass().getName(), message);
        }
        ArrayList<RAMAsset> assetList = null;
        if (status.isOK()) {
            assetList = new ArrayList<RAMAsset>();
            for (AssetIdentification anAssetId : assetIdList) {
                try {
                    assetList.add(this.ramSession.getAsset(anAssetId));
                }
                catch (Exception exception) {
                    String message = this.packageVersion != null && !this.packageVersion.isEmpty() ? MessageFormat.format(Messages.getString("GetCommand.3"), this.packageId, this.packageVersion) : MessageFormat.format(Messages.getString("GetCommand.9"), this.packageId);
                    status = new Status(4, this.getClass().getName(), message);
                    break;
                }
            }
        }
        if (status.isOK()) {
            status = this.changeState(assetList, RAMAction.RETIRE, "com.ibm.ram.internal.retire.state.phasedOut", "com.ibm.ram.internal.retire.state.retired");
        }
        if (status.isOK() || status.matches(1)) {
            status = this.changeState(assetList, RAMAction.ARCHIVE, "com.ibm.ram.internal.retire.state.retired");
        }
        this.releaseRAMSession();
        return status;
    }

    @Override
    public IStatus validate() {
        CommandLine commandLine = new CommandLine(this.cmdArgs);
        commandLine.addOption(new Option("-config", true));
        commandLine.addOption(new Option("-q", true));
        IStatus status = super.validate(commandLine);
        if (!status.isOK()) {
            return status;
        }
        if (this.packageId == null || this.packageId.isEmpty()) {
            return new Status(4, this.getClass().getName(), Messages.getString("CommandLine.6"));
        }
        this.queryString = commandLine.getOption("-q").getValue();
        this.createConfiguration(commandLine.getOption("-config").getValue());
        status = this.config.validate();
        return status;
    }

    public IStatus changeState(List<RAMAsset> assetList, RAMAction action, String ... ignoreStates) {
        Status status = null;
        if (assetList != null && !assetList.isEmpty()) {
            boolean assetsQueued = false;
            List<String> ignoreStateList = Arrays.asList(ignoreStates);
            for (RAMAsset anAsset : assetList) {
                String currentState = anAsset.getState().getIdentifier();
                if (ignoreStateList.contains(currentState)) continue;
                anAsset.setAction(action);
                this.ramSession.queueAssetForPut(anAsset);
                assetsQueued = true;
            }
            if (assetsQueued) {
                try {
                    status = this.ramSession.putAssets((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    String message = MessageFormat.format(Messages.getString("RetireCommand.3"), this.packageId);
                    if (e.getLocalizedMessage() != null) {
                        message = String.valueOf(message) + "\n" + e.getLocalizedMessage();
                    }
                    status = new Status(4, this.getClass().getName(), message);
                }
            }
        }
        if (status == null) {
            status = new Status(0, this.getClass().getName(), null);
        }
        return status;
    }
}

