/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.access.ws;

import java.io.IOException;
import java.io.Writer;
import org.apache.axis.components.encoding.DefaultXMLEncoder;
import org.apache.axis.i18n.Messages;
import org.apache.axis.utils.XMLChar;

public class RAMXMLEncoder
extends DefaultXMLEncoder {
    public RAMXMLEncoder() {
        super("UTF-8");
    }

    @Override
    public void writeEncoded(Writer writer, String xmlString) throws IOException {
        if (xmlString == null) {
            return;
        }
        int length = xmlString.length();
        int i = 0;
        while (i < length) {
            char character = xmlString.charAt(i);
            switch (character) {
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '\"': {
                    writer.write("&quot;");
                    break;
                }
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '\n': {
                    writer.write("\n");
                    break;
                }
                case '\r': {
                    writer.write("\r");
                    break;
                }
                case '\t': {
                    writer.write("\t");
                    break;
                }
                default: {
                    if (character < ' ') {
                        throw new IllegalArgumentException(Messages.getMessage("invalidXmlCharacter00", Integer.toHexString(character), xmlString.substring(0, i)));
                    }
                    if (character > '\u007f') {
                        if (XMLChar.isHighSurrogate(character)) {
                            char nextCharacter = xmlString.charAt(i + 1);
                            if (XMLChar.isLowSurrogate(nextCharacter)) {
                                int newSurrogateChar = XMLChar.supplemental(character, nextCharacter);
                                writer.write("&#x");
                                writer.write(Integer.toHexString(newSurrogateChar).toUpperCase());
                                writer.write(";");
                                ++i;
                                break;
                            }
                            writer.write("&#x");
                            writer.write(Integer.toHexString(character).toUpperCase());
                            writer.write(";");
                            break;
                        }
                        writer.write("&#x");
                        writer.write(Integer.toHexString(character).toUpperCase());
                        writer.write(";");
                        break;
                    }
                    writer.write(character);
                }
            }
            ++i;
        }
    }
}

