/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.RAMPropertyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.CallTarget;

public class IterateTask
extends Task {
    String target;
    String param;
    String collection;
    boolean inheritAll = false;

    public void execute() throws BuildException {
        try {
            super.execute();
            if (this.target == null) {
                throw new BuildException("target must be specified");
            }
            if (this.param == null) {
                throw new BuildException("param must be specified");
            }
            if (this.collection == null) {
                throw new BuildException("collection must be specified");
            }
            _Collection c = new _Collection(this.collection);
            for (Object obj : c) {
                this.executeTarget(obj);
            }
        }
        catch (Exception e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
    }

    private void executeTarget(Object obj) {
        CallTarget task = (CallTarget)this.getProject().createTask("antcall");
        task.setOwningTarget(this.getOwningTarget());
        task.init();
        task.setTarget(this.target);
        task.setInheritAll(this.inheritAll);
        task.setInheritRefs(true);
        Project project = task.getProject();
        project.addReference(this.param, obj);
        task.execute();
    }

    public String getCollection() {
        return this.collection;
    }

    public boolean getInheritAll() {
        return this.inheritAll;
    }

    public String getParam() {
        return this.param;
    }

    public String getTarget() {
        return this.target;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setInheritAll(boolean inheritAll) {
        this.inheritAll = inheritAll;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    class _Collection
    implements Iterable {
        String property;

        public _Collection(String property) {
            this.property = property;
        }

        public Iterator iterator() {
            Object obj = RAMPropertyUtil.getPropertyValue(IterateTask.this.getProject(), this.property);
            if (obj instanceof Collection) {
                return ((Collection)obj).iterator();
            }
            if (obj instanceof Object[]) {
                return Arrays.asList((Object[])obj).iterator();
            }
            if (obj == null) {
                return new ArrayList().iterator();
            }
            throw new BuildException("The value you specified for collection (\"" + this.property + "\") is not valid. Be sure you're not using ${} syntax.");
        }
    }
}

