/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetValidation;
import com.ibm.ram.client.RAMComment;
import com.ibm.ram.client.RAMStateHistory;
import com.ibm.ram.client.RAMVote;
import com.ibm.ram.client.RCAssetNotFoundException;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.Comment;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.Search;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ModifyTask
extends RAMTask {
    private String guid;
    private Asset asset;
    private Search search;
    private String action;
    private String actionId;
    private String vote;
    private Comment comment;
    private Boolean lockAsset;
    private String lockComment;
    private boolean createNew = true;

    public void setCreateNew(boolean flag) {
        this.createNew = flag;
    }

    public void add(Asset asset) {
        if (this.asset != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)asset);
        } else {
            if (this.getSession() != null) {
                asset.setSession(this.getSession());
            }
            asset.setTask(this);
            this.asset = asset;
        }
    }

    public void add(Comment comment) {
        if (this.comment != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)comment);
        } else {
            this.comment = comment;
        }
    }

    public void add(Search search) {
        if (this.search != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)search);
        } else {
            if (this.getSession() != null) {
                search.setSession(this.getSession());
            }
            search.setTask(this);
            this.search = search;
        }
    }

    public boolean isLock() {
        return this.lockAsset != null ? this.lockAsset : false;
    }

    public void setLock(boolean lock) {
        if (this.lockAsset != null && !this.lockAsset.booleanValue()) {
            LoggingUtil.warn((ProjectComponent)this, "Cannot set both lock and unlock asset.");
        } else {
            this.lockAsset = lock ? Boolean.valueOf(true) : null;
        }
    }

    public boolean isUnlock() {
        return this.lockAsset != null ? !this.lockAsset.booleanValue() : false;
    }

    public void setUnlock(boolean unlock) {
        if (this.lockAsset != null && this.lockAsset.booleanValue()) {
            LoggingUtil.warn((ProjectComponent)this, "Cannot set both lock and unlock asset.");
        } else {
            this.lockAsset = unlock ? Boolean.valueOf(false) : null;
        }
    }

    public String getLockChangeComment() {
        return this.lockComment;
    }

    public void setLockChangeComment(String lockComment) {
        this.lockComment = lockComment;
    }

    @Override
    public void execute() throws BuildException {
        block39: {
            try {
                RAMStateHistory stateHistory;
                super.execute();
                if (this.getSession() == null) {
                    LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.MustSpecifyAttribute"), "server", this.getProject().getElementName((Object)this)));
                }
                if (this.asset == null) break block39;
                if (this.search != null && this.search.getAssets() != null && this.search.getAssets().length > 0) {
                    this.asset.setAsset(this.search.getAssets()[0]);
                }
                if (this.asset.getAsset() == null) {
                    String guid;
                    String version = this.asset.getNewVersion();
                    if (version == null) {
                        LoggingUtil.error((ProjectComponent)this.asset, MessageFormat.format(ClientMessages.getString((String)"Ant.ReversionTask.MustSetNewVersion"), String.valueOf(this.asset.getName()) + " [" + version + "]"));
                    }
                    if ((guid = this.asset.getNewGuid()) != null) {
                        this.asset.setAsset(this.getSession().createAsset(guid, version));
                    } else {
                        this.asset.setAsset(this.getSession().createAsset(version));
                    }
                }
                if (this.lockAsset != null) {
                    if (this.lockAsset.booleanValue()) {
                        this.asset.getAsset().lockAsset(this.getLockChangeComment());
                    } else {
                        this.asset.getAsset().unlockAsset(this.getLockChangeComment());
                    }
                }
                if (this.action != null || this.actionId != null) {
                    RAMAction[] availableActions = this.asset.getAsset().getAvailableActions();
                    ArrayList<RAMAction> matchingActions = new ArrayList<RAMAction>();
                    RAMAction[] rAMActionArray = availableActions;
                    int n = availableActions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RAMAction availableAction = rAMActionArray[n2];
                        if (availableAction.getName().equalsIgnoreCase(this.action) || availableAction.getIdentifier().equals(this.actionId)) {
                            matchingActions.add(availableAction);
                        }
                        ++n2;
                    }
                    if (matchingActions.size() == 1) {
                        RAMAction actionToTake = (RAMAction)matchingActions.get(0);
                        LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ModifyTask.TakingAction"), actionToTake.getName()));
                        this.asset.getAsset().setAction(actionToTake);
                    } else if (matchingActions.size() == 0) {
                        if (this.action != null) {
                            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ModifyTask.NoActionFoundForName"), this.action, this.getActionNamesString(Arrays.asList(availableActions))));
                        } else if (this.actionId != null) {
                            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ModifyTask.NoActionFoundForId"), this.actionId, this.getActionIdsString(Arrays.asList(availableActions))));
                        }
                    } else {
                        LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ModifyTask.MultipleActionsFoundForName"), this.action, this.getActionNamesString(matchingActions)));
                        this.asset.getAsset().setAction((RAMAction)matchingActions.get(0));
                    }
                }
                if (this.vote != null) {
                    stateHistory = this.asset.getAsset().getCurrentStateHistory();
                    RAMVote ramVote = new RAMVote();
                    if (RAMVote.APPROVE.equalsIgnoreCase(this.vote) || "approved".equalsIgnoreCase(this.vote)) {
                        ramVote.setVoteChoice(RAMVote.APPROVE);
                    } else if (RAMVote.REJECT.equalsIgnoreCase(this.vote) || "rejected".equalsIgnoreCase(this.vote)) {
                        ramVote.setVoteChoice(RAMVote.REJECT);
                    } else {
                        LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ModifyTask.InvalidVote"), this.vote));
                    }
                    if (this.comment != null) {
                        ramVote.setComment(this.comment.getValue());
                    }
                    stateHistory.castVote(ramVote);
                } else if (this.comment != null) {
                    stateHistory = this.asset.getAsset().getCurrentStateHistory();
                    RAMComment ramComment = new RAMComment();
                    ramComment.setBody(this.comment.getValue());
                    stateHistory.comment(ramComment);
                }
                if (!this.createNew) {
                    LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ModifyTask.CreateNew"), this.createNew));
                    RAMAsset assetIsThere = null;
                    try {
                        assetIsThere = this.getSession().getAsset(new AssetIdentification(this.asset.getGuid(), this.asset.getVersion()));
                        assetIsThere.refresh();
                    }
                    catch (RCAssetNotFoundException e) {
                        LoggingUtil.info((ProjectComponent)this.asset, MessageFormat.format(ClientMessages.getString((String)"Ant.ModifyTask.TargetAssetNotFound"), Boolean.toString(this.createNew)));
                        throw e;
                    }
                    catch (RAMRuntimeException e) {
                        if (MessageFormat.format(ClientMessages.getString((String)"RAMSession.AssetNotFoundInServer"), assetIsThere.toString()).equalsIgnoreCase(e.getLocalizedMessage())) {
                            LoggingUtil.info((ProjectComponent)this.asset, MessageFormat.format(ClientMessages.getString((String)"Ant.ModifyTask.TargetAssetNotFound"), Boolean.toString(this.createNew)));
                        }
                        throw e;
                    }
                }
                this.asset.commitModel();
                if (this.asset.getAsset().getAction() == RAMAction.UPDATE_DRAFT) {
                    this.asset.getAsset().setAction(RAMAction.UPDATE);
                }
                LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ModifyTask.ModifyingAsset"), String.valueOf(this.asset.getAsset().getName()) + " [" + this.asset.getAsset().getIdentification().getVersion() + "]"));
                RAMAssetValidation[] errors = this.asset.getAsset().validate();
                if (errors != null && errors.length > 0) {
                    StringBuffer buffer = new StringBuffer("\n");
                    buffer.append(ClientMessages.getString((String)"Ant.ValidationErrorsExist"));
                    buffer.append("\n");
                    int i = 0;
                    while (i < errors.length) {
                        buffer.append(errors[i].getMessage());
                        buffer.append("\n");
                        ++i;
                    }
                    LoggingUtil.error((ProjectComponent)this, buffer.toString());
                } else {
                    this.getSession().put((IRAMSessionObject)this.asset.getAsset(), (IProgressMonitor)new NullProgressMonitor());
                    if (this.getGuidProperty() != null && this.getGuidProperty().length() > 0) {
                        this.getProject().setProperty(this.getGuidProperty(), this.asset.getAsset().getIdentification().getGUID());
                    }
                }
            }
            catch (Exception e) {
                LoggingUtil.error((ProjectComponent)this, (Throwable)e);
            }
        }
    }

    private String getActionNamesString(List<RAMAction> actions) {
        StringBuffer buffer = new StringBuffer();
        if (actions != null && !actions.isEmpty()) {
            for (RAMAction action : actions) {
                buffer.append(action.getName());
                buffer.append(", ");
            }
            buffer.setLength(buffer.length() - 2);
        }
        return buffer.toString();
    }

    private String getActionIdsString(List<RAMAction> actions) {
        StringBuffer buffer = new StringBuffer();
        if (actions != null) {
            for (RAMAction action : actions) {
                buffer.append(action.getIdentifier());
                buffer.append(", ");
            }
            buffer.setLength(buffer.length() - 2);
        }
        return buffer.toString();
    }

    @Override
    public List getChildren() {
        ArrayList<RAMDataType> children = new ArrayList<RAMDataType>();
        if (this.asset != null) {
            children.add(this.asset);
        }
        if (this.search != null) {
            children.add(this.search);
        }
        return children;
    }

    public String getGuidProperty() {
        return this.guid;
    }

    public void setGuidProperty(String guid) {
        this.guid = guid;
    }

    public String getVote() {
        return this.vote;
    }

    public void setAction(String action) {
        if (this.actionId != null) {
            LoggingUtil.errorExclusiveAttributes((ProjectComponent)this, "action, actionId");
        }
        this.action = action;
    }

    public void setActionId(String actionId) {
        if (this.action != null) {
            LoggingUtil.errorExclusiveAttributes((ProjectComponent)this, "action, actionId");
        }
        this.actionId = actionId;
    }

    public void setVote(String vote) {
        this.vote = vote;
    }
}

