/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.DateValue;
import com.ibm.ram.internal.client.ant.types.Description;
import com.ibm.ram.internal.client.ant.types.LinkValue;
import com.ibm.ram.internal.client.ant.types.Name;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.ResourceValue;
import com.ibm.ram.internal.client.ant.types.Select;
import com.ibm.ram.internal.client.ant.types.ValidValue;
import com.ibm.ram.internal.client.ant.types.Value;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;

public class Attribute
extends RAMDataType {
    private static final String SINGLE_SELECT = "single";
    private static final String MULTI_SELECT = "multi";
    private String name;
    private Name newName;
    private Description newDescription;
    private List setValues = new ArrayList();
    private List validValuesList = new ArrayList();
    private Select select;
    private String[] validValues;
    private RAMAssetAttribute attribute;
    private RAMAsset asset;

    public void add(ValidValue validValue) {
        this.validValuesList.add(validValue);
    }

    public void add(Value value) {
        this.setValues.add(value);
    }

    public void add(Description description) {
        this.newDescription = description;
    }

    public void add(Select select) {
        this.select = select;
    }

    public void add(Name name) {
        this.newName = name;
    }

    private void validateValues() {
        block3: {
            String type;
            block5: {
                block4: {
                    if (this.getAttribute() == null) break block3;
                    type = this.getAttribute().getType();
                    if (!AssetAttribute.TYPE_DATE.equals(type)) break block4;
                    for (Object value : this.setValues) {
                        if (value instanceof DateValue) continue;
                        LoggingUtil.error((ProjectComponent)this, "Use <dateValue> for attributes of type date");
                    }
                    break block3;
                }
                if (!AssetAttribute.TYPE_LINK.equals(type)) break block5;
                for (Object value : this.setValues) {
                    if (value instanceof LinkValue) continue;
                    LoggingUtil.error((ProjectComponent)this, "Use <linkValue> for attributes of type link");
                }
                break block3;
            }
            if (!AssetAttribute.TYPE_RESOURCE.equals(type)) break block3;
            for (Object value : this.setValues) {
                if (value instanceof ResourceValue) continue;
                LoggingUtil.error((ProjectComponent)this, "Use <resourceValue> for attributes of type resource");
            }
        }
    }

    @Override
    public void commitModel() {
        if (this.getAttribute() != null) {
            this.validateValues();
            RAMAssetAttribute assetAttribute = (RAMAssetAttribute)this.asset.getAssetAttribute(this.getName());
            if (assetAttribute != null) {
                assetAttribute.setValues(this.getValues());
            }
        } else {
            AssetAttribute attr = new AssetAttribute();
            attr.setName(this.getName());
            attr.setValues(this.getValues());
            AssetAttribute[] attrs = this.asset.getAssetAttributes();
            AssetAttribute[] newAttrs = new AssetAttribute[attrs.length + 1];
            System.arraycopy(attrs, 0, newAttrs, 0, attrs.length);
            newAttrs[newAttrs.length - 1] = attr;
            this.asset.setAssetAttributes(newAttrs);
        }
    }

    public String[] getValues() {
        if (this.getAttribute() != null && AssetAttribute.TYPE_RESOURCE.equals(this.getAttribute().getType())) {
            JsonObject json = new JsonObject();
            JsonArray links = new JsonArray();
            for (Object v : this.setValues) {
                if (!(v instanceof ResourceValue)) continue;
                ResourceValue value = (ResourceValue)((Object)v);
                JsonObject link = new JsonObject();
                link.addProperty("url", value.getUrl());
                if (value.getUserId() != null) {
                    link.addProperty("userId", value.getUserId());
                }
                if (value.getLabel() != null) {
                    link.addProperty("label", value.getLabel());
                }
                links.add((JsonElement)link);
            }
            json.add("links", (JsonElement)links);
            return new String[]{json.toString()};
        }
        String[] values = new String[this.setValues.size()];
        int i = 0;
        while (i < this.setValues.size()) {
            values[i] = ((Value)((Object)this.setValues.get(i))).getValue();
            ++i;
        }
        return values;
    }

    @Override
    public Object getModel() {
        return this.getAttribute();
    }

    public String getNewName() {
        if (this.newName != null) {
            return this.newName.getValue();
        }
        return null;
    }

    public String getNewDescription() {
        if (this.newDescription != null) {
            return this.newDescription.getValue();
        }
        return null;
    }

    public RAMAssetAttribute getAttribute() {
        if (this.isReference()) {
            return this.getRef().getAttribute();
        }
        if (this.attribute != null) {
            return this.attribute;
        }
        if (this.name != null) {
            try {
                if (this.getParent() instanceof Asset) {
                    this.attribute = this.getAttributeFromAsset();
                }
                if (this.attribute == null) {
                    this.attribute = this.getAttributeFromServer();
                }
            }
            catch (RAMRuntimeException e) {
                LoggingUtil.errorGettingObject((ProjectComponent)this, this.name, e);
            }
        }
        return this.attribute;
    }

    private RAMAssetAttribute getAttributeFromAsset() {
        RAMAsset asset = (RAMAsset)this.getParent().getModel();
        if (asset != null) {
            return (RAMAssetAttribute)asset.getAssetAttribute(this.name);
        }
        return null;
    }

    private RAMAssetAttribute getAttributeFromServer() {
        RAMSession session = this.getSession();
        if (session != null) {
            return session.getAssetAttribute(this.name);
        }
        return null;
    }

    protected Attribute getRef() {
        return (Attribute)((Object)this.getCheckedRef(Attribute.class, Attribute.class.getName()));
    }

    public String getName() {
        return this.name;
    }

    public String[] getValidValues() {
        if (this.validValuesList.isEmpty()) {
            return null;
        }
        if (this.validValues == null) {
            this.validValues = new String[this.validValuesList.size()];
            int i = 0;
            while (i < this.validValues.length) {
                this.validValues[i] = ((ValidValue)((Object)this.validValuesList.get(i))).getValue();
                ++i;
            }
        }
        return this.validValues;
    }

    public boolean isSingleSelect() {
        return this.select == null || SINGLE_SELECT.equalsIgnoreCase(this.select.getValue());
    }

    public boolean isMultiSelect() {
        return this.select != null && MULTI_SELECT.equalsIgnoreCase(this.select.getValue());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAttribute(RAMAssetAttribute attribute) {
        this.attribute = attribute;
    }

    public void setAsset(RAMAsset asset) {
        this.asset = asset;
    }

    @Override
    public List getChildren() {
        ArrayList<Select> children = new ArrayList<Select>();
        children.addAll(this.validValuesList);
        children.add(this.select);
        return children;
    }
}

