/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.RAMRichSession;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Password;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.SubBuildListener;
import org.eclipse.emf.ecore.EPackage;

public class Server
extends RAMDataType {
    private String url;
    private String username;
    private String password;
    private Password passwordType;
    private static Field antLoaderProjectField;

    static {
        try {
            antLoaderProjectField = AntClassLoader.class.getDeclaredField("project");
            antLoaderProjectField.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
    }

    @Override
    public RAMSession getSession() {
        block14: {
            if (super.getSession() == null) {
                if (this.getUrl() == null) {
                    LoggingUtil.errorRequiredAttribute((ProjectComponent)this, "url");
                }
                if (this.getUsername() == null) {
                    LoggingUtil.errorRequiredAttribute((ProjectComponent)this, "username");
                }
                if (this.getPassword() == null && this.getPasswordtype() == null) {
                    LoggingUtil.error((ProjectComponent)this, "Either password or password type must be set.");
                }
                try {
                    ClassLoader cl;
                    LoggingUtil.verbose((ProjectComponent)this, "Creating session for user " + this.username + " on server " + this.url);
                    if (this.passwordType == null) {
                        this.setSession((RAMSession)new RAMRichSession(this.getUrl(), this.getUsername(), this.getPassword()));
                    } else {
                        this.setSession((RAMSession)new RAMRichSession(this.getUrl(), this.getUsername(), this.getPasswordtype().getRAMPassword(), null));
                    }
                    final RAMSession finalizeSession = this.getSession();
                    if (finalizeSession != null) {
                        this.getProject().addBuildListener((BuildListener)new SubBuildListener(){
                            Project proj;
                            {
                                this.proj = Server.this.getProject();
                            }

                            public void subBuildFinished(BuildEvent event) {
                                if (this.proj == event.getProject()) {
                                    LoggingUtil.verbose((ProjectComponent)Server.this, "Releasing session for user " + Server.this.username + " on server " + Server.this.url);
                                    try {
                                        finalizeSession.release();
                                    }
                                    catch (Exception exception) {
                                        LoggingUtil.verbose((ProjectComponent)Server.this, "An error occured releasing the session");
                                    }
                                    this.proj.removeBuildListener((BuildListener)this);
                                    this.proj = null;
                                }
                            }

                            public void buildStarted(BuildEvent event) {
                            }

                            public void messageLogged(BuildEvent event) {
                            }

                            public void targetFinished(BuildEvent event) {
                            }

                            public void targetStarted(BuildEvent event) {
                            }

                            public void taskFinished(BuildEvent event) {
                            }

                            public void taskStarted(BuildEvent event) {
                            }

                            public void buildFinished(BuildEvent event) {
                                LoggingUtil.verbose((ProjectComponent)Server.this, "Releasing session for user " + Server.this.username + " on server " + Server.this.url);
                                try {
                                    finalizeSession.release();
                                }
                                catch (Exception exception) {
                                    LoggingUtil.verbose((ProjectComponent)Server.this, "An error occured releasing the session");
                                }
                                this.proj.removeBuildListener((BuildListener)this);
                                this.proj = null;
                            }

                            public void subBuildStarted(BuildEvent event) {
                            }
                        });
                    }
                    if (antLoaderProjectField == null || (cl = ((Object)((Object)this)).getClass().getClassLoader()) == Thread.currentThread().getContextClassLoader() || !(cl instanceof AntClassLoader) || EPackage.Registry.INSTANCE.getClass().getClassLoader() == cl) break block14;
                    try {
                        final Project clProject = (Project)antLoaderProjectField.get(cl);
                        if (clProject != null) {
                            clProject.addBuildListener((BuildListener)new SubBuildListener(){

                                public void taskStarted(BuildEvent event) {
                                }

                                public void taskFinished(BuildEvent event) {
                                }

                                public void targetStarted(BuildEvent event) {
                                }

                                public void targetFinished(BuildEvent event) {
                                }

                                public void messageLogged(BuildEvent event) {
                                }

                                public void buildStarted(BuildEvent event) {
                                }

                                public void buildFinished(BuildEvent event) {
                                }

                                public void subBuildStarted(BuildEvent event) {
                                }

                                public void subBuildFinished(BuildEvent event) {
                                    if (clProject == event.getProject()) {
                                        Iterator iv = EPackage.Registry.INSTANCE.values().iterator();
                                        while (iv.hasNext()) {
                                            Object o = iv.next();
                                            if (o == null || o.getClass().getClassLoader() != cl) continue;
                                            iv.remove();
                                        }
                                        clProject.removeBuildListener((BuildListener)this);
                                    }
                                }
                            });
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (ClassCastException classCastException) {}
                }
                catch (RAMRuntimeException e) {
                    LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ErrorConnectingToServer"), this.getUrl()), (Throwable)e);
                }
            }
        }
        return super.getSession();
    }

    @Override
    public List getChildren() {
        return null;
    }

    @Override
    public Object getModel() {
        if (this.isReference()) {
            return this.getRef().getModel();
        }
        return this.getSession();
    }

    public String getUrl() {
        if (this.isReference()) {
            return this.getRef().getUrl();
        }
        return this.url;
    }

    protected Server getRef() {
        return (Server)((Object)this.getCheckedRef(Server.class, Server.class.getName()));
    }

    public void setUrl(String url) {
        this.checkAttributesAllowed();
        this.url = url;
    }

    public String getUsername() {
        if (this.isReference()) {
            return this.getRef().getUsername();
        }
        return this.username;
    }

    public void setUsername(String username) {
        this.checkAttributesAllowed();
        this.username = username;
    }

    public String getPassword() {
        if (this.isReference()) {
            return this.getRef().getPassword();
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.checkAttributesAllowed();
        if (this.passwordType != null) {
            throw new BuildException("Both password and password type may not be set. They are mutually exclusive.", this.getLocation());
        }
        this.password = password;
    }

    public Password getPasswordtype() {
        if (this.isReference()) {
            return this.getRef().getPasswordtype();
        }
        return this.passwordType;
    }

    public void addConfigured(Password passwordType) {
        this.checkChildrenAllowed();
        if (this.passwordType != null) {
            throw new BuildException("Only one Password element allowed.", this.getLocation());
        }
        if (this.password != null) {
            throw new BuildException("Both password and password type may not be set. They are mutually exclusive.", this.getLocation());
        }
        this.passwordType = passwordType;
    }
}

