/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.common.data.AssetActivity;
import com.ibm.ram.common.data.CustomAssetActivity;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.AssetList;
import com.ibm.ram.internal.client.ant.types.Search;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class RecordActivityTask
extends RAMTask {
    private List assets = new ArrayList();
    private List assetLists = new ArrayList();
    private List searches = new ArrayList();
    private String name;
    private String description;
    private long numberData;
    private int activityId;

    public void add(Asset asset) {
        if (this.getSession() != null) {
            asset.setSession(this.getSession());
        }
        asset.setTask(this);
        this.assets.add(asset);
    }

    public void add(AssetList assetlist) {
        if (this.getSession() != null) {
            assetlist.setSession(this.getSession());
        }
        assetlist.setTask(this);
        this.assetLists.add(assetlist);
    }

    public void add(Search search) {
        if (this.getSession() != null) {
            search.setSession(this.getSession());
        }
        search.setTask(this);
        this.searches.add(search);
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.assetLists);
        children.addAll(this.assets);
        children.addAll(this.searches);
        return children;
    }

    @Override
    public void execute() throws BuildException {
        try {
            int i;
            RAMAsset[] ramAssets;
            super.execute();
            CustomAssetActivity activity = new CustomAssetActivity();
            activity.setTypeId(this.getActivityId());
            activity.setLabel(this.getName());
            activity.setDescription(this.getDescription());
            activity.setNumberData(this.getNumberData());
            for (Asset asset : this.assets) {
                RAMAsset ramAsset = asset.getAsset();
                ramAsset.recordActivity((AssetActivity)activity);
                this.getSession().queueAssetForPut(ramAsset);
            }
            for (AssetList assetlist : this.assetLists) {
                ramAssets = assetlist.getAssets();
                i = 0;
                while (i < ramAssets.length) {
                    ramAssets[i].recordActivity((AssetActivity)activity);
                    this.getSession().queueAssetForPut(ramAssets[i]);
                    ++i;
                }
            }
            for (Search search : this.searches) {
                ramAssets = search.getAssets();
                i = 0;
                while (i < ramAssets.length) {
                    ramAssets[i].recordActivity((AssetActivity)activity);
                    this.getSession().queueAssetForPut(ramAssets[i]);
                    ++i;
                }
            }
            try {
                this.getSession().putAssets((IProgressMonitor)new NullProgressMonitor());
            }
            catch (RAMRuntimeException e) {
                LoggingUtil.error((ProjectComponent)this, (Throwable)e);
            }
            catch (IOException e) {
                LoggingUtil.error((ProjectComponent)this, (Throwable)e);
            }
        }
        catch (Exception e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getNumberData() {
        return this.numberData;
    }

    public void setNumberData(long numberData) {
        this.numberData = numberData;
    }

    public int getActivityId() {
        return this.activityId;
    }

    public void setActivityId(int activityId) {
        this.activityId = activityId;
    }
}

