/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.InstanceCreator;
import com.google.gson.ObjectConstructor;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.TypeInfo;
import com.google.gson.TypeUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MappedObjectConstructor
implements ObjectConstructor {
    private static final Logger log = Logger.getLogger(MappedObjectConstructor.class.getName());
    private final ParameterizedTypeHandlerMap<InstanceCreator<?>> instanceCreatorMap;

    public MappedObjectConstructor(ParameterizedTypeHandlerMap<InstanceCreator<?>> instanceCreators) {
        this.instanceCreatorMap = instanceCreators;
    }

    @Override
    public <T> T construct(Type typeOfT) {
        InstanceCreator<?> creator = this.instanceCreatorMap.getHandlerFor(typeOfT);
        if (creator != null) {
            return (T)creator.createInstance(typeOfT);
        }
        return this.constructWithNoArgConstructor(typeOfT);
    }

    @Override
    public Object constructArray(Type type, int length) {
        return Array.newInstance(TypeUtils.toRawClass(type), length);
    }

    private <T> T constructWithNoArgConstructor(Type typeOfT) {
        try {
            Constructor<T> constructor = this.getNoArgsConstructor(typeOfT);
            if (constructor == null) {
                throw new RuntimeException("No-args constructor for " + typeOfT + " does not exist. " + "Register an InstanceCreator with Gson for this type to fix this problem.");
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to invoke no-args constructor for " + typeOfT + ". " + "Register an InstanceCreator with Gson for this type may fix this problem.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to invoke no-args constructor for " + typeOfT + ". " + "Register an InstanceCreator with Gson for this type may fix this problem.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to invoke no-args constructor for " + typeOfT + ". " + "Register an InstanceCreator with Gson for this type may fix this problem.", e);
        }
    }

    private <T> Constructor<T> getNoArgsConstructor(Type typeOfT) {
        TypeInfo typeInfo = new TypeInfo(typeOfT);
        Class<?> clazz = typeInfo.getRawClass();
        AccessibleObject[] declaredConstructors = clazz.getDeclaredConstructors();
        AccessibleObject.setAccessible(declaredConstructors, true);
        AccessibleObject[] accessibleObjectArray = declaredConstructors;
        int n = declaredConstructors.length;
        int n2 = 0;
        while (n2 < n) {
            AccessibleObject constructor = accessibleObjectArray[n2];
            if (((Constructor)constructor).getParameterTypes().length == 0) {
                return constructor;
            }
            ++n2;
        }
        return null;
    }

    <T> void register(Type typeOfT, InstanceCreator<? extends T> creator) {
        if (this.instanceCreatorMap.hasSpecificHandlerFor(typeOfT)) {
            log.log(Level.WARNING, "Overriding the existing InstanceCreator for " + typeOfT);
        }
        this.instanceCreatorMap.register(typeOfT, creator);
    }

    public String toString() {
        return this.instanceCreatorMap.toString();
    }
}

