/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMAttributeConstraint;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.CommunityAssetType;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.emf.AssetTypeConfiguration;
import com.ibm.ram.common.emf.Attribute751Grouping;
import com.ibm.ram.common.emf.AttributeConstraint;
import com.ibm.ram.common.emf.AttributeGrouping;
import com.ibm.ram.common.emf.ConstraintGrouping;
import com.ibm.ram.common.emf.EMFFactory;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.util.Utilities;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.common.data.AssetTypeCommunityRelationshipSO;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class RAMCommunityAssetType
extends CommunityAssetType
implements IRAMSessionObject {
    private static String COMMUNITY_ASSET_TYPE_HASH_KEY = "COMMUNITY_ASSET_TYPE:";
    private static final Logger logger = Logger.getLogger((String)RAMAssetType.class.getName());
    private AssetTypeCommunityRelationshipSO fCommunityAssetType;
    private RAMSession fSession;
    private RAMAction fAction;
    private boolean fDirty = false;
    private boolean fConfigModified = false;
    private volatile RAMAttributeConstraint[] fAttributeConstraints;
    private List<ConstraintGrouping> fConstraintGroupings;
    private AssetTypeConfiguration fAssetTypeConfig;
    boolean fUseMasterForConstraints;

    RAMCommunityAssetType(RAMSession session, AssetTypeCommunityRelationshipSO webServiceAssetType) {
        this.fSession = session;
        this.fCommunityAssetType = webServiceAssetType;
        if (webServiceAssetType.getMasterAssetType() == null) {
            RAMAssetType[] allTypes = this.getSession().getAllAssetTypes();
            int i = 0;
            while (i < allTypes.length) {
                if (allTypes[i].getId() == webServiceAssetType.getAssetTypeID()) {
                    this.setMasterAssetType(allTypes[i]);
                }
                ++i;
            }
        } else {
            this.setMasterAssetType(session.getAssetType(webServiceAssetType.getMasterAssetType().getName()));
        }
        if (webServiceAssetType.getCommunity() == null) {
            RAMCommunity community = this.getSession().getCommunity(webServiceAssetType.getCommunityID());
            this.setCommunity(community);
        } else {
            this.setCommunity(webServiceAssetType.getCommunity());
        }
        this.fAction = RAMAction.UPDATE;
    }

    RAMCommunityAssetType(RAMAssetType assetType, RAMCommunity community) {
        this.fSession = assetType.getSession();
        this.fCommunityAssetType = new AssetTypeCommunityRelationshipSO();
        this.setMasterAssetType(assetType);
        this.setCommunity(community);
        this.fAction = RAMAction.CREATE;
        this.setDirty(true);
    }

    void assetTypeCommited() throws RAMRuntimeException {
        this.fAction = RAMAction.UPDATE;
        this.setDirty(false);
    }

    List<ConstraintGrouping> getConstatintGroupings() {
        if (this.fConstraintGroupings == null) {
            this.loadConstraints();
        }
        return this.fConstraintGroupings;
    }

    boolean isMasterUsedForConstraints() {
        this.getConstatintGroupings();
        return this.fUseMasterForConstraints;
    }

    private URI getConfigURI() {
        return URI.createURI((String)("config:/config/" + this.getMasterAssetType().getId() + '/' + this.getCommunity().getId()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadConstraints() {
        String config = this.getConfiguration(false);
        if (!UtilitiesCommon.isEmptyString(config)) {
            Resource res = this.getResource(this.getConfigURI(), config, this.getSession().getResourceSet());
            try {
                if (res.getContents().isEmpty() || !(res.getContents().get(0) instanceof AssetTypeConfiguration)) {
                    EList contents = res.getContents();
                    this.fConstraintGroupings = new ArrayList<ConstraintGrouping>(contents.size());
                    for (EObject eObject : contents) {
                        this.fConstraintGroupings.add((ConstraintGrouping)eObject);
                    }
                    this.fUseMasterForConstraints = false;
                } else {
                    this.fAssetTypeConfig = (AssetTypeConfiguration)res.getContents().get(0);
                    this.fUseMasterForConstraints = !this.isLocal() && !this.fAssetTypeConfig.isSetConstraints();
                    this.fConstraintGroupings = new ArrayList<ConstraintGrouping>((Collection<ConstraintGrouping>)this.fAssetTypeConfig.getConstraints());
                }
                if (this.getSession().compareServicesVersion(RAMSession.RAM_7_5_1_0_SERVICES_VERSION) >= 0) return;
                ListIterator<ConstraintGrouping> gItr = this.fConstraintGroupings.listIterator();
                while (gItr.hasNext()) {
                    ConstraintGrouping next = gItr.next();
                    if (!(next instanceof AttributeGrouping)) continue;
                    if ((next = EMFFactory.eINSTANCE.migrateAttributeGrouping((AttributeGrouping)next)) != null) {
                        gItr.set(next);
                        continue;
                    }
                    gItr.remove();
                }
                return;
            }
            finally {
                if (res != null) {
                    res.getResourceSet().getResources().remove((Object)res);
                    res = null;
                }
            }
        } else {
            this.fConstraintGroupings = new ArrayList<ConstraintGrouping>(0);
            this.fUseMasterForConstraints = !this.isLocal();
        }
    }

    private Resource getResource(URI uri, String data, ResourceSet rset) {
        XMIResource res = (XMIResource)rset.getResource(uri, false);
        if (res == null) {
            res = (XMIResource)rset.createResource(uri);
            if (!UtilitiesCommon.isEmptyString(data)) {
                try {
                    res.load(Utilities.createEMFInputSource((XMLResource)res, new StringReader(data)), null);
                }
                catch (Exception ieee) {
                    logger.error((Object)ieee.getLocalizedMessage(), (Throwable)ieee);
                }
            }
        }
        return res;
    }

    private String serializeConstraints() {
        String ret = null;
        if (this.fConstraintGroupings != null && this.fConstraintGroupings.size() > 0) {
            List<ConstraintGrouping> cg = this.fConstraintGroupings;
            ResourceSet rset = this.getSession().getResourceSet();
            URI configURI = this.getConfigURI();
            XMIResource res = (XMIResource)rset.createResource(configURI);
            EList contents = res.getContents();
            if (this.getSession().compareServicesVersion(RAMSession.RAM_7_1_1_0_SERVICES_VERSION) < 0) {
                contents.clear();
                for (ConstraintGrouping grouping : cg) {
                    if (grouping instanceof Attribute751Grouping) {
                        AttributeGrouping o = EMFFactory.eINSTANCE.regressAttributeGrouping((Attribute751Grouping)grouping);
                        if (o == null) continue;
                        contents.add(o);
                        continue;
                    }
                    contents.add(grouping);
                }
            } else {
                if (this.fAssetTypeConfig == null) {
                    this.fAssetTypeConfig = EMFFactory.eINSTANCE.createAssetTypeConfiguration();
                } else {
                    this.fAssetTypeConfig.getConstraints().clear();
                }
                EList constraints = this.fAssetTypeConfig.getConstraints();
                if (this.getSession().compareServicesVersion(RAMSession.RAM_7_5_1_0_SERVICES_VERSION) >= 0) {
                    constraints.addAll(cg);
                } else {
                    for (ConstraintGrouping grouping : cg) {
                        if (grouping instanceof Attribute751Grouping) {
                            AttributeGrouping o = EMFFactory.eINSTANCE.regressAttributeGrouping((Attribute751Grouping)grouping);
                            if (o == null) continue;
                            constraints.add(o);
                            continue;
                        }
                        constraints.add(grouping);
                    }
                }
                contents.clear();
                if (!this.fAssetTypeConfig.isClean()) {
                    contents.add(this.fAssetTypeConfig);
                }
            }
            if (!res.getContents().isEmpty()) {
                try {
                    StringWriter sw = new StringWriter(1000);
                    res.save((Writer)sw, null);
                    ret = sw.toString();
                }
                catch (IOException e) {
                    throw new RAMRuntimeException(ClientMessages.getString("RAMAssetType.1"), e);
                }
            }
        }
        return ret;
    }

    public RAMAttributeConstraint createAttributeConstraint(RAMAssetAttribute attribute, boolean required) {
        RAMAttributeConstraint ret = new RAMAttributeConstraint((RAMAssetType)this.getMasterAssetType(), attribute, required);
        RAMAttributeConstraint[] attributes = this.getAttributeConstraints();
        RAMAttributeConstraint[] newAttributes = new RAMAttributeConstraint[attributes.length + 1];
        System.arraycopy(attributes, 0, newAttributes, 0, attributes.length);
        newAttributes[attributes.length] = ret;
        List<ConstraintGrouping> groupings = this.getConstatintGroupings();
        boolean found = false;
        for (ConstraintGrouping grouping : groupings) {
            if (!(grouping instanceof Attribute751Grouping)) continue;
            ((Attribute751Grouping)grouping).getColumn1().add((Object)ret.getInternalAttributeConstraint());
            found = true;
            break;
        }
        if (!found) {
            Attribute751Grouping attGrouping = EMFFactory.eINSTANCE.createDefaultAttribute751Grouping();
            attGrouping.getColumn1().add((Object)ret.getInternalAttributeConstraint());
            this.fConstraintGroupings.add(attGrouping);
        }
        this.fAttributeConstraints = newAttributes;
        this.fConfigModified = true;
        this.setDirty(true);
        return ret;
    }

    public RAMAttributeConstraint[] getAttributeConstraints() {
        if (this.fAttributeConstraints == null) {
            List<ConstraintGrouping> groupings = this.getConstatintGroupings();
            ArrayList<RAMAttributeConstraint> ramAttributeConstraints = new ArrayList<RAMAttributeConstraint>();
            for (ConstraintGrouping grouping : groupings) {
                if (!(grouping instanceof Attribute751Grouping)) continue;
                for (AttributeConstraint ac : ((Attribute751Grouping)grouping).getConstraintsIterator(false)) {
                    ramAttributeConstraints.add(new RAMAttributeConstraint((RAMAssetType)this.getMasterAssetType(), ac));
                }
            }
            RAMAttributeConstraint[] tmpArray = ramAttributeConstraints.toArray(new RAMAttributeConstraint[ramAttributeConstraints.size()]);
            this.fAttributeConstraints = tmpArray;
        }
        return this.fAttributeConstraints;
    }

    @Override
    public String getDescription() throws RAMRuntimeException {
        if (this.isLocal() || this.fCommunityAssetType.getDescription() != null && this.fCommunityAssetType.getDescription() != "") {
            return this.fCommunityAssetType.getDescription();
        }
        return this.getMasterAssetType().getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.fCommunityAssetType.setDescription(description);
        this.setDirty(true);
    }

    public String getName() throws RAMRuntimeException {
        return this.getMasterAssetType().getName();
    }

    public String getURI() throws RAMRuntimeException {
        return this.getMasterAssetType().getURI();
    }

    AssetTypeCommunityRelationshipSO getInternalCommunityAssetType() {
        this.fCommunityAssetType.setCommunityID(this.getCommunity().getId());
        this.fCommunityAssetType.setMasterAssetType(this.getMasterAssetType());
        this.fCommunityAssetType.setAssetTypeID(this.getMasterAssetType().getId());
        return this.fCommunityAssetType;
    }

    RAMSession getSession() {
        return this.fSession;
    }

    void setDirty(boolean dirtyFlag) {
        this.fDirty = dirtyFlag;
        if (dirtyFlag) {
            this.getSession().cache(this);
        } else {
            this.getSession().uncache(this);
        }
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    String getSessionKey() {
        String ret = String.valueOf(COMMUNITY_ASSET_TYPE_HASH_KEY) + ((RAMAssetType)this.getMasterAssetType()).getSessionKey() + " : " + ((RAMCommunity)this.getCommunity()).getSessionKey();
        return ret;
    }

    public String toString() {
        return String.valueOf(this.getMasterAssetType().getName()) + "(" + this.getCommunity().getName() + ")";
    }

    @Override
    public void setConfiguration(String configuration) {
        this.fCommunityAssetType.setConfiguration(configuration);
        this.fConstraintGroupings = null;
        this.fAssetTypeConfig = null;
        this.fConfigModified = false;
        this.setDirty(true);
    }

    @Override
    public void setCommunity(CommunityInformation community) {
        if (!(community == null || community instanceof RAMCommunity && ((RAMCommunity)community).getSession() == this.getSession())) {
            community = this.getSession().getCommunity(community.getName());
        }
        super.setCommunity(community);
    }

    @Override
    public String getConfiguration() {
        return this.getConfiguration(true);
    }

    private String getConfiguration(boolean inherited) {
        if (this.isLocal() || this.fConfigModified || !UtilitiesCommon.isEmptyString(this.fCommunityAssetType.getConfiguration())) {
            if (this.fConfigModified) {
                String config = this.serializeConstraints();
                this.fCommunityAssetType.setConfiguration(config);
                this.fConfigModified = false;
                this.fUseMasterForConstraints = false;
                this.setDirty(true);
            }
            return this.fCommunityAssetType.getConfiguration();
        }
        if (inherited) {
            return ((RAMAssetType)this.getMasterAssetType()).getConfiguration();
        }
        return null;
    }

    @Override
    public RAMAction getAction() {
        return this.fAction;
    }

    public void setAction(RAMAction action) {
        if (action != RAMAction.CREATE && action != RAMAction.UPDATE && action != RAMAction.DELETE) {
            String message = MessageFormat.format(ClientMessages.getString("ACTION_NOT_ACCEPTABLE"), action.getName(), this.getClass().getName());
            throw new RAMRuntimeException(message, true);
        }
        this.fAction = action;
        if (action == RAMAction.DELETE) {
            this.setDirty(true);
        }
    }
}

