/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;

public class RAMUser
extends UserInformation
implements IRAMSessionObject {
    private volatile UserInformation fUserInformation;
    private RAMSession fSession;
    private RAMAction fAction;
    private Boolean fRepositoryAdministrator;
    private boolean fDirty = false;
    private String USER_HASH_KEY = "USER:";

    RAMUser(RAMSession session, UserInformation webServiceUser) {
        this.fSession = session;
        this.setInternalUser(webServiceUser);
    }

    RAMSession getSession() {
        return this.fSession;
    }

    @Override
    public String getEmail() {
        return this.fUserInformation.getEmail();
    }

    @Override
    public void setEmail(String email) {
        if (email == null && this.fUserInformation.getEmail() != null || email != null && !email.equals(this.fUserInformation.getEmail())) {
            this.fUserInformation.setEmail(email);
            this.setDirty(true);
        }
    }

    @Override
    public String getName() {
        return this.fUserInformation.getName();
    }

    @Override
    public void setName(String name) {
        if (name == null && this.fUserInformation.getName() != null || name != null && !name.equals(this.fUserInformation.getName())) {
            this.fUserInformation.setName(name);
            this.setDirty(true);
        }
    }

    @Override
    public String getUid() {
        return this.fUserInformation.getUid();
    }

    @Override
    public void setUid(String uid) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMUser.UNIQUE_ID_CAN_ONLY_BE_SET_BY_SERVER"), true);
    }

    UserInformation getInternalUser() {
        return this.fUserInformation;
    }

    void setInternalUser(UserInformation userinfo) {
        this.fUserInformation = userinfo;
        this.setDirty(!this.fUserInformation.isRegistered());
    }

    @Override
    public String getPhone() {
        return this.fUserInformation.getPhone();
    }

    @Override
    public boolean isAnonymous() {
        return this.fUserInformation.isAnonymous();
    }

    @Override
    public boolean isRegistered() {
        return this.fUserInformation.isRegistered();
    }

    public boolean isRepositoryAdministrator() {
        if (this.fRepositoryAdministrator == null) {
            try {
                boolean isAdmin = this.getSession().getRAMClient().getRAM1Webservice().isRepositoryAdministrator(this.getUid());
                this.fRepositoryAdministrator = new Boolean(isAdmin);
            }
            catch (Throwable e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
        return this.fRepositoryAdministrator;
    }

    @Override
    public boolean isRepositoryUser() {
        return this.fUserInformation.isRepositoryUser();
    }

    @Override
    public String getImageURL() {
        return this.fUserInformation.getImageURL();
    }

    @Override
    public void setAnonymous(boolean anonymous) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMUser.CANNOT_SET_A_USER_ANON"), true);
    }

    @Override
    public void setImageURL(String userImageURL) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMUser.ONLY_SERVER_CAN_SET_IMAGE"), true);
    }

    @Override
    public void setPhone(String phone) {
        if (phone == null && this.fUserInformation.getPhone() != null || phone != null && !phone.equals(this.fUserInformation.getPhone())) {
            this.fUserInformation.setPhone(phone);
            this.setDirty(true);
        }
    }

    @Override
    public void setRegistered(boolean registered) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMUser.ONLY_SERVER_CAN_SET_REGISTERED_FLAG"), true);
    }

    @Override
    public void setRepositoryUser(boolean repositoryUser) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMUser.ONLY_SERVER_CAN_SET_REPO_USER_FLAG"), true);
    }

    void setDirty(boolean dirtyFlag) {
        this.fDirty = dirtyFlag;
        if (dirtyFlag) {
            this.getSession().cache(this);
        } else {
            this.getSession().uncache(this);
        }
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    String getSessionKey() {
        return String.valueOf(this.USER_HASH_KEY) + this.getUid();
    }

    @Override
    public String toString() {
        if (this.getName() != null) {
            return String.valueOf(this.getName()) + "(" + this.getUid() + ")";
        }
        return this.getUid();
    }

    @Override
    public RAMAction getAction() {
        return this.fAction;
    }

    public void setAction(RAMAction action) {
        if (action != RAMAction.CREATE && action != RAMAction.UPDATE) {
            String message = MessageFormat.format(ClientMessages.getString("ACTION_NOT_ACCEPTABLE"), action.getName(), this.getClass().getName());
            throw new RAMRuntimeException(message, true);
        }
        this.fAction = action;
    }
}

