/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.EmptyFileAccess;
import com.ibm.ram.fix.FileAccess;
import com.ibm.ram.fix.Fixes;
import com.ibm.ram.fix.FolderFileAccess;
import com.ibm.ram.fix.PatchControl;
import com.ibm.ram.fix.TouchFiles;
import com.ibm.ram.fix.ZipAccess;
import com.ibm.ram.fix.ZipFileAccess;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Apply {
    private final ZipAccess testfix;
    private final FileAccess toRoot;
    private Map<String, String> moduleMap = Collections.emptyMap();
    private File workdir;
    private List<String> messages = new ArrayList<String>();
    private static ModuleMap ERRORS = new ModuleMap("", "");
    private static ModuleMap NOT_MAPPED = new ModuleMap("", "");
    private ZipFile fix;
    private boolean hadErrors;
    private List<String> entryNames;
    private ListIterator<String> namesItr;
    private Map<String, String> controlFiles = new HashMap<String, String>();
    private SortedMap<String, String> deleteFiles = new TreeMap<String, String>();

    private static File createWorkDir(File workdir) throws IOException {
        File w = File.createTempFile("apply", null, workdir);
        w.delete();
        w.mkdir();
        return w;
    }

    public Apply(File testfix, File toRoot, File workDir, Map<String, String> moduleMap) throws ZipException, IOException {
        this(testfix, toRoot, moduleMap, Apply.createWorkDir(workDir));
    }

    private Apply(File testfix, File toRoot, Map<String, String> moduleMap, File workDir) throws ZipException, IOException {
        this(new ZipFileAccess(testfix, null, workDir), FileAccess.createFileAccess(toRoot, null, workDir), moduleMap);
        this.workdir = workDir;
    }

    Apply(ZipAccess testfix, FileAccess toRoot, Map<String, String> moduleMap) {
        this.testfix = testfix;
        this.toRoot = toRoot;
        if (moduleMap != null) {
            this.moduleMap = moduleMap;
        }
    }

    ModuleMap mapModule(String fixRoot, String local, String mappedParentModuleRoot) {
        String mappedRoot = fixRoot;
        if (this.moduleMap.containsKey(fixRoot)) {
            mappedRoot = this.moduleMap.get(fixRoot);
            if (mappedRoot != null) {
                if (mappedRoot.startsWith(mappedParentModuleRoot)) {
                    return new ModuleMap(mappedRoot, mappedRoot.substring(mappedParentModuleRoot.length()));
                }
                this.messages.add("Invalid - A nested mapped module doesn't map under the parent module. Parent mapped=\"" + mappedParentModuleRoot + "\" and mapped=\"" + mappedRoot + '\"');
                return ERRORS;
            }
            return null;
        }
        return NOT_MAPPED;
    }

    public boolean hadErrors() {
        return this.hadErrors;
    }

    public Collection<String> apply() throws ZipException, IOException, ParserConfigurationException, SAXException {
        this.fix = this.testfix.getZip();
        Module rootModule = null;
        Closeable fa = null;
        try {
            this.loadNamesSorted(this.testfix);
            this.namesItr = this.entryNames.listIterator();
            ModuleMap mapModule = this.mapModule("", "", "");
            if (mapModule != ERRORS) {
                if (mapModule != null) {
                    FileAccess moduleRoot = this.toRoot;
                    String mappedRoot = "";
                    if (mapModule != NOT_MAPPED) {
                        moduleRoot = this.toRoot.getNested(mapModule.local);
                        mappedRoot = mapModule.mappedRoot;
                    }
                    rootModule = new Module("", moduleRoot, mappedRoot);
                    rootModule.processModule();
                    if (rootModule.hadErrors()) {
                        this.hadErrors = true;
                    }
                } else {
                    this.messages.add("Root module has been mapped to be skipped. Nothing applied.");
                }
            }
            List<String> list = this.messages;
            return list;
        }
        finally {
            Apply.close(rootModule);
            Apply.close(fa);
            if (this.testfix != null) {
                Apply.close(this.testfix);
            }
            if (this.workdir != null) {
                Apply.deleteFiles(this.workdir);
            }
        }
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {}
    }

    static void deleteFiles(File dirOrFile) {
        if (dirOrFile.exists()) {
            if (dirOrFile.isDirectory()) {
                dirOrFile.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        Apply.deleteFiles(file);
                        return false;
                    }
                });
            }
            dirOrFile.delete();
        }
    }

    private void loadNamesSorted(FileAccess fa) {
        this.entryNames = fa.getFiles(new FileAccess.NameFilter(){

            @Override
            public boolean acceptName(FileAccess fa, String name) {
                int ndx = name.lastIndexOf(47);
                int nxndx = ndx + 1;
                if (PatchControl.isFixControl(name, PatchControl.ControlType.eitherType, nxndx, null)) {
                    Apply.this.controlFiles.put(ndx != -1 ? name.substring(0, ndx) : "", name);
                } else if (name.endsWith("META-INF/ibm-partialapp-delete.props")) {
                    int dndx = name.length() - "META-INF/ibm-partialapp-delete.props".length();
                    Apply.this.deleteFiles.put(dndx != 0 ? name.substring(0, dndx - 1) : "", name);
                    return false;
                }
                return true;
            }
        }, true);
        Collections.sort(this.entryNames);
    }

    static void extractTo(File to, ZipEntry ze, ZipFile zip, byte[] copyBuffer) throws IOException {
        FileOutputStream os = null;
        InputStream zin = null;
        try {
            to.getParentFile().mkdirs();
            os = new FileOutputStream(to);
            zin = zip.getInputStream(ze);
            Apply.copyStreams(zin, os, copyBuffer, true, true);
            os = null;
            zin = null;
            long mod = ze.getTime();
            if (mod >= 0L) {
                to.setLastModified(mod);
            }
        }
        catch (Throwable throwable) {
            Apply.close(os);
            Apply.close(zin);
            throw throwable;
        }
        Apply.close(os);
        Apply.close(zin);
    }

    static long copyStreams(InputStream in, OutputStream output, byte[] copyBuffer, boolean closeInput, boolean closeOutput) throws IOException {
        try {
            int read;
            int start = 0;
            long copied = 0L;
            while ((read = in.read(copyBuffer, start, copyBuffer.length - start)) > -1) {
                if ((start += read) < copyBuffer.length) continue;
                output.write(copyBuffer);
                start = 0;
                copied += (long)copyBuffer.length;
            }
            if (start > 0) {
                output.write(copyBuffer, 0, start);
                copied += (long)start;
            }
            long l = copied;
            return l;
        }
        finally {
            if (closeInput) {
                Apply.close(in);
            }
            if (closeOutput) {
                Apply.close(output);
            }
        }
    }

    static void copyReader(Reader in, Writer output, char[] buffer, boolean closeInput, boolean closeOutput) throws IOException {
        try {
            int read;
            int start = 0;
            while ((read = in.read(buffer, start, buffer.length - start)) > -1) {
                if ((start += read) < buffer.length) continue;
                output.write(buffer);
                start = 0;
            }
            if (start > 0) {
                output.write(buffer, 0, start);
            }
        }
        finally {
            if (closeInput) {
                Apply.close(in);
            }
            if (closeOutput) {
                Apply.close(output);
            }
        }
    }

    static /* synthetic */ ListIterator access$3(Apply apply) {
        return apply.namesItr;
    }

    static /* synthetic */ ZipAccess access$4(Apply apply) {
        return apply.testfix;
    }

    private class DoNothingModule
    extends Module {
        public DoNothingModule(String moduleRoot, FileAccess fa, String mappedModuleRoot) {
            super(moduleRoot, new EmptyFileAccess(fa, moduleRoot), mappedModuleRoot);
        }

        @Override
        public void processModule() {
        }
    }

    private class Module
    implements Closeable {
        protected final String moduleRoot;
        protected final String moduleRootPath;
        protected final StringBuilder moduleRootPathSB;
        protected final String mappedModuleRoot;
        protected final StringBuilder mappedModuleRootSB;
        protected PatchControl moduleControl;
        private boolean hadErrors;
        protected final FileAccess fa;
        protected boolean addVerified;

        protected Module(String moduleRoot, FileAccess fa, String mappedModuleRoot) {
            this.moduleRoot = moduleRoot;
            this.moduleRootPathSB = new StringBuilder(moduleRoot);
            this.moduleRootPath = moduleRoot.length() > 0 ? this.moduleRootPathSB.append('/').toString() : moduleRoot;
            this.fa = fa;
            if (moduleRoot.equals(mappedModuleRoot)) {
                this.mappedModuleRoot = this.moduleRootPath;
                this.mappedModuleRootSB = new StringBuilder(this.moduleRootPath);
            } else {
                this.mappedModuleRoot = mappedModuleRoot.length() > 0 && mappedModuleRoot.charAt(mappedModuleRoot.length() - 1) != '/' ? String.valueOf(mappedModuleRoot) + '/' : mappedModuleRoot;
                this.mappedModuleRootSB = new StringBuilder(this.mappedModuleRoot);
            }
        }

        public boolean hadErrors() {
            return this.hadErrors;
        }

        protected void markErrors() {
            this.hadErrors = true;
        }

        protected void deletes(Set<String> deletes) {
            this.fa.setDeletes(deletes);
        }

        private final void finish() throws IOException {
            if (this.addVerified) {
                this.primAddFileContents("fix.verified", Boolean.toString(!this.hadErrors()));
            }
            this.fa.finish();
            if (this.fa instanceof FolderFileAccess && this.moduleControl != null && !this.moduleControl.getTouches().isEmpty()) {
                this.processTouch(this.moduleControl.getTouches());
            }
        }

        @Override
        public final void close() throws IOException {
            this.fa.close();
        }

        protected final Module addFile(String filename) throws IOException, ParserConfigurationException, SAXException {
            String local = this.makeLocal(filename);
            if (!this.fa.isDeleted(local)) {
                if ("fix.verified".equals(local)) {
                    this.addVerified = true;
                } else {
                    Module m = this.isModule(local, filename);
                    if (m == null) {
                        this.primAddFile(local, filename);
                    } else {
                        return m;
                    }
                }
            }
            return null;
        }

        private final void primAddFile(String localName, String filename) throws IOException {
            try {
                this.fa.extractTo(localName, Apply.this.fix.getEntry(filename), Apply.this.fix);
            }
            catch (Fixes.FileIsDirectory fileIsDirectory) {
                Apply.this.messages.add("Cannot add file " + this.fa.getFullname(localName) + " because it is a directory and cannot be replaced from the test fix.");
                this.markErrors();
            }
        }

        protected final void primAddFileContents(String localName, String contents) throws IOException {
            try {
                this.fa.addContents(localName, contents);
            }
            catch (Fixes.FileIsDirectory fileIsDirectory) {
                Apply.this.messages.add("Cannot add file " + this.fa.getFullname(localName) + " because it is a directory and cannot be replaced from the test fix.");
                this.markErrors();
            }
        }

        protected String makeLocal(String filename) {
            if (this.moduleRootPath.length() > 0) {
                return filename.substring(this.moduleRootPath.length());
            }
            return filename;
        }

        /*
         * Exception decompiling
         */
        public void processModule() throws IOException, ParserConfigurationException, SAXException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected boolean processControl() throws IOException, ParserConfigurationException, SAXException {
            String ctrl = (String)Apply.this.controlFiles.remove(this.moduleRoot);
            boolean skip = false;
            if (ctrl != null) {
                this.moduleControl = PatchControl.loadXML(new BufferedReader(new InputStreamReader(Apply.this.fix.getInputStream(Apply.this.fix.getEntry(ctrl)), Charset.forName("UTF-8"))));
                String runtimeBase = this.moduleControl.getRuntimeBase();
                if (runtimeBase != null) {
                    InputStream rtBaseIS = null;
                    try {
                        rtBaseIS = this.fa.getNestedIS(runtimeBase);
                        try {
                            String rtVersion = PatchControl.readRuntimeVersion(rtBaseIS, this.moduleControl.getBaseVersionPattern());
                            if (!this.moduleControl.getBaseVersion().equals(rtVersion)) {
                                Apply.this.messages.add("Cannot apply to module \"" + this.moduleRoot + "\" because versions don't match. Module version=" + rtVersion + " but test fix version required=" + this.moduleControl.getBaseVersion());
                                skip = true;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            Apply.this.messages.add("Cannot apply to module \"" + this.moduleRoot + "\" because " + e.getLocalizedMessage());
                            skip = true;
                        }
                        Apply.close(rtBaseIS);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Apply.this.messages.add("Cannot apply to module \"" + this.moduleRoot + "\" because can't find the runtime base version file (relative to module) \"" + runtimeBase + '\"');
                        skip = true;
                    }
                }
            }
            if (skip) {
                this.markErrors();
            }
            return skip;
        }

        private void processTouch(Collection<PatchControl.Touch> touches) {
            new TouchFiles(((FolderFileAccess)this.fa).getBase(), touches, Apply.this.moduleMap).touch();
        }

        /*
         * Unable to fully structure code
         */
        protected final Module isModule(String local, String filename) throws ZipException, IOException {
            if (Apply.access$5(Apply.this).containsKey(filename) || Apply.access$2(Apply.this).containsKey(filename)) {
                Apply.access$1(Apply.this).add("Invalid to have a direct update of an entire module. It must be updated through the module delta updates. Module=" + filename);
                return new DoNothingModule(filename, this.fa, filename);
            }
            dirNdx = -1;
            if (true) ** GOTO lbl14
            do {
                lfn = local.substring(0, dirNdx);
                fn = PatchControl.createFilename(this.moduleRootPathSB, lfn, '/');
                ismodule = Apply.access$5(Apply.this).containsKey(fn) != false || Apply.access$2(Apply.this).containsKey(fn) != false;
                ftype = this.getFileType(lfn);
                if (ismodule || ftype == FileAccess.FileType.file) {
                    return this.createModule(lfn, fn, ftype);
                }
lbl14:
                // 3 sources

                ++dirNdx;
            } while ((dirNdx = local.indexOf(47, dirNdx)) != -1);
            return null;
        }

        protected Module createModule(String local, String fixRoot, FileAccess.FileType type) throws ZipException, IOException {
            ModuleMap mapModule = Apply.this.mapModule(fixRoot, local, this.mappedModuleRoot);
            try {
                if (mapModule == NOT_MAPPED) {
                    return new Module(fixRoot, this.fa.getNested(local), this.mappedModuleRoot == this.moduleRootPath ? fixRoot : PatchControl.createFilename(this.mappedModuleRootSB, local, '/'));
                }
                if (mapModule == null) {
                    return new SkipModule(fixRoot, this.fa, fixRoot);
                }
                if (mapModule != ERRORS) {
                    return new Module(fixRoot, this.fa.getNested(mapModule.local), mapModule.mappedRoot);
                }
                this.markErrors();
                return new SkipModule(fixRoot, this.fa, fixRoot);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Apply.this.messages.add("Module " + local + " in " + fixRoot + " could not be found.");
                this.markErrors();
                return new SkipModule(fixRoot, this.fa, fixRoot);
            }
        }

        protected final FileAccess.FileType getFileType(String local) {
            return this.fa.getFileType(local);
        }
    }

    private static class ModuleMap {
        public String mappedRoot;
        public String local;

        public ModuleMap(String mappedRoot, String local) {
            this.mappedRoot = mappedRoot;
            this.local = local;
        }
    }

    private class SkipModule
    extends Module {
        protected SkipModule(String moduleRoot, FileAccess fa, String mappedModuleRoot) {
            super(moduleRoot, new EmptyFileAccess(fa, moduleRoot), mappedModuleRoot);
        }

        @Override
        protected boolean processControl() {
            Apply.this.controlFiles.remove(this.moduleRoot);
            return true;
        }
    }
}

