/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.Apply;
import com.ibm.ram.fix.FileAccess;
import com.ibm.ram.fix.Fixes;
import com.ibm.ram.fix.PatchControl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class ZipAccess
extends FileAccess {
    private ZipFile zip;
    private String zipname;
    private ZipOutputStream zipOut;
    private Set<String> directories;
    private Set<String> processed = Collections.emptySet();
    private Collection<File> temps = Collections.emptyList();

    protected ZipAccess(File zipfile, byte[] copybuffer, File workDir) throws ZipException, IOException {
        super(copybuffer, workDir);
        this.init(zipfile);
    }

    ZipAccess(File zipfile, FileAccess nestedFA, String path) throws ZipException, IOException {
        super(nestedFA, path);
        boolean inited = false;
        try {
            this.init(zipfile);
            inited = true;
        }
        finally {
            if (!inited) {
                this.close();
            }
        }
    }

    private void init(File zipfile) throws ZipException, IOException {
        this.zip = new ZipFile(zipfile);
        this.zipname = zipfile.toString();
    }

    protected ZipFile getZip() {
        return this.zip;
    }

    @Override
    public List<String> getFiles(FileAccess.NameFilter filter, boolean nest) {
        ArrayList<String> pcFiles = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = this.getZip().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (!nest && name.indexOf(47) != -1 || !filter.acceptName(this, name)) continue;
            pcFiles.add(name);
        }
        return pcFiles;
    }

    @Override
    public FileAccess.FileType getFileType(String local) {
        if (this.getDirectories().contains(local)) {
            return FileAccess.FileType.directory;
        }
        return this.getFileType(this.getZip().getEntry(local));
    }

    protected FileAccess.FileType getFileType(ZipEntry ze) {
        if (ze == null) {
            return FileAccess.FileType.notExist;
        }
        if (this.getDirectories().contains(ze.getName())) {
            return FileAccess.FileType.directory;
        }
        if (ze.isDirectory()) {
            return FileAccess.FileType.directory;
        }
        return FileAccess.FileType.file;
    }

    @Override
    public InputStream getIS(String file) throws IOException, FileNotFoundException, Fixes.FileIsDirectory {
        switch (this.getFileType(file)) {
            case directory: {
                throw new Fixes.FileIsDirectory(file);
            }
            case file: {
                return this.getZip().getInputStream(this.getZip().getEntry(file));
            }
        }
        throw new FileNotFoundException(this.getFullname(file));
    }

    @Override
    public OutputStream getOS(String file) throws IOException {
        ZipOutputStream zout = this.getZipOut();
        ZipEntry ze = new ZipEntry(file);
        ze.setTime(System.currentTimeMillis());
        Closeable w = null;
        try {
            zout.putNextEntry(ze);
            ZoutOutputStream os = new ZoutOutputStream(zout, file);
            zout = null;
            ZoutOutputStream zoutOutputStream = os;
            return zoutOutputStream;
        }
        finally {
            Apply.close(w);
            if (zout != null) {
                zout.closeEntry();
            }
        }
    }

    @Override
    public boolean touch(String file) {
        return false;
    }

    protected abstract ZipOutputStream createZipOutputStream() throws IOException;

    protected final ZipOutputStream getZipOut() throws IOException {
        if (this.zipOut == null) {
            this.zipOut = this.createZipOutputStream();
        }
        return this.zipOut;
    }

    @Override
    protected void doClose() throws IOException {
        this.closeZipFile();
        this.closeZipout();
        for (File tfile : this.temps) {
            tfile.delete();
        }
    }

    protected void closeZipout() {
        Apply.close(this.zipOut);
        this.zipOut = null;
    }

    protected void closeZipFile() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException iOException) {}
            this.zip = null;
        }
    }

    @Override
    public String getFullname(String name) {
        return String.valueOf(this.zipname) + '!' + name;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FileAccess getNested(String name) throws ZipException, IOException {
        switch (ZipAccess.$SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType()[this.getFileType(name).ordinal()]) {
            case 2: {
                return new FolderInZipAccess(name);
            }
            case 1: {
                return new ZipInZipAccess(this.createTempZipFile(name), name);
            }
        }
        dirNdx = -1;
        if (true) ** GOTO lbl15
        do {
            intermediateFn = name.substring(0, dirNdx);
            switch (ZipAccess.$SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType()[this.getFileType(intermediateFn).ordinal()]) {
                case 1: {
                    nestedFA = this.getNestedFA(intermediateFn);
                    nestLocalToIntermediate = name.substring(dirNdx + 1);
                    return nestedFA != null ? nestedFA.getNested(nestLocalToIntermediate) : this.getNested(intermediateFn).getNested(nestLocalToIntermediate);
                }
            }
lbl15:
            // 2 sources

            ++dirNdx;
        } while ((dirNdx = name.indexOf(47, dirNdx)) != -1);
        throw new FileNotFoundException(this.getFullname(name));
    }

    protected Set<String> getDirectories() {
        if (this.directories != null) {
            return this.directories;
        }
        this.directories = this.calculateDirectories();
        return this.directories;
    }

    protected final Set<String> calculateDirectories() {
        HashSet<String> dirs = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.getZip().entries();
        String lastDir = "";
        block0: while (entries.hasMoreElements()) {
            String dir;
            ZipEntry ne = entries.nextElement();
            String name = ne.getName();
            int ld = name.lastIndexOf(47);
            if (ld <= 0 || ld == lastDir.length() && name.startsWith(lastDir)) continue;
            lastDir = dir = name.substring(0, ld);
            while (!dirs.contains(dir = dir.substring(0, ld))) {
                dirs.add(dir);
                if ((ld = dir.lastIndexOf(47, ld)) > 0) continue;
                continue block0;
            }
        }
        return dirs;
    }

    protected Set<String> getProcessed(boolean updatable) {
        if (updatable && this.processed.isEmpty()) {
            this.processed = new HashSet<String>();
            return this.processed;
        }
        return this.processed;
    }

    @Override
    protected void doFinish() throws IOException {
        Set<String> processedFiles = this.getProcessed(false);
        if (!(processedFiles.isEmpty() && this.getDeletes().isEmpty() && this.getDeletePatterns().isEmpty())) {
            Enumeration<? extends ZipEntry> entries = this.getZip().entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String name = ze.getName();
                if (processedFiles.contains(name) || this.isDeleted(name)) continue;
                this.extractTo(name, ze, this.getZip());
            }
        }
    }

    @Override
    public void addContents(String localName, String contents) throws IOException, Fixes.FileIsDirectory {
        ZipOutputStream zout = this.getZipOut();
        ZipEntry ze = new ZipEntry(localName);
        ze.setTime(System.currentTimeMillis());
        OutputStreamWriter w = null;
        try {
            zout.putNextEntry(ze);
            w = new OutputStreamWriter((OutputStream)new ZoutOutputStream(zout, localName), Charset.forName("UTF-8"));
            Apply.copyReader(new StringReader(contents), w, new char[contents.length()], true, true);
            w = null;
        }
        catch (Throwable throwable) {
            Apply.close(w);
            zout.closeEntry();
            throw throwable;
        }
        Apply.close(w);
        zout.closeEntry();
    }

    @Override
    public void extractTo(String toFile, ZipEntry ze, ZipFile zip) throws IOException {
        InputStream zin = null;
        ZipOutputStream zout = this.getZipOut();
        try {
            ZipEntry newZE = new ZipEntry(toFile);
            newZE.setTime(ze.getTime());
            newZE.setExtra(ze.getExtra());
            newZE.setComment(ze.getComment());
            zout.putNextEntry(newZE);
            zin = zip.getInputStream(ze);
            Apply.copyStreams(zin, new ZoutOutputStream(zout, toFile), this.getCopybuffer(), true, true);
            zin = null;
        }
        catch (Throwable throwable) {
            Apply.close(zin);
            zout.closeEntry();
            throw throwable;
        }
        Apply.close(zin);
        zout.closeEntry();
    }

    protected void addFileToZip(String toName, File fromFile) throws IOException {
        FileInputStream fin = null;
        ZipOutputStream zout = this.getZipOut();
        try {
            ZipEntry newZE = new ZipEntry(toName);
            newZE.setTime(fromFile.lastModified());
            zout.putNextEntry(newZE);
            fin = new FileInputStream(fromFile);
            Apply.copyStreams(fin, new ZoutOutputStream(zout, toName), this.getCopybuffer(), true, true);
            fin = null;
        }
        catch (Throwable throwable) {
            Apply.close(fin);
            zout.closeEntry();
            throw throwable;
        }
        Apply.close(fin);
        zout.closeEntry();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public InputStream getNestedIS(String local) throws FileNotFoundException, Fixes.FileIsDirectory, IOException {
        switch (ZipAccess.$SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType()[this.getFileType(local).ordinal()]) {
            case 2: {
                throw new Fixes.FileIsDirectory(local);
            }
            case 1: {
                return this.getIS(local);
            }
        }
        dirNdx = -1;
        if (true) ** GOTO lbl20
        do {
            lfn = local.substring(0, dirNdx);
            switch (ZipAccess.$SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType()[this.getFileType(lfn).ordinal()]) {
                case 1: {
                    nestedFA = this.getNestedFA(lfn);
                    nestLocal = local.substring(dirNdx + 1);
                    if (nestedFA != null) {
                        return nestedFA.getIS(nestLocal);
                    }
                    try {
                        return new NestedIS(null, this.getZip().getInputStream(this.getZip().getEntry(lfn))).getNestedIS(nestLocal);
                    }
                    catch (FileNotFoundException v0) {
                        throw new FileNotFoundException(this.getFullname(local));
                    }
                }
            }
lbl20:
            // 2 sources

            ++dirNdx;
        } while ((dirNdx = local.indexOf(47, dirNdx)) != -1);
        throw new FileNotFoundException(this.getFullname(local));
    }

    private File createTempZipFile(String filename) throws Fixes.FileIsDirectory, FileNotFoundException, IOException {
        File tempZip = null;
        try {
            int ndx = filename.lastIndexOf(47) + 1;
            tempZip = File.createTempFile(filename.substring(ndx), null, this.getWorkDir());
            tempZip.deleteOnExit();
            ZipEntry ze = this.getZip().getEntry(filename);
            switch (this.getFileType(ze)) {
                case file: {
                    Apply.extractTo(tempZip, ze, this.getZip(), this.getCopybuffer());
                    break;
                }
                case directory: {
                    throw new Fixes.FileIsDirectory(this.getFullname(filename));
                }
                default: {
                    throw new FileNotFoundException(this.getFullname(filename));
                }
            }
            File rzip = tempZip;
            tempZip = null;
            File file = rzip;
            return file;
        }
        finally {
            if (tempZip != null) {
                tempZip.delete();
            }
        }
    }

    @Override
    public File extract(String file) throws IOException, FileNotFoundException, Fixes.FileIsDirectory {
        File file2;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = this.getIS(file);
            File f = File.createTempFile(file, null, this.getWorkDir());
            f.deleteOnExit();
            if (this.temps.isEmpty()) {
                this.temps = new ArrayList<File>();
            }
            this.temps.add(f);
            os = new FileOutputStream(f);
            Apply.copyStreams(is, os, this.getCopybuffer(), true, true);
            is = null;
            os = null;
            file2 = f;
        }
        catch (Throwable throwable) {
            Apply.close(is);
            Apply.close(os);
            throw throwable;
        }
        Apply.close(is);
        Apply.close(os);
        return file2;
    }

    private class FolderInZipAccess
    extends FileAccess {
        private StringBuilder folderSB;

        public FolderInZipAccess(String foldername) {
            super(ZipAccess.this, foldername);
            this.folderSB = new StringBuilder(foldername);
        }

        private String getFilename(String name) {
            return PatchControl.createFilename(this.folderSB, name, '/');
        }

        @Override
        public String getFullname(String name) {
            return ZipAccess.this.getFullname(this.getFilename(name));
        }

        @Override
        public InputStream getIS(String file) throws IOException, FileNotFoundException, Fixes.FileIsDirectory {
            return ZipAccess.this.getIS(this.getFilename(file));
        }

        @Override
        public OutputStream getOS(String file) throws IOException, Fixes.FileIsDirectory {
            return ZipAccess.this.getOS(this.getFilename(file));
        }

        @Override
        public boolean touch(String file) {
            return ZipAccess.this.touch(this.getFilename(file));
        }

        @Override
        public FileAccess getNested(String name) throws ZipException, IOException {
            return ZipAccess.this.getNested(this.getFilename(name));
        }

        @Override
        protected void doClose() {
        }

        @Override
        protected void doFinish() {
        }

        @Override
        public FileAccess.FileType getFileType(String name) {
            return ZipAccess.this.getFileType(this.getFilename(name));
        }

        @Override
        public void addContents(String name, String contents) throws IOException, Fixes.FileIsDirectory {
            ZipAccess.this.addContents(this.getFilename(name), contents);
        }

        @Override
        public void extractTo(String name, ZipEntry ze, ZipFile zip) throws IOException {
            ZipAccess.this.extractTo(this.getFilename(name), ze, zip);
        }

        @Override
        public List<String> getFiles(final FileAccess.NameFilter filter, final boolean nest) {
            return ZipAccess.this.getFiles(new FileAccess.NameFilter(){

                @Override
                public boolean acceptName(FileAccess fa, String name) {
                    if (!nest && name.indexOf(47, FolderInZipAccess.this.folderSB.length()) != -1) {
                        return false;
                    }
                    return filter.acceptName(FolderInZipAccess.this, name.substring(FolderInZipAccess.this.folderSB.length()));
                }
            }, true);
        }

        @Override
        public void setDeletes(Collection<String> deletes) {
            super.setDeletes(deletes);
            if (!deletes.isEmpty()) {
                ArrayList<String> pdeletes = new ArrayList<String>(deletes.size());
                for (String delete : deletes) {
                    pdeletes.add(this.getFilename(delete));
                }
                ZipAccess.this.setDeletes(pdeletes);
            }
        }

        @Override
        public InputStream getNestedIS(String file) throws FileNotFoundException, Fixes.FileIsDirectory, IOException {
            return ZipAccess.this.getNestedIS(this.getFilename(file));
        }

        @Override
        public File extract(String file) throws IOException, FileNotFoundException, Fixes.FileIsDirectory {
            return ZipAccess.this.extract(this.getFilename(file));
        }
    }

    private class NestedIS {
        private final NestedIS parentIS;
        private final ZipInputStream zin;

        private NestedIS(NestedIS parentIS, InputStream nestedZip) {
            try {
                this.parentIS = parentIS;
                this.zin = new ZipInputStream(new BufferedInputStream(nestedZip));
            }
            catch (RuntimeException e) {
                this.closed();
                throw e;
            }
            catch (Error e) {
                this.closed();
                throw e;
            }
        }

        private void closed() {
            Apply.close(this.zin);
            if (this.parentIS != null) {
                this.parentIS.closed();
            }
        }

        public InputStream getNestedIS(String local) throws IOException {
            try {
                ZipEntry next = null;
                while ((next = this.zin.getNextEntry()) != null) {
                    if (next.isDirectory()) continue;
                    String nextName = next.getName();
                    if (nextName.equals(local)) {
                        return new FilterInputStream(this.zin){

                            @Override
                            public void close() throws IOException {
                                NestedIS.this.closed();
                                super.close();
                            }
                        };
                    }
                    if (!local.startsWith(nextName) || local.charAt(nextName.length()) != '/') continue;
                    return new NestedIS(this, this.zin).getNestedIS(local.substring(nextName.length() + 1));
                }
                throw new FileNotFoundException();
            }
            catch (IOException e) {
                this.closed();
                throw e;
            }
            catch (RuntimeException e) {
                this.closed();
                throw e;
            }
            catch (Error e) {
                this.closed();
                throw e;
            }
        }
    }

    private class ZipInZipAccess
    extends ZipAccess {
        private File tempZip;
        private final String localName;
        private File zipOutFile;

        private ZipInZipAccess(File tempZip, String localName) throws ZipException, IOException {
            super(tempZip, ZipAccess.this, localName);
            this.tempZip = tempZip;
            this.localName = localName;
        }

        @Override
        protected ZipOutputStream createZipOutputStream() throws IOException {
            if (this.zipOutFile != null) {
                throw new IllegalStateException("Already created zip out stream once for this zip: " + this.tempZip.getName());
            }
            this.zipOutFile = File.createTempFile(this.tempZip.getName(), null, this.getWorkDir());
            return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipOutFile)));
        }

        @Override
        protected void doFinish() throws IOException {
            super.doFinish();
            this.closeZipFile();
            this.closeZipout();
            if (this.zipOutFile != null) {
                ZipAccess.this.addFileToZip(this.localName, this.zipOutFile);
            }
        }

        @Override
        protected void doClose() throws IOException {
            super.doClose();
            if (this.tempZip != null) {
                this.tempZip.delete();
                this.tempZip = null;
            }
            if (this.zipOutFile != null) {
                this.zipOutFile.delete();
                this.zipOutFile = null;
            }
        }
    }

    private class ZoutOutputStream
    extends FilterOutputStream {
        private final String name;

        public ZoutOutputStream(ZipOutputStream zout, String name) {
            super(zout);
            this.name = name;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            ZipAccess.this.getProcessed(true).add(this.name);
        }
    }
}

