/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.data;

import com.ibm.ram.common.util.RAMURLDecoder;
import com.ibm.ram.internal.common.data.FacetSelectionSO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SearchNode {
    private static final Logger logger = Logger.getLogger(SearchNode.class);
    private List<String> textQueries;
    private List<FacetSelectionSO> facetSelections;
    private List<FacetSelectionSO> allSelections;
    private boolean searchArtifacts = false;
    private boolean searchForums = false;
    private boolean searchShadowAssets = false;
    public static final String VERSION_ONE = "1";
    public static final String RAMSEARCH_PREFIX = "ramSearch:(";
    public static final String RAMSEARCH_SUFFIX = ")";
    public static final String PARAM_ASSIGNEMENT = ",";
    public static final String TEXT_PARAM = "txt,";
    public static final String ARTIFACT_PARAM = "art";
    public static final String FORUM_PARAM = "frm";
    public static final String SHADOW_PARAM = "sdw";
    public static final String DELIM = "$";
    public static final String ESCAPED_DELIM = "\\$";
    public static final String OLD_DELIM = "|";
    public static final String OLD_ESCAPED_DELIM = "\\|";

    public SearchNode(String node) {
        this.facetSelections = new ArrayList<FacetSelectionSO>();
        this.textQueries = new ArrayList<String>();
        this.allSelections = new ArrayList<FacetSelectionSO>();
        ArrayList<String> textParameters = new ArrayList<String>();
        ArrayList<String> facetParameters = new ArrayList<String>();
        if (node != null && node.length() > 0 && node.startsWith(RAMSEARCH_PREFIX) && node.endsWith(RAMSEARCH_SUFFIX)) {
            String[] facets;
            String actualNode = node.substring(RAMSEARCH_PREFIX.length(), node.length() - RAMSEARCH_SUFFIX.length()).trim();
            try {
                actualNode = RAMURLDecoder.decode(actualNode);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (actualNode.startsWith(VERSION_ONE)) {
                actualNode = actualNode.substring(VERSION_ONE.length());
                facets = actualNode.split(ESCAPED_DELIM);
            } else {
                facets = actualNode.split(OLD_ESCAPED_DELIM);
            }
            int i = 0;
            while (i < facets.length) {
                if (facets[i].startsWith(TEXT_PARAM)) {
                    textParameters.add(facets[i]);
                } else if (facets[i].startsWith(ARTIFACT_PARAM)) {
                    this.searchArtifacts = true;
                } else if (facets[i].startsWith(FORUM_PARAM)) {
                    this.searchForums = true;
                } else if (facets[i].startsWith(SHADOW_PARAM)) {
                    this.searchShadowAssets = true;
                } else {
                    facetParameters.add(facets[i]);
                }
                ++i;
            }
        }
        for (String param : facetParameters) {
            String[] tokens = param.split(PARAM_ASSIGNEMENT, 2);
            if (tokens.length < 2) {
                logger.warn((Object)("Invalid facet selection: " + param + ". Search node string: " + node));
                continue;
            }
            FacetSelectionSO selection = new FacetSelectionSO(tokens[0], tokens[1]);
            this.allSelections.add(selection);
        }
        this.facetSelections.addAll(this.allSelections);
        for (String param : textParameters) {
            String[] tokens = param.split(PARAM_ASSIGNEMENT, 2);
            this.textQueries.add(tokens[1]);
        }
    }

    public SearchNode(List textQueries, List facetSelections, List allSelections, boolean searchArtifacts, boolean searchForums, boolean searchShadowAssets) {
        this.textQueries = textQueries;
        this.facetSelections = facetSelections;
        this.allSelections = allSelections;
        this.searchArtifacts = searchArtifacts;
        this.searchForums = searchForums;
        this.searchShadowAssets = searchShadowAssets;
    }

    public static String toString(List textQueries, List facetSelections, List allSelections, boolean searchArtifacts, boolean searchForums, boolean searchShadowAssets) {
        return new SearchNode(textQueries, facetSelections, allSelections, searchArtifacts, searchForums, searchShadowAssets).toString();
    }

    public List<FacetSelectionSO> getFacetSelections() {
        if (this.facetSelections == null) {
            this.facetSelections = new ArrayList<FacetSelectionSO>();
        }
        return this.facetSelections;
    }

    public List<String> getTextQueries() {
        if (this.textQueries == null) {
            this.textQueries = new ArrayList<String>();
        }
        return this.textQueries;
    }

    public boolean isSearchArtifacts() {
        return this.searchArtifacts;
    }

    public boolean isSearchForums() {
        return this.searchForums;
    }

    public boolean isSearchShadowAssets() {
        return this.searchShadowAssets;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeTextSearch) {
        Iterator<Object> iter;
        StringBuffer buffer = new StringBuffer();
        buffer.append(RAMSEARCH_PREFIX);
        if (includeTextSearch) {
            iter = this.textQueries.iterator();
            while (iter.hasNext()) {
                String query = (String)iter.next();
                buffer.append(TEXT_PARAM);
                buffer.append(query);
                if (!iter.hasNext() && this.allSelections.size() <= 0) continue;
                buffer.append(DELIM);
            }
        }
        iter = this.allSelections.iterator();
        while (iter.hasNext()) {
            FacetSelectionSO selection = (FacetSelectionSO)iter.next();
            buffer.append(selection.getFacetName());
            buffer.append(PARAM_ASSIGNEMENT);
            buffer.append(selection.getItem());
            if (!iter.hasNext()) continue;
            buffer.append(DELIM);
        }
        if (this.isSearchArtifacts()) {
            if (buffer.length() > 0) {
                buffer.append(DELIM);
            }
            buffer.append(ARTIFACT_PARAM);
        }
        if (this.isSearchForums()) {
            if (buffer.length() > 0) {
                buffer.append(DELIM);
            }
            buffer.append(FORUM_PARAM);
        }
        if (this.isSearchShadowAssets()) {
            if (buffer.length() > 0) {
                buffer.append(DELIM);
            }
            buffer.append(SHADOW_PARAM);
        }
        if (buffer.length() > RAMSEARCH_PREFIX.length()) {
            buffer.insert(RAMSEARCH_PREFIX.length(), VERSION_ONE);
        }
        buffer.append(RAMSEARCH_SUFFIX);
        return buffer.toString();
    }

    public List<FacetSelectionSO> getAllSelections() {
        return this.allSelections;
    }

    public static String removePrefixAndSuffix(String nodeString) {
        if (nodeString.startsWith(RAMSEARCH_PREFIX) && nodeString.endsWith(RAMSEARCH_SUFFIX)) {
            nodeString = nodeString.substring(RAMSEARCH_PREFIX.length());
            nodeString = nodeString.substring(0, nodeString.length() - RAMSEARCH_SUFFIX.length());
        }
        return nodeString.trim();
    }

    public static boolean isRAMSearchQuery(String txt) {
        if (txt != null) {
            return txt.startsWith(RAMSEARCH_PREFIX) && txt.endsWith(RAMSEARCH_SUFFIX);
        }
        return false;
    }

    public static String getTagNode(String tag) {
        StringBuffer sb = new StringBuffer(RAMSEARCH_PREFIX);
        sb.append(VERSION_ONE);
        sb.append("fTag");
        sb.append(PARAM_ASSIGNEMENT);
        sb.append(tag);
        sb.append(RAMSEARCH_SUFFIX);
        return sb.toString();
    }

    public static String getNodeLink(String facetName, String facetItem) {
        StringBuffer sb = new StringBuffer(VERSION_ONE);
        sb.append(facetName);
        sb.append(PARAM_ASSIGNEMENT);
        sb.append(facetItem);
        return sb.toString();
    }
}

