/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.internal.common.util.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

public class AcceptHeader {
    private List<MediaType> mediaTypes = new ArrayList<MediaType>();
    private String value;

    public AcceptHeader(String value) {
        this.value = value;
        this.mediaTypes = new ArrayList<MediaType>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            try {
                this.mediaTypes.add(new MediaType(token));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        Collections.sort(this.mediaTypes, new Comparator<MediaType>(){

            @Override
            public int compare(MediaType o1, MediaType o2) {
                float f = o2.getQuality() - o1.getQuality();
                if (f < 0.0f) {
                    return -1;
                }
                if (f > 0.0f) {
                    return 1;
                }
                if (o2.getType().equals(o1.getType()) && !o2.getSubtype().equals(o1.getSubtype())) {
                    if ("*".equals(o2.getSubtype())) {
                        return -1;
                    }
                    if ("*".equals(o1.getSubtype())) {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }

    public List<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public boolean contains(MediaType type) {
        for (MediaType mt : this.mediaTypes) {
            if (!mt.getType().equals(type.getType()) || !mt.getSubtype().equals(type.getSubtype())) continue;
            return true;
        }
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public MediaType getBestMatch(List<MediaType> types) {
        for (MediaType type : this.mediaTypes) {
            for (MediaType t : types) {
                if (!type.matches(t)) continue;
                return t;
            }
        }
        return null;
    }

    public MediaType getBestMatch(MediaType ... types) {
        for (MediaType type : this.mediaTypes) {
            MediaType[] mediaTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                MediaType t = mediaTypeArray[n2];
                if (type.matches(t)) {
                    return t;
                }
                ++n2;
            }
        }
        return null;
    }

    public MediaType getBestMatch(String[] types) {
        for (MediaType type : this.mediaTypes) {
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                if (type.matches(t)) {
                    try {
                        return new MediaType(t);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                ++n2;
            }
        }
        return null;
    }

    public String toString() {
        return this.value;
    }
}

