/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.AssetType;
import com.ibm.ram.internal.client.ant.types.Attribute;
import com.ibm.ram.internal.client.ant.types.Community;
import com.ibm.ram.internal.client.ant.types.RelationshipType;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CreateTask
extends RAMTask {
    private List communities = new ArrayList();
    private List assetTypes = new ArrayList();
    private List attributes = new ArrayList();
    private List relationshipTypes = new ArrayList();

    public void add(Community community) {
        if (this.getSession() != null) {
            community.setSession(this.getSession());
        }
        community.setTask(this);
        this.communities.add(community);
    }

    public void add(RelationshipType relationshipType) {
        if (this.getSession() != null) {
            relationshipType.setSession(this.getSession());
        }
        relationshipType.setTask(this);
        this.relationshipTypes.add(relationshipType);
    }

    public void add(Attribute attribute) {
        if (this.getSession() != null) {
            attribute.setSession(this.getSession());
        }
        attribute.setTask(this);
        this.attributes.add(attribute);
    }

    public void add(AssetType assetType) {
        if (this.getSession() != null) {
            assetType.setSession(this.getSession());
        }
        assetType.setTask(this);
        this.assetTypes.add(assetType);
    }

    protected void createAssetTypes() {
        for (AssetType at : this.assetTypes) {
            RAMAssetType assetType = this.getSession().getAssetType(at.getNewName());
            if (assetType == null) {
                assetType = this.getSession().createAssetType(at.getNewName());
            }
            if (at.getDescription() != null) {
                assetType.setDescription(at.getDescription());
            }
            at.setAssetType(assetType);
            this.getSession().put((IRAMSessionObject)assetType, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void createAttributes() {
        for (Attribute a : this.attributes) {
            RAMAssetAttribute attribute = this.getSession().getAssetAttribute(a.getNewName());
            if (attribute == null) {
                attribute = this.getSession().createAssetAttribute(a.getNewName());
            }
            if (a.getNewDescription() != null) {
                attribute.setDescription(a.getNewDescription());
            }
            if (a.getValidValues() != null) {
                attribute.setValidValues(a.getValidValues());
                attribute.setSingleSetting(a.isSingleSelect());
            }
            a.setAttribute(attribute);
            this.getSession().put((IRAMSessionObject)attribute, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void createCommunities() {
        for (Community c : this.communities) {
            RAMCommunity community = this.getSession().getCommunity(c.getNewName());
            if (community == null) {
                community = this.getSession().createCommunity(c.getNewName());
            }
            if (c.getNewDescription() != null) {
                community.setDescription(c.getNewDescription());
            }
            c.setCommunity(community);
            this.getSession().put((IRAMSessionObject)community, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void createRelationshipTypes() {
        for (RelationshipType rt : this.relationshipTypes) {
            RAMRelationshipType relationshipType = this.getSession().getRelationshipType(rt.getNewName());
            if (relationshipType == null) {
                relationshipType = this.getSession().createRelationshipType(rt.getNewName(), rt.getNewReverseName());
            } else if (!relationshipType.getReverseName().equals(rt.getNewReverseName())) {
                LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.CreateTask.RelationshipTypeExists"), rt.getName(), rt.getNewReverseName(), relationshipType.getName(), relationshipType.getReverseName()));
            }
            rt.setRelationshipType(relationshipType);
            this.getSession().put((IRAMSessionObject)relationshipType, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public void execute() throws BuildException {
        try {
            super.execute();
            this.createAssetTypes();
            this.createAttributes();
            this.createCommunities();
            this.createRelationshipTypes();
        }
        catch (Exception e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.communities);
        return children;
    }
}

