/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.google.gson.JsonObject;
import com.ibm.ram.client.RAMClientProperties;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.AbstractRESTClient;
import com.ibm.ram.internal.client.IRESTCacheManager;
import com.ibm.ram.internal.client.RAMClient;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.client.util.StringUtils;
import com.ibm.ram.internal.jaxb.Error;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.jaxb.util.JAXButil;
import com.ibm.ram.internal.json.JsonUtil;
import com.ibm.ram.internal.rest.Request;
import com.ibm.ram.internal.rest.Response;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.log4j.Logger;

public class RESTCacheManager
implements IRESTCacheManager {
    private static final String TRASH_SET_LOCK = "TRASH_SET_LOCK";
    private static Set trashSet = new HashSet();
    private static int MAX_TRASH_SET_SIZE = 50;
    public static File cacheFolder = null;
    private static RESTCacheManager INSTANCE = null;
    private static final Logger LOGGER = Logger.getLogger(RESTCacheManager.class);
    private static boolean canDebug = LOGGER.isDebugEnabled();
    private static long VERY_SHORT_TIMEOUT = 6000L;
    private static long SHORT_LOGIN_TIMEOUT = 60000L;
    private HashMap<String, Long> dontAccessUntil = new HashMap();
    private Map<String, RESTEntry> resourcesMap = new HashMap<String, RESTEntry>();
    private static volatile boolean deleteTemp = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RESTCacheManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<RESTCacheManager> clazz = RESTCacheManager.class;
        synchronized (RESTCacheManager.class) {
            if (cacheFolder == null) {
                String property = RAMClientProperties.getProperty((String)RAMClientProperties.REST_CACHE_FOLDER_PROPERTY_KEY);
                if (property == null) {
                    String tmpLocation = System.getProperty("java.io.tmpdir");
                    if (!tmpLocation.endsWith(System.getProperty("file.separator"))) {
                        tmpLocation = String.valueOf(tmpLocation) + System.getProperty("file.separator");
                    }
                    tmpLocation = String.valueOf(tmpLocation) + "local_ram_rest_cache_store";
                    cacheFolder = new File(tmpLocation);
                } else {
                    cacheFolder = new File(property);
                }
                if (!cacheFolder.exists()) {
                    cacheFolder.mkdir();
                }
            }
            deleteTemp = Boolean.valueOf(RAMClientProperties.getProperty((String)RAMClientProperties.REST_CACHE_TEMP_DELET_KEY));
            RAMClientProperties.subscribe((Observer)new Observer(){

                @Override
                public void update(Observable observable, Object data) {
                    deleteTemp = Boolean.valueOf((String)data);
                }
            }, (String[])new String[]{RAMClientProperties.REST_CACHE_TEMP_DELET_KEY});
            INSTANCE = new RESTCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private RESTCacheManager() {
    }

    public void login(AbstractRESTClient restClient, HttpMethod method) throws RAMServiceException {
        RAMClient ramClient = (RAMClient)restClient.getRAMClient();
        HttpClient httpClient = ramClient.getHTTPClient();
        if (ramClient.isAuthenticationRequired()) {
            method.setDoAuthentication(true);
            httpClient.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(ramClient.getUserName(), ramClient.getPassword()));
        } else {
            method.setDoAuthentication(false);
        }
        if (ramClient.getUploadDownloadTimeout() > 0) {
            httpClient.getParams().setSoTimeout(ramClient.getUploadDownloadTimeout());
        }
        method.addRequestHeader("Accept-Language", Locale.getDefault().toString());
    }

    public <T> Response<T> getResource(AbstractRESTClient client, Request request, Class<T> class1) throws RAMServiceException {
        try {
            return this.getResource(client, request, class1, false);
        }
        catch (RAMServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RAMServiceException(500, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public <T> Response<T> getResource(AbstractRESTClient client, Request request, Class<T> class1, boolean resolveAllLinks) throws RAMServiceException {
        try {
            String serverResourcePath = request.getRequestURI().toString();
            HashMap<String, Object> serverPathToResourceMap = new HashMap<String, Object>();
            Response response = this.primGetResourceObject(client, request, resolveAllLinks, serverPathToResourceMap);
            long lastModified = -1L;
            if (this.resourcesMap.containsKey(serverResourcePath)) {
                RESTEntry entry = this.resourcesMap.get(serverResourcePath);
                lastModified = entry.lastModified;
            }
            response.setLastModified(lastModified);
            return response;
        }
        catch (RAMServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RAMServiceException(500, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public InputStream getResourceContent(AbstractRESTClient client, Request request) throws RAMServiceException {
        String serverResourcePath = null;
        try {
            serverResourcePath = request.getRequestURI().toString();
        }
        catch (URISyntaxException e1) {
            throw new RAMServiceException(500, e1.getLocalizedMessage(), (Throwable)e1);
        }
        String fullResourcePath = this.resolveResourceURL(client, serverResourcePath);
        GetMethod resourceGET = RAMClient.createGet(fullResourcePath);
        try {
            this.login(client, (HttpMethod)resourceGET);
            HttpClient httpClient = ((RAMClient)client.getRAMClient()).getHTTPClient();
            resourceGET.setFollowRedirects(true);
            int executeMethod = httpClient.executeMethod((HttpMethod)resourceGET);
            if (executeMethod == 200) {
                return resourceGET.getResponseBodyAsStream();
            }
            throw new RAMServiceException(executeMethod, "Unable to retreive resource content from server: " + HttpStatus.getStatusText((int)executeMethod));
        }
        catch (HttpException e) {
            throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
        }
        catch (IOException e) {
            if ("The repository connection is currently logged out".equals(e.getMessage())) {
                throw new RAMServiceException(10008, e.getMessage(), (Throwable)e);
            }
            LOGGER.warn((Object)"Unable to retreive resource from server", (Throwable)e);
            throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Response primGetResourceObject(AbstractRESTClient client, Request request, final boolean resolveAllLinks, Map<String, Object> serverPathToResourceMap) throws RAMServiceException {
        serverResourcePath = null;
        try {
            serverResourcePath = request.getRequestURI().toString();
        }
        catch (URISyntaxException e1) {
            throw new RAMServiceException(500, e1.getLocalizedMessage(), (Throwable)e1);
        }
        requestEntry = this.readRequestHeaders(request);
        if (serverResourcePath != null && serverResourcePath.endsWith(".xml")) {
            serverResourcePath = serverResourcePath.substring(0, serverResourcePath.lastIndexOf(".xml"));
        }
        if (serverResourcePath != null && serverResourcePath.endsWith(".json")) {
            serverResourcePath = serverResourcePath.substring(0, serverResourcePath.lastIndexOf(".json"));
        }
        if (serverResourcePath != null && serverResourcePath.endsWith(".xhtml")) {
            serverResourcePath = serverResourcePath.substring(0, serverResourcePath.lastIndexOf(".xhtml"));
        }
        response = new Response(null);
        methodStartTime = System.currentTimeMillis();
        thread = Thread.currentThread();
        id = thread.getId();
        if (RESTCacheManager.canDebug) {
            RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): " + serverResourcePath));
        }
        if (serverPathToResourceMap.containsKey(serverResourcePath)) {
            response.setValue(serverPathToResourceMap.get(serverResourcePath));
            response.setStatus(200);
            return response;
        }
        serverResourcePathKey = null;
        restEntry = null;
        var15_14 = this.resourcesMap;
        synchronized (var15_14) {
            if (this.resourcesMap.containsKey(serverResourcePath)) {
                restEntry = this.resourcesMap.get(serverResourcePath);
                for (String path : this.resourcesMap.keySet()) {
                    if (!serverResourcePath.equals(path)) continue;
                    serverResourcePathKey = path;
                    break;
                }
            } else {
                restEntry = new RESTEntry();
                serverResourcePathKey = serverResourcePath;
                this.resourcesMap.put(serverResourcePath, restEntry);
            }
        }
        fullDownload = false;
        refreshInformation = false;
        resourceValue = null;
        resourceStream = null;
        linksToParentMap = new HashMap<K, V>();
        loadStart = 0L;
        var22_22 = restEntry;
        synchronized (var22_22) {
            block113: {
                if (requestEntry.neverStore) {
                    fullDownload = true;
                    refreshInformation = true;
                } else {
                    if (RESTCacheManager.canDebug) {
                        RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): (wait) key: " + serverResourcePathKey));
                    }
                    if (RESTCacheManager.canDebug) {
                        RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): (use) key: " + serverResourcePathKey));
                    }
                    resourceValue = restEntry.value;
                    if (restEntry.localPath != null && new File(restEntry.localPath).canRead()) {
                        if (restEntry.alwaysCheckServerForModification) {
                            if (RESTCacheManager.canDebug) {
                                RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): Always check server for modification"));
                            }
                            refreshInformation = true;
                        }
                        if (restEntry.neverStore) {
                            if (RESTCacheManager.canDebug) {
                                RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): Never cache. Always get full contents"));
                            }
                            fullDownload = true;
                            refreshInformation = true;
                            restEntry.value = null;
                            resourceValue = null;
                        } else if (restEntry.expires > -1L) {
                            if (System.currentTimeMillis() > restEntry.expires) {
                                if (RESTCacheManager.canDebug) {
                                    RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): Cache EXPIRED"));
                                }
                                fullDownload = true;
                                refreshInformation = true;
                                resourceValue = null;
                                restEntry.value = null;
                                this.deleteTmpFiles(id, restEntry);
                            } else if (RESTCacheManager.canDebug) {
                                RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): Cache NOT EXPIRED"));
                            }
                        }
                    } else {
                        if (RESTCacheManager.canDebug) {
                            RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): No local file"));
                        }
                        fullDownload = true;
                        refreshInformation = true;
                        resourceValue = null;
                        restEntry.value = null;
                    }
                    if (fullDownload || refreshInformation) {
                        if (this.dontAccessUntil.containsKey(serverResourcePath)) {
                            currentTime = System.currentTimeMillis();
                            dontAccessUntilTime = this.dontAccessUntil.get(serverResourcePathKey);
                            if (RESTCacheManager.canDebug) {
                                RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): DONTACCESS: current=" + currentTime + ", dontAccessUntil=" + dontAccessUntilTime + ", [" + serverResourcePath + "]"));
                            }
                            if (currentTime > dontAccessUntilTime) {
                                if (RESTCacheManager.canDebug) {
                                    RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): DONT ACCESS: EXPIRED"));
                                }
                                this.dontAccessUntil.remove(serverResourcePath);
                                restEntry.value = null;
                                resourceValue = null;
                                this.deleteTmpFiles(id, restEntry);
                                fullDownload = true;
                            } else {
                                if (RESTCacheManager.canDebug) {
                                    RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): DONT ACCESS: Using value"));
                                }
                                resourceValue = restEntry.value;
                                refreshInformation = false;
                                fullDownload = false;
                            }
                        } else {
                            resourceValue = null;
                        }
                    }
                }
                if (resourceValue != null) break block113;
                if (RESTCacheManager.canDebug) {
                    RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): No value determined for " + serverResourcePath + ", refresh=" + refreshInformation + ", full download=" + fullDownload));
                }
                fullResourcePath = this.resolveResourceURL(client, serverResourcePath);
                resourceGET = RAMClient.createGet(fullResourcePath);
                try {
                    try {
                        if (!refreshInformation && !fullDownload) ** GOTO lbl220
                        this.login(client, (HttpMethod)resourceGET);
                        downloadStartTime = System.currentTimeMillis();
                        httpClient = ((RAMClient)client.getRAMClient()).getHTTPClient();
                        resourceGET.setFollowRedirects(true);
                        lastModified = restEntry.lastModified;
                        eTag = restEntry.eTag;
                        modifiedSince = null;
                        if (lastModified > -1L) {
                            modifiedSince = DateUtil.formatDate((Date)new Date(lastModified));
                            resourceGET.addRequestHeader(new Header("If-Modified-Since", modifiedSince));
                        }
                        if (eTag != null) {
                            resourceGET.addRequestHeader("If-None-Match", eTag);
                        }
                        if (!request.getParameterMap().isEmpty()) {
                            nvps = new NameValuePair[request.getParameterMap().size()];
                            i = 0;
                            for (Map.Entry<K, V> entry : request.getParameterMap().entrySet()) {
                                nvps[i++] = new NameValuePair((String)entry.getKey(), (String)entry.getValue());
                            }
                            resourceGET.setQueryString(nvps);
                        }
                        for (Map.Entry<K, V> entry : request.getHeadersMap().entrySet()) {
                            resourceGET.addRequestHeader(new Header((String)entry.getKey(), (String)entry.getValue()));
                        }
                        if (RESTCacheManager.canDebug) {
                            RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): GET with If-Modified-Since=" + modifiedSince + ", eTAG=" + eTag));
                        }
                        getStatus = httpClient.executeMethod((HttpMethod)resourceGET);
                        this.readHeaders(restEntry, resourceGET);
                        modifiedSinceLast = lastModified < 0L ? true : lastModified != restEntry.lastModified;
                        fullDownload = fullDownload != false || modifiedSinceLast != false;
                        response.setValue(serverPathToResourceMap.get(serverResourcePath));
                        response.setStatus(getStatus);
                        if (getStatus == 304) {
                            if (RESTCacheManager.canDebug) {
                                RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): NOT MODIFIED. Using cache at: " + restEntry.localPath));
                            }
                            resourceStream = new FileInputStream(new File(restEntry.localPath));
                        } else if (getStatus == 200) {
                            if (fullDownload) {
                                name = "cache";
                                extension = null;
                                restPathIndex = -1;
                                restPathLength = 0;
                                restPathIndex = fullResourcePath.indexOf("/internal/");
                                if (restPathIndex > -1) {
                                    restPathLength = "/internal/".length();
                                } else {
                                    restPathIndex = fullResourcePath.indexOf("/oslc/");
                                    if (restPathIndex > -1) {
                                        restPathLength = "/oslc/".length();
                                    }
                                }
                                if (restPathIndex > -1 && fullResourcePath.length() > restPathIndex + restPathLength) {
                                    sub = StringUtils.stripSlashPrefix((String)fullResourcePath.substring(restPathIndex + restPathLength));
                                    index1 = sub.indexOf("/");
                                    if (index1 > 0) {
                                        name = sub.substring(0, index1);
                                    }
                                } else {
                                    fileName = fullResourcePath.substring(fullResourcePath.lastIndexOf("/") + 1);
                                    lastIndex = fileName.lastIndexOf(63);
                                    if (lastIndex > -1) {
                                        fileName = fileName.substring(0, lastIndex);
                                    }
                                    if ((index = fileName.lastIndexOf(46)) > -1) {
                                        name = fileName.substring(0, index);
                                        extension = fileName.substring(index + 1);
                                    }
                                }
                                if (name == null || name.length() < 3) {
                                    name = "CACHE" + (name == null ? "" : name);
                                }
                                if (!RESTCacheManager.cacheFolder.exists()) {
                                    RESTCacheManager.cacheFolder.mkdir();
                                }
                                cacheFile = File.createTempFile(name, extension, RESTCacheManager.cacheFolder);
                                cacheFile.deleteOnExit();
                                is = resourceGET.getResponseBodyAsStream();
                                fos = new FileOutputStream(cacheFile);
                                UtilitiesCommon.copyStreams((InputStream)is, (OutputStream)fos, null, (boolean)true, (boolean)true);
                                if (RESTCacheManager.canDebug) {
                                    RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): DOWNLOADED in " + (System.currentTimeMillis() - downloadStartTime) + "ms from:" + serverResourcePath));
                                }
                                restEntry.localPath = cacheFile.getAbsolutePath();
                            }
                            resourceStream = new FileInputStream(new File(restEntry.localPath));
                        } else if (getStatus == 500) {
                            download = resourceGET.getResponseBodyAsStream();
                            if (download != null) {
                                rse = RESTCacheManager.handleRestError(download);
                                throw rse;
                            }
                        } else if (getStatus == 404) {
                            if (RESTCacheManager.canDebug) {
                                RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): NOT FOUND"));
                            }
                            resourceStream = null;
                            restEntry.clear();
                        } else {
                            if (RESTCacheManager.canDebug) {
                                RESTCacheManager.LOGGER.debug((Object)("Error getting resource : " + fullResourcePath + " - " + resourceGET.getStatusCode() + " - " + resourceGET.getResponseBodyAsString()));
                            }
                            if ((download = resourceGET.getResponseBodyAsStream()) != null) {
                                rse = RESTCacheManager.handleRestError(download);
                                throw rse;
                            }
                            throw new RAMServiceException(resourceGET.getStatusCode(), resourceGET.getResponseBodyAsString());
lbl220:
                            // 1 sources

                            if (RESTCacheManager.canDebug) {
                                RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): Reading from cache: " + restEntry.localPath));
                            }
                            if (restEntry.localPath != null) {
                                resourceStream = new FileInputStream(new File(restEntry.localPath));
                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new RAMServiceException(10006, "Unable to locate cached resource", (Throwable)e);
                    }
                    catch (HttpException e) {
                        throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
                    }
                    catch (JAXBException e) {
                        throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
                    }
                    catch (IOException e) {
                        this.dontAccessUntil.put(serverResourcePath, System.currentTimeMillis() + RESTCacheManager.SHORT_LOGIN_TIMEOUT);
                        if ("The repository connection is currently logged out".equals(e.getMessage())) {
                            throw new RAMServiceException(10008, e.getMessage(), (Throwable)e);
                        }
                        throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
                    }
                }
                finally {
                    resourceGET.releaseConnection();
                }
                if (resourceStream != null) {
                    loadStart = System.currentTimeMillis();
                    try {
                        if (resourceGET.getResponseHeader("Content-Type").getValue().contains("json")) {
                            br = null;
                            br = new BufferedReader(new InputStreamReader((InputStream)resourceStream, "UTF-8"));
                            type = request.getRespondingType();
                            resourceValue = type != null ? JsonUtil.getGson().fromJson((Reader)br, type) : JsonUtil.getGson().fromJson((Reader)br, String[].class);
                        } else {
                            m = JAXButil.getXMLunMarshaller();
                            m.setListener(new Unmarshaller.Listener(){

                                public void afterUnmarshal(Object target, Object parent) {
                                    if (resolveAllLinks && target instanceof Link) {
                                        linksToParentMap.put((Link)target, parent);
                                    }
                                }

                                public void beforeUnmarshal(Object target, Object parent) {
                                }
                            });
                            f = (JAXBElement)m.unmarshal((InputStream)resourceStream);
                            resourceValue = f.getValue();
                        }
                        restEntry.value = resourceValue;
                    }
                    catch (UnsupportedEncodingException e) {
                        RESTCacheManager.LOGGER.warn((Object)("Unable to deserialize resource at path: " + serverResourcePath + " the resource should be of format json"), (Throwable)e);
                        try {
                            resourceStream.close();
                        }
                        catch (IOException e) {
                            RESTCacheManager.LOGGER.warn((Object)("Resource stream: " + resourceStream.toString() + " can not be closed"), (Throwable)e);
                        }
                        break block113;
                    }
                    catch (JAXBException e) {
                        try {
                            RESTCacheManager.LOGGER.warn((Object)("Unable to deserialize resource at path: " + serverResourcePath), (Throwable)e);
                            break block113;
                        }
                        catch (Throwable var27_38) {
                            throw var27_38;
                        }
                        finally {
                            try {
                                resourceStream.close();
                            }
                            catch (IOException e) {
                                RESTCacheManager.LOGGER.warn((Object)("Resource stream: " + resourceStream.toString() + " can not be closed"), (Throwable)e);
                            }
                        }
                    }
                    try {
                        resourceStream.close();
                    }
                    catch (IOException e) {
                        RESTCacheManager.LOGGER.warn((Object)("Resource stream: " + resourceStream.toString() + " can not be closed"), (Throwable)e);
                    }
                }
            }
        }
        if (resourceStream != null) {
            serverPathToResourceMap.put(serverResourcePath, resourceValue);
            if (!linksToParentMap.isEmpty()) {
                keySet = linksToParentMap.keySet();
                for (Link link : keySet) {
                    href = link.getHref();
                    if (link.getValue() != null || href == null) continue;
                    if (RESTCacheManager.canDebug) {
                        RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): [" + serverResourcePath + "] >> CHILD [" + href + "]"));
                    }
                    link.setValue(this.primGetResourceObject(client, new Request(href), resolveAllLinks, serverPathToResourceMap).getValue());
                }
            }
            dontUntil = System.currentTimeMillis() + RESTCacheManager.VERY_SHORT_TIMEOUT;
            var24_36 = this.dontAccessUntil;
            synchronized (var24_36) {
                this.dontAccessUntil.put(serverResourcePath, dontUntil);
            }
            if (RESTCacheManager.canDebug) {
                RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): loaded in " + (System.currentTimeMillis() - loadStart) + " ms. DONT ACCESS till " + dontUntil + ". [" + serverResourcePath + "]"));
            }
        }
        if (RESTCacheManager.canDebug) {
            RESTCacheManager.LOGGER.debug((Object)("[" + id + "] getResource(): Returning value in " + (System.currentTimeMillis() - methodStartTime) + "ms for " + serverResourcePath));
        }
        response.setValue(resourceValue);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void deleteTmpFiles(final long id, RESTEntry restEntry) {
        if (deleteTemp && restEntry.localPath != null) {
            File file = new File(restEntry.localPath);
            String string = TRASH_SET_LOCK;
            // MONITORENTER : "TRASH_SET_LOCK"
            trashSet.add(file);
            if (trashSet.size() >= MAX_TRASH_SET_SIZE) {
                final Set oldTrash = trashSet;
                trashSet = new HashSet();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        File file = null;
                        int count = 0;
                        Iterator itr = oldTrash.iterator();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("deleting temp files for REST Cache start at: " + new Date().toString()));
                        }
                        while (itr.hasNext()) {
                            try {
                                file = (File)itr.next();
                                if (!file.delete()) {
                                    if (!LOGGER.isDebugEnabled()) continue;
                                    LOGGER.debug((Object)("[" + id + "] deleteTmpFiles(). tmp file: " + file.getName() + " can not be deleted. temp file will be deleted by File.deleteOnExit."));
                                    continue;
                                }
                                ++count;
                                if (!LOGGER.isDebugEnabled()) continue;
                                LOGGER.debug((Object)("[" + id + "] deleteTmpFiles(). tmp file: " + file.getName() + " is deleted."));
                            }
                            catch (Exception e) {
                                LOGGER.warn((Object)("Exception thrown while deleting temp file: " + file.getAbsolutePath()), (Throwable)e);
                            }
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("deleting temp files for REST Cache ends at: " + new Date().toString() + ". " + count + " files deleted."));
                        }
                    }
                }).start();
            }
            // MONITOREXIT : string
        }
        restEntry.localPath = null;
    }

    public void clearCache(String serverResourcePath) {
        if (serverResourcePath != null && serverResourcePath.endsWith(".xml")) {
            serverResourcePath = serverResourcePath.substring(0, serverResourcePath.lastIndexOf(".xml"));
        }
        this.dontAccessUntil.remove(serverResourcePath);
    }

    private void readHeaders(RESTEntry restEntry, GetMethod resourceGET) {
        Header eTagHeader;
        Header lastModifiedHeader;
        HeaderElement[] elements;
        String eTag = null;
        long lastModified = -1L;
        long maxAge = -1L;
        long expires = -1L;
        boolean alwaysCheckServerForModification = true;
        boolean neverStore = false;
        Header cacheControlHeader = resourceGET.getResponseHeader("Cache-Control");
        if (cacheControlHeader != null && (elements = cacheControlHeader.getElements()) != null) {
            int hc = 0;
            while (hc < elements.length) {
                if (elements[hc].getName().equals("no-cache")) {
                    alwaysCheckServerForModification = true;
                }
                if (elements[hc].getName().equals("no-store")) {
                    neverStore = true;
                }
                if (elements[hc].getName().equals("max-age")) {
                    maxAge = Long.parseLong(elements[hc].getValue());
                }
                ++hc;
            }
        }
        if ((lastModifiedHeader = resourceGET.getResponseHeader("Last-Modified")) != null) {
            try {
                lastModified = DateUtil.parseDate((String)lastModifiedHeader.getValue()).getTime();
            }
            catch (DateParseException e) {
                LOGGER.warn((Object)"Unable to determine last modified time of resource", (Throwable)e);
            }
        }
        if ((eTagHeader = resourceGET.getResponseHeader("ETag")) != null) {
            eTag = eTagHeader.getValue();
        }
        long maxAgeTime = maxAge > -1L ? System.currentTimeMillis() + maxAge : -1L;
        expires = Math.max(maxAgeTime, expires);
        restEntry.alwaysCheckServerForModification = alwaysCheckServerForModification;
        restEntry.eTag = eTag;
        restEntry.expires = expires;
        restEntry.lastModified = lastModified;
        restEntry.neverStore = neverStore;
    }

    private RESTEntry readRequestHeaders(Request request) {
        String cacheControlHeader = (String)request.getHeadersMap().get("Cache-Control");
        RESTEntry ret = new RESTEntry();
        ret.neverStore = false;
        if (cacheControlHeader != null && cacheControlHeader.equals("no-store")) {
            ret.neverStore = true;
        }
        return ret;
    }

    public <T> Response<T> postResource(AbstractRESTClient client, String resourcePath, JAXBElement postElement, Class<T> class1) throws RAMServiceException {
        Response response;
        block9: {
            response = new Response(null);
            try {
                Marshaller m = JAXButil.getXMLMarshaller((String)"http://jazz.net/xmlns/ecalm/ram/internal/v7.2");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                m.marshal((Object)postElement, (OutputStream)baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                InputStreamRequestEntity isre = new InputStreamRequestEntity((InputStream)bais);
                PostMethod resourcePost = new PostMethod(this.resolveResourceURL(client, resourcePath));
                this.login(client, (HttpMethod)resourcePost);
                resourcePost.setRequestEntity((RequestEntity)isre);
                int postResponse = ((RAMClient)client.getRAMClient()).getHTTPClient().executeMethod((HttpMethod)resourcePost);
                response.setStatus(postResponse);
                if (postResponse == 201 || postResponse == 200) {
                    InputStream download = resourcePost.getResponseBodyAsStream();
                    if (download != null) {
                        Unmarshaller um = JAXButil.getXMLunMarshaller();
                        JAXBElement f = (JAXBElement)um.unmarshal(download);
                        T resource = class1.cast(f.getValue());
                        response.setValue(resource);
                    }
                    break block9;
                }
                if (postResponse == 500) {
                    InputStream download = resourcePost.getResponseBodyAsStream();
                    if (download != null) {
                        RAMServiceException rse = RESTCacheManager.handleRestError(download);
                        throw rse;
                    }
                    break block9;
                }
                if (canDebug) {
                    LOGGER.debug((Object)("Error POSTing resource : " + this.resolveResourceURL(client, resourcePath) + " - " + postResponse + " - " + resourcePost.getResponseBodyAsString()));
                }
                throw new RAMServiceException(postResponse, HttpStatus.getStatusText((int)postResponse));
            }
            catch (IOException e) {
                if ("The repository connection is currently logged out".equals(e.getMessage())) {
                    throw new RAMServiceException(10008, e.getMessage(), (Throwable)e);
                }
                LOGGER.warn((Object)"Unable to retreive resource from server", (Throwable)e);
                throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
            }
            catch (JAXBException e) {
                LOGGER.warn((Object)"Unable to deserialize resource", (Throwable)e);
                throw new RAMServiceException(10006, "Unable to deserialize resource", (Throwable)e);
            }
        }
        return response;
    }

    private static RAMServiceException handleRestError(InputStream errorStream) throws JAXBException {
        Unmarshaller um = JAXButil.getXMLunMarshaller();
        JAXBElement f = (JAXBElement)um.unmarshal(errorStream);
        Error error = (Error)Error.class.cast(f.getValue());
        RAMServiceException rse = new RAMServiceException(error.getStatusCode(), error.getMessage());
        StackTraceElement[] ste = new StackTraceElement[error.getTrace().size()];
        int i = 0;
        while (i < ste.length) {
            Error.ErrorTraceElement ete = (Error.ErrorTraceElement)error.getTrace().get(i);
            ste[i] = new StackTraceElement(ete.getClassName(), ete.getMethodName(), ete.getFileName(), ete.getLineNumber());
            ++i;
        }
        rse.setStackTrace(ste);
        return rse;
    }

    private String resolveResourceURL(AbstractRESTClient client, String resourceRelativePath) throws RAMServiceException {
        if (client.getRAMClient().isAnonymous) {
            if (AbstractRAMClient.ServerVersion.VERSION_751.compareTo((Enum)client.getRAMClient().getServerVersion()) <= 0) {
                return JAXBLinksUtil.createURL((String)((RAMClient)client.getRAMClient()).getWebServicesPath(), (String)resourceRelativePath, (boolean)true);
            }
            return JAXBLinksUtil.createURL((String)((RAMClient)client.getRAMClient()).getWebServerPath(), (String)resourceRelativePath, (boolean)true);
        }
        if (AbstractRAMClient.ServerVersion.VERSION_751.compareTo((Enum)client.getRAMClient().getServerVersion()) <= 0) {
            return JAXBLinksUtil.createURL((String)(String.valueOf(((RAMClient)client.getRAMClient()).getWebServicesPath()) + "/RAMSecure"), (String)resourceRelativePath, (boolean)true);
        }
        return JAXBLinksUtil.createURL((String)((RAMClient)client.getRAMClient()).getWebServicesPath(), (String)resourceRelativePath, (boolean)true);
    }

    public <T> T deleteResource(AbstractRESTClient client, String resourcePath, Class<T> class1) throws RAMServiceException {
        T resource;
        block7: {
            resource = null;
            try {
                DeleteMethod resourceDelete = new DeleteMethod(this.resolveResourceURL(client, resourcePath));
                this.login(client, (HttpMethod)resourceDelete);
                int postResponse = ((RAMClient)client.getRAMClient()).getHTTPClient().executeMethod((HttpMethod)resourceDelete);
                if (postResponse == 200) {
                    this.clearCache(resourcePath);
                    break block7;
                }
                if (postResponse == 500) {
                    InputStream download = resourceDelete.getResponseBodyAsStream();
                    if (download != null) {
                        RAMServiceException rse = RESTCacheManager.handleRestError(download);
                        throw rse;
                    }
                    break block7;
                }
                LOGGER.warn((Object)("Error Deleteing resource : " + this.resolveResourceURL(client, resourcePath) + " - " + postResponse + " - " + resourceDelete.getResponseBodyAsString()));
                throw new RAMServiceException(postResponse, HttpStatus.getStatusText((int)postResponse));
            }
            catch (IOException e) {
                if ("The repository connection is currently logged out".equals(e.getMessage())) {
                    throw new RAMServiceException(10008, e.getMessage(), (Throwable)e);
                }
                LOGGER.warn((Object)"Unable to retreive resource from server", (Throwable)e);
                throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
            }
            catch (JAXBException e) {
                LOGGER.warn((Object)"Unable to deserialize resource", (Throwable)e);
                throw new RAMServiceException(10006, "Unable to deserialize resource", (Throwable)e);
            }
        }
        return resource;
    }

    public <T> Response<T> headResource(AbstractRESTClient client, Request request) throws RAMServiceException {
        try {
            Response response = this.primHeadResourceObject(client, request);
            long lastModified = -1L;
            response.setLastModified(lastModified);
            return response;
        }
        catch (RAMServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RAMServiceException(500, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected Response primHeadResourceObject(AbstractRESTClient client, Request request) throws RAMServiceException {
        Response resp;
        block25: {
            String serverResourcePath = null;
            try {
                serverResourcePath = request.getRequestURI().toString();
            }
            catch (URISyntaxException e1) {
                throw new RAMServiceException(500, e1.getLocalizedMessage(), (Throwable)e1);
            }
            if (serverResourcePath != null && serverResourcePath.endsWith(".xml")) {
                serverResourcePath = serverResourcePath.substring(0, serverResourcePath.lastIndexOf(".xml"));
            }
            if (serverResourcePath != null && serverResourcePath.endsWith(".json")) {
                serverResourcePath = serverResourcePath.substring(0, serverResourcePath.lastIndexOf(".json"));
            }
            if (serverResourcePath != null && serverResourcePath.endsWith(".xhtml")) {
                serverResourcePath = serverResourcePath.substring(0, serverResourcePath.lastIndexOf(".xhtml"));
            }
            resp = new Response(null);
            long id = Thread.currentThread().getId();
            if (canDebug) {
                LOGGER.debug((Object)("[" + id + "] getResource(): No value determined for " + serverResourcePath));
            }
            String fullResourcePath = this.resolveResourceURL(client, serverResourcePath);
            HeadMethod resourceHead = RAMClient.createHead(fullResourcePath);
            try {
                try {
                    InputStream download;
                    this.login(client, (HttpMethod)resourceHead);
                    HttpClient httpClient = ((RAMClient)client.getRAMClient()).getHTTPClient();
                    resourceHead.setFollowRedirects(true);
                    for (Map.Entry entry : request.getHeadersMap().entrySet()) {
                        resourceHead.addRequestHeader(new Header((String)entry.getKey(), (String)entry.getValue()));
                    }
                    if (canDebug) {
                        LOGGER.debug((Object)("[" + id + "] getResource(): Head"));
                    }
                    int getStatus = httpClient.executeMethod((HttpMethod)resourceHead);
                    resp.setStatus(getStatus);
                    if (getStatus == 304) {
                        if (canDebug) {
                            LOGGER.debug((Object)("[" + id + "] headResource(): NOT MODIFIED."));
                        }
                        break block25;
                    }
                    if (getStatus == 200) break block25;
                    if (getStatus == 500) {
                        download = resourceHead.getResponseBodyAsStream();
                        if (download != null) {
                            RAMServiceException rse = RESTCacheManager.handleRestError(download);
                            throw rse;
                        }
                        break block25;
                    }
                    if (getStatus == 404) {
                        if (canDebug) {
                            LOGGER.debug((Object)("[" + id + "] headResource(): NOT FOUND"));
                        }
                        break block25;
                    }
                    if (canDebug) {
                        LOGGER.debug((Object)("Error getting resource : " + fullResourcePath + " - " + resourceHead.getStatusCode() + " - " + resourceHead.getResponseBodyAsString()));
                    }
                    if ((download = resourceHead.getResponseBodyAsStream()) != null) {
                        RAMServiceException rse = RESTCacheManager.handleRestError(download);
                        throw rse;
                    }
                    throw new RAMServiceException(resourceHead.getStatusCode(), resourceHead.getResponseBodyAsString());
                }
                catch (FileNotFoundException e) {
                    throw new RAMServiceException(10006, "Unable to locate cached resource", (Throwable)e);
                }
                catch (HttpException e) {
                    throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
                }
                catch (JAXBException e) {
                    throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
                }
                catch (IOException e) {
                    this.dontAccessUntil.put(serverResourcePath, System.currentTimeMillis() + SHORT_LOGIN_TIMEOUT);
                    if ("The repository connection is currently logged out".equals(e.getMessage())) {
                        throw new RAMServiceException(10008, e.getMessage(), (Throwable)e);
                    }
                    throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
                }
            }
            finally {
                resourceHead.releaseConnection();
            }
        }
        return resp;
    }

    public <T> T putResource(AbstractRESTClient client, String resourcePath, JAXBElement putElement, Class<T> class1) throws RAMServiceException {
        T resource;
        block8: {
            resource = null;
            try {
                Marshaller m = JAXButil.getXMLMarshaller((String)"http://jazz.net/xmlns/ecalm/ram/internal/v7.2");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                m.marshal((Object)putElement, (OutputStream)baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                InputStreamRequestEntity isre = new InputStreamRequestEntity((InputStream)bais);
                PutMethod resourcePost = RAMClient.createPut(this.resolveResourceURL(client, resourcePath));
                this.login(client, (HttpMethod)resourcePost);
                resourcePost.setRequestEntity((RequestEntity)isre);
                int postResponse = ((RAMClient)client.getRAMClient()).getHTTPClient().executeMethod((HttpMethod)resourcePost);
                if (class1 != null && postResponse == 200) {
                    InputStream download = resourcePost.getResponseBodyAsStream();
                    if (download != null) {
                        Unmarshaller um = JAXButil.getXMLunMarshaller();
                        JAXBElement f = (JAXBElement)um.unmarshal(download);
                        resource = class1.cast(f.getValue());
                    }
                    break block8;
                }
                if (postResponse == 500) {
                    InputStream download = resourcePost.getResponseBodyAsStream();
                    if (download != null) {
                        RAMServiceException rse = RESTCacheManager.handleRestError(download);
                        throw rse;
                    }
                    break block8;
                }
                LOGGER.warn((Object)("Error POSTing resource : " + this.resolveResourceURL(client, resourcePath) + " - " + postResponse + " - " + resourcePost.getResponseBodyAsString()));
                throw new RAMServiceException(postResponse, HttpStatus.getStatusText((int)postResponse));
            }
            catch (IOException e) {
                if ("The repository connection is currently logged out".equals(e.getMessage())) {
                    throw new RAMServiceException(10008, e.getMessage(), (Throwable)e);
                }
                LOGGER.warn((Object)"Unable to retreive resource from server", (Throwable)e);
                throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
            }
            catch (JAXBException e) {
                LOGGER.warn((Object)"Unable to deserialize resource", (Throwable)e);
                throw new RAMServiceException(10006, "Unable to deserialize resource", (Throwable)e);
            }
        }
        return resource;
    }

    public void putResource(AbstractRESTClient client, String resourcePath, JAXBElement putElement) throws RAMServiceException {
        this.putResource(client, resourcePath, putElement, null);
    }

    public <T> T putResource(AbstractRESTClient client, String resourcePath, JsonObject putObject, Class<T> class1) throws RAMServiceException {
        T resource;
        block6: {
            resource = null;
            try {
                String jsonText = putObject.toString();
                ByteArrayInputStream bais = new ByteArrayInputStream(jsonText.getBytes());
                InputStreamRequestEntity isre = new InputStreamRequestEntity((InputStream)bais);
                PutMethod resourcePut = RAMClient.createPut(this.resolveResourceURL(client, resourcePath));
                this.login(client, (HttpMethod)resourcePut);
                resourcePut.setRequestEntity((RequestEntity)isre);
                int putResponse = ((RAMClient)client.getRAMClient()).getHTTPClient().executeMethod((HttpMethod)resourcePut);
                if (putResponse == 200) {
                    InputStream download = resourcePut.getResponseBodyAsStream();
                    resource = this.readJSON(download, class1);
                    break block6;
                }
                if (putResponse == 500) {
                    InputStream download = resourcePut.getResponseBodyAsStream();
                    if (download != null) {
                        RAMServiceException rse = RESTCacheManager.handleRestError(download);
                        throw rse;
                    }
                    break block6;
                }
                LOGGER.warn((Object)("Error POSTing resource : " + this.resolveResourceURL(client, resourcePath) + " - " + putResponse + " - " + resourcePut.getResponseBodyAsString()));
                throw new RAMServiceException(putResponse, HttpStatus.getStatusText((int)putResponse));
            }
            catch (Exception e) {
                if ("The repository connection is currently logged out".equals(e.getMessage())) {
                    throw new RAMServiceException(10008, e.getMessage(), (Throwable)e);
                }
                LOGGER.warn((Object)"Unable to retreive resource from server", (Throwable)e);
                throw new RAMServiceException(10002, "Unable to retreive resource from server", (Throwable)e);
            }
        }
        return resource;
    }

    private <T> T readJSON(InputStream download, Class<T> class1) throws IOException, IllegalAccessException, InstantiationException {
        Object resource = null;
        if (download != null) {
            StringBuffer buf = new StringBuffer();
            try {
                int ch;
                while ((ch = download.read()) > -1) {
                    buf.append((char)ch);
                }
            }
            catch (Throwable throwable) {
                try {
                    download.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                download.close();
            }
            catch (IOException iOException) {}
            resource = JsonUtil.getGson().fromJson(buf.toString(), class1);
        }
        return (T)resource;
    }

    private static class RESTEntry {
        public String localPath = null;
        public String eTag = null;
        public long lastModified = -1L;
        public long expires = -1L;
        public boolean alwaysCheckServerForModification = true;
        public boolean neverStore = false;
        public Object value;

        private RESTEntry() {
        }

        public void clear() {
            this.localPath = null;
            this.eTag = null;
            this.lastModified = -1L;
            this.expires = -1L;
            this.alwaysCheckServerForModification = true;
            this.neverStore = false;
            this.value = null;
        }
    }
}

