/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogLine {
    private final String msg;
    private final Throwable exception;
    private final Level level;
    public static final String LEVEL_KEY = "%level";

    public static void log(Collection<? extends LogLine> lines, Logger logger) {
        for (LogLine logLine : lines) {
            logLine.log(logger);
        }
    }

    public static void log(Collection<? extends LogLine> lines, PrintWriter printer, String defaultLineStart, Map<Level, String> levelLineStarts) {
        for (LogLine logLine : lines) {
            logLine.log(printer, defaultLineStart, levelLineStarts);
        }
    }

    public static void log(Collection<? extends LogLine> lines, PrintWriter printer, String defaultLineStart) {
        LogLine.log(lines, printer, defaultLineStart, Collections.<Level, String>emptyMap());
    }

    public LogLine(String msg, Throwable exception, Level level) {
        this.msg = msg;
        this.exception = exception;
        this.level = level;
    }

    public LogLine(String msg, Level level) {
        this(msg, null, level);
    }

    protected void log(Logger logger) {
        if (this.exception == null) {
            logger.log((Priority)this.level, (Object)this.msg);
        } else {
            logger.log((Priority)this.level, (Object)this.msg, this.exception);
        }
    }

    protected void log(PrintWriter printer, String defaultLineStart, Map<Level, String> levelLineStarts) {
        int ndx;
        String lineStart = levelLineStarts.get(this.level);
        if (lineStart == null && (ndx = (lineStart = defaultLineStart).indexOf(LEVEL_KEY)) >= 0) {
            lineStart = lineStart.replace(LEVEL_KEY, this.level.toString());
        }
        if (lineStart.length() > 0) {
            printer.print(lineStart);
        }
        printer.println(this.msg);
        if (this.exception != null) {
            this.exception.printStackTrace(printer);
        }
    }
}

