/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.data.AssetIdentification;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class FacetConverter {
    public static final String CATEGORY_SCHEMA_FACET_NAME = "Classification";
    public static final String PEER_CATEGORY_SCHEMA_FACET_NAME = "~Classification";
    public static final String STATE_FACET_NAME = "fState";
    public static final String PEER_STATE_FACET_NAME = "~fState";
    public static final String ASSET_TYPE_FACET_NAME = "fType";
    public static final String PEER_ASSET_TYPE_FACET_NAME = "~fType";
    public static final String COMMUNITY_FACET_NAME = "fGroup";
    public static final String PEER_COMMUNITY_FACET_NAME = "~fGroup";
    public static final String TAG_FACET_NAME = "fTag";
    public static final String PEER_TAG_FACET_NAME = "~fTag";
    public static final String RATING_FACET_NAME = "fRate";
    public static final String RELATED_ASSET_FACET_NAME = "fRelatedAssets";
    public static final String RELATIONSHIP_TYPE_FACET_NAME = "fRelationshipType";
    public static final String PEER_RELATIONSHIP_TYPE_FACET_NAME = "~fRelationshipType";
    public static final String DEVOPS_TYPE_FACET_NAME = "fDType";
    public static final String DEVOPS_TEST_RESULT_FACET_NAME = "fTType";
    public static final String DEVOPS_PACKAGE_TYPE_FACET_NAME = "fPType";
    public static final String DEVOPS_VIEW_FACET_NAME = "fView";
    public static final String DEVOPS_ENVIRONMENT_FACET_NAME = "fDEnvType";
    public static final String DEVOPS_COMPONENT_FACET_ITEM_NAME = "Component";
    public static final String DEVOPS_PACKAGE_FACET_ITEM_NAME = "Package";
    public static final String DEVOPS_ENVIRONMENT_FACET_ITEM_NAME = "Environment";
    public static final String DEVOPS_TEST_RESULT_PASSED_FACET_ITEM_NAME = "Passed";
    public static final String DEVOPS_TEST_RESULT_FAILED_FACET_ITEM_NAME = "Failed";
    public static final String SCHEMA_FACET_KEY = "facet_category";
    public static final String RELATED_SCHEMA_FACET_KEY = "related_facet_category";
    public static final String STATE_FACET_KEY = "facet_state";
    public static final String TYPE_FACET_KEY = "facet_type";
    public static final String GROUP_FACET_KEY = "facet_team_space";
    public static final String TAG_FACET_KEY = "facet_tag";
    public static final String RATING_FACET_KEY = "facet_rating";
    public static final String RELATED_ASSET_KEY = "facet_related_asset";
    public static final String RELATIONSHIP_TYPE_FACET_KEY = "facet_relationship_type";
    public static final String DEVOPS_TYPE_FACET_KEY = "facet_devops_type";
    public static final String DEVOPS_TEST_RESULT_FACET_KEY = "facet_devops_test_result";
    public static final String DEVOPS_VIEW_FACET_KEY = "facet_devops_view";
    public static final String DEVOPS_PACKAGE_TYPE_FACET_KEY = "facet_devops_package_type";
    public static final String DEVOPS_ENVIRONMENT_FACET_KEY = "facet_devops_environment_type";
    public static final Pattern FACET_SPACE_PATTERN = Pattern.compile("\\s|\u3000|/");
    public static final Pattern CATEGORY_FACET_SPACE_PATTERN = Pattern.compile("\\s|\u3000");
    public static final String RELATED_ASSET_FACET_DELIM = "com.ibm.ram.version";
    public static final Map<String, String> FACET_TITLE_KEY_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(FacetConverter.CATEGORY_SCHEMA_FACET_NAME, FacetConverter.SCHEMA_FACET_KEY);
            this.put(FacetConverter.PEER_CATEGORY_SCHEMA_FACET_NAME, FacetConverter.RELATED_SCHEMA_FACET_KEY);
            this.put(FacetConverter.STATE_FACET_NAME, FacetConverter.STATE_FACET_KEY);
            this.put(FacetConverter.PEER_STATE_FACET_NAME, FacetConverter.STATE_FACET_KEY);
            this.put(FacetConverter.ASSET_TYPE_FACET_NAME, FacetConverter.TYPE_FACET_KEY);
            this.put(FacetConverter.PEER_ASSET_TYPE_FACET_NAME, FacetConverter.TYPE_FACET_KEY);
            this.put(FacetConverter.COMMUNITY_FACET_NAME, FacetConverter.GROUP_FACET_KEY);
            this.put(FacetConverter.PEER_COMMUNITY_FACET_NAME, FacetConverter.GROUP_FACET_KEY);
            this.put(FacetConverter.TAG_FACET_NAME, FacetConverter.TAG_FACET_KEY);
            this.put(FacetConverter.RATING_FACET_NAME, FacetConverter.RATING_FACET_KEY);
            this.put(FacetConverter.RELATED_ASSET_FACET_NAME, FacetConverter.RELATED_ASSET_KEY);
            this.put(FacetConverter.RELATIONSHIP_TYPE_FACET_NAME, FacetConverter.RELATIONSHIP_TYPE_FACET_KEY);
            this.put(FacetConverter.PEER_RELATIONSHIP_TYPE_FACET_NAME, FacetConverter.RELATIONSHIP_TYPE_FACET_KEY);
            this.put(FacetConverter.DEVOPS_TYPE_FACET_NAME, FacetConverter.DEVOPS_TYPE_FACET_KEY);
            this.put(FacetConverter.DEVOPS_TEST_RESULT_FACET_NAME, FacetConverter.DEVOPS_TEST_RESULT_FACET_KEY);
            this.put(FacetConverter.DEVOPS_VIEW_FACET_NAME, FacetConverter.DEVOPS_VIEW_FACET_KEY);
            this.put(FacetConverter.DEVOPS_PACKAGE_TYPE_FACET_NAME, FacetConverter.DEVOPS_PACKAGE_TYPE_FACET_KEY);
            this.put(FacetConverter.DEVOPS_ENVIRONMENT_FACET_NAME, FacetConverter.DEVOPS_ENVIRONMENT_FACET_KEY);
        }
    };
    public static final Map<String, String> RATING_FACET_KEY_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("1", "facet_rating_1");
            this.put("2", "facet_rating_2");
            this.put("3", "facet_rating_3");
            this.put("4", "facet_rating_4");
        }
    };
    public static final String FACET_NAME_START = "com.ibm.ram.facet.name";
    public static final String FACET_OR_QUERY = "com.ibm.ram.or";
    public static final String FACET_NOT_QUERY = "com.ibm.ram.not";

    public static String convertFacetName(String descriptorName) {
        return FacetConverter.createIntervalValue(descriptorName);
    }

    public static String convertFacetValue(String descriptorValue) {
        return FacetConverter.createIntervalValue(descriptorValue);
    }

    public static String convertCategoryFacetValue(String categoryValue) {
        return CATEGORY_FACET_SPACE_PATTERN.matcher(categoryValue).replaceAll("_").toLowerCase();
    }

    private static String createIntervalValue(String value) {
        return FACET_SPACE_PATTERN.matcher(value).replaceAll("_").toLowerCase();
    }

    public static String createRelatedAssetFacetValue(String guid, String version) {
        StringBuilder sb = new StringBuilder();
        sb.append(guid);
        sb.append(RELATED_ASSET_FACET_DELIM);
        sb.append(version);
        return sb.toString();
    }

    public static AssetIdentification parseRelatedAssetFacetValue(String relatedAssetFacetValue) {
        String[] values;
        AssetIdentification assetId = null;
        if (relatedAssetFacetValue != null && (values = relatedAssetFacetValue.split(RELATED_ASSET_FACET_DELIM)).length == 2) {
            assetId = new AssetIdentification(values[0], values[1]);
        }
        return assetId;
    }

    public static boolean isOrQuery(String facetName) {
        if (facetName != null && facetName.length() > 0) {
            String[] tokens = facetName.split(FACET_NAME_START);
            return tokens.length > 0 && tokens[0].contains(FACET_OR_QUERY);
        }
        return false;
    }

    public static boolean isNotQuery(String facetName) {
        if (facetName != null && facetName.length() > 0) {
            String[] tokens = facetName.split(FACET_NAME_START);
            return tokens.length > 0 && tokens[0].contains(FACET_NOT_QUERY);
        }
        return false;
    }

    public static String getFacetName(String facetName) {
        int index;
        if (facetName != null && facetName.length() > 0 && (index = facetName.indexOf(FACET_NAME_START)) >= 0) {
            facetName = facetName.substring(index + FACET_NAME_START.length());
        }
        return facetName;
    }

    public static String getFacetNameStart(String facetName, boolean orQuery, boolean notQuery, boolean peer) {
        if (facetName != null && facetName.length() > 0 && (orQuery || notQuery)) {
            StringBuilder builder = new StringBuilder();
            if (orQuery) {
                builder.append(FACET_OR_QUERY);
            }
            if (notQuery) {
                builder.append(FACET_NOT_QUERY);
            }
            builder.append(FACET_NAME_START);
            if (peer) {
                builder.append("~");
            }
            builder.append(facetName);
            return builder.toString();
        }
        return facetName;
    }
}

