/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.FileInfo;
import com.ibm.ram.internal.scm.clearcase.VersionFileInfo;
import com.ibm.ram.internal.scm.clearcase.ViewPrivateFileInfo;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.util.StringTokenizer;

public class GetFileInfoCommand
extends OutputCleartoolCommand {
    private String[] filePath = null;

    public GetFileInfoCommand(String[] filePath) {
        this.filePath = filePath;
    }

    @Override
    public String[] getArguments() {
        String[] args = new String[this.filePath.length + 3];
        args[0] = "ls";
        args[1] = "-long";
        args[2] = "-d";
        int c = 0;
        while (c < this.filePath.length) {
            args[3 + c] = this.filePath[c];
            ++c;
        }
        return args;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(final String output, String error) {
        return new IFileInfoCommandOutput(){

            @Override
            public FileInfo[] getFileInfo() {
                FileInfo[] fileInfo = new FileInfo[GetFileInfoCommand.this.filePath.length];
                if (output != null && output.length() > 24) {
                    int count = 0;
                    StringTokenizer lineTokenizer = new StringTokenizer(output, "\r\n", false);
                    while (lineTokenizer.hasMoreTokens()) {
                        String line = lineTokenizer.nextToken();
                        String fileType = line.substring(0, 23).trim();
                        String versionAndRule = line.substring(23).trim();
                        String version = null;
                        String rule = null;
                        String RULESTRING = CleartoolCommandConstants.LS_OUTPUT_RULE;
                        int ruleIndex = versionAndRule.indexOf(RULESTRING);
                        if (ruleIndex > -1) {
                            version = versionAndRule.substring(0, ruleIndex).trim();
                            rule = versionAndRule.substring(ruleIndex + RULESTRING.length());
                        } else {
                            version = versionAndRule;
                            rule = null;
                        }
                        if (fileType.indexOf(CleartoolCommandConstants.LS_OUTPUT_VIEW_PRIVATE_OBJECT) > -1) {
                            fileInfo[count] = new ViewPrivateFileInfo(GetFileInfoCommand.this.filePath[count]);
                        } else if (fileType.indexOf(CleartoolCommandConstants.LS_OUTPUT_VERSION) > -1) {
                            String CHECKEDOUTSTRING = CleartoolCommandConstants.LS_OUTPUT_CHECKEDOUT_FROM;
                            int fromIndex = version.indexOf(CHECKEDOUTSTRING);
                            boolean checkedOut = fromIndex > -1;
                            String checkedOutVersion = null;
                            if (checkedOut) {
                                checkedOutVersion = version.substring(fromIndex + CHECKEDOUTSTRING.length()).trim();
                                version = version.substring(0, fromIndex);
                            }
                            version = version.substring(version.indexOf("@@") + "@@".length());
                            fileInfo[count] = new VersionFileInfo(GetFileInfoCommand.this.filePath[count], checkedOut, version, checkedOutVersion, rule);
                        }
                        ++count;
                    }
                }
                return fileInfo;
            }
        };
    }

    public static interface IFileInfoCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public FileInfo[] getFileInfo();
    }
}

