/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.udeploy.repo.integration;

import com.ibm.ram.udeploy.repo.integration.RAMHelper;
import com.urbancode.air.vc.Transaction;
import com.urbancode.commons.util.IO;
import com.urbancode.ds.persistence.database.UDTxManagerLookup;
import com.urbancode.ds.persistence.versioned.VCUtil;
import com.urbancode.ds.subsys.deploy.config.Component;
import com.urbancode.ds.subsys.deploy.config.DeployConfigFactory;
import com.urbancode.ds.subsys.deploy.config.Version;
import com.urbancode.ds.subsys.deploy.config.VersionStatus;
import com.urbancode.ds.subsys.deploy.repo.integration.AbstractIntegrator;
import com.urbancode.ds.subsys.deploy.repo.integration.RepoIntegrationFileHelper;
import com.urbancode.ds.subsys.deploy.runtime.PropertyContextHelper;
import com.urbancode.ds.subsys.deploy.status.Status;
import com.urbancode.ds.subsys.deploy.status.StatusFactory;
import com.urbancode.ds.subsys.process.property_context.PropertyContext;
import com.urbancode.persistence.hibernate.TxManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class RAMIntegrator
extends AbstractIntegrator {
    private static final String RAM_WEB_URL = "RAM Url";
    private static final Logger log = Logger.getLogger(RAMIntegrator.class);
    private final String repoUrl;
    private final String user;
    private final String password;
    private final String guid;
    private final String query;
    private final int copyCount;
    private final String versionPattern;
    private final boolean includeDependent;
    private final boolean saveFileExecuteBits;
    private RAMHelper ramClient;
    private String revision;
    private final boolean isUseVFS;
    private final String state;

    public RAMIntegrator(UUID componentId) {
        this(componentId, new HashMap<String, String>());
    }

    public RAMIntegrator(UUID componentId, Map<String, String> initProps) {
        super(componentId);
        DeployConfigFactory dbFactory = DeployConfigFactory.getInstance();
        TxManager txman = UDTxManagerLookup.get();
        Transaction vtx = null;
        try {
            txman.forceBegin();
            vtx = VCUtil.getInstance().getSession().beginTransaction();
            Component component = dbFactory.getComponentForId(componentId);
            PropertyContextHelper propContextHelper = PropertyContextHelper.getInstance();
            PropertyContext propContext = propContextHelper.mapPropertyContext(component, initProps);
            this.sourceConfig = component.getSourceConfigPlugin();
            String repoUrlPropName = this.getComponentPropertyName("repoUrl");
            String userPropName = this.getComponentPropertyName("user");
            String passwordPropName = this.getComponentPropertyName("password");
            String guidPropName = this.getComponentPropertyName("guid");
            String queryPropName = this.getComponentPropertyName("query");
            String copyCountPropName = this.getComponentPropertyName("copyCount");
            String versionPatternPropName = this.getComponentPropertyName("versionPattern");
            String saveFileExecuteBitsPropName = this.getComponentPropertyName("saveFileExecuteBits");
            String includeDependentPropName = this.getComponentPropertyName("includeDependent");
            String statePropName = this.getComponentPropertyName("state");
            String revisionPropName = "revision";
            Map resolvedProps = propContext.getResolvedProperties(new String[]{repoUrlPropName, userPropName, passwordPropName, guidPropName, queryPropName, copyCountPropName, versionPatternPropName, saveFileExecuteBitsPropName, revisionPropName, includeDependentPropName, statePropName});
            this.repoUrl = (String)resolvedProps.get(repoUrlPropName);
            this.user = (String)resolvedProps.get(userPropName);
            this.password = (String)resolvedProps.get(passwordPropName);
            this.guid = (String)resolvedProps.get(guidPropName);
            this.query = (String)resolvedProps.get(queryPropName);
            this.state = (String)resolvedProps.get(statePropName);
            this.copyCount = Integer.parseInt((String)resolvedProps.get(copyCountPropName));
            this.versionPattern = (String)resolvedProps.get(versionPatternPropName);
            this.saveFileExecuteBits = Boolean.valueOf((String)resolvedProps.get(saveFileExecuteBitsPropName));
            this.includeDependent = Boolean.valueOf((String)resolvedProps.get(includeDependentPropName));
            this.revision = (String)resolvedProps.get(revisionPropName);
            this.isUseVFS = component.isUseVfs();
            txman.commit();
        }
        finally {
            if (vtx != null) {
                vtx.commit();
            }
            txman.forceEnd();
        }
    }

    private UUID integrate(String ramVersion) throws Exception {
        UUID result = null;
        RAMHelper ramClient = this.getRAMClient();
        boolean hasVersion = this.componentHasVersion(ramVersion);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Version from RAM: " + ramVersion));
        }
        if (!hasVersion) {
            if (this.isUseVFS) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Uploading files to VFS");
                }
                File tempDir = ramClient.downloadFiles(ramVersion, this.includeDependent);
                try {
                    RepoIntegrationFileHelper helper = new RepoIntegrationFileHelper(this.saveFileExecuteBits);
                    helper.addFilesToRepository(ramVersion, tempDir, log, this.componentId);
                }
                finally {
                    try {
                        IO.delete((File)tempDir);
                    }
                    catch (IOException e) {
                        log.error((Object)"Unable to delete download directory", (Throwable)e);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new version");
            }
            result = this.createVersion(ramVersion);
            this.updateVersionStatuses(ramVersion);
        }
        return result;
    }

    public List<UUID> integrate() throws Exception {
        ArrayList<UUID> result = new ArrayList<UUID>();
        try {
            try {
                if (this.revision != null && this.revision.trim().length() > 0) {
                    String version = this.getRAMClient().getVersion(this.revision);
                    if (version != null) {
                        UUID returned = this.integrate(version);
                        if (returned != null) {
                            result.add(returned);
                        }
                    } else {
                        log.error((Object)("No matching version found for the version:" + this.revision));
                    }
                } else {
                    List<String> versions = this.getRAMClient().getLatestVersions(this.copyCount);
                    for (String version : versions) {
                        UUID newVersion = this.integrate(version);
                        if (newVersion == null) continue;
                        result.add(newVersion);
                    }
                    this.updateVersionStatuses(null);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        finally {
            this.releaseRAMClient();
        }
        return result;
    }

    private void releaseRAMClient() {
        if (this.ramClient != null) {
            this.ramClient.release();
        }
    }

    private RAMHelper getRAMClient() throws IOException {
        if (this.ramClient == null) {
            this.ramClient = new RAMHelper(this.repoUrl, this.user, this.password, this.guid, this.versionPattern, this.query, this.state);
        }
        return this.ramClient;
    }

    private void updateVersionStatuses(String specificVersion) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Updating version statuses");
        }
        DeployConfigFactory dbFactory = DeployConfigFactory.getInstance();
        TxManager txman = UDTxManagerLookup.get();
        Transaction vtx = null;
        try {
            try {
                txman.forceBegin();
                vtx = VCUtil.getInstance().getSession().beginTransaction();
                Component component = dbFactory.getComponentForId(this.componentId);
                ArrayList<Version> udVersion = null;
                if (specificVersion != null) {
                    Version version = component.getVersion(specificVersion);
                    if (version != null) {
                        udVersion = new ArrayList<Version>(1);
                        udVersion.add(version);
                        String ramLink = this.getRAMClient().getWebURL();
                        if (ramLink.endsWith("/")) {
                            ramLink = ramLink.substring(0, ramLink.length() - 1);
                        }
                        StringBuilder sb = new StringBuilder(ramLink).append("/assetDetail/generalDetails.faces?guid=").append(this.guid).append("&v=").append(specificVersion);
                        version.addLink(RAM_WEB_URL, sb.toString());
                    }
                } else {
                    udVersion = component.getActiveVersionList();
                }
                if (udVersion != null) {
                    for (Version version : udVersion) {
                        Status status;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Updating version statuses for asset, guid=" + this.guid + ",version=" + version.getName()));
                        }
                        String assetState = this.getRAMClient().getState(version.getName());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("asset state=" + assetState));
                        }
                        VersionStatus versionStatus = version.getLatestStatus();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("component version status=" + versionStatus));
                        }
                        if (versionStatus != null && versionStatus.getStatus() != null && versionStatus.getStatus().getName().equals(assetState)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("component version status=" + assetState));
                        }
                        if ((status = this.getStatus(assetState)) == null) continue;
                        version.addStatus(status);
                    }
                }
                txman.commit();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (vtx != null) {
                    vtx.commit();
                }
                txman.forceEnd();
            }
        }
        finally {
            if (vtx != null) {
                vtx.commit();
            }
            txman.forceEnd();
        }
    }

    private Status getStatus(String assetState) {
        Status status = null;
        if (assetState != null && (status = StatusFactory.getInstance().getVersionStatus(assetState)) == null) {
            status = StatusFactory.getInstance().createStatus(Status.StatusType.VERSION, assetState);
        }
        return status;
    }
}

