/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.internal.client.AbstractRESTClient;
import com.ibm.ram.internal.client.RESTCacheManager;
import com.ibm.ram.internal.client.RESTClient;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.rest.AbstractRestService;
import com.ibm.ram.internal.rest.RAMRestException;
import com.ibm.ram.internal.rest.Request;
import com.ibm.ram.internal.rest.Response;
import com.ibm.ram.internal.rest.RestContext;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;

public class RestClientService
extends AbstractRestService {
    private RESTCacheManager cacheManager = RESTCacheManager.getInstance();
    private RESTClient client;

    public RestClientService(RESTClient client, RestContext context, Request request) {
        super(context, request);
        this.client = client;
    }

    public RestClientService(RESTClient client, RestContext context, Link link, Class responseClass) {
        super(context, new Request(context, link, responseClass));
        this.client = client;
    }

    public Response doPut() throws RAMRestException {
        try {
            Object resource = this.cacheManager.putResource((AbstractRESTClient)this.client, this.getRequest().getRequestURI().toString(), (JAXBElement)this.getRequest().getLink().getValue(), this.getRequest().getRequestingClass());
            Response response = new Response(this.getContext());
            response.setValue(resource);
            return response;
        }
        catch (Exception e) {
            throw new RAMRestException((Throwable)e);
        }
    }

    public Response doGet() throws RAMRestException {
        try {
            Response resourceResponse = this.cacheManager.getResource(this.client, this.getRequest(), this.getRequest().getRequestingClass());
            return resourceResponse;
        }
        catch (Exception e) {
            throw new RAMRestException((Throwable)e);
        }
    }

    public Response doDelete() throws RAMRestException {
        try {
            Object resource = this.cacheManager.deleteResource(this.client, this.getRequest().getRequestURI().toString(), this.getRequest().getRequestingClass());
            Response response = new Response(this.getContext());
            response.setValue(resource);
            return response;
        }
        catch (Exception e) {
            throw new RAMRestException((Throwable)e);
        }
    }

    public Response doPost() throws RAMRestException {
        try {
            return this.cacheManager.postResource(this.client, this.getRequest().getRequestURI().toString(), (JAXBElement)this.getRequest().getLink().getValue(), this.getRequest().getRequestingClass());
        }
        catch (Exception e) {
            throw new RAMRestException((Throwable)e);
        }
    }

    public InputStream doGetContent() throws RAMRestException {
        try {
            return this.cacheManager.getResourceContent(this.client, this.getRequest());
        }
        catch (Exception e) {
            throw new RAMRestException((Throwable)e);
        }
    }
}

