/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.batch;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.LocalArchiveFolderArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RAMSubCategory;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.client.status.RAMStatusMonitor;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.AssetType;
import com.ibm.ram.common.data.CategorySchema;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.Forum;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.client.RAMMappings;
import com.ibm.ram.internal.client.batch.BatchTarget;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.AssetUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class Utilities {
    private static final Logger logger = Logger.getLogger(Utilities.class);

    public static void batchUpload(BatchTarget target, IProgressMonitor monitor) throws RAMRuntimeException, IOException {
        monitor.beginTask(ClientMessages.getString((String)"Utilities.0"), 200);
        RAMSession targetSession = target.getTargetSession();
        RAMMappings mappings = target.getMappings();
        BatchTarget.BatchAsset[] sourceAssets = target.getAssets().getAssets();
        if (sourceAssets.length == 0) {
            monitor.worked(200);
        } else {
            RAMAsset targetAsset;
            Asset sourceAsset;
            RAMStatusMonitor subMonitor = new RAMStatusMonitor(monitor, 100);
            subMonitor.beginTask(ClientMessages.getString((String)"Utilities.1"), 100 * sourceAssets.length);
            int j = 0;
            while (!monitor.isCanceled() && j < sourceAssets.length) {
                if (sourceAssets[j].isSelected()) {
                    try {
                        sourceAsset = sourceAssets[j].getSourceAsset();
                        targetAsset = sourceAssets[j].getTargetAsset();
                        subMonitor.subTask(MessageFormat.format(ClientMessages.getString((String)"Utilities.PORT_ASSET_METADATA"), sourceAsset));
                        AssetUtil.portAssetInfo((RAMAsset)targetAsset, (Asset)sourceAsset, (RAMMappings)mappings, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)subMonitor, 10));
                        AssetAttribute[] attributes = targetAsset.getAssetAttributes();
                        int cnt = 0;
                        while (cnt < attributes.length) {
                            if (AssetAttribute.TYPE_USER.equals(attributes[cnt].getType())) {
                                String[] values = attributes[cnt].getValues();
                                int vc = 0;
                                while (values != null && vc < values.length) {
                                    String userid = values[vc];
                                    try {
                                        String mappedId;
                                        if (mappings.getUserIdMappings().containsKey(userid) && (mappedId = (String)mappings.getUserIdMappings().get(userid)) != null) {
                                            userid = mappedId;
                                        }
                                        if (!UtilitiesCommon.isEmptyString((String)userid)) {
                                            boolean isInLdap;
                                            RAMUser user = targetSession.getUser(userid);
                                            boolean registered = user.isRegistered();
                                            boolean bl = isInLdap = !userid.equals(user.getName());
                                            if (!registered && isInLdap) {
                                                targetSession.put((IRAMSessionObject)user, (IProgressMonitor)new RAMStatusMonitor());
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.warn((Object)("Filed to register user " + userid + " on asset " + targetAsset + " attibute " + attributes[cnt]), (Throwable)e);
                                    }
                                    ++vc;
                                }
                            }
                            ++cnt;
                        }
                    }
                    catch (Exception e) {
                        subMonitor.appendStatus((Object)sourceAssets[j], 4, 1000, e.getLocalizedMessage(), (Throwable)e);
                        logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        sourceAssets[j].setSelected(false);
                        subMonitor.worked(10);
                    }
                } else {
                    subMonitor.worked(10);
                }
                ++j;
            }
            j = 0;
            while (!monitor.isCanceled() && j < sourceAssets.length) {
                if (sourceAssets[j].isSelected()) {
                    try {
                        sourceAsset = sourceAssets[j].getSourceAsset();
                        targetAsset = sourceAssets[j].getTargetAsset();
                        subMonitor.subTask(MessageFormat.format(ClientMessages.getString((String)"Utilities.PORT_ASSET_RELATIONSHIPS"), sourceAsset));
                        AssetUtil.portAssetRelationships((RAMAsset)targetAsset, (Asset)sourceAsset, (RAMMappings)mappings, (IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)subMonitor, 10), (boolean)true);
                    }
                    catch (Exception e) {
                        subMonitor.appendStatus((Object)sourceAssets[j], 4, 1000, e.getLocalizedMessage(), (Throwable)e);
                        logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        sourceAssets[j].setSelected(false);
                        subMonitor.worked(10);
                    }
                } else {
                    subMonitor.worked(10);
                }
                ++j;
            }
            j = 0;
            while (!monitor.isCanceled() && j < sourceAssets.length) {
                if (sourceAssets[j].isSelected()) {
                    try {
                        sourceAsset = sourceAssets[j].getSourceAsset();
                        targetAsset = sourceAssets[j].getTargetAsset();
                        subMonitor.subTask(MessageFormat.format(ClientMessages.getString((String)"Utilities.PORT_ASSET_ARTIFACTS"), sourceAsset));
                        new LocalArchiveFolderArtifact(targetAsset, sourceAsset, (IProgressMonitor)new RAMStatusMonitor((IProgressMonitor)subMonitor, 80));
                        targetSession.queueAssetForPut(targetAsset, true);
                    }
                    catch (Exception e) {
                        subMonitor.appendStatus((Object)sourceAssets[j], 4, 1000, e.getLocalizedMessage(), (Throwable)e);
                        logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        sourceAssets[j].setSelected(false);
                        subMonitor.worked(10);
                    }
                } else {
                    subMonitor.worked(80);
                }
                ++j;
            }
        }
        if (!monitor.isCanceled()) {
            targetSession.putAssets((IProgressMonitor)new RAMStatusMonitor(monitor, 100));
        }
    }

    public static void sort(Asset[] assets) {
        if (assets == null || assets.length <= 0) {
            return;
        }
        Comparator assetComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                Asset asset = (Asset)arg0;
                Asset asset2 = (Asset)arg1;
                if (asset.getName() == null || asset.getVersion() == null) {
                    return -1;
                }
                if (asset2.getName() == null || asset2.getVersion() == null) {
                    return 1;
                }
                if (asset.getName().equals(asset2.getName())) {
                    return asset.getVersion().compareToIgnoreCase(asset2.getVersion());
                }
                return asset.getName().compareToIgnoreCase(asset2.getName());
            }
        };
        Arrays.sort(assets, assetComparator);
    }

    public static void sort(BatchTarget.BatchAsset[] assets) {
        if (assets == null || assets.length <= 0) {
            return;
        }
        Comparator assetComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                Asset asset = ((BatchTarget.BatchAsset)arg0).getSourceAsset();
                Asset asset2 = ((BatchTarget.BatchAsset)arg1).getSourceAsset();
                if (asset.getName() == null || asset.getVersion() == null) {
                    return -1;
                }
                if (asset2.getName() == null || asset2.getVersion() == null) {
                    return 1;
                }
                if (asset.getName().equals(asset2.getName())) {
                    return asset.getVersion().compareToIgnoreCase(asset2.getVersion());
                }
                return asset.getName().compareToIgnoreCase(asset2.getName());
            }
        };
        Arrays.sort(assets, assetComparator);
    }

    public static void sort(AssetType[] assetTypes) {
        if (assetTypes == null || assetTypes.length <= 0) {
            return;
        }
        Comparator atComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                String at1 = ((AssetType)arg0).getName();
                String at2 = ((AssetType)arg1).getName();
                if (at1 == null) {
                    return -1;
                }
                if (at2 == null) {
                    return 1;
                }
                return at1.compareToIgnoreCase(at2);
            }
        };
        Arrays.sort(assetTypes, atComparator);
    }

    public static void sort(BatchTarget.BatchAssetType[] assetTypes) {
        if (assetTypes == null || assetTypes.length <= 0) {
            return;
        }
        Comparator atComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                String at1 = ((BatchTarget.BatchAssetType)arg0).getSourceAssetType().getName();
                String at2 = ((BatchTarget.BatchAssetType)arg1).getSourceAssetType().getName();
                if (at1 == null) {
                    return -1;
                }
                if (at2 == null) {
                    return 1;
                }
                return at1.compareToIgnoreCase(at2);
            }
        };
        Arrays.sort(assetTypes, atComparator);
    }

    public static void sort(AssetAttribute[] customAttributes) {
        if (customAttributes == null || customAttributes.length <= 0) {
            return;
        }
        Comparator categoriesComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                AssetAttribute attribute = (AssetAttribute)arg0;
                AssetAttribute attribute2 = (AssetAttribute)arg1;
                if (attribute.getName() == null) {
                    return -1;
                }
                if (attribute.getName() == null) {
                    return 1;
                }
                return attribute.getName().compareToIgnoreCase(attribute2.getName());
            }
        };
        Arrays.sort(customAttributes, categoriesComparator);
    }

    public static void sort(Forum[] forums) {
        if (forums == null || forums.length <= 0) {
            return;
        }
        Comparator forumComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                Forum forum = (Forum)arg0;
                Forum forum2 = (Forum)arg1;
                if (forum.getTitle() == null) {
                    return -1;
                }
                if (forum2.getTitle() == null) {
                    return 1;
                }
                return forum.getTitle().compareToIgnoreCase(forum2.getTitle());
            }
        };
        Arrays.sort(forums, forumComparator);
    }

    public static void sort(BatchTarget.BatchForum[] forums) {
        if (forums == null || forums.length <= 0) {
            return;
        }
        Comparator forumComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                Forum forum = ((BatchTarget.BatchForum)arg0).getSourceForum();
                Forum forum2 = ((BatchTarget.BatchForum)arg1).getSourceForum();
                if (forum.getTitle() == null) {
                    return -1;
                }
                if (forum2.getTitle() == null) {
                    return 1;
                }
                return forum.getTitle().compareToIgnoreCase(forum2.getTitle());
            }
        };
        Arrays.sort(forums, forumComparator);
    }

    public static void sort(CommunityInformation[] communities) {
        if (communities == null || communities.length <= 0) {
            return;
        }
        Comparator comComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                String com1 = ((CommunityInformation)arg0).getName();
                String com2 = ((CommunityInformation)arg1).getName();
                if (com1 == null) {
                    return -1;
                }
                if (com2 == null) {
                    return 1;
                }
                return com1.compareToIgnoreCase(com2);
            }
        };
        Arrays.sort(communities, comComparator);
    }

    public static void sort(BatchTarget.BatchCommunity[] communities) {
        if (communities == null || communities.length <= 0) {
            return;
        }
        Comparator comComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                String com1 = ((BatchTarget.BatchCommunity)arg0).getSourceCommunity().getName();
                String com2 = ((BatchTarget.BatchCommunity)arg1).getSourceCommunity().getName();
                if (com1 == null) {
                    return -1;
                }
                if (com2 == null) {
                    return 1;
                }
                return com1.compareToIgnoreCase(com2);
            }
        };
        Arrays.sort(communities, comComparator);
    }

    public static void sort(RelationshipType[] relationshipTypes) {
        if (relationshipTypes == null || relationshipTypes.length <= 0) {
            return;
        }
        Comparator relComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                RelationshipType type = (RelationshipType)arg0;
                RelationshipType type2 = (RelationshipType)arg1;
                if (type.getDisplayName() == null) {
                    return -1;
                }
                if (type2.getDisplayName() == null) {
                    return 1;
                }
                return type.getDisplayName().compareToIgnoreCase(type2.getDisplayName());
            }
        };
        Arrays.sort(relationshipTypes, relComparator);
    }

    public static void sort(BatchTarget.BatchRelationshipType[] relationshipTypes) {
        if (relationshipTypes == null || relationshipTypes.length <= 0) {
            return;
        }
        Comparator relComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                RelationshipType type = ((BatchTarget.BatchRelationshipType)arg0).getSourceRelationshipType();
                RelationshipType type2 = ((BatchTarget.BatchRelationshipType)arg1).getSourceRelationshipType();
                if (type.getDisplayName() == null) {
                    return -1;
                }
                if (type2.getDisplayName() == null) {
                    return 1;
                }
                return type.getDisplayName().compareToIgnoreCase(type2.getDisplayName());
            }
        };
        Arrays.sort(relationshipTypes, relComparator);
    }

    public static void sort(BatchTarget.BatchUser[] batchUSers) {
        if (batchUSers == null || batchUSers.length <= 0) {
            return;
        }
        Comparator relComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                UserInformation user = ((BatchTarget.BatchUser)arg0).getSourceUser();
                UserInformation user2 = ((BatchTarget.BatchUser)arg1).getSourceUser();
                if (user.getName() == null) {
                    return -1;
                }
                if (user2.getName() == null) {
                    return 1;
                }
                return user.getName().compareToIgnoreCase(user2.getName());
            }
        };
        Arrays.sort(batchUSers, relComparator);
    }

    public static void sort(SubCategory[] subcategories) {
        if (subcategories == null || subcategories.length <= 0) {
            return;
        }
        Comparator categoriesComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                RAMSubCategory subCategory = (RAMSubCategory)arg0;
                RAMSubCategory subCategory2 = (RAMSubCategory)arg1;
                if (subCategory.getCategory() == null || subCategory.getCategory().getName() == null) {
                    return -1;
                }
                if (subCategory2.getName() == null || subCategory2.getCategory().getName() == null) {
                    return 1;
                }
                if (subCategory.getCategory().getName().equals(subCategory2.getCategory().getName())) {
                    if (subCategory.getCategorization() == null) {
                        return -1;
                    }
                    if (subCategory2.getCategorization() == null) {
                        return 1;
                    }
                    return subCategory.getCategorization().compareToIgnoreCase(subCategory2.getCategorization());
                }
                return subCategory.getCategory().getName().compareToIgnoreCase(subCategory2.getCategory().getName());
            }
        };
        Arrays.sort(subcategories, categoriesComparator);
    }

    public static void sort(BatchTarget.BatchSubCategory[] subcategories) {
        if (subcategories == null || subcategories.length <= 0) {
            return;
        }
        Comparator categoriesComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                BatchTarget.BatchSubCategory subCategory = (BatchTarget.BatchSubCategory)arg0;
                BatchTarget.BatchSubCategory subCategory2 = (BatchTarget.BatchSubCategory)arg1;
                String fullPath = subCategory.getSourceSubCategory().getFullPath();
                String fullPath2 = subCategory2.getSourceSubCategory().getFullPath();
                return fullPath.compareToIgnoreCase(fullPath2);
            }
        };
        Arrays.sort(subcategories, categoriesComparator);
    }

    public static void sort(CategorySchema[] schemeas) {
        if (schemeas == null || schemeas.length <= 0) {
            return;
        }
        Comparator categoriesComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                CategorySchema category = (CategorySchema)arg0;
                CategorySchema category2 = (CategorySchema)arg1;
                if (category == null || category.getName() == null) {
                    return -1;
                }
                if (category2 == null || category2.getName() == null) {
                    return 1;
                }
                return category.getName().compareToIgnoreCase(category2.getName());
            }
        };
        Arrays.sort(schemeas, categoriesComparator);
    }

    public static void sort(UserInformation[] users) {
        if (users == null || users.length <= 0) {
            return;
        }
        Comparator userComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                UserInformation user = (UserInformation)arg0;
                UserInformation user2 = (UserInformation)arg1;
                if (user.getName() == null || user.getUid() == null) {
                    return -1;
                }
                if (user2.getName() == null || user2.getUid() == null) {
                    return 1;
                }
                if (user.getName().equals(user2.getName())) {
                    return user.getUid().compareToIgnoreCase(user2.getUid());
                }
                return user.getName().compareToIgnoreCase(user2.getName());
            }
        };
        Arrays.sort(users, userComparator);
    }
}

