/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.common.util.ManifestBuilder;
import com.ibm.ram.defaultprofile.NodeDescriptor;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.common.data.AssetAttributeSO;
import com.ibm.ram.internal.common.util.SerializationHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RAMAssetAttribute
extends AssetAttribute
implements IRAMSessionObject {
    private static final Logger logger = Logger.getLogger((String)RAMAssetAttribute.class.getName());
    private static String ASSET_ATTRIBUTE_HASH_KEY = "ASSET_ATTRIBUTE:";
    private static String NEW_ASSET_ATTRIBUTE_KEY = "NEW_ASSET_ATTRIBUTE:";
    private RAMAsset fAsset;
    private RAMSession fSession;
    private String[] fOriginalValues;
    private boolean fDirty = false;
    private RAMAction fAction;
    private Map fConfiguration = new HashMap();
    private AssetAttribute fWebServiceAttribute;
    private ManifestAccessor.CustomAttribute fCustomAttribute;
    private boolean fAssetScoped = false;

    RAMAssetAttribute(RAMSession session, AssetAttribute internalCustomAttribute) {
        AssetAttributeSO so;
        this.fSession = session;
        this.fWebServiceAttribute = internalCustomAttribute;
        this.fOriginalValues = this.fWebServiceAttribute.getValidValues();
        this.fAction = RAMAction.UPDATE;
        if (internalCustomAttribute instanceof AssetAttributeSO && (so = (AssetAttributeSO)internalCustomAttribute).getConfiguration() != null) {
            try {
                SerializationHelper helper = new SerializationHelper(so.getConfiguration());
                this.fConfiguration = (Map)helper.deserialize();
            }
            catch (Exception e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
    }

    RAMAssetAttribute(RAMAsset asset, ManifestAccessor.CustomAttribute internalCustomAttribute) {
        this.fAsset = asset;
        this.fCustomAttribute = internalCustomAttribute;
        this.fAssetScoped = true;
        this.fAction = RAMAction.UPDATE;
        this.fSession = asset.getSession();
    }

    RAMAssetAttribute(RAMSession session, String name) {
        this.fSession = session;
        this.fWebServiceAttribute = new AssetAttributeSO();
        this.fWebServiceAttribute.setName(name);
        this.setDirty(true);
        this.fAction = RAMAction.CREATE;
    }

    @Override
    public String getName() {
        String name = null;
        name = this.fAssetScoped ? this.fCustomAttribute.getName() : this.fWebServiceAttribute.getName();
        return name;
    }

    void assetAttributeCommited() throws RAMRuntimeException {
        this.fAction = RAMAction.UPDATE;
        this.setDirty(false);
    }

    @Override
    public void setName(String name) {
        if (this.fAssetScoped) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAssetAttribute.CANNOT_MODIFY_ATTRIBUTE_NAME"), true);
        }
        this.fWebServiceAttribute.setName(name);
        this.setDirty(true);
    }

    @Override
    public String[] getValues() {
        String[] ret = null;
        if (this.fAssetScoped && this.fCustomAttribute.isAttributeSet()) {
            if (!this.fCustomAttribute.isRestrictedValues()) {
                List<String> values = this.fCustomAttribute.getUnrestrictedAttributeValues();
                ret = values.toArray(new String[values.size()]);
            } else {
                NodeDescriptor[] nodes = this.fCustomAttribute.getRestrictedAttributeValues();
                ret = new String[nodes.length];
                int i = 0;
                while (i < nodes.length) {
                    ret[i] = nodes[i].getName();
                    ++i;
                }
            }
        }
        return ret;
    }

    private boolean canEdit() {
        String currentUserId = this.fAsset.getSession().getIdentification().getLoginId();
        List<String> authorizedUsers = this.getInternalCustomAttribute().getAuthorizedUpdateUserIds();
        if ("ram.repositoryprocess".equals(currentUserId) || authorizedUsers.isEmpty()) {
            return true;
        }
        if (currentUserId == null || currentUserId.length() == 0) {
            return false;
        }
        for (String userId : authorizedUsers) {
            if (!currentUserId.equals(userId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setValues(String[] value) throws RAMRuntimeException {
        if (this.fAssetScoped) {
            if (!this.canEdit()) {
                String errorMsg = MessageFormat.format(ClientMessages.getString("RAMAssetAttribute.NOT_AUTHORIZED_TO_MODIFY_VALUE"), this.getName());
                throw new RAMRuntimeException(errorMsg, true);
            }
            if (value == null || value.length == 0) {
                this.fAsset.getManifestBuilder().removeCustomAttribute(this.fCustomAttribute.getURIString());
            } else if (!this.fCustomAttribute.isRestrictedValues()) {
                if (this.fCustomAttribute instanceof ManifestBuilder.CustomAttributeUpdate && value.length > 1) {
                    ((ManifestBuilder.CustomAttributeUpdate)this.fCustomAttribute).getUnrestrictedAttributeValues().clear();
                    String[] stringArray = value;
                    int n = value.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        ((ManifestBuilder.CustomAttributeUpdate)this.fCustomAttribute).getUnrestrictedAttributeValues().add(val);
                        ++n2;
                    }
                } else {
                    this.fAsset.getManifestBuilder().addCustomAttribute(this.fCustomAttribute.getURIString(), value[0]);
                }
                this.fCustomAttribute = this.fAsset.getManifestBuilder().getCustomAttributes().get(this.fCustomAttribute.getURIString());
            } else {
                NodeDescriptor[] validValues = this.fCustomAttribute.getRestrictedValidAttributeValues();
                ArrayList<NodeDescriptor> valuesList = new ArrayList<NodeDescriptor>(value.length);
                int i = 0;
                while (i < value.length) {
                    int j = 0;
                    while (j < validValues.length) {
                        if (value[i].equals(validValues[j].getName())) {
                            valuesList.add(validValues[j]);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                NodeDescriptor[] values = valuesList.toArray(new NodeDescriptor[valuesList.size()]);
                this.fAsset.getManifestBuilder().addCustomAttribute(this.fCustomAttribute.getURIString(), values);
            }
        } else {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAssetAttribute.CANNOT_MODIFY_ATTIBUTE_VALUES"), true);
        }
        this.fAsset.setAssetDirty(true);
    }

    public void addValue(String value) {
        String[] oldVals = this.getValues();
        String[] tmps = oldVals == null ? new String[1] : new String[oldVals.length + 1];
        System.arraycopy(oldVals, 0, tmps, 0, oldVals.length);
        tmps[oldVals.length] = value;
        this.setValues(tmps);
    }

    ManifestAccessor.CustomAttribute getInternalCustomAttribute() throws RAMRuntimeException {
        return this.fCustomAttribute;
    }

    AssetAttribute getInternalWebServiceAssetAttribute() throws RAMRuntimeException {
        return this.fWebServiceAttribute;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        if (this.fAssetScoped) {
            toString.append(this.getName());
            toString.append(" = ");
            String[] values = this.getValues();
            if (values != null) {
                int i = 0;
                while (i < values.length) {
                    toString.append(values[i]);
                    if (i < values.length - 1) {
                        toString.append(", ");
                    }
                    ++i;
                }
            }
        } else {
            toString.append(this.getName());
            toString.append("[");
            toString.append(this.getURI());
            toString.append("]");
        }
        return toString.toString();
    }

    @Override
    public String getDescription() {
        String description = null;
        description = this.fAssetScoped ? this.fCustomAttribute.getDescription() : this.fWebServiceAttribute.getDescription();
        return description;
    }

    @Override
    public void setDescription(String description) {
        if (this.fAssetScoped) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAssetAttribute.CONNOT_MODIFY_DESCRIPTION"), true);
        }
        this.fWebServiceAttribute.setDescription(description);
        this.setDirty(true);
    }

    @Override
    public String getURI() {
        String uriString = null;
        uriString = this.fAssetScoped ? this.fCustomAttribute.getURIString() : this.fWebServiceAttribute.getURI();
        return uriString;
    }

    @Override
    public String[] getValidValues() {
        String[] ret = null;
        if (this.fAssetScoped) {
            NodeDescriptor[] descriptor = this.fCustomAttribute.getRestrictedValidAttributeValues();
            if (descriptor != null) {
                ret = new String[descriptor.length];
                int i = 0;
                while (i < descriptor.length) {
                    ret[i] = descriptor[i].getName();
                    ++i;
                }
            }
        } else {
            ret = this.fWebServiceAttribute.getValidValues();
        }
        return ret;
    }

    String[] getOriginalValues() {
        return this.fOriginalValues;
    }

    @Override
    public void setValidValues(String[] validSettings) {
        if (this.fAssetScoped) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAssetAttribute.CANNOT_MODIFY_VALID_VALUES"), true);
        }
        this.fWebServiceAttribute.setValidValues(validSettings);
        this.fWebServiceAttribute.setRestrictedSetting(validSettings != null && validSettings.length > 0);
        this.setDirty(true);
    }

    @Override
    public boolean isRestrictedSetting() {
        boolean restrictedSetting = false;
        restrictedSetting = this.fAssetScoped ? this.fCustomAttribute.isRestrictedValues() : this.fWebServiceAttribute.isRestrictedSetting();
        return restrictedSetting;
    }

    @Override
    public void setRestrictedSetting(boolean restrictedSetting) {
        if (this.fAssetScoped) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAssetAttribute.CANNOT_MODIFY_SINGLE_SELECTION"), true);
        }
        this.fWebServiceAttribute.setRestrictedSetting(restrictedSetting);
    }

    @Override
    public boolean isSingleSetting() {
        boolean singleSetting = false;
        singleSetting = this.fAssetScoped ? !this.fCustomAttribute.isManySelect() : this.fWebServiceAttribute.isSingleSetting();
        return singleSetting;
    }

    @Override
    public void setSingleSetting(boolean singleSetting) {
        if (this.fAssetScoped) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAssetAttribute.CANNOT_MODIFY_SINGLE_SELECTION"), true);
        }
        this.fWebServiceAttribute.setSingleSetting(singleSetting);
    }

    public RAMSession getSession() {
        return this.fSession;
    }

    void setDirty(boolean dirtyFlag) {
        this.fDirty = dirtyFlag;
        if (dirtyFlag) {
            this.getSession().cache(this);
        } else {
            this.getSession().uncache(this);
        }
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    String getSessionKey() {
        String ret = this.getURI() != null ? String.valueOf(ASSET_ATTRIBUTE_HASH_KEY) + this.getURI() : String.valueOf(NEW_ASSET_ATTRIBUTE_KEY) + this.hashCode();
        return ret;
    }

    @Override
    public void setURI(String uriString) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAssetAttribute.ASSET_ATTRIBUTE_URI_CAN_ONLY_BE_SET_BY_THE_SERVER"), true);
    }

    protected RAMAsset getAsset() {
        return this.fAsset;
    }

    @Override
    public RAMAction getAction() {
        return this.fAction;
    }

    public void setAction(RAMAction action) {
        if (action != RAMAction.CREATE && action != RAMAction.UPDATE && action != RAMAction.DELETE) {
            String message = MessageFormat.format(ClientMessages.getString("ACTION_NOT_ACCEPTABLE"), action.getName(), this.getClass().getName());
            throw new RAMRuntimeException(message, true);
        }
        this.fAction = action;
        if (action == RAMAction.DELETE) {
            this.setDirty(true);
        }
    }

    @Override
    public String getType() {
        if (super.getType() == null) {
            if (this.fWebServiceAttribute == null && this.fCustomAttribute != null) {
                this.fWebServiceAttribute = this.fSession.getAssetAttributeByURI(this.fCustomAttribute.getURIString());
            }
            super.setType(this.fWebServiceAttribute.getType() != null ? this.fWebServiceAttribute.getType() : TYPE_TEXT);
        }
        return super.getType();
    }

    @Override
    public void setType(String type) {
        if (this.getAction() != RAMAction.CREATE) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAssetAttribute.TYPE_CANNOT_BE_MODIFED"), true);
        }
        if (type != TYPE_BOOLEAN && type != TYPE_DATE && type != TYPE_LINK && type != TYPE_NUMBER && type != TYPE_TEXT && type != TYPE_USER && type != TYPE_XML && type != TYPE_RESOURCE) {
            throw new RAMRuntimeException(MessageFormat.format(ClientMessages.getString("RAMAssetAttribute.UnknownType"), type), true);
        }
        super.setType(type);
    }

    public String getConfiguration() {
        try {
            return new SerializationHelper(this.fConfiguration).serialize();
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

