/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.RelationshipInfo;
import com.ibm.ram.common.emf.ArtifactDetail;
import com.ibm.ram.common.emf.ArtifactDetails;
import com.ibm.ram.common.emf.EMFFactory;
import com.ibm.ram.common.emf.EMFPackage;
import com.ibm.ram.common.emf.util.ArtifactAdapter;
import com.ibm.ram.common.util.IMimeTypeResolver;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.common.util.RelationSource;
import com.ibm.ram.common.util.UniqueIDGenerator;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.common.util.ValidationManager;
import com.ibm.ram.defaultprofile.Activity;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.defaultprofile.ArtifactActivity;
import com.ibm.ram.defaultprofile.ArtifactType;
import com.ibm.ram.defaultprofile.Asset;
import com.ibm.ram.defaultprofile.Classification;
import com.ibm.ram.defaultprofile.ClassificationSchema;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.DefaultprofilePackage;
import com.ibm.ram.defaultprofile.Description;
import com.ibm.ram.defaultprofile.Descriptor;
import com.ibm.ram.defaultprofile.DescriptorGroup;
import com.ibm.ram.defaultprofile.FreeFormDescriptor;
import com.ibm.ram.defaultprofile.FreeFormValue;
import com.ibm.ram.defaultprofile.NodeDescriptor;
import com.ibm.ram.defaultprofile.Reference;
import com.ibm.ram.defaultprofile.ReferenceKind;
import com.ibm.ram.defaultprofile.RelatedAsset;
import com.ibm.ram.defaultprofile.Solution;
import com.ibm.ram.defaultprofile.Usage;
import com.ibm.ram.internal.common.util.ArtifactUtilities;
import com.ibm.ram.internal.common.util.RelationshipRangeUtility;
import com.ibm.ram.internal.common.util.Utilities;
import com.ibm.ram.io.zip.ZipEntry;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class ManifestBuilder
extends ManifestAccessor {
    public static final int UPDATE_MANIFEST = 0;
    public static final int DUPLICATE_MANIFEST = 1;
    public static final int NEW_VERSION_MANIFEST = 2;
    public static final int NEW_MANIFEST = 3;
    protected ValidationManager validationManager;
    private String originalVersion;
    boolean newVersionRequired;
    private Map<NodeDescriptor, NodeDescriptor> forcedNodeDescriptor = null;
    Set<NodeDescriptor> forcedNodeSet = null;
    private String originalAssetType;
    private CommunityInformation originalCommunity;
    private List<String> assetVersions;
    private int updateType;
    private List<RelationSource> addRelations;
    private List<Integer> deleteRelations;

    public static Asset createEmptyManifest() {
        Asset manifest = DefaultprofileFactory.eINSTANCE.createAsset();
        manifest.setId(UniqueIDGenerator.getUniqueID());
        return manifest;
    }

    public void addForcedNodeDescriptor(NodeDescriptor node) {
        LinkedList<NodeDescriptor> tempNodeList = new LinkedList<NodeDescriptor>();
        NodeDescriptor parent = node;
        boolean addFlag = Boolean.TRUE;
        if (this.forcedNodeDescriptor == null) {
            this.forcedNodeDescriptor = new HashMap<NodeDescriptor, NodeDescriptor>();
        }
        if (this.forcedNodeSet == null) {
            this.forcedNodeSet = new HashSet<NodeDescriptor>();
        }
        while (parent.getGeneral() != null) {
            if (this.forcedNodeDescriptor.containsKey(parent = parent.getGeneral())) {
                if (!parent.isExclusive()) break;
                for (NodeDescriptor nd : tempNodeList) {
                    this.forcedNodeDescriptor.remove(nd);
                }
                addFlag = Boolean.FALSE;
                break;
            }
            this.forcedNodeDescriptor.put(parent, node);
            tempNodeList.add(parent);
        }
        tempNodeList.clear();
        if (addFlag == Boolean.TRUE) {
            this.forcedNodeSet.add(node);
        }
    }

    public void addForcedNodeToManifestBuilder() {
        if (this.forcedNodeSet != null) {
            Collection<ManifestAccessor.ClassificationInfo> cinfos = this.getClassificationInfos().values();
            LinkedList<NodeDescriptor> removedNodes = new LinkedList<NodeDescriptor>();
            for (ManifestAccessor.ClassificationInfo cinfo : cinfos) {
                if (!cinfo.isSchemaSet()) continue;
                Iterator<NodeDescriptor> iterator = cinfo.getNodeDescriptors().iterator();
                block1: while (iterator.hasNext()) {
                    NodeDescriptor node;
                    NodeDescriptor parent = node = iterator.next();
                    while ((parent = parent.getGeneral()) != null) {
                        if (!this.forcedNodeDescriptor.containsKey(parent)) continue;
                        if (!parent.isExclusive()) continue block1;
                        removedNodes.add(node);
                        continue block1;
                    }
                }
            }
            for (NodeDescriptor node : removedNodes) {
                this.removeNodeDescriptorFromManifest(node);
            }
            for (NodeDescriptor node : this.forcedNodeSet) {
                this.addNodeDescriptorToManifest(node);
            }
            this.clearForcedCategorizationSetting();
        }
    }

    private void clearForcedCategorizationSetting() {
        if (this.forcedNodeDescriptor != null) {
            this.forcedNodeDescriptor.clear();
        }
        if (this.forcedNodeSet != null) {
            this.forcedNodeSet.clear();
        }
    }

    public final Set<NodeDescriptor> getForcedCategorizationSet() {
        return this.forcedNodeSet;
    }

    public ManifestBuilder(ResourceSet rset, boolean manageArtifactDetails, CommunityInformation community) {
        this.community = community;
        Asset manifest = ManifestBuilder.createEmptyManifest();
        ArtifactDetails details = null;
        if (manageArtifactDetails) {
            details = EMFFactory.eINSTANCE.createArtifactDetails();
        }
        this.setUpdateType(3);
        this.setContents(manifest, details);
        this.initializeNewManifest(rset);
        if (manageArtifactDetails && details != null) {
            this.manageDetails();
        }
    }

    @Override
    protected void manifestCleared() {
        super.manifestCleared();
        this.community = null;
        this.originalVersion = null;
        this.originalAssetType = null;
        this.originalCommunity = null;
        this.validationManager = null;
    }

    @Override
    protected void setContents(Asset inputManifest, ArtifactDetails artifactDetails) {
        super.setContents(inputManifest, artifactDetails);
    }

    public boolean getNewVersionRequired() {
        return this.newVersionRequired;
    }

    public void setNewVersionRequired(boolean required) {
        this.newVersionRequired = required;
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public String getOriginalAssetType() {
        return this.originalAssetType;
    }

    public CommunityInformation getOriginalCommunity() {
        return this.originalCommunity;
    }

    public void setCommunity(CommunityInformation community) {
        if (this.community == null ? community == null : community != null && this.community.getId() == community.getId()) {
            return;
        }
        this.community = community;
        ValidationManager vm = this.getValidationManager();
        if (vm != null) {
            vm.initialize();
        }
    }

    public void manageDetails() {
        if (this.artifactDetails == null) {
            Resource resource = this.getManifestResource().getResourceSet().createResource(URI.createURI((String)("ram:asset/" + this.manifest.getId() + ".details.xmi")));
            this.artifactDetails = EMFFactory.eINSTANCE.createArtifactDetails();
            resource.getContents().add((Object)this.artifactDetails);
        }
        this.artifactDetails.eResource().setTrackingModification(true);
        if (this.artifactAdapter != null) {
            ArtifactAdapter.setupArtifactDetails(this.artifactDetails, this.manifest);
        }
    }

    public ManifestBuilder(XMLResource res, XMLResource detailsResource, CommunityInformation community) {
        this(res, detailsResource, 0, community);
    }

    public ManifestBuilder(XMLResource res, XMLResource detailsResource, int updateType, CommunityInformation community) {
        this((Asset)EcoreUtil.getObjectByType((Collection)res.getContents(), (EClassifier)DefaultprofilePackage.eINSTANCE.getAsset()), detailsResource != null ? (ArtifactDetails)EcoreUtil.getObjectByType((Collection)detailsResource.getContents(), (EClassifier)EMFPackage.eINSTANCE.getArtifactDetails()) : null, updateType, community, null);
    }

    public ManifestBuilder(XMLResource res, XMLResource detailsResource, int updateType, CommunityInformation community, Integer assetDbid, String stateId) {
        this(res, detailsResource, updateType, community);
        this.setAuxInfo(assetDbid, stateId);
    }

    public void initializeCopy(int updateType, String originalVersion, List<String> assetVersions, CommunityInformation originalCommunity, String originalAssetType) {
        this.setUpdateType(updateType);
        this.originalVersion = originalVersion;
        this.originalCommunity = originalCommunity;
        this.originalAssetType = originalAssetType;
        this.assetVersions = assetVersions;
        switch (updateType) {
            case 1: 
            case 2: {
                Iterator raItr = this.manifest.getRelatedAsset().iterator();
                while (raItr.hasNext()) {
                    RelatedAsset ra = (RelatedAsset)raItr.next();
                    RelationshipInfo info = RelationshipRangeUtility.getInfo(ra);
                    if (info == null) continue;
                    if (info.isReverseRange()) {
                        raItr.remove();
                        continue;
                    }
                    if (!info.isSource()) continue;
                    ra.setDescription(null);
                }
                break;
            }
        }
    }

    private void initializeNewManifest(ResourceSet rset) {
        if (this.manifest.getId() == null) {
            this.manifest.setId(UniqueIDGenerator.getUniqueID());
        }
        Resource resource = rset.createResource(URI.createURI((String)("ram:asset/" + this.manifest.getId() + ".rmd")));
        resource.getContents().add((Object)this.manifest);
        if (this.artifactDetails != null) {
            resource = rset.createResource(URI.createURI((String)("ram:asset/" + this.manifest.getId() + ".details.xmi")));
            resource.getContents().add((Object)this.artifactDetails);
        }
    }

    public ManifestBuilder(Asset manifest, ArtifactDetails artifactDetails, CommunityInformation community) {
        this(manifest, artifactDetails, 0, community, null);
    }

    public ManifestBuilder(Asset inputManifest, ArtifactDetails artifactDetails, int updateType, CommunityInformation community, List<String> versions) {
        super(inputManifest, artifactDetails, community);
        this.setUpdateType(updateType);
        switch (updateType) {
            case 0: 
            case 2: {
                URI assetType = this.getAssetTypeURI();
                if (assetType != null) {
                    this.initializeCopy(updateType, inputManifest.getVersion(), versions, community, this.getAssetTypeURI().toString());
                    break;
                }
                this.initializeCopy(updateType, inputManifest.getVersion(), versions, community, null);
                break;
            }
            case 1: {
                this.manifest.setId(UniqueIDGenerator.getUniqueID());
                this.initializeCopy(updateType, null, null, null, null);
                break;
            }
        }
        if (this.artifactDetails != null) {
            this.manageDetails();
        }
    }

    public int getUpdateType() {
        return this.updateType;
    }

    private void setUpdateType(int updateType) {
        if (updateType == 2) {
            this.newVersionRequired = true;
        }
        this.updateType = updateType;
    }

    public void setURI(URI uri) throws IllegalArgumentException {
        XMLResource res = this.getManifestResource();
        if (uri.equals((Object)res.getURI())) {
            return;
        }
        if (res.getResourceSet().getResource(uri, false) != null) {
            throw new IllegalArgumentException("URI already exists in resource set. \"" + uri + "\"");
        }
        res.setURI(uri);
    }

    public boolean isBuilderValid() {
        return this.manifest != null;
    }

    public void setRevisionCount(int revCount) {
        Classification cl = this.manifest.getClassification();
        if (cl == null) {
            cl = DefaultprofileFactory.eINSTANCE.createClassification();
            this.manifest.setClassification(cl);
        }
        DescriptorGroup stndGroup = null;
        for (DescriptorGroup group : cl.getDescriptorGroup()) {
            if (!"StandardInfo".equals(group.getName())) continue;
            for (FreeFormValue ffv : group.getFreeFormValue()) {
                if (ffv.getFreeFormDescriptor() == null || !"revisionCount".equals(ffv.getFreeFormDescriptor().getName())) continue;
                ffv.setValue(Integer.toString(revCount));
                return;
            }
            stndGroup = group;
            break;
        }
        if (stndGroup == null) {
            stndGroup = DefaultprofileFactory.eINSTANCE.createDescriptorGroup();
            stndGroup.setName("StandardInfo");
            cl.getDescriptorGroup().add((Object)stndGroup);
        }
        FreeFormDescriptor revCntFFD = null;
        for (FreeFormDescriptor ffd : stndGroup.getFreeFormDescriptor()) {
            if (!"revisionCount".equals(ffd.getName())) continue;
            revCntFFD = ffd;
            break;
        }
        if (revCntFFD == null) {
            revCntFFD = DefaultprofileFactory.eINSTANCE.createFreeFormDescriptor();
            revCntFFD.setName("revisionCount");
            stndGroup.getFreeFormDescriptor().add((Object)revCntFFD);
        }
        revCntFFD.setValue(Integer.toString(revCount));
    }

    public void setName(String name) {
        if (name != null) {
            name = name.trim();
        }
        this.manifest.setName(Utilities.escapeForXML(name));
    }

    public void setDate(Date date) {
        this.manifest.setDate(date);
    }

    public void setId(String id) {
        this.manifest.setId(Utilities.escapeForXML(id));
    }

    public void setDescription(String description) {
        description = Utilities.escapeForXML(description);
        Description d = this.manifest.getDescription();
        if (!UtilitiesCommon.isEmptyString(description)) {
            if (d == null) {
                d = DefaultprofileFactory.eINSTANCE.createDescription();
                this.manifest.setDescription(d);
            } else if (UtilitiesCommon.objectsEqual(description, d.getValue())) {
                return;
            }
            d.setValue(description);
        } else if (d != null && d.getValue() != null) {
            this.manifest.setDescription(null);
        }
    }

    public void setState(String state) {
        this.manifest.setState(state);
    }

    public void setState(String state, String stateId) {
        this.setState(state);
        this.stateId = stateId;
    }

    public void setAssetDbid(Integer assetDbid) {
        this.assetDbid = assetDbid;
    }

    public RelatedAsset addRelatedAsset(Asset relatedAsset, String relationshipType) {
        return this.addRelatedAsset(relatedAsset.getName(), relatedAsset.getId(), relatedAsset.getVersion(), relationshipType);
    }

    public RelatedAsset addRelatedAsset(ManifestAccessor relatedAsset, String relationshipType) {
        return this.addRelatedAsset(relatedAsset.getManifest(), relationshipType);
    }

    public RelatedAsset addRelatedAsset(String assetName, String assetId, String version, String relationshipType) {
        return this.addRelatedAsset(assetName, assetId, version, relationshipType, null);
    }

    public RelatedAsset addRelatedAsset(String assetName, String assetId, String version, String relationshipType, String description) {
        RelatedAsset ra = DefaultprofileFactory.eINSTANCE.createRelatedAsset();
        ra.setName(assetName);
        ra.setAssetId(assetId);
        ra.setAssetVersion(version);
        ra.setRelationshipType(relationshipType);
        if (!UtilitiesCommon.isEmptyString(description)) {
            Description desc = DefaultprofileFactory.eINSTANCE.createDescription();
            desc.setValue(description);
            ra.setDescription(desc);
        }
        this.manifest.getRelatedAsset().add((Object)ra);
        return ra;
    }

    public void removeRelatedAsset(RelatedAsset relAsset) {
        this.manifest.getRelatedAsset().remove((Object)relAsset);
    }

    public void setVersion(String version) {
        if (version != null) {
            this.manifest.setVersion(version.trim());
        } else {
            this.manifest.setVersion(null);
        }
    }

    public void setShortDescription(String shortDescription) {
        if (shortDescription != null) {
            shortDescription = shortDescription.trim();
        }
        this.manifest.setShortDescription(Utilities.escapeForXML(shortDescription));
    }

    public String setAssetTypeLocalized(String assetTypeLocalized) {
        return com.ibm.ram.defaultprofile.util.Utilities.getClassificationSchemaURIString(this.setAssetTypeURI(com.ibm.ram.defaultprofile.util.Utilities.createClassificationSchemaURI(assetTypeLocalized, this.getManifestResourceSet())), this.getManifestResourceSet());
    }

    public URI setAssetTypeURI(URI assetTypeURI) {
        try {
            Classification cl = this.manifest.getClassification();
            DescriptorGroup assetTypeGroup = null;
            URI oldAssetType = null;
            boolean existingAssetTypeDescriptor = false;
            if (cl != null) {
                EList descriptorGroups = cl.getDescriptorGroup();
                Iterator iter = descriptorGroups.iterator();
                while (iter.hasNext()) {
                    DescriptorGroup dg = (DescriptorGroup)iter.next();
                    if (!"AssetType".equals(dg.getName())) continue;
                    List nodes = ((EcoreEList)dg.getNodeDescriptor()).basicList();
                    if (!nodes.isEmpty()) {
                        oldAssetType = EcoreUtil.getURI((EObject)((EObject)nodes.get(0)));
                        existingAssetTypeDescriptor = true;
                    }
                    if (assetTypeURI == null) {
                        iter.remove();
                        URI uRI = oldAssetType;
                        return uRI;
                    }
                    assetTypeGroup = dg;
                    break;
                }
                if (assetTypeURI == null) {
                    URI uRI = oldAssetType;
                    return uRI;
                }
            } else if (assetTypeURI != null) {
                cl = DefaultprofileFactory.eINSTANCE.createClassification();
                this.manifest.setClassification(cl);
            } else {
                return null;
            }
            if (assetTypeGroup == null) {
                assetTypeGroup = DefaultprofileFactory.eINSTANCE.createDescriptorGroup();
                assetTypeGroup.setName("AssetType");
                cl.getDescriptorGroup().add((Object)assetTypeGroup);
            }
            if (!existingAssetTypeDescriptor || !assetTypeURI.equals(oldAssetType)) {
                InternalEObject newType = (InternalEObject)DefaultprofileFactory.eINSTANCE.createNodeDescriptor();
                newType.eSetProxyURI(assetTypeURI);
                if (existingAssetTypeDescriptor) {
                    assetTypeGroup.getNodeDescriptor().set(0, (Object)newType);
                } else {
                    assetTypeGroup.getNodeDescriptor().add(0, (Object)newType);
                }
            }
            URI uRI = oldAssetType;
            return uRI;
        }
        finally {
            ValidationManager vm = this.getValidationManager();
            if (vm != null) {
                vm.initialize();
            }
        }
    }

    public void addNodeDescriptorToManifest(NodeDescriptor descriptor) {
        ClassificationUpdate cupdate = (ClassificationUpdate)this.getClassificationInfo(descriptor);
        if (cupdate != null) {
            cupdate.primAddNodeDescriptor(descriptor);
        }
    }

    public void addFreeFormValueToManifest(FreeFormValue ffv) {
        ClassificationUpdate cupdate = (ClassificationUpdate)this.getClassificationInfo(ffv);
        if (cupdate != null) {
            cupdate.primAddFreeFormValue(ffv);
        }
    }

    public FreeFormValue addFreeFormValueToManifest(String value, FreeFormDescriptor ffd) {
        FreeFormValue ffv = DefaultprofileFactory.eINSTANCE.createFreeFormValue();
        ffv.setFreeFormDescriptor(ffd);
        ffv.setValue(value);
        this.addFreeFormValueToManifest(ffv);
        return ffv;
    }

    public void removeNodeDescriptorFromManifest(NodeDescriptor descriptor) {
        ClassificationUpdate cupdate = (ClassificationUpdate)this.getClassificationInfo(descriptor);
        if (cupdate != null) {
            cupdate.primRemoveNodeDescriptor(descriptor);
        }
    }

    public void removeFreeFormValueFromManifest(FreeFormValue ffv) {
        ClassificationUpdate cupdate = (ClassificationUpdate)this.getClassificationInfo(ffv);
        if (cupdate != null) {
            cupdate.primRemoveFreeFormValue(ffv);
        }
    }

    public void setCreationTime(String[] creationTime) {
        boolean creationTimeSet = creationTime != null && creationTime.length == 2 && creationTime[0] != null && !creationTime[0].equals("") && creationTime[1] != null && !creationTime[1].equals("");
        Classification cl = this.manifest.getClassification();
        if (cl == null) {
            cl = DefaultprofileFactory.eINSTANCE.createClassification();
            this.manifest.setClassification(cl);
        }
        DescriptorGroup creationGroup = null;
        for (DescriptorGroup group : cl.getDescriptorGroup()) {
            if (!"CreationTime".equals(group.getName())) continue;
            creationGroup = group;
            break;
        }
        if (creationGroup == null) {
            if (!creationTimeSet) {
                return;
            }
            creationGroup = DefaultprofileFactory.eINSTANCE.createDescriptorGroup();
            creationGroup.setName("CreationTime");
            cl.getDescriptorGroup().add((Object)creationGroup);
        } else if (!creationTimeSet) {
            cl.getDescriptorGroup().remove((Object)creationGroup);
            return;
        }
        creationGroup.getFreeFormDescriptor().clear();
        creationGroup.getFreeFormValue().clear();
        FreeFormDescriptor ffd = DefaultprofileFactory.eINSTANCE.createFreeFormDescriptor();
        ffd.setName("CreationTime");
        creationGroup.getFreeFormDescriptor().add((Object)ffd);
        FreeFormValue ffv = DefaultprofileFactory.eINSTANCE.createFreeFormValue();
        ffv.setFreeFormDescriptor(ffd);
        ffv.setValue(creationTime[0]);
        creationGroup.getFreeFormValue().add((Object)ffv);
        ffv = DefaultprofileFactory.eINSTANCE.createFreeFormValue();
        ffv.setFreeFormDescriptor(ffd);
        ffv.setValue(creationTime[1]);
        creationGroup.getFreeFormValue().add((Object)ffv);
    }

    public void setUsageTime(String[] usageTime) {
        boolean usageTimeSet = usageTime != null && usageTime.length == 2 && usageTime[0] != null && !usageTime[0].equals("") && usageTime[1] != null && !usageTime[1].equals("");
        Classification cl = this.manifest.getClassification();
        if (cl == null) {
            cl = DefaultprofileFactory.eINSTANCE.createClassification();
            this.manifest.setClassification(cl);
        }
        DescriptorGroup usageGroup = null;
        for (DescriptorGroup group : cl.getDescriptorGroup()) {
            if (!"UsageTime".equals(group.getName())) continue;
            usageGroup = group;
            break;
        }
        if (usageGroup == null) {
            if (!usageTimeSet) {
                return;
            }
            usageGroup = DefaultprofileFactory.eINSTANCE.createDescriptorGroup();
            usageGroup.setName("UsageTime");
            cl.getDescriptorGroup().add((Object)usageGroup);
        } else if (!usageTimeSet) {
            cl.getDescriptorGroup().remove((Object)usageGroup);
            return;
        }
        usageGroup.getFreeFormDescriptor().clear();
        usageGroup.getFreeFormValue().clear();
        FreeFormDescriptor ffd = DefaultprofileFactory.eINSTANCE.createFreeFormDescriptor();
        ffd.setName("UsageTime");
        usageGroup.getFreeFormDescriptor().add((Object)ffd);
        FreeFormValue ffv = DefaultprofileFactory.eINSTANCE.createFreeFormValue();
        ffv.setFreeFormDescriptor(ffd);
        ffv.setValue(usageTime[0]);
        usageGroup.getFreeFormValue().add((Object)ffv);
        ffv = DefaultprofileFactory.eINSTANCE.createFreeFormValue();
        ffv.setFreeFormDescriptor(ffd);
        ffv.setValue(usageTime[1]);
        usageGroup.getFreeFormValue().add((Object)ffv);
    }

    public Map<String, CustomAttributeUpdate> getCustomAttributeUpdates() {
        return this.getCustomAttributes();
    }

    public Map<URI, ClassificationUpdate> getClassificationUpdates() {
        return this.getClassificationInfos();
    }

    public void addCustomAttribute(String uriString, String value) {
        CustomAttributeUpdate ca = (CustomAttributeUpdate)this.uriStringsToCustomAttributes.get(uriString);
        if (ca != null) {
            ca.setUnrestrictedAttributeValue(value);
        }
    }

    public CustomAttributeUpdate addCustomAttribute(String uriString) {
        CustomAttributeUpdate ca = (CustomAttributeUpdate)this.uriStringsToCustomAttributes.get(uriString);
        if (ca != null) {
            return ca;
        }
        ca = (CustomAttributeUpdate)this.createCustomAttribute(uriString, true, false, false);
        if (ca.getDescriptor() == null) {
            FreeFormDescriptor ffd = DefaultprofileFactory.eINSTANCE.createFreeFormDescriptor();
            ((InternalEObject)ffd).eSetProxyURI(URI.createURI((String)uriString));
            ca.setDescriptor(ffd);
        }
        this.uriStringsToCustomAttributes.put(uriString, ca);
        return ca;
    }

    public CustomAttributeUpdate addSelfDefinedCustomAttribute(String name, String value) {
        return this.addSelfDefinedCustomAttribute(name, Collections.singletonList(value));
    }

    public CustomAttributeUpdate addSelfDefinedCustomAttribute(String name, Collection<String> values) {
        CustomAttributeUpdate ca = (CustomAttributeUpdate)this.getSelfDefinedCustomAttribute(name);
        if (ca != null) {
            List<String> cavalues = ca.getUnrestrictedAttributeValues();
            cavalues.clear();
            cavalues.addAll(values);
        } else {
            FreeFormDescriptor ffd = DefaultprofileFactory.eINSTANCE.createFreeFormDescriptor();
            ffd.setName(name);
            ca = (CustomAttributeUpdate)this.createCustomAttribute(this.createSelfDefinedURIString(name, (XMLResource)this.getManifest().eResource()), true, false, true);
            ca.setDescriptor(ffd);
            ca.getUnrestrictedAttributeValues().addAll(values);
            this.uriStringsToCustomAttributes.put(ca.getURIString(), ca);
            this.selfDefinedCustomAttributeNamesToCustomAttributes.put(name, ca);
        }
        return ca;
    }

    public void addCustomAttribute(String uriString, NodeDescriptor[] values) {
        CustomAttributeUpdate ca = (CustomAttributeUpdate)this.uriStringsToCustomAttributes.get(uriString);
        if (ca != null) {
            ca.setRestrictedAttributeValues(values);
        }
    }

    public void addCustomAttribute(String uriString, NodeDescriptor value) {
        CustomAttributeUpdate ca = (CustomAttributeUpdate)this.uriStringsToCustomAttributes.get(uriString);
        if (ca != null) {
            ca.setRestrictedAttributeValue(value);
        }
    }

    public void removeCustomAttribute(String uriString) {
        CustomAttributeUpdate ca = (CustomAttributeUpdate)this.uriStringsToCustomAttributes.get(uriString);
        if (ca != null) {
            ca.removeAttribute();
        }
    }

    protected Solution getSolutionCreateIfNeeded() {
        Solution sol = this.getSolution();
        if (sol == null) {
            sol = DefaultprofileFactory.eINSTANCE.createSolution();
            this.manifest.setSolution(sol);
        }
        return sol;
    }

    public void clearSolution() {
        Solution sol = this.getSolution();
        if (sol != null) {
            sol.getArtifact().clear();
        }
    }

    public Artifact addArtifactFolder(Artifact parentFolder, String folderName) throws IllegalArgumentException {
        if (!ArtifactUtilities.isValidArtifactPath(folderName)) {
            throw new IllegalArgumentException("The specified folder name is not valid: " + folderName);
        }
        Artifact folder = DefaultprofileFactory.eINSTANCE.createArtifact();
        folder.setName(folderName);
        folder.setType("folder");
        if (parentFolder != null) {
            parentFolder.getArtifact().add((Object)folder);
        } else {
            this.getSolutionCreateIfNeeded().getArtifact().add((Object)folder);
        }
        return folder;
    }

    public Artifact addArtifactFolder(String path) {
        return this.getFolder(path);
    }

    public Artifact addArtifactUrl(Artifact folder, String name, String url) {
        Artifact artifact = DefaultprofileFactory.eINSTANCE.createArtifact();
        artifact.setName(name);
        artifact.setType("url");
        Reference ref = DefaultprofileFactory.eINSTANCE.createReference();
        ref.setValue(url);
        ReferenceKind refKind = DefaultprofileFactory.eINSTANCE.createReferenceKind();
        refKind.setName("url");
        ref.setReferenceKind(refKind);
        artifact.setReference(ref);
        if (folder != null) {
            folder.getArtifact().add((Object)artifact);
        } else {
            this.getSolutionCreateIfNeeded().getArtifact().add((Object)artifact);
        }
        return artifact;
    }

    public Artifact addArtifactUrlCache(Artifact folder, String name, String url, String description) {
        if (UtilitiesCommon.isEmptyString(description)) {
            throw new IllegalArgumentException("Argument 'description' may not be empty.");
        }
        Artifact artifact = DefaultprofileFactory.eINSTANCE.createArtifact();
        artifact.setName(name);
        artifact.setType("url_cache");
        Description desc = DefaultprofileFactory.eINSTANCE.createDescription();
        desc.setValue(description);
        artifact.setDescription(desc);
        Reference ref = DefaultprofileFactory.eINSTANCE.createReference();
        ref.setValue(url);
        ReferenceKind refKind = DefaultprofileFactory.eINSTANCE.createReferenceKind();
        refKind.setName("url");
        ref.setReferenceKind(refKind);
        artifact.setReference(ref);
        if (folder != null) {
            folder.getArtifact().add((Object)artifact);
        } else {
            this.getSolutionCreateIfNeeded().getArtifact().add((Object)artifact);
        }
        return artifact;
    }

    public Artifact addArtifactFile(Artifact folder, String filename, String description) {
        Artifact file = DefaultprofileFactory.eINSTANCE.createArtifact();
        file.setName(filename);
        if (description != null && description.length() > 0) {
            Description desc = DefaultprofileFactory.eINSTANCE.createDescription();
            desc.setValue(description);
            file.setDescription(desc);
        }
        if (folder != null) {
            folder.getArtifact().add((Object)file);
        } else {
            this.getSolutionCreateIfNeeded().getArtifact().add((Object)file);
        }
        return file;
    }

    public ArtifactDetail addArtifactDetail(Artifact artifact, long size, Timestamp creationDate) {
        if (this.artifactDetails == null) {
            return null;
        }
        ArtifactDetail detail = this.getArtifactAdapter().getArtifactDetail(artifact);
        if (detail == null) {
            EObject container = artifact.eContainer();
            String path = null;
            if (container instanceof Artifact) {
                path = ((Artifact)container).computePathInSolution("/");
            }
            return this.addArtifactDetail(path, this.getArtifactAdapter().getFileName(artifact), size, creationDate);
        }
        detail.setCreationDate(creationDate);
        detail.setSize(size);
        return detail;
    }

    public ArtifactDetail addArtifactDetail(Artifact artifact, ZipEntry artifactZipEntry) {
        if (artifactZipEntry.isDirectory()) {
            return null;
        }
        if (this.artifactDetails != null) {
            return this.addArtifactDetail(artifact, artifactZipEntry.getSize(), new Timestamp(artifactZipEntry.getTime()));
        }
        return null;
    }

    public ArtifactDetail addArtifactDetail(String path, String name, long size, Timestamp creationDate) {
        if (this.artifactDetails == null) {
            return null;
        }
        ArtifactDetail detail = EMFFactory.eINSTANCE.createArtifactDetail();
        if (path != null) {
            detail.setPath(path);
        }
        detail.setName(name);
        detail.setCreationDate(creationDate);
        detail.setSize(size);
        this.artifactDetails.getArtifactDetails().add((Object)detail);
        return detail;
    }

    public void removeArtifact(Artifact artifact) {
        EObject container = artifact.eContainer();
        if (container != null && this.getManifestResource() == container.eResource()) {
            ((List)container.eGet((EStructuralFeature)artifact.eContainmentFeature())).remove(artifact);
        }
    }

    public Artifact addArtifact(ZipEntry artifactZipEntry) {
        return this.addArtifact(artifactZipEntry, null);
    }

    private static String formFullName(String path, String file) {
        StringBuilder sb = new StringBuilder(path);
        if (path.endsWith("/")) {
            if (!file.startsWith("/")) {
                sb.append(file);
            } else {
                sb.append(file, 1, file.length() - 1);
            }
        } else if (!file.startsWith("/")) {
            sb.append('/').append(file);
        } else {
            sb.append(file);
        }
        return sb.toString();
    }

    public Artifact addArtifact(ZipEntry zipEntry, String path) {
        String zipname = this.normalize(zipEntry.getName());
        path = this.normalize(path);
        zipname = ManifestBuilder.formFullName(path, zipname);
        if (zipEntry.isDirectory()) {
            return this.getFolder(zipname);
        }
        String[] pathName = this.getPathName(zipname);
        if (pathName[0] == "/" && "manifest.rmd".equalsIgnoreCase(pathName[1])) {
            return null;
        }
        Artifact file = this.getArtifactAdapter().getArtifact(pathName[0], pathName[1]);
        if (file == null) {
            Artifact folder = this.getFolder(pathName[0]);
            file = this.addArtifactFile(folder, pathName[1], zipEntry.getComment());
            Reference ref = DefaultprofileFactory.eINSTANCE.createReference();
            ref.setValue(pathName[1]);
            file.setReference(ref);
        }
        if (this.artifactDetails != null) {
            this.addArtifactDetail(pathName[0], pathName[1], zipEntry.getSize(), new Timestamp(zipEntry.getTime()));
        }
        return file;
    }

    public Artifact addArtifact(File aFile, String path) {
        return this.addArtifact(aFile, path, aFile.getName());
    }

    public Artifact addArtifact(File aFile, String path, String name) {
        String fileName = this.normalize(name != null ? name : aFile.getName());
        fileName = ManifestBuilder.formFullName(path = this.normalize(path), fileName);
        String[] pathName = this.getPathName(fileName);
        if (pathName[0] == "/" && "manifest.rmd".equalsIgnoreCase(pathName[1])) {
            return null;
        }
        Artifact file = this.getArtifactAdapter().getArtifact(pathName[0], pathName[1]);
        if (file == null) {
            Artifact folder = this.getFolder(pathName[0]);
            file = this.addArtifactFile(folder, pathName[1], null);
            Reference ref = DefaultprofileFactory.eINSTANCE.createReference();
            ref.setValue(pathName[1]);
            file.setReference(ref);
        }
        if (this.artifactDetails != null) {
            this.addArtifactDetail(file, aFile.length(), new Timestamp(aFile.lastModified()));
        }
        return file;
    }

    public Artifact addArtifact(Artifact folder, File file, String description) {
        if (file.isDirectory()) {
            return null;
        }
        return this.addArtifact(folder, file.getName(), description, file.length(), new Timestamp(file.lastModified()));
    }

    public Artifact addArtifact(Artifact folder, String filename, String description, long fileLength, Timestamp fileTimestamp) {
        Artifact afile = this.addArtifactFile(folder, filename, description);
        Reference ref = DefaultprofileFactory.eINSTANCE.createReference();
        ref.setValue(filename);
        afile.setReference(ref);
        if (this.artifactDetails != null) {
            this.addArtifactDetail(afile, fileLength, fileTimestamp);
        }
        return afile;
    }

    protected Artifact getFolder(String path) {
        if (path == null || "/".equals(path)) {
            return null;
        }
        Artifact folder = this.getArtifactAdapter().getFolder(path);
        if (folder == null) {
            String[] pathName = this.getPathName(path);
            if (pathName[0] == "/") {
                return this.addArtifactFolder(null, pathName[1]);
            }
            return this.addArtifactFolder(this.getFolder(pathName[0]), pathName[1]);
        }
        return folder;
    }

    @Override
    protected ManifestAccessor.ClassificationInfo createClassificationInfo(ClassificationSchema schema, URI uri, boolean other) {
        return new ClassificationUpdate(schema, uri, other);
    }

    void aboutToInitializeValidationManager() {
        this.internalInitializeClassifications(this.includeOtherSchemas, Collections.<URI>emptyList(), false);
        this.internalInitializeCustomAttributes(this.includeOtherCustomAttributes, Collections.<String>emptyList(), false, Collections.<String>emptyList(), Collections.<String, List<String>>emptyMap());
    }

    void validationManagerReinit(Collection<URI> classifications, boolean allClassifications, Collection<String> attributes, Collection<String> requiredAttributeURIs, Map<String, List<String>> authorizedUserMap) {
        this.internalInitializeClassifications(this.includeOtherSchemas, classifications, true);
        this.internalInitializeCustomAttributes(this.includeOtherCustomAttributes, attributes, true, requiredAttributeURIs, authorizedUserMap);
    }

    public Map initializeClassifications(boolean includeOthers, Collection<URI> classificationSchemas) {
        throw new IllegalStateException("This method cannot be called on a ManifestBuilder. Use initializeClassifications(boolean, Collection classificationSchemas, boolean deleteDifferences) instead.");
    }

    public Map<URI, ManifestAccessor.ClassificationInfo> initializeClassifications(boolean includeOthers, Collection<URI> classificationSchemaURIs, boolean deleteDifferences) {
        if (this.validationManager != null) {
            throw new IllegalStateException("Cannot call initializeClassifications when there is a ValidationManager controlling the accessor.");
        }
        return this.internalInitializeClassifications(includeOthers, classificationSchemaURIs, deleteDifferences);
    }

    protected Map<URI, ManifestAccessor.ClassificationInfo> internalInitializeClassifications(boolean includeOthers, Collection<URI> classificationSchemaURIs, boolean deleteDifferences) {
        if (this.schemaURIToInfo != null && deleteDifferences) {
            HashSet notReferenced = new HashSet(this.schemaURIToInfo.keySet());
            notReferenced.removeAll(classificationSchemaURIs);
            for (URI uri : notReferenced) {
                ManifestAccessor.ClassificationInfo cinfo = (ManifestAccessor.ClassificationInfo)this.schemaURIToInfo.remove(uri);
                this.schemaToInfo.remove(cinfo.getSchema());
                DescriptorGroup group = cinfo.getGroup();
                if (group == null || cinfo.isOtherSchema()) continue;
                this.manifest.getClassification().getDescriptorGroup().remove((Object)group);
            }
        }
        return super.internalInitializeClassifications(includeOthers, classificationSchemaURIs);
    }

    @Override
    public Map<String, ManifestAccessor.CustomAttribute> initializeCustomAttributes(boolean includeOthers, Collection<String> customAttributeURIStrings) {
        throw new IllegalStateException("This method cannot be called on a ManifestBuilder. Use initializeCustomAttributes(boolean, Collection customAttributeURIStrings, boolean deleteDifferences) instead.");
    }

    public Map<String, ManifestAccessor.CustomAttribute> initializeCustomAttributes(boolean includeOthers, Collection<String> customAttributeURIStrings, boolean deleteDifferences) {
        if (this.validationManager != null) {
            throw new IllegalStateException("Cannot call initializeCustomAttributes when there is a ValidationManager controlling the accessor.");
        }
        List<String> e = Collections.emptyList();
        return this.internalInitializeCustomAttributes(includeOthers, customAttributeURIStrings, deleteDifferences, e, Collections.<String, List<String>>emptyMap());
    }

    protected Map<String, ManifestAccessor.CustomAttribute> internalInitializeCustomAttributes(boolean includeOthers, Collection<String> customAttributeURIStrings, boolean deleteDifferences, Collection<String> requiredAttributeURIStrings, Map<String, List<String>> authorizedUserMap) {
        if (this.uriStringsToCustomAttributes != null && deleteDifferences) {
            HashSet notReferenced = new HashSet(this.uriStringsToCustomAttributes.keySet());
            notReferenced.removeAll(customAttributeURIStrings);
            for (String uri : notReferenced) {
                CustomAttributeUpdate ca = (CustomAttributeUpdate)this.uriStringsToCustomAttributes.remove(uri);
                if (!ca.isAttributeSet() || ca.isOtherAttribute()) continue;
                ca.removeAttribute();
            }
        }
        return super.internalInitializeCustomAttributes(includeOthers, customAttributeURIStrings, requiredAttributeURIStrings, authorizedUserMap);
    }

    @Override
    protected <C extends ManifestAccessor.CustomAttribute> C createCustomAttribute(String uriString, boolean other, boolean required, boolean selfDefined) {
        return (C)new CustomAttributeUpdate(uriString, other, required, selfDefined);
    }

    public void setPrimaryType(String type, ArtifactDetail detail) {
        this.setFormat(type, detail);
    }

    public void setFormat(String format, ArtifactDetail detail) {
        this.setFormat(format, detail.getArtifact());
    }

    public void setPrimaryType(String type, Artifact artifact) {
        this.setFormat(type, artifact);
    }

    public void setFormat(String format, Artifact artifact) {
        if (artifact != null) {
            if ((format = Utilities.escapeForXML(format)) != null && format.length() == 0) {
                format = null;
            }
            artifact.setType(format);
        }
    }

    public void setSecondaryType(String type, ArtifactDetail detail) {
        this.setLabel(type, detail.getArtifact());
    }

    public void setLabel(String type, ArtifactDetail detail) {
        this.setLabel(type, detail.getArtifact());
    }

    public void setSecondaryType(String type, Artifact artifact) {
        this.setLabel(type, artifact);
    }

    public void setLabel(String type, Artifact artifact) {
        if (artifact != null) {
            if ((type = Utilities.escapeForXML(type)) != null) {
                type = type.trim();
            }
            EList secTypes = artifact.getArtifactType();
            if (!UtilitiesCommon.isEmptyString(type)) {
                if (!secTypes.isEmpty()) {
                    int foundNdx = -1;
                    ListIterator li = secTypes.listIterator();
                    while (li.hasNext()) {
                        ArtifactType at = (ArtifactType)li.next();
                        if (!UtilitiesCommon.stringsEqualOrEmpty(type, at.getType())) continue;
                        foundNdx = li.previousIndex();
                        break;
                    }
                    ArtifactType at = (ArtifactType)secTypes.get(0);
                    if (foundNdx == -1) {
                        at.setType(type);
                    } else if (foundNdx > 0) {
                        secTypes.remove(foundNdx);
                        at.setType(type);
                    }
                } else {
                    ArtifactType at = DefaultprofileFactory.eINSTANCE.createArtifactType();
                    at.setType(type);
                    secTypes.add(at);
                }
            } else if (!secTypes.isEmpty()) {
                secTypes.remove(0);
            }
        }
    }

    private void setFormatTypes(IMimeTypeResolver resolver, Iterator aIter) {
        while (aIter.hasNext()) {
            String mime;
            int idx;
            Artifact a = (Artifact)aIter.next();
            String format = this.getFormat(a);
            if ((format == null || format.length() == 0) && (idx = a.getName().lastIndexOf(46)) >= 0 && (mime = resolver.getMimeType(a.getName().substring(idx, a.getName().length()))) != null && mime.length() > 0) {
                this.setFormat(mime, a);
            }
            if (a.getArtifact().isEmpty()) continue;
            this.setFormatTypes(resolver, a.getArtifact().iterator());
        }
    }

    public void setFormatTypes(IMimeTypeResolver resolver) {
        if (resolver != null && this.getSolution() != null && !this.getSolution().getArtifact().isEmpty()) {
            this.setFormatTypes(resolver, this.getSolution().getArtifact().iterator());
        }
    }

    public void setValidationManager(ValidationManager validationManager) {
        if (this.validationManager == validationManager) {
            return;
        }
        this.validationManager = validationManager;
        if (validationManager != null) {
            validationManager.setBuilder(this);
            this.aboutToInitializeValidationManager();
            validationManager.initialize();
        }
    }

    public ValidationManager getValidationManager() {
        return this.validationManager;
    }

    public RelatedAsset getRelatedAsset(String guid, String version, String relationshipType) {
        try {
            for (RelatedAsset rel : this.getRelatedAssets()) {
                if (!UtilitiesCommon.objectsEqual(rel.getAssetId(), guid) || !UtilitiesCommon.objectsEqual(rel.getAssetVersion(), version) || !UtilitiesCommon.objectsEqual(rel.getRelationshipType(), relationshipType)) continue;
                return rel;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public void cleanupManifest() {
        Usage usage = this.getManifest().getUsage();
        if (usage != null) {
            Artifact usageArt = usage.getArtifact();
            if (usageArt != null && usageArt.eResource() == null) {
                usage.setArtifact(null);
            }
            boolean removedArtifactActivites = false;
            Iterator artActivites = usage.getArtifactActivity().iterator();
            while (artActivites.hasNext()) {
                ArtifactActivity artActivity = (ArtifactActivity)artActivites.next();
                Artifact artifact = artActivity.getArtifact();
                if (artifact != null && artifact.eResource() != null) continue;
                boolean changed = false;
                Iterator activities = artActivity.getActivity().iterator();
                while (activities.hasNext()) {
                    Activity activity = (Activity)activities.next();
                    if (!"com.ibm.ram.rich.ui.extension.consumeProjectTask".equals(activity.getTaskType())) continue;
                    activities.remove();
                    changed = true;
                }
                if (!changed || !artActivity.getActivity().isEmpty()) continue;
                artActivites.remove();
                removedArtifactActivites = true;
            }
            if (removedArtifactActivites && usage.getArtifactActivity().isEmpty() && usage.getAssetActivity().isEmpty() && usage.getArtifact() == null) {
                this.getManifest().setUsage(null);
            }
        }
    }

    public List<String> getAssetVersions() {
        return this.assetVersions == null ? Collections.emptyList() : this.assetVersions;
    }

    public void setAssetVersions(List<String> assetVersions) {
        this.assetVersions = assetVersions;
    }

    public List<RelationSource> getAddRelations() {
        return this.addRelations == null ? Collections.emptyList() : this.addRelations;
    }

    public void addRelation(RelationSource relSource) {
        if (this.addRelations == null) {
            this.addRelations = new ArrayList<RelationSource>();
        }
        this.addRelations.add(relSource);
    }

    public boolean isAnyAddRelations() {
        return this.addRelations != null;
    }

    public List<Integer> getDeleteRelations() {
        return this.deleteRelations == null ? Collections.emptyList() : this.deleteRelations;
    }

    public void deleteRelation(int relationID) {
        if (this.deleteRelations == null) {
            this.deleteRelations = new ArrayList<Integer>();
        }
        this.deleteRelations.add(relationID);
    }

    public boolean isAndRelationsDeleted() {
        return this.deleteRelations != null;
    }

    public class ClassificationUpdate
    extends ManifestAccessor.ClassificationInfo {
        ClassificationUpdate(ClassificationSchema schema, URI uri, boolean other) {
            super(ManifestBuilder.this, schema, uri, other);
        }

        public void unsetSchema() {
            if (this.group != null) {
                this.group.getFreeFormValue().clear();
                this.group.getFreeFormDescriptor().clear();
                this.group.getNodeDescriptor().clear();
                this.handleDescriptorGroupEmpty();
            }
        }

        public void addNodeDescriptor(NodeDescriptor descriptor) {
            ClassificationSchema cfs = ManifestBuilder.this.getClassificationSchema(descriptor);
            if (cfs != this.getSchema()) {
                throw new IllegalArgumentException("Descriptor is for a different schema than the one this ClassificationInfo is for.");
            }
            this.primAddNodeDescriptor(descriptor);
        }

        public void addFreeFormValue(FreeFormValue ffv) {
            ClassificationSchema cfs = ManifestBuilder.this.getClassificationSchema(ffv.getFreeFormDescriptor());
            if (cfs != this.getSchema()) {
                throw new IllegalArgumentException("Descriptor is for a different schema than the one this ClassificationInfo is for.");
            }
            this.primAddFreeFormValue(ffv);
        }

        void primAddNodeDescriptor(NodeDescriptor descriptor) {
            if ((descriptor = ManifestBuilder.this.resolveDescriptor(descriptor)) == null) {
                return;
            }
            this.handleGroup();
            if (this.nodeDescriptors.add(descriptor)) {
                this.group.getNodeDescriptor().add((Object)descriptor);
            }
        }

        public void removeNodeDescriptor(NodeDescriptor descriptor) {
            ClassificationSchema cfs = ManifestBuilder.this.getClassificationSchema(descriptor);
            if (cfs != this.getSchema()) {
                throw new IllegalArgumentException("Descriptor is for a different schema than the one this ClassificationInfo is for.");
            }
            this.primRemoveNodeDescriptor(descriptor);
        }

        void primRemoveNodeDescriptor(NodeDescriptor descriptor) {
            NodeDescriptor resolvedDescriptor = ManifestBuilder.this.resolveDescriptor(descriptor);
            if (resolvedDescriptor != null) {
                descriptor = resolvedDescriptor;
            }
            if (this.nodeDescriptors.remove(descriptor) && this.group.getNodeDescriptor().remove((Object)descriptor)) {
                this.handleDescriptorGroupEmpty();
            }
        }

        public void removeFreeFormValue(FreeFormValue ffv) {
            FreeFormDescriptor ffd = ffv.getFreeFormDescriptor();
            ClassificationSchema cfs = ManifestBuilder.this.getClassificationSchema(ffd);
            if (cfs != this.getSchema()) {
                throw new IllegalArgumentException("FreeFormValue is for a different schema than the one this ClassificationInfo is for.");
            }
            this.primRemoveFreeFormValue(ffv);
        }

        void primAddFreeFormValue(FreeFormValue ffv) {
            this.handleGroup();
            if (this.freeformValues.add(ffv)) {
                this.group.getFreeFormValue().add((Object)ffv);
            }
        }

        void primRemoveFreeFormValue(FreeFormValue ffv) {
            if (this.freeformValues.remove(ffv) && this.group.getFreeFormValue().remove((Object)ffv)) {
                this.handleDescriptorGroupEmpty();
            }
        }

        protected void handleDescriptorGroupEmpty() {
            if (this.group.getFreeFormValue().isEmpty() && this.group.getNodeDescriptor().isEmpty()) {
                ManifestBuilder.this.manifest.getClassification().getDescriptorGroup().remove((Object)this.group);
                this.group = null;
                this.nodeDescriptors.clear();
                this.freeformValues.clear();
            }
        }

        protected void handleGroup() {
            if (!this.isSchemaSet()) {
                if (!this.isValid()) {
                    return;
                }
                Classification cl = ManifestBuilder.this.manifest.getClassification();
                if (cl == null) {
                    cl = DefaultprofileFactory.eINSTANCE.createClassification();
                    ManifestBuilder.this.manifest.setClassification(cl);
                }
                DescriptorGroup g = DefaultprofileFactory.eINSTANCE.createDescriptorGroup();
                ClassificationSchema schema = this.getSchema();
                g.setName(schema.getName());
                g.getClassificationSchema().add((Object)schema);
                cl.getDescriptorGroup().add((Object)g);
                this.setDescriptorGroup(g);
            }
        }
    }

    public class CustomAttributeUpdate
    extends ManifestAccessor.CustomAttribute {
        CustomAttributeUpdate(String uriString, boolean other, boolean required, boolean selfDefined) {
            super(ManifestBuilder.this, uriString, other, required, selfDefined);
        }

        public void setUnrestrictedAttributeValue(String value) {
            if (this.isRestrictedValues()) {
                throw new IllegalStateException("Cannot apply a string value to a restricted values custom attribute.");
            }
            if (UtilitiesCommon.isEmptyStringTrimmed(value)) {
                this.removeUnrestrictedSetting(-23, null);
            } else {
                FreeFormValue ffv;
                if (!this.isAttributeSet()) {
                    ffv = this.createFreeFormValue(-1, null);
                } else if (this.ffvSet.size() == 1) {
                    ffv = (FreeFormValue)this.ffvSet.get(0);
                } else {
                    List removedFFV = this.ffvSet.subList(1, this.ffvSet.size());
                    ManifestBuilder.this.customAttributeGroup.getFreeFormValue().removeAll(removedFFV);
                    ffv = (FreeFormValue)this.ffvSet.get(0);
                    removedFFV.clear();
                }
                ffv.setValue(Utilities.escapeForXML(value));
            }
        }

        @Override
        protected void addUnrestrictedSetting(int index, ListIterator<FreeFormValue> ffvItr, String value) {
            if (this.isRestrictedValues()) {
                throw new IllegalStateException("Cannot apply a string value to a restricted values custom attribute.");
            }
            this.createFreeFormValue(index, ffvItr).setValue(Utilities.escapeForXML(value));
        }

        @Override
        protected String setUnrestrictedSetting(int index, String value) {
            if (this.isRestrictedValues()) {
                throw new IllegalStateException("Cannot apply a string value to a restricted values custom attribute.");
            }
            FreeFormValue ffv = (FreeFormValue)this.ffvSet.get(index);
            try {
                String string = ffv.getValue();
                return string;
            }
            finally {
                ffv.setValue(Utilities.escapeForXML(value));
            }
        }

        public void setRestrictedAttributeValues(NodeDescriptor[] values) {
            if (!this.isRestrictedValues()) {
                throw new IllegalStateException("Cannot apply a node descriptor value to a non-restricted values custom attribute.");
            }
            if (values.length > 1 && !this.isManySelect()) {
                throw new IllegalArgumentException("Cannot apply more than one value to a single select restricted value custom attribute.");
            }
            if (values.length == 0) {
                this.removeAttribute();
            } else {
                this.isAttributeSet();
                this.nodesSet = (NodeDescriptor[])values.clone();
                this.applyRestrictedValues();
            }
        }

        public void setRestrictedAttributeValue(NodeDescriptor value) {
            if (!this.isRestrictedValues()) {
                throw new IllegalStateException("Cannot apply a node descriptor value to a non-restricted values custom attribute.");
            }
            this.isAttributeSet();
            if (this.nodesSet != null && this.nodesSet.length == 1) {
                this.nodesSet[0] = value;
            } else {
                this.nodesSet = new NodeDescriptor[]{value};
            }
            this.applyRestrictedValues();
        }

        public void removeAttribute() {
            if (this.isAttributeSet()) {
                if (this.isRestrictedValues()) {
                    this.primRemoveRestrictedAttribute();
                } else {
                    this.primRemoveUnrestrictedSetting(-23, null);
                }
            }
        }

        @Override
        protected String removeUnrestrictedSetting(int ndx, ManifestAccessor.CustomAttribute.ValueList.Itr vItr) {
            if (this.isAttributeSet()) {
                return this.primRemoveUnrestrictedSetting(ndx, vItr);
            }
            return null;
        }

        protected FreeFormValue createFreeFormValue(int ndx, ListIterator<FreeFormValue> ffvItr) {
            FreeFormDescriptor ffd;
            FreeFormValue ffv = DefaultprofileFactory.eINSTANCE.createFreeFormValue();
            if (ffvItr == null && (ndx == -1 || ndx == this.getFreeFormValues().size())) {
                this.getFreeFormValues().add(ffv);
                this.createGroup();
                ffd = (FreeFormDescriptor)this.getDescriptor();
                ManifestBuilder.this.customAttributeGroup.getFreeFormValue().add((Object)ffv);
            } else {
                if (ffvItr != null) {
                    ndx = ffvItr.nextIndex();
                    ffvItr.add(ffv);
                } else {
                    this.getFreeFormValues().add(ndx, ffv);
                }
                this.createGroup();
                ffd = (FreeFormDescriptor)this.getDescriptor();
                int cnt = -1;
                ListIterator itr = ManifestBuilder.this.customAttributeGroup.getFreeFormValue().listIterator();
                while (itr.hasNext()) {
                    FreeFormValue ffvg = (FreeFormValue)itr.next();
                    if (ffvg.getFreeFormDescriptor() != ffd || ++cnt != ndx) continue;
                    itr.add(ffv);
                    break;
                }
            }
            if (this.isSelfDefined() && ffd.eResource() == null) {
                ManifestBuilder.this.customAttributeGroup.getFreeFormDescriptor().add((Object)ffd);
                ((XMLResource)ffd.eResource()).setID((EObject)ffd, this.getURIString());
            }
            ffv.setFreeFormDescriptor(ffd);
            if (!this.isSelfDefined() && this.isResolved() && !ManifestBuilder.this.customAttributeGroup.getClassificationSchema().contains((Object)ffd.getClassificationSchema())) {
                ManifestBuilder.this.customAttributeGroup.getClassificationSchema().add((Object)ffd.getClassificationSchema());
            }
            return ffv;
        }

        private void createGroup() {
            if (ManifestBuilder.this.customAttributeGroup == null) {
                Classification cl = ManifestBuilder.this.manifest.getClassification();
                if (cl == null) {
                    cl = DefaultprofileFactory.eINSTANCE.createClassification();
                    ManifestBuilder.this.manifest.setClassification(cl);
                } else {
                    for (DescriptorGroup dg : cl.getDescriptorGroup()) {
                        if (!"CustomAttributes".equals(dg.getName())) continue;
                        ManifestBuilder.this.customAttributeGroup = dg;
                        return;
                    }
                }
                ManifestBuilder.this.customAttributeGroup = DefaultprofileFactory.eINSTANCE.createDescriptorGroup();
                cl.getDescriptorGroup().add((Object)ManifestBuilder.this.customAttributeGroup);
                ManifestBuilder.this.customAttributeGroup.setName("CustomAttributes");
            }
        }

        protected void applyRestrictedValues() {
            this.createGroup();
            NodeDescriptor attrNode = (NodeDescriptor)this.getDescriptor();
            Iterator iter = ManifestBuilder.this.customAttributeGroup.getNodeDescriptor().iterator();
            while (iter.hasNext()) {
                NodeDescriptor node = (NodeDescriptor)iter.next();
                if (node.getGeneral() != attrNode) continue;
                iter.remove();
            }
            Collections.addAll(ManifestBuilder.this.customAttributeGroup.getNodeDescriptor(), this.nodesSet);
            NodeDescriptor topNode = attrNode;
            while (topNode.getGeneral() != null) {
                topNode = topNode.getGeneral();
            }
            if (!ManifestBuilder.this.customAttributeGroup.getClassificationSchema().contains((Object)topNode.getClassificationSchema())) {
                ManifestBuilder.this.customAttributeGroup.getClassificationSchema().add((Object)topNode.getClassificationSchema());
            }
        }

        public void setName(String name) {
            this.isAttributeSet();
            if (this.isSelfDefined()) {
                Descriptor desc = this.getDescriptor();
                if (this.isResolved() && !UtilitiesCommon.objectsEqual(desc.getName(), name)) {
                    desc.setName(name);
                }
            } else {
                throw new UnsupportedOperationException("Cannot change name of a defined attribute through the manifes of an asset. Must be changed in repository instead.");
            }
        }
    }
}

