/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.io.zip.ZipEntry;
import com.ibm.ram.io.zip.ZipFile;
import com.ibm.ram.io.zip.ZipOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.ZipException;

public class RAMZip {
    private static final int MODE_CREATE = 1;
    private static final int MODE_LIST = 2;
    private static final int MODE_EXTRACT = 3;
    private static final String ARG_EXTRACT = "-x";
    private static final String ARG_LIST = "-t";
    private static final String ARG_CREATE = "-c";
    private static final String ARG_VERBOSE = "-v";
    private static final String ARG_PARENT_FOLDER = "-C";
    private static int VERSION = 2;
    private int mode = -1;
    private boolean verbose = false;
    private File fileZip = null;
    private FilePath[] filePaths = null;
    private static final String BUNDLE_NAME = "com.ibm.ram.internal.common.bundles.commonMessages";
    private static ResourceBundle bundle = null;

    public static String getNLString(String key) {
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            }
            catch (MissingResourceException missingResourceException) {
                return String.valueOf('!') + key + '!';
            }
        }
        return bundle.getString(key);
    }

    public static void main(String[] args) throws IOException {
        RAMZip ramZip = null;
        if (args != null && args.length > 0) {
            ramZip = RAMZip.parseArguments(args);
        }
        if (ramZip == null) {
            RAMZip.displayUsage();
        } else {
            super.processZip();
        }
    }

    private static RAMZip parseArguments(String[] args) {
        RAMZip ramZip = null;
        if (args != null && args.length > 0) {
            int argIndex;
            int mode = -1;
            boolean verbose = false;
            String zipPath = null;
            FilePath[] paths = null;
            ArrayList<FilePath> filePaths = new ArrayList<FilePath>();
            if (args.length < 3) {
                RAMZip.displayUsage();
            }
            if (ARG_VERBOSE.equals(args[argIndex = 0])) {
                verbose = true;
                ++argIndex;
            }
            if (ARG_CREATE.equals(args[argIndex])) {
                mode = 1;
                ++argIndex;
            } else if (ARG_LIST.equals(args[argIndex])) {
                mode = 2;
                ++argIndex;
            } else if (ARG_EXTRACT.equals(args[argIndex])) {
                mode = 3;
                ++argIndex;
            } else {
                RAMZip.displayUsage();
            }
            if (argIndex >= args.length) {
                RAMZip.displayUsage();
            }
            zipPath = args[argIndex];
            int zipFileIndex = argIndex;
            if (zipFileIndex + 1 >= args.length) {
                RAMZip.displayUsage();
            }
            String parentFolder = null;
            int argc = zipFileIndex + 1;
            while (argc < args.length) {
                if (ARG_PARENT_FOLDER.equals(args[argc])) {
                    if (mode == 1) {
                        parentFolder = args[++argc];
                    } else if (mode == 3) {
                        filePaths.add(new FilePath(args[++argc], null));
                    } else if (mode == 2) {
                        RAMZip.displayUsage();
                    }
                } else if (mode == 1) {
                    filePaths.add(new FilePath(parentFolder, args[argc]));
                } else {
                    RAMZip.displayUsage();
                }
                ++argc;
            }
            if (filePaths != null && filePaths.size() > 0) {
                paths = filePaths.toArray(new FilePath[filePaths.size()]);
            }
            ramZip = new RAMZip(mode, verbose, new File(zipPath), paths);
        }
        return ramZip;
    }

    public RAMZip(int mode, boolean verbose, File zipFile, FilePath[] filePaths) {
        this.setMode(mode);
        this.setVerbose(verbose);
        this.setFileZip(zipFile);
        this.setFilePaths(filePaths);
    }

    private void processZip() throws IOException {
        switch (this.getMode()) {
            case 1: {
                this.createZip();
                break;
            }
            case 2: {
                this.listZip();
                break;
            }
            case 3: {
                this.extractZip();
                break;
            }
            default: {
                RAMZip.displayUsage();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void extractZip() throws ZipException, IOException {
        block10: {
            zipFile = new ZipFile(this.fileZip);
            entries = zipFile.entries();
            if (entries == null) break block10;
            targetFolderPath = "";
            if (this.getFilePaths() != null && this.getFilePaths().length > 0) {
                targetFolderPath = this.getFilePaths()[0].getParentPath();
            }
            if ((targetFolder = new File(targetFolderPath).getAbsoluteFile()).exists() || targetFolder.mkdirs()) ** GOTO lbl34
            throw new IllegalStateException(String.valueOf(RAMZip.getNLString("zip.tool.error.create.target")) + targetFolder.getAbsolutePath());
lbl-1000:
            // 1 sources

            {
                entry = (ZipEntry)entries.nextElement();
                if (this.isVerbose()) {
                    System.out.println(this.getEntryDisplayLine(entry));
                }
                child = new File(targetFolder, entry.getName());
                if (entry.isDirectory()) {
                    child.mkdirs();
                    continue;
                }
                childParent = child.getParentFile();
                if (!childParent.exists() && !childParent.mkdirs()) {
                    throw new IllegalStateException(String.valueOf(RAMZip.getNLString("zip.tool.error.extract")) + childParent.getAbsolutePath());
                }
                if (!child.createNewFile()) {
                    throw new IllegalStateException(String.valueOf(RAMZip.getNLString("zip.tool.error.create.file")) + child.getAbsolutePath());
                }
                is = zipFile.getInputStream(entry);
                fos = new FileOutputStream(child);
                try {
                    data = new byte[8192];
                    while ((read = is.read(data)) > -1) {
                        fos.write(data, 0, read);
                    }
                    continue;
                }
                finally {
                    is.close();
                    fos.close();
                }
lbl34:
                // 3 sources

                ** while (entries.hasMoreElements())
            }
        }
    }

    private String getEntryDisplayLine(ZipEntry entry) {
        return String.valueOf(entry.getName()) + " [ " + entry.getSize() + " > " + entry.getCompressedSize() + " ] CRC=" + entry.getCrc();
    }

    private void listZip() throws ZipException, IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.fileZip);
            Enumeration entries = zipFile.entries();
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)entries.nextElement();
                    System.out.println(this.getEntryDisplayLine(entry));
                }
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void createZip() throws IOException {
        FileOutputStream fileOS = new FileOutputStream(this.getFileZip(), false);
        ZipOutputStream zos = new ZipOutputStream(fileOS);
        try {
            FilePath[] paths = this.getFilePaths();
            if (paths != null) {
                int pathCount = 0;
                while (pathCount < paths.length) {
                    String parentPath = paths[pathCount].getParentPath();
                    String childPath = paths[pathCount].getChildPath();
                    File parentFolder = parentPath != null ? new File(parentPath) : new File(".");
                    File childlFile = new File(childPath);
                    if (!childlFile.isAbsolute()) {
                        childlFile = new File(parentFolder, childPath);
                    }
                    this.addZipFile(zos, parentFolder, childlFile, true);
                    ++pathCount;
                }
            }
        }
        finally {
            try {
                zos.finish();
            }
            finally {
                zos.close();
            }
        }
    }

    private void addZipFile(ZipOutputStream zos, File parentFolder, File childlFile, boolean includeChildren) throws IOException {
        block15: {
            if (childlFile != null && !childlFile.equals(parentFolder)) {
                this.addZipFile(zos, parentFolder, childlFile.getParentFile(), false);
                String path = this.determineRelativePath(parentFolder, childlFile);
                if (!path.endsWith("/") && childlFile.isDirectory()) {
                    path = String.valueOf(path) + "/";
                }
                if (childlFile.isFile()) {
                    ZipEntry entry = new ZipEntry(path);
                    entry.setTime(childlFile.lastModified());
                    zos.putNextEntry(entry);
                    try {
                        FileInputStream childFileIs = new FileInputStream(childlFile);
                        try {
                            int read;
                            byte[] data = new byte[8192];
                            while ((read = childFileIs.read(data)) > -1) {
                                zos.write(data, 0, read);
                            }
                            break block15;
                        }
                        finally {
                            childFileIs.close();
                        }
                    }
                    finally {
                        zos.closeEntry();
                        zos.flush();
                        if (this.isVerbose()) {
                            System.out.println(this.getEntryDisplayLine(entry));
                        }
                    }
                }
                if (includeChildren) {
                    File[] grandChildren;
                    ZipEntry entry = new ZipEntry(path);
                    zos.putNextEntry(entry);
                    zos.closeEntry();
                    zos.flush();
                    if (this.isVerbose()) {
                        System.out.println(this.getEntryDisplayLine(entry));
                    }
                    if ((grandChildren = childlFile.listFiles()) != null) {
                        int gcc = 0;
                        while (gcc < grandChildren.length) {
                            this.addZipFile(zos, parentFolder, grandChildren[gcc], true);
                            ++gcc;
                        }
                    }
                }
            }
        }
    }

    private String determineRelativePath(File parentFolder, File childlFile) {
        String path = null;
        if (childlFile == null) {
            return "";
        }
        if (parentFolder.equals(childlFile)) {
            path = "";
        } else {
            String relativePath = this.determineRelativePath(parentFolder, childlFile.getParentFile());
            path = childlFile.getName() != null && childlFile.getName().length() > 0 ? (relativePath != null && relativePath.length() > 0 ? String.valueOf(relativePath) + "/" + childlFile.getName() : childlFile.getName()) : "";
        }
        return path;
    }

    private static void displayUsage() {
        String NL = System.getProperty("line.separator");
        if (NL == null) {
            NL = "\r\n";
        }
        StringBuffer usage = new StringBuffer();
        usage.append(String.valueOf(MessageFormat.format(RAMZip.getNLString("zip.tool.name.version"), String.valueOf(VERSION))) + NL);
        usage.append(String.valueOf(RAMZip.getNLString("zip.tool.usage")) + "RAMZip [-v] {-c -t -x} [" + RAMZip.getNLString("zip.tool.filename") + "].zip [-C " + RAMZip.getNLString("zip.tool.folder") + "] " + RAMZip.getNLString("zip.tool.22") + NL);
        usage.append(String.valueOf(RAMZip.getNLString("zip.tool.options")) + NL);
        usage.append(String.valueOf(MessageFormat.format(RAMZip.getNLString("zip.tool.verbose.output"), ARG_VERBOSE)) + NL);
        usage.append(String.valueOf(MessageFormat.format(RAMZip.getNLString("zip.tool.create.zip"), ARG_CREATE)) + NL);
        usage.append(String.valueOf(MessageFormat.format(RAMZip.getNLString("zip.tool.list.contents"), ARG_LIST)) + NL);
        usage.append(String.valueOf(MessageFormat.format(RAMZip.getNLString("zip.tool.extract.all"), ARG_EXTRACT)) + NL);
        usage.append(String.valueOf(MessageFormat.format(RAMZip.getNLString("zip.tool.parent.folder"), ARG_PARENT_FOLDER)) + NL);
        System.err.println(usage.toString());
        System.exit(-1);
    }

    private FilePath[] getFilePaths() {
        return this.filePaths;
    }

    private void setFilePaths(FilePath[] filePaths) {
        this.filePaths = filePaths;
    }

    private File getFileZip() {
        return this.fileZip;
    }

    private void setFileZip(File fileZip) {
        this.fileZip = fileZip;
    }

    private int getMode() {
        return this.mode;
    }

    private void setMode(int mode) {
        this.mode = mode;
    }

    private boolean isVerbose() {
        return this.verbose;
    }

    private void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private static class FilePath {
        private String parentPath = null;
        private String childPath = null;

        public FilePath(String parentPath, String childPath) {
            this.parentPath = parentPath;
            this.childPath = childPath;
        }

        public String getChildPath() {
            return this.childPath;
        }

        public String getParentPath() {
            return this.parentPath;
        }

        public String toString() {
            return "parentPath=" + this.parentPath + ", childPath=" + this.childPath;
        }
    }
}

