/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.emf.ArtifactConstraint;
import com.ibm.ram.common.emf.ArtifactGrouping;
import com.ibm.ram.common.emf.Attribute;
import com.ibm.ram.common.emf.Attribute751Grouping;
import com.ibm.ram.common.emf.AttributeConstraint;
import com.ibm.ram.common.emf.AttributeGrouping;
import com.ibm.ram.common.emf.CategoryGrouping;
import com.ibm.ram.common.emf.ConstraintGrouping;
import com.ibm.ram.common.emf.NamespaceMapping;
import com.ibm.ram.common.emf.RelationshipConstraint;
import com.ibm.ram.common.emf.RelationshipGrouping;
import com.ibm.ram.common.emf.XMLArtifactCategoryConstraint;
import com.ibm.ram.common.emf.XMLArtifactConstraintGrouping;
import com.ibm.ram.common.util.ArtifactAccessor;
import com.ibm.ram.common.util.ArtifactConstraintValidationError;
import com.ibm.ram.common.util.AttributeConstants;
import com.ibm.ram.common.util.CategorizationConstraintValidationError;
import com.ibm.ram.common.util.CategoryConflictConstraint;
import com.ibm.ram.common.util.CategoryConstraint;
import com.ibm.ram.common.util.CustomAttributeValidationError;
import com.ibm.ram.common.util.FieldValidationError;
import com.ibm.ram.common.util.InputStreamInformation;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.common.util.ManifestBuilder;
import com.ibm.ram.common.util.RelationshipConstraintValidationError;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.NodeDescriptor;
import com.ibm.ram.defaultprofile.Reference;
import com.ibm.ram.defaultprofile.RelatedAsset;
import com.ibm.ram.defaultprofile.Solution;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.common.data.XMLArtifactAttributeConstraint;
import com.ibm.ram.internal.common.util.RAMDateFormat;
import com.ibm.ram.internal.common.util.Utilities;
import com.ibm.ram.internal.common.util.XMLUtility;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class ValidationManager {
    public static final int MAX_XML_PARSE_FILE_SIZE = 0x200000;
    private static final String NOT_SET = "*****NOT SET******";
    public static final String ARTIFACT_CONSTRAINTS_ERRORS = "artifact_constraints_errors";
    public static final String CUSTOM_ATTRIBUTES_ERRORS = "custom_attributes_errors";
    public static final String RELATIONSHIP_CONSTRAINTS_ERRORS = "relationship_constraints_errors";
    public static final String FIELD_ERRORS = "field_errors";
    public static final String CATEGORIZATION_ERRORS = "categorization_errors";
    private static final String ANY_ERRORS_FLAG = "any_errors_boolean_flag";
    private static final String ANY_BLOCKERS_FLAG = "any_blockers_boolean_flag";
    public static final char[] RESTRICTED_CHARACTERS = new char[]{'#', '%', '+', '/', '*'};
    private static String RESTRICTED_CHARACTERS_FOR_MESSAGEFORMAT = "'#' '%' '+' '/' '*'";
    public static final Pattern RESTRICTED_PATTERN = Pattern.compile(".*\\\\$");
    private ManifestBuilder manifestBuilder;
    private String assetType = "*****NOT SET******";
    private CommunityInformation currentCommunity;
    private List<ArtifactConstraint> artifactConstraints;
    private List<XMLArtifactCategoryConstraint> fXMLArtifactCategoryConstaints;
    private List<ManifestBuilder.CustomAttributeUpdate> fXMLArtifactBoundAttributes = new ArrayList<ManifestBuilder.CustomAttributeUpdate>();
    private List<XMLArtifactAttributeConstraint> fXMLArtifactBoundAttributesConstaints = new ArrayList<XMLArtifactAttributeConstraint>();
    private List<AttributeConstraint> customAttributes;
    private List<Attribute> fValidAttributes;
    private List<RelationshipConstraint> relationshipContraints;
    private Map<String, AttributeConstraint> requiredAttributes;
    private boolean isRelationshipConstraintsOnlyThese = false;
    private Set<String> extraRelationships = new HashSet<String>();
    private boolean inValidation;
    private FieldValidationError assetTypeError;
    private static final String[][] ARTIFACT_ERRORS = new String[][]{{"validation.format.exactly", "validation.format.atleast", "validation.format.upto"}, {"validation.label.exactly", "validation.label.atleast", "validation.label.upto"}, {"validation.ext.exactly", "validation.ext.atleast", "validation.ext.upto"}, {"validation.fn.exactly", "validation.fn.atleast", "validation.fn.upto"}};

    public static boolean isAnyErrors(Map<String, Object> validationMap) {
        return validationMap.containsKey(ANY_ERRORS_FLAG) && (Boolean)validationMap.get(ANY_ERRORS_FLAG) != false;
    }

    public static boolean isAnyBlockers(Map<String, Object> validationMap) {
        return validationMap.containsKey(ANY_BLOCKERS_FLAG) && (Boolean)validationMap.get(ANY_BLOCKERS_FLAG) != false;
    }

    protected ManifestBuilder getBuilder() {
        return this.manifestBuilder;
    }

    protected abstract ArtifactAccessor getArtifactAccessor();

    protected List<Attribute> getAttributes(String[] uris) {
        return Collections.emptyList();
    }

    protected void unsetAssetType() {
        this.assetType = NOT_SET;
    }

    public Map<String, Object> validateBlockerOnly() {
        return this.validate(true);
    }

    public final Map<String, Object> validate() {
        return this.validate(false);
    }

    protected final Map<String, Object> validate(boolean blockerOnly) {
        if (this.inValidation) {
            return Collections.emptyMap();
        }
        this.inValidation = true;
        try {
            this.initialize();
            HashMap<String, Object> result = new HashMap<String, Object>(5);
            ValidateErrorFlags valErrorFlags = new ValidateErrorFlags();
            ArtifactConstraintValidationError[] validateArtifactConstraints = this.validateArtifactConstraints(blockerOnly);
            valErrorFlags.markError(validateArtifactConstraints.length > 0);
            if (!valErrorFlags.isAnyBlockers() && validateArtifactConstraints.length > 0) {
                int i = 0;
                while (!valErrorFlags.isAnyBlockers() && i < validateArtifactConstraints.length) {
                    valErrorFlags.markBlocker(validateArtifactConstraints[i].isBlocker());
                    ++i;
                }
            }
            result.put(ARTIFACT_CONSTRAINTS_ERRORS, validateArtifactConstraints);
            CustomAttributeValidationError[] validateCustomAttributes = this.validateCustomAttributes(blockerOnly);
            valErrorFlags.markError(validateCustomAttributes.length > 0);
            if (!valErrorFlags.isAnyBlockers() && validateCustomAttributes.length > 0) {
                int i = 0;
                while (!valErrorFlags.isAnyBlockers() && i < validateCustomAttributes.length) {
                    valErrorFlags.markBlocker(validateCustomAttributes[i].isBlocker());
                    ++i;
                }
            }
            result.put(CUSTOM_ATTRIBUTES_ERRORS, validateCustomAttributes);
            RelationshipConstraintValidationError[] validateRelationshipConstraints = this.validateRelationshipConstraints(blockerOnly);
            valErrorFlags.markError(validateRelationshipConstraints.length > 0);
            if (!valErrorFlags.isAnyBlockers() && validateRelationshipConstraints.length > 0) {
                int i = 0;
                while (!valErrorFlags.isAnyBlockers() && i < validateRelationshipConstraints.length) {
                    valErrorFlags.markBlocker(validateRelationshipConstraints[i].isBlocker());
                    ++i;
                }
            }
            result.put(RELATIONSHIP_CONSTRAINTS_ERRORS, validateRelationshipConstraints);
            FieldValidationError[] fieldValidationErrors = this.validateFields(blockerOnly);
            valErrorFlags.markError(fieldValidationErrors.length > 0);
            if (!valErrorFlags.isAnyBlockers() && fieldValidationErrors.length > 0) {
                int i = 0;
                while (!valErrorFlags.isAnyBlockers() && i < fieldValidationErrors.length) {
                    valErrorFlags.markBlocker(fieldValidationErrors[i].isBlocker());
                    ++i;
                }
            }
            result.put(FIELD_ERRORS, fieldValidationErrors);
            CategorizationConstraintValidationError[] categoryValidationErrors = this.validateCategorizationConstraints(blockerOnly);
            valErrorFlags.markError(categoryValidationErrors.length > 0);
            if (!valErrorFlags.isAnyBlockers() && categoryValidationErrors.length > 0) {
                int i = 0;
                while (!valErrorFlags.isAnyBlockers() && i < categoryValidationErrors.length) {
                    valErrorFlags.markBlocker(categoryValidationErrors[i].isBlocker());
                    ++i;
                }
            }
            result.put(CATEGORIZATION_ERRORS, categoryValidationErrors);
            this.doValidate(blockerOnly, result, valErrorFlags);
            result.put(ANY_ERRORS_FLAG, valErrorFlags.isAnyErrors());
            result.put(ANY_BLOCKERS_FLAG, valErrorFlags.isAnyBlockers());
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            this.inValidation = false;
        }
    }

    protected void doValidate(boolean blockerOnly, Map<String, Object> errors, ValidateErrorFlags errorFlags) {
    }

    protected abstract Collection<URI> getAllCategoryURIs();

    void setBuilder(ManifestBuilder builder) {
        this.manifestBuilder = builder;
    }

    /*
     * WARNING - void declaration
     */
    void initialize() {
        void var10_16;
        boolean allClassifications;
        URI assetTypeURI;
        String currentType;
        boolean communityChanged = false;
        CommunityInformation community = this.getCommunity();
        if (community != null) {
            communityChanged = this.currentCommunity == null || community.getId() != this.currentCommunity.getId();
        } else {
            boolean bl = communityChanged = this.currentCommunity != null;
        }
        if (communityChanged) {
            this.setCommunity(community);
            this.currentCommunity = community;
        }
        String string = currentType = (assetTypeURI = this.getBuilder().getAssetTypeURI()) != null ? assetTypeURI.toString() : NOT_SET;
        if (UtilitiesCommon.objectsEqual(this.assetType, currentType)) {
            return;
        }
        this.assetTypeError = this.setAssetType(currentType);
        this.assetType = currentType;
        this.requiredAttributes = Collections.emptyMap();
        this.artifactConstraints = null;
        this.customAttributes = null;
        this.fValidAttributes = null;
        this.relationshipContraints = null;
        this.fXMLArtifactCategoryConstaints = null;
        List categories = null;
        if (currentType != null) {
            List<ConstraintGrouping> groupings = this.getAssetTypeGroupings();
            for (ConstraintGrouping cg : groupings) {
                if (cg instanceof ArtifactGrouping) {
                    this.artifactConstraints = ((ArtifactGrouping)cg).getConstraints();
                    continue;
                }
                if (cg instanceof AttributeGrouping) {
                    this.customAttributes = ((AttributeGrouping)cg).getConstraints();
                    continue;
                }
                if (cg instanceof Attribute751Grouping) {
                    Attribute751Grouping grouping = (Attribute751Grouping)cg;
                    this.customAttributes = new ArrayList<AttributeConstraint>();
                    for (AttributeConstraint attributeConstraint : grouping.getConstraintsIterator(false)) {
                        this.customAttributes.add(attributeConstraint);
                    }
                    continue;
                }
                if (cg instanceof RelationshipGrouping) {
                    this.relationshipContraints = ((RelationshipGrouping)cg).getConstraints();
                    this.isRelationshipConstraintsOnlyThese = ((RelationshipGrouping)cg).isOnlyThese();
                    continue;
                }
                if (cg instanceof CategoryGrouping) {
                    categories = ((CategoryGrouping)cg).getClassificationSchemaURIs();
                    continue;
                }
                if (!(cg instanceof XMLArtifactConstraintGrouping)) continue;
                this.fXMLArtifactCategoryConstaints = ((XMLArtifactConstraintGrouping)cg).getConstraints();
            }
        }
        ResourceSet rset = this.getBuilder().getManifestResourceSet();
        List<URI> allValidCategories = Collections.emptyList();
        if (categories != null) {
            allClassifications = false;
            if (!categories.isEmpty()) {
                allValidCategories = new ArrayList(categories.size());
                for (String schema : categories) {
                    if (schema.indexOf(35) == -1) {
                        schema = String.valueOf(schema) + "#/";
                    }
                    allValidCategories.add(com.ibm.ram.defaultprofile.util.Utilities.createClassificationSchemaURI(schema, rset));
                }
            }
        } else {
            allClassifications = true;
        }
        List<String> allValidCustomAttributes = Collections.emptyList();
        Map map = Collections.emptyMap();
        if (this.customAttributes != null) {
            this.requiredAttributes = new HashMap<String, AttributeConstraint>(this.customAttributes.size());
            HashMap<String, EList> hashMap = new HashMap<String, EList>(this.customAttributes.size());
            allValidCustomAttributes = new ArrayList<String>(this.customAttributes.size());
            for (AttributeConstraint constraint : this.customAttributes) {
                String uri = com.ibm.ram.defaultprofile.util.Utilities.createClassificationSchemaURIString(constraint.getAttributeName(), rset);
                allValidCustomAttributes.add(uri);
                if (constraint.isRequired()) {
                    this.requiredAttributes.put(uri, constraint);
                }
                if (constraint.getAuthorizedUpdateUserIds().isEmpty()) continue;
                hashMap.put(uri, constraint.getAuthorizedUpdateUserIds());
            }
        }
        this.initialized();
        if (allClassifications) {
            allValidCategories = this.getAllCategoryURIs();
        }
        this.getBuilder().validationManagerReinit(allValidCategories, allClassifications, allValidCustomAttributes, this.requiredAttributes.keySet(), (Map<String, List<String>>)var10_16);
    }

    protected void initialized() {
    }

    protected List<ConstraintGrouping> getAssetTypeGroupings(String assetTypeURI) {
        return Collections.emptyList();
    }

    protected abstract FieldValidationError setAssetType(String var1);

    protected CommunityInformation getCommunity() {
        return this.getBuilder().getCommunity();
    }

    protected abstract FieldValidationError setCommunity(CommunityInformation var1);

    protected abstract List<ConstraintGrouping> getAssetTypeGroupings();

    private boolean isCommunityEqual(CommunityInformation o1, CommunityInformation o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null && o2 != null) {
            return o1.getId() == o2.getId();
        }
        return false;
    }

    private void validateCommunity(List<FieldValidationError> fieldErrors, CommunityInformation community) {
        if (community == null) {
            fieldErrors.add(new FieldValidationError(3, CommonMessages.getString("validation.community.required"), true, true));
        } else {
            switch (this.getBuilder().getUpdateType()) {
                case 1: 
                case 2: 
                case 3: {
                    if (this.isValidCommunity(this.getValidSubmitCommunities(), community)) break;
                    fieldErrors.add(new FieldValidationError(3, CommonMessages.getString("validation.community.invalid"), false, true));
                    break;
                }
                case 0: {
                    if (this.isCommunityEqual(community, this.getBuilder().getOriginalCommunity()) || this.isValidCommunity(this.getValidSubmitCommunities(), community)) break;
                    fieldErrors.add(new FieldValidationError(3, CommonMessages.getString("validation.community.invalid"), false, true));
                }
            }
        }
    }

    private boolean isValidCommunity(List<? extends CommunityInformation> communities, CommunityInformation current) {
        if (communities == null) {
            return true;
        }
        for (CommunityInformation communityInformation : communities) {
            if (!this.isCommunityEqual(current, communityInformation)) continue;
            return true;
        }
        return false;
    }

    private void validateAssetType(List<FieldValidationError> fieldErrors, String assetTypeURL) {
        if (assetTypeURL == NOT_SET) {
            return;
        }
        switch (this.getBuilder().getUpdateType()) {
            case 1: 
            case 2: 
            case 3: {
                if (this.isValidAssetType(this.getValidAssetTypesForCreate(), assetTypeURL)) break;
                fieldErrors.add(new FieldValidationError(1, CommonMessages.getString("validation.assettype.invalid"), false, true));
                break;
            }
            case 0: {
                if (UtilitiesCommon.objectsEqual(assetTypeURL, this.getBuilder().getOriginalAssetType()) || this.isValidAssetType(this.getValidAssetTypesForCreate(), assetTypeURL)) break;
                fieldErrors.add(new FieldValidationError(1, CommonMessages.getString("validation.assettype.invalid"), false, true));
            }
        }
    }

    private boolean isValidAssetType(List<String> assetTypeURLs, String current) {
        if (assetTypeURLs == null) {
            return true;
        }
        for (String url : assetTypeURLs) {
            if (!UtilitiesCommon.objectsEqual(url, current)) continue;
            return true;
        }
        return false;
    }

    public FieldValidationError[] validateFields() {
        return this.validateFields(false);
    }

    protected FieldValidationError[] validateFields(boolean blockerOnly) {
        String version;
        this.initialize();
        ArrayList<FieldValidationError> fieldErrors = new ArrayList<FieldValidationError>();
        if (this.assetTypeError != null) {
            if (!blockerOnly || this.assetTypeError.isBlocker()) {
                fieldErrors.add(this.assetTypeError);
            }
        } else if (!blockerOnly && this.assetType == NOT_SET) {
            fieldErrors.add(new FieldValidationError(1, CommonMessages.getString("validation.assettype.required"), true));
        }
        this.validateAssetType(fieldErrors, this.assetType);
        ManifestBuilder builder = this.getBuilder();
        CommunityInformation community = builder.getCommunity();
        this.validateCommunity(fieldErrors, community);
        String name = builder.getName();
        if (UtilitiesCommon.isEmptyString(name)) {
            fieldErrors.add(new FieldValidationError(4, CommonMessages.getString("validation.name.required"), true, true));
        }
        String shortDescription = builder.getShortDescription();
        if (!blockerOnly && UtilitiesCommon.isEmptyString(shortDescription)) {
            fieldErrors.add(new FieldValidationError(5, CommonMessages.getString("validation.shortDescription.required"), true));
        }
        if (UtilitiesCommon.isEmptyString(version = builder.getVersion())) {
            fieldErrors.add(new FieldValidationError(2, CommonMessages.getString("validation.version.required"), true, true));
        } else if (this.containsRestrictedCharacter(version)) {
            fieldErrors.add(new FieldValidationError(2, MessageFormat.format(CommonMessages.getString("validation.version.invalidchars"), RESTRICTED_CHARACTERS_FOR_MESSAGEFORMAT), false, true));
        } else if (builder.newVersionRequired && UtilitiesCommon.objectsEqual(version, builder.getOriginalVersion())) {
            fieldErrors.add(new FieldValidationError(2, CommonMessages.getString("validation.version.newversion"), false));
        } else if (builder.newVersionRequired && builder.getAssetVersions().contains(version)) {
            fieldErrors.add(new FieldValidationError(2, CommonMessages.getString("validation.version.versionExists"), false));
        }
        String id = builder.getId();
        if (UtilitiesCommon.isEmptyString(id)) {
            fieldErrors.add(new FieldValidationError(6, CommonMessages.getString("validation.id.required"), true, true));
        } else if (this.containsRestrictedCharacter(id)) {
            fieldErrors.add(new FieldValidationError(6, MessageFormat.format(CommonMessages.getString("validation.id.invalidchars"), RESTRICTED_CHARACTERS_FOR_MESSAGEFORMAT), false, true));
        }
        return fieldErrors.toArray(new FieldValidationError[fieldErrors.size()]);
    }

    private boolean containsRestrictedCharacter(String s) {
        if (RESTRICTED_PATTERN.matcher(s).matches()) {
            return true;
        }
        char[] cArray = RESTRICTED_CHARACTERS;
        int n = RESTRICTED_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (s.indexOf(c) >= 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ArtifactConstraintValidationError[] validateArtifactConstraints() {
        return this.validateArtifactConstraints(false);
    }

    private boolean categoriesAlreadyApplied(XMLArtifactCategoryConstraint constaint) {
        EList cats = constaint.getCategoryURIs();
        DefaultprofileFactory factory = DefaultprofileFactory.eINSTANCE;
        int count = 0;
        int j = 0;
        while (j < cats.size()) {
            String categoryURI = (String)cats.get(j);
            try {
                URI uri = com.ibm.ram.defaultprofile.util.Utilities.createClassificationSchemaURI(categoryURI, this.getBuilder().getManifestResourceSet());
                NodeDescriptor node = factory.createNodeDescriptor();
                InternalEObject eObject = (InternalEObject)node;
                eObject.eSetProxyURI(uri);
                NodeDescriptor resNode = this.getBuilder().resolveDescriptor(node);
                ManifestAccessor.ClassificationInfo ci = this.getBuilder().getClassificationInfo(resNode);
                if (ci == null || !ci.getNodeDescriptors().contains(resNode)) break;
                ++count;
            }
            catch (Exception e) {
                Logger.getLogger((String)ValidationManager.class.getName()).error((Object)("Category Schema " + categoryURI + " not found"), (Throwable)e);
            }
            ++j;
        }
        return count == cats.size();
    }

    private String[] getValidAttributeURIs() {
        if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
            Map<String, ManifestAccessor.CustomAttribute> attrMap = this.manifestBuilder.getCustomAttributes();
            String[] uris = new String[attrMap.size()];
            int i = 0;
            for (ManifestAccessor.CustomAttribute ca : attrMap.values()) {
                if (ca == null) continue;
                uris[i++] = ca.getURIString();
            }
            return uris;
        }
        return new String[0];
    }

    private List<Attribute> getValidAttributes() {
        if (this.fValidAttributes == null) {
            this.fValidAttributes = this.getAttributes(this.getValidAttributeURIs());
        }
        return this.fValidAttributes;
    }

    private void bindXMLArtifactContent(List<Artifact> artifacts, Map<String, SortedSet<String>> newXMLValues) {
        if (artifacts != null && this.fXMLArtifactCategoryConstaints != null && !this.fXMLArtifactCategoryConstaints.isEmpty() || !this.fXMLArtifactBoundAttributes.isEmpty()) {
            int cnt = 0;
            while (cnt < artifacts.size()) {
                Artifact artifact = artifacts.get(cnt);
                this.applyCategoryRules(artifact);
                if (artifact != null) {
                    int i = 0;
                    while (i < this.fXMLArtifactBoundAttributes.size()) {
                        block20: {
                            ManifestBuilder.CustomAttributeUpdate cAttribute = this.fXMLArtifactBoundAttributes.get(i);
                            XMLArtifactAttributeConstraint constraint = this.fXMLArtifactBoundAttributesConstaints.get(i);
                            if (XMLUtility.matchesFileTypes(constraint, artifact)) {
                                InputStreamInformation is = null;
                                try {
                                    try {
                                        if (!ManifestAccessor.isFolder(artifact) && !ManifestAccessor.isURLArtifact(artifact) && (is = this.getArtifactAccessor().getArtifactContentInformation(artifact)) != null && is.isExactSize() && is.getSize() <= 0x200000L) {
                                            Object result = XMLUtility.evaluateXPathExpression(is.getIs(), constraint.getXPath(), constraint.getNamespaceMappingsArray());
                                            boolean match = false;
                                            String path = artifact.computePathInSolution("/");
                                            if (result instanceof List) {
                                                List resultList = (List)result;
                                                int j = 0;
                                                while (!match && j < resultList.size()) {
                                                    Object jthResult = resultList.get(j);
                                                    String jthResultPath = String.valueOf(path) + "#" + XMLUtility.getStringValue(jthResult);
                                                    SortedSet<String> list = newXMLValues.get(cAttribute.getURIString());
                                                    if (list == null) {
                                                        list = new TreeSet<String>(new Comparator<String>(){

                                                            @Override
                                                            public int compare(String o1, String o2) {
                                                                return o1.compareTo(o2);
                                                            }
                                                        });
                                                        newXMLValues.put(cAttribute.getURIString(), list);
                                                    }
                                                    list.add(jthResultPath);
                                                    ++j;
                                                }
                                            } else {
                                                String valuePath = String.valueOf(path) + "#" + XMLUtility.getStringValue(result);
                                                SortedSet<String> list = newXMLValues.get(cAttribute.getURIString());
                                                if (list == null) {
                                                    list = new TreeSet<String>(new Comparator<String>(){

                                                        @Override
                                                        public int compare(String o1, String o2) {
                                                            return o1.compareTo(o2);
                                                        }
                                                    });
                                                    newXMLValues.put(cAttribute.getURIString(), list);
                                                }
                                                list.add(valuePath);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        Logger.getLogger(ValidationManager.class).warn((Object)"Error validating XML", (Throwable)e);
                                        if (is != null) {
                                            is.closeIs();
                                            is = null;
                                        }
                                        break block20;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (is != null) {
                                        is.closeIs();
                                        is = null;
                                    }
                                    throw throwable;
                                }
                                if (is != null) {
                                    is.closeIs();
                                    is = null;
                                }
                            }
                        }
                        ++i;
                    }
                }
                ++cnt;
            }
            for (Artifact artifact : artifacts) {
                EList children = artifact.getArtifact();
                if (children.isEmpty()) continue;
                this.bindXMLArtifactContent((List<Artifact>)children, newXMLValues);
            }
        }
    }

    private void initXMLAttributeConstaints() {
        this.fXMLArtifactBoundAttributes.clear();
        this.fXMLArtifactBoundAttributesConstaints.clear();
        List<Attribute> attributes = this.getValidAttributes();
        int i = 0;
        while (i < attributes.size()) {
            String config;
            Attribute attribute = attributes.get(i);
            if (attribute.getAttributeType() == AttributeConstants.Type.xml && !UtilitiesCommon.isEmptyString(config = attribute.getConfiguration())) {
                try {
                    XMLArtifactAttributeConstraint constraint = new XMLArtifactAttributeConstraint(config);
                    URI uri = com.ibm.ram.defaultprofile.util.Utilities.createClassificationSchemaURI(attribute.getUriString(), this.getBuilder().getManifestResourceSet());
                    ManifestBuilder.CustomAttributeUpdate cAttribute = (ManifestBuilder.CustomAttributeUpdate)this.getBuilder().getCustomAttributes().get(uri.toString());
                    if (cAttribute != null && !cAttribute.isRestrictedValues()) {
                        this.fXMLArtifactBoundAttributes.add(cAttribute);
                        this.fXMLArtifactBoundAttributesConstaints.add(constraint);
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    private void applyCategoryRules(Artifact artifact) {
        if (artifact != null && this.fXMLArtifactCategoryConstaints != null) {
            int i = 0;
            while (i < this.fXMLArtifactCategoryConstaints.size()) {
                block17: {
                    XMLArtifactCategoryConstraint constraint = this.fXMLArtifactCategoryConstaints.get(i);
                    if (XMLUtility.matchesFileTypes(constraint, artifact) && !this.categoriesAlreadyApplied(constraint)) {
                        InputStreamInformation isInfo = null;
                        try {
                            try {
                                isInfo = this.getArtifactAccessor().getArtifactContentInformation(artifact);
                                if (isInfo != null && isInfo.isExactSize() && isInfo.getSize() <= 0x200000L) {
                                    NamespaceMapping[] mappings = (NamespaceMapping[])constraint.getNamespaces().toArray((Object[])new NamespaceMapping[constraint.getNamespaces().size()]);
                                    Object result = XMLUtility.evaluateXPathExpression(isInfo.getIs(), constraint.getXpath(), mappings);
                                    Pattern pattern = Pattern.compile(constraint.getXMatchPattern());
                                    boolean match = false;
                                    if (result instanceof List) {
                                        List resultList = (List)result;
                                        int j = 0;
                                        while (!match && j < resultList.size()) {
                                            Object jthResult = resultList.get(j);
                                            String jthString = XMLUtility.getStringValue(jthResult);
                                            match = pattern.matcher(jthString).find();
                                            ++j;
                                        }
                                    } else {
                                        String resultValue = XMLUtility.getStringValue(result);
                                        match = pattern.matcher(resultValue).find();
                                    }
                                    if (match) {
                                        EList cats = constraint.getCategoryURIs();
                                        DefaultprofileFactory factory = DefaultprofileFactory.eINSTANCE;
                                        int j = 0;
                                        while (j < cats.size()) {
                                            String categoryURI = (String)cats.get(j);
                                            URI uri = com.ibm.ram.defaultprofile.util.Utilities.createClassificationSchemaURI(categoryURI, this.getBuilder().getManifestResourceSet());
                                            NodeDescriptor node = factory.createNodeDescriptor();
                                            InternalEObject eObject = (InternalEObject)node;
                                            eObject.eSetProxyURI(uri);
                                            this.getBuilder().addNodeDescriptorToManifest(node);
                                            ++j;
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                Logger.getLogger(ValidationManager.class).error((Object)"Error validating XML", (Throwable)ex);
                                if (isInfo != null) {
                                    isInfo.closeIs();
                                    isInfo = null;
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            if (isInfo != null) {
                                isInfo.closeIs();
                                isInfo = null;
                            }
                            throw throwable;
                        }
                        if (isInfo != null) {
                            isInfo.closeIs();
                            isInfo = null;
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected ArtifactConstraintValidationError[] validateArtifactConstraints(boolean blockerOnly) {
        ArrayList<ArtifactConstraintValidationError> errors;
        block17: {
            if (blockerOnly) {
                return new ArtifactConstraintValidationError[0];
            }
            this.initialize();
            errors = new ArrayList<ArtifactConstraintValidationError>();
            ArtifactConstraint lastConstratint = this.artifactConstraints != null && !this.artifactConstraints.isEmpty() ? this.artifactConstraints.get(0) : null;
            try {
                Solution sol = this.getBuilder().getSolution();
                if (sol != null) {
                    EList details = sol.getArtifact();
                    this.initXMLAttributeConstaints();
                    HashMap<String, SortedSet<String>> newXMLValues = new HashMap<String, SortedSet<String>>();
                    this.bindXMLArtifactContent((List<Artifact>)details, newXMLValues);
                    for (ManifestBuilder.CustomAttributeUpdate update : this.fXMLArtifactBoundAttributes) {
                        if (newXMLValues.containsKey(update.getURIString())) continue;
                        update.getUnrestrictedAttributeValues().clear();
                    }
                    block8: for (ManifestBuilder.CustomAttributeUpdate update : this.fXMLArtifactBoundAttributes) {
                        SortedSet<String> newValues = newXMLValues.get(update.getURIString());
                        List<String> existingValues = update.getUnrestrictedAttributeValues();
                        if (newValues == null || existingValues.size() != newValues.size()) {
                            existingValues.clear();
                            if (newValues == null) continue;
                            existingValues.addAll(newValues);
                            continue;
                        }
                        for (String string : existingValues) {
                            if (newValues.contains(string)) continue;
                            existingValues.clear();
                            existingValues.addAll(newValues);
                            continue block8;
                        }
                    }
                }
                if (this.artifactConstraints != null && !this.artifactConstraints.isEmpty()) {
                    ArrayList<ArtifactConstraintValidationError> initialErrs = new ArrayList<ArtifactConstraintValidationError>(this.artifactConstraints.size());
                    for (ArtifactConstraint artConst : this.artifactConstraints) {
                        initialErrs.add(new ArtifactConstraintValidationError(artConst));
                    }
                    if (sol != null) {
                        EList details = sol.getArtifact();
                        this.validateArtifactConstraints(initialErrs, (List<Artifact>)details);
                    }
                    for (ArtifactConstraintValidationError constraintError : initialErrs) {
                        ArtifactConstraint constraint;
                        lastConstratint = constraint = constraintError.getConstraint();
                        switch (constraint.getCountType().getValue()) {
                            case 0: {
                                if (constraint.getCount() == constraintError.totalCount) break;
                                constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString(ARTIFACT_ERRORS[constraint.getMatchType().getValue()][0]), new Integer(constraint.getCount()), constraint.getType()));
                                errors.add(constraintError);
                                break;
                            }
                            case 2: {
                                if (constraintError.totalCount <= constraint.getCount()) break;
                                constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString(ARTIFACT_ERRORS[constraint.getMatchType().getValue()][2]), new Integer(constraint.getCount()), constraint.getType()));
                                errors.add(constraintError);
                                break;
                            }
                            case 1: {
                                if (constraintError.totalCount >= constraint.getCount()) break;
                                constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString(ARTIFACT_ERRORS[constraint.getMatchType().getValue()][1]), new Integer(constraint.getCount()), constraint.getType()));
                                errors.add(constraintError);
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (lastConstratint == null) break block17;
                ArtifactConstraintValidationError error = new ArtifactConstraintValidationError(lastConstratint);
                error.setErrorMessage(ex.getLocalizedMessage());
                errors.add(error);
            }
        }
        return errors.toArray(new ArtifactConstraintValidationError[errors.size()]);
    }

    private void validateArtifactConstraints(List<ArtifactConstraintValidationError> constraints, List<Artifact> artifacts) {
        if (!artifacts.isEmpty()) {
            for (Artifact artifact : artifacts) {
                if (artifact == null) continue;
                if (!ManifestAccessor.isFolder(artifact)) {
                    block7: for (ArtifactConstraintValidationError constraintError : constraints) {
                        ArtifactConstraint constraint = constraintError.getConstraint();
                        String constraintType = constraint.getType();
                        if (constraintType.length() == 0) continue;
                        switch (constraint.getMatchType().getValue()) {
                            case 0: {
                                if (!constraintType.equals(this.getBuilder().getFormat(artifact))) break;
                                ++constraintError.totalCount;
                                break;
                            }
                            case 1: {
                                if (!constraintType.equals(this.getBuilder().getLabel(artifact))) break;
                                ++constraintError.totalCount;
                                break;
                            }
                            case 2: {
                                int periodIndex;
                                String extName = artifact.getName();
                                if (extName == null) {
                                    Reference ref = artifact.getReference();
                                    if (ref == null || ref.getValue() == null) continue block7;
                                    extName = ref.getValue();
                                }
                                if (!constraintType.equalsIgnoreCase(extName = (periodIndex = extName.lastIndexOf(46)) != -1 ? extName.substring(periodIndex + 1) : "")) break;
                                ++constraintError.totalCount;
                                break;
                            }
                            case 3: {
                                String fname = artifact.getName();
                                if (fname == null) {
                                    Reference ref = artifact.getReference();
                                    if (ref == null || ref.getValue() == null) continue block7;
                                    fname = ref.getValue();
                                }
                                if (!constraintType.endsWith(fname)) break;
                                StringBuffer fullname = new StringBuffer(fname);
                                EObject artifactParent = artifact.eContainer();
                                while (artifactParent != null && artifactParent instanceof Artifact) {
                                    fullname.insert(0, '/');
                                    Artifact parent = (Artifact)artifactParent;
                                    fname = parent.getName();
                                    if (fname == null) {
                                        Reference ref = parent.getReference();
                                        if (ref == null || ref.getValue() == null) continue;
                                        fname = ref.getValue();
                                    }
                                    fullname.insert(0, fname);
                                    artifactParent = parent.eContainer();
                                }
                                if (!constraintType.equals(fullname.toString())) break;
                                ++constraintError.totalCount;
                                break;
                            }
                        }
                    }
                    continue;
                }
                this.validateArtifactConstraints(constraints, (List<Artifact>)artifact.getArtifact());
            }
        }
    }

    public CustomAttributeValidationError[] validateCustomAttributes() {
        return this.validateCustomAttributes(false);
    }

    protected CustomAttributeValidationError[] validateCustomAttributes(boolean blockerOnly) {
        if (blockerOnly) {
            return new CustomAttributeValidationError[0];
        }
        this.initialize();
        ArrayList<CustomAttributeValidationError> errors = new ArrayList<CustomAttributeValidationError>();
        if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
            Map<String, ManifestAccessor.CustomAttribute> attrMap = this.getBuilder().getCustomAttributes();
            block7: for (Attribute attr : this.getValidAttributes()) {
                String uriString;
                ManifestAccessor.CustomAttribute ca;
                if (attr == null || (ca = attrMap.get(uriString = com.ibm.ram.defaultprofile.util.Utilities.createClassificationSchemaURIString(attr.getUriString(), this.getBuilder().getManifestResourceSet()))) == null) continue;
                if (ca.isAttributeSet()) {
                    if (ca.isRestrictedValues()) continue;
                    Map config = !UtilitiesCommon.isEmptyString(attr.getConfiguration()) ? Utilities.decodeXML(attr.getConfiguration()) : Collections.EMPTY_MAP;
                    String value = ca.getUnrestrictedAttributeValue();
                    switch (attr.getAttributeType()) {
                        case text: {
                            String pattern;
                            if (ca.isRestrictedValues() || UtilitiesCommon.isEmptyString(pattern = (String)config.get("pattern")) || value.matches(pattern)) continue block7;
                            String msg = (String)config.get("pattern error message");
                            if (UtilitiesCommon.isEmptyString(msg)) {
                                msg = MessageFormat.format(CommonMessages.getString("attribute_pattern_error_msg"), new Object[0]);
                            }
                            errors.add(new CustomAttributeValidationError(null, msg, ca.getURIString()));
                            break;
                        }
                        case date: {
                            Object maxDateValue;
                            Date d = AttributeConstants.getDate(value);
                            if (d == null) {
                                errors.add(new CustomAttributeValidationError(null, MessageFormat.format(CommonMessages.getString("validation.customattribute.InvalidDateFormat"), ca.getName(), value), ca.getURIString()));
                                break;
                            }
                            Calendar date = Calendar.getInstance();
                            date.setTime(d);
                            Object minDateValue = config.get("minimum date");
                            d = AttributeConstants.getDate(minDateValue);
                            if (d != null) {
                                Calendar minDate = Calendar.getInstance();
                                minDate.setTime(d);
                                if (date.before(minDate)) {
                                    minDate.add(5, -1);
                                    String dateStr = RAMDateFormat.getDateInstance().format(minDate.getTime());
                                    errors.add(new CustomAttributeValidationError(null, MessageFormat.format(CommonMessages.getString("validation.customattibute.mindate"), ca.getName(), dateStr), ca.getURIString()));
                                }
                            }
                            if ((d = AttributeConstants.getDate(maxDateValue = config.get("maximum date"))) == null) continue block7;
                            Calendar maxDate = Calendar.getInstance();
                            maxDate.setTime(d);
                            if (!date.after(maxDate)) continue block7;
                            maxDate.add(5, 1);
                            String dateStr = RAMDateFormat.getDateInstance().format(maxDate.getTime());
                            errors.add(new CustomAttributeValidationError(null, MessageFormat.format(CommonMessages.getString("validation.customattibute.maxdate"), ca.getName(), dateStr), ca.getURIString()));
                            break;
                        }
                        case number: {
                            try {
                                Double maxValue;
                                Double dbl = new Double(value);
                                Double minValue = (Double)config.get("minimum number");
                                if (minValue != null && dbl.compareTo(minValue) < 0) {
                                    errors.add(new CustomAttributeValidationError(null, MessageFormat.format(CommonMessages.getString("validation.customattibute.minnumber"), ca.getName(), minValue.toString()), ca.getURIString()));
                                }
                                if ((maxValue = (Double)config.get("maximum number")) == null || dbl.compareTo(maxValue) <= 0) continue block7;
                                errors.add(new CustomAttributeValidationError(null, MessageFormat.format(CommonMessages.getString("validation.customattibute.maxnumber"), ca.getName(), maxValue.toString()), ca.getURIString()));
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                errors.add(new CustomAttributeValidationError(null, MessageFormat.format(CommonMessages.getString("validation.customattribute.InvalidNumberFormat"), ca.getName(), value), ca.getURIString()));
                            }
                        }
                    }
                    continue;
                }
                if (!ca.isRequired()) continue;
                errors.add(new CustomAttributeValidationError(this.requiredAttributes.get(ca.getURIString()), MessageFormat.format(CommonMessages.getString("validation.customattibute"), ca.getName()), ca.getURIString()));
            }
        }
        return errors.toArray(new CustomAttributeValidationError[errors.size()]);
    }

    protected abstract String getAssetTypeURIString(String var1, String var2);

    protected abstract String getAssetTypeName(String var1);

    protected abstract String getRelationshipDisplayName(String var1);

    public RelationshipConstraintValidationError[] validateRelationshipConstraints() {
        return this.validateRelationshipConstraints(false);
    }

    protected RelationshipConstraintValidationError[] validateRelationshipConstraints(boolean blockerOnly) {
        if (blockerOnly) {
            return new RelationshipConstraintValidationError[0];
        }
        this.initialize();
        ArrayList<RelationshipConstraintValidationError> errors = new ArrayList<RelationshipConstraintValidationError>();
        if (this.relationshipContraints != null && !this.relationshipContraints.isEmpty()) {
            ResourceSet rset = this.getBuilder().getManifestResourceSet();
            ArrayList<RelationshipConstraintValidationError> initialErrs = new ArrayList<RelationshipConstraintValidationError>(this.relationshipContraints.size());
            for (RelationshipConstraint constraint : this.relationshipContraints) {
                initialErrs.add(new RelationshipConstraintValidationError(constraint, com.ibm.ram.defaultprofile.util.Utilities.createClassificationSchemaURIString(constraint.getRequiredAssetType(), rset)));
            }
            List<RelatedAsset> relatedAssets = this.manifestBuilder.getRelatedAssets();
            if (relatedAssets.size() > 0) {
                for (RelatedAsset ra : relatedAssets) {
                    boolean notMatchFlag = Boolean.TRUE;
                    for (RelationshipConstraintValidationError constraintError : initialErrs) {
                        RelationshipConstraint constraint = constraintError.getConstraint();
                        if (!constraint.getRelationship().equals(ra.getRelationshipType())) continue;
                        notMatchFlag = Boolean.FALSE;
                        if (constraint.getRequiredAssetType() != null) {
                            if (!constraintError.getConstraintAssetTypeURI().equals(this.getAssetTypeURIString(ra.getAssetId(), ra.getAssetVersion()))) continue;
                            ++constraintError.totalCount;
                            continue;
                        }
                        ++constraintError.totalCount;
                    }
                    if (!notMatchFlag || !this.isRelationshipConstraintsOnlyThese) continue;
                    this.extraRelationships.add(ra.getRelationshipType());
                }
            }
            String rqdAssetType = null;
            for (RelationshipConstraintValidationError constraintError : initialErrs) {
                RelationshipConstraint constraint = constraintError.getConstraint();
                if (constraint.getRequiredAssetType() != null) {
                    rqdAssetType = this.getAssetTypeName(constraintError.getConstraintAssetTypeURI());
                    if (rqdAssetType.length() == 0) {
                        rqdAssetType = null;
                    }
                } else {
                    rqdAssetType = null;
                }
                switch (constraint.getCountType().getValue()) {
                    case 0: {
                        if (constraint.getCount() == constraintError.totalCount) break;
                        if (rqdAssetType == null) {
                            constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString("validation.related.exactly"), new Integer(constraint.getCount()), this.getRelationshipDisplayName(constraint.getRelationship())));
                        } else {
                            constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString("validation.related.exactly.reqAsset"), new Integer(constraint.getCount()), this.getRelationshipDisplayName(constraint.getRelationship()), rqdAssetType));
                        }
                        errors.add(constraintError);
                        break;
                    }
                    case 2: {
                        if (constraintError.totalCount <= constraint.getCount()) break;
                        if (rqdAssetType == null) {
                            constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString("validation.related.upto"), String.valueOf(constraint.getCount()), this.getRelationshipDisplayName(constraint.getRelationship())));
                        } else {
                            constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString("validation.related.upto.reqAsset"), String.valueOf(constraint.getCount()), this.getRelationshipDisplayName(constraint.getRelationship()), rqdAssetType));
                        }
                        errors.add(constraintError);
                        break;
                    }
                    case 1: {
                        if (constraintError.totalCount >= constraint.getCount()) break;
                        if (rqdAssetType == null) {
                            constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString("validation.related.atleast"), String.valueOf(constraint.getCount()), this.getRelationshipDisplayName(constraint.getRelationship())));
                        } else {
                            constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString("validation.related.atleast.reqAsset"), String.valueOf(constraint.getCount()), this.getRelationshipDisplayName(constraint.getRelationship()), rqdAssetType));
                        }
                        errors.add(constraintError);
                        break;
                    }
                }
            }
        }
        if (this.extraRelationships.size() > 0) {
            String[] stringArray = this.extraRelationships.toArray(new String[this.extraRelationships.size()]);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String relationshipStr = stringArray[n2];
                RelationshipConstraintValidationError constraintError = new RelationshipConstraintValidationError();
                constraintError.setErrorMessage(MessageFormat.format(CommonMessages.getString("validation.related.isonlythese"), relationshipStr));
                errors.add(constraintError);
                ++n2;
            }
        }
        this.extraRelationships.clear();
        return errors.toArray(new RelationshipConstraintValidationError[errors.size()]);
    }

    public CategorizationConstraintValidationError[] validateCategorizationConstraints() {
        return this.validateCategorizationConstraints(false);
    }

    protected CategorizationConstraintValidationError[] validateCategorizationConstraints(boolean blockerOnly) {
        this.initialize();
        ArrayList<CategorizationConstraintValidationError> errors = new ArrayList<CategorizationConstraintValidationError>();
        HashMap<NodeDescriptor, NodeDescriptor> parentCategories = new HashMap<NodeDescriptor, NodeDescriptor>();
        ManifestBuilder builder = this.getBuilder();
        Collection<ManifestAccessor.ClassificationInfo> cinfos = builder.getClassificationInfos().values();
        ArrayList<NodeDescriptor> childAddedTo = new ArrayList<NodeDescriptor>();
        try {
            for (ManifestAccessor.ClassificationInfo cinfo : cinfos) {
                if (!cinfo.isSchemaSet()) continue;
                Iterator<NodeDescriptor> iterator = cinfo.getNodeDescriptors().iterator();
                while (iterator.hasNext()) {
                    NodeDescriptor child;
                    NodeDescriptor parent = child = iterator.next();
                    while ((parent = parent.getGeneral()) != null) {
                        if (parentCategories.containsKey(parent)) {
                            if (!parent.isExclusive()) break;
                            NodeDescriptor explicitChild = (NodeDescriptor)parentCategories.get(parent);
                            errors.add(new CategorizationConstraintValidationError(new CategoryConflictConstraint(explicitChild, child, parent), MessageFormat.format(CommonMessages.getString("validation.category.conflict"), child.getName(), explicitChild.getName(), parent.getName()), true));
                            int i = 0;
                            int n = childAddedTo.size();
                            while (i < n) {
                                parentCategories.remove(childAddedTo.get(i));
                                ++i;
                            }
                            break;
                        }
                        parentCategories.put(parent, child);
                        childAddedTo.add(parent);
                    }
                    childAddedTo.clear();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CategoryConstraint constraint = new CategoryConstraint(){};
            String errorMessage = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "npe";
            CategorizationConstraintValidationError error = new CategorizationConstraintValidationError(constraint, "Unknown error while validating categorizations: " + errorMessage, true);
            errors.add(error);
        }
        return errors.toArray(new CategorizationConstraintValidationError[errors.size()]);
    }

    public abstract List<? extends CommunityInformation> getValidSubmitCommunities();

    public abstract List<String> getValidAssetTypesForCreate();

    public static final class ValidateErrorFlags {
        private boolean anyErrors;
        private boolean anyBlockers;

        public boolean isAnyErrors() {
            return this.anyErrors;
        }

        public void markError(boolean error) {
            this.anyErrors |= error;
        }

        public boolean isAnyBlockers() {
            return this.anyBlockers;
        }

        public void markBlocker(boolean blocker) {
            this.anyBlockers |= blocker;
        }
    }
}

