/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageCompressor {
    private static final String RESIZED_IMAGE_FILE_EXTENSION = "jpg";
    private int imageWidth;
    private int imageHeight;
    private byte[] imageBits = null;
    private String imageFileExtention;
    private IOException error;

    public ImageCompressor(InputStream srcImage, String imageFileExtension, int maxWidth, int maxHeight) {
        this.imageFileExtention = imageFileExtension;
        try {
            this.resizeToMinimum(srcImage, imageFileExtension, maxWidth, maxHeight);
        }
        catch (IOException e) {
            this.setError(e);
        }
    }

    private void setError(IOException e) {
        this.error = e;
        this.imageBits = null;
        this.imageHeight = -1;
        this.imageWidth = -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resizeToMinimum(InputStream imageSrcStream, String imageFileExtension, int maxWidth, int maxHeight) throws IOException {
        block25: {
            try {
                imInput = ImageIO.createImageInputStream(imageSrcStream);
                if (imInput == null) throw new IOException("Could not create image source input for the image.");
                imgRdr = null;
                imgWrt = null;
                try {
                    rdrItr = ImageIO.getImageReaders(imInput);
                    if (rdrItr.hasNext() == false) throw new IOException("Could not find a valid processor to read the image. Claimed image type is \"" + imageFileExtension + '\"');
                    imgRdr = rdrItr.next();
                    imgRdr.setInput(imInput);
                    this.imageWidth = imgRdr.getWidth(0);
                    this.imageHeight = imgRdr.getHeight(0);
                    if (this.imageWidth <= maxWidth && this.imageHeight <= maxHeight) ** GOTO lbl69
                    newWidth = this.imageWidth;
                    newHeight = this.imageHeight;
                    if (maxWidth - this.imageWidth < maxHeight - this.imageHeight) {
                        newWidth = maxWidth;
                        newHeight = Math.round((double)this.imageHeight * (double)newWidth / (double)this.imageWidth);
                    } else {
                        newHeight = maxHeight;
                        newWidth = Math.round((double)this.imageWidth * (double)newHeight / (double)this.imageHeight);
                    }
                    nThumbNails = imgRdr.getNumThumbnails(0);
                    if (nThumbNails <= 0) ** GOTO lbl61
                    i = 0;
                    if (true) ** GOTO lbl49
                }
                catch (Throwable var16_15) {
                    if (imgRdr != null) {
                        imgRdr.dispose();
                    }
                    if (imgWrt != null) {
                        imgWrt.dispose();
                    }
                    imInput.close();
                    throw var16_15;
                }
lbl33:
                // 2 sources

                while (true) {
                    imInput.close();
                    break;
                }
            }
            catch (Throwable var17_16) {
                try {
                    imageSrcStream.close();
                    throw var17_16;
                }
                catch (IOException v0) {}
                throw var17_16;
            }
            try {
                imageSrcStream.close();
                return;
            }
            catch (IOException v1) {}
            return;
            {
                block24: {
                    do {
                        ++i;
lbl49:
                        // 2 sources

                        if (i >= nThumbNails) break block24;
                    } while ((long)imgRdr.getThumbnailWidth(0, i) > newWidth || (long)imgRdr.getThumbnailHeight(0, i) > newHeight);
                    imgWrt = ImageIO.getImageWriter(imgRdr);
                    if (imgWrt != null) {
                        this.writeImage(imgWrt, imgRdr.readThumbnail(0, i), imageFileExtension);
                    } else {
                        imgWrt = this.writeDefaultImage(imgRdr.readThumbnail(0, i));
                    }
                    if (imgRdr != null) {
                        imgRdr.dispose();
                    }
                    if (imgWrt == null) ** GOTO lbl33
                    imgWrt.dispose();
                    ** continue;
                }
                newImage = new BufferedImage((int)newWidth, (int)newHeight, 1);
                graphics2D = newImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(imgRdr.read(0), 0, 0, (int)newWidth, (int)newHeight, null);
                imgWrt = this.writeDefaultImage(newImage);
                break block25;
lbl69:
                // 1 sources

                imgWrt = ImageIO.getImageWriter(imgRdr);
                if (imgWrt != null) {
                    this.writeImage(imgWrt, imgRdr.read(0), imageFileExtension);
                    break block25;
                }
                imgWrt = this.writeDefaultImage(imgRdr.read(0));
            }
        }
        if (imgRdr != null) {
            imgRdr.dispose();
        }
        if (imgWrt != null) {
            imgWrt.dispose();
        }
        imInput.close();
        try {
            imageSrcStream.close();
            return;
        }
        catch (IOException v2) {}
    }

    private ImageWriter writeDefaultImage(BufferedImage bi) throws IOException {
        ImageWriter imgWrt = null;
        Iterator<ImageWriter> wtrItr = ImageIO.getImageWritersByFormatName(RESIZED_IMAGE_FILE_EXTENSION);
        if (wtrItr.hasNext()) {
            imgWrt = wtrItr.next();
            try {
                this.writeImage(imgWrt, bi, RESIZED_IMAGE_FILE_EXTENSION);
            }
            catch (IOException e) {
                imgWrt.dispose();
                throw e;
            }
        } else {
            throw new IOException("Could not find a valid processor to write an image of file type \"jpg\"");
        }
        return imgWrt;
    }

    private void writeImage(ImageWriter imgWriter, BufferedImage bi, String imageFileExtension) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        ImageOutputStream imgOut = ImageIO.createImageOutputStream(bos);
        imgWriter.setOutput(imgOut);
        imgWriter.write(bi);
        imgOut.close();
        this.imageBits = bos.toByteArray();
        this.imageWidth = bi.getWidth();
        this.imageHeight = bi.getHeight();
        this.imageFileExtention = imageFileExtension;
    }

    public InputStream getImage() {
        if (this.imageBits != null) {
            return new ByteArrayInputStream(this.imageBits);
        }
        return null;
    }

    public long getImageByteSize() {
        return this.imageBits != null ? this.imageBits.length : 0;
    }

    public String getImageFileExtention() {
        return this.imageFileExtention;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public IOException getError() {
        return this.error;
    }
}

