/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class MediaType {
    public static final MediaType ANY = new MediaType("*/*");
    public static final MediaType HTML = new MediaType("text/html");
    public static final MediaType XML = new MediaType("application/xml");
    public static final MediaType JSON = new MediaType("application/json");
    public static final MediaType RDF_XML = new MediaType("application/rdf+xml");
    public static final MediaType ZIP = new MediaType("application/zip");
    public static final MediaType RAS = new MediaType("application/ras");
    public static final MediaType ATOM = new MediaType("application/atom+xml");
    public static final MediaType TEXT = new MediaType("text/plain");
    public static final MediaType JAZZ_COMPACT = new MediaType("application/x-jazz-compact-rendering");
    public static final MediaType OSLC_COMPACT = new MediaType("application/x-oslc-compact+xml");
    private static Logger logger = Logger.getLogger(MediaType.class);
    private String value;
    private String type;
    private String subtype;
    private float quality = 1.0f;
    private Map<String, String> params = new HashMap<String, String>();

    public MediaType(String s) throws IllegalArgumentException {
        int i;
        String token;
        if (s == null) {
            String msg = "Media type can not be null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            logger.debug((Object)msg, (Throwable)e);
            throw e;
        }
        this.value = s;
        StringTokenizer st = new StringTokenizer(s, ";");
        if (st.hasMoreTokens()) {
            token = st.nextToken().trim().toLowerCase();
            i = token.indexOf(47);
            if (i < 1 || token.length() < i + 2) {
                String msg = "Media type \"" + token + "\" is invalid";
                IllegalArgumentException e = new IllegalArgumentException(msg);
                logger.debug((Object)msg, (Throwable)e);
                throw e;
            }
            this.type = token.substring(0, i);
            this.subtype = token.substring(i + 1);
        }
        while (st.hasMoreTokens()) {
            token = st.nextToken().trim();
            i = token.indexOf(61);
            if (i < 1 || token.length() < i + 2) {
                String msg = "Media type parameter \"" + token + "\" is invalid";
                IllegalArgumentException e = new IllegalArgumentException(msg);
                logger.debug((Object)msg, (Throwable)e);
                throw e;
            }
            String key = token.substring(0, i).toLowerCase();
            String value = token.substring(i + 1);
            if ("q".equals(key)) {
                this.quality = Float.parseFloat(value);
                continue;
            }
            this.params.put(key, value);
        }
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public float getQuality() {
        return this.quality;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean matches(String accept) {
        try {
            MediaType mt = new MediaType(accept);
            return this.matches(mt);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public boolean matches(MediaType mt) {
        return !(mt == null || !mt.getType().equals(this.getType()) && !mt.getType().equals("*") && !this.getType().equals("*") || !mt.getSubtype().equals(this.getSubtype()) && !mt.getSubtype().equals("*") && !this.getSubtype().equals("*"));
    }

    public String toString() {
        return this.value;
    }
}

