/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.io.rof;

import com.ibm.ram.io.rof.ReadOnlyFile;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractReadOnlyFile
implements ReadOnlyFile {
    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        int read;
        int total = 0;
        do {
            if ((read = this.read(buf, off + total, len - total)) >= 0) continue;
            throw new EOFException();
        } while ((total += read) < len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        long fp = this.getFilePointer();
        long len = this.length();
        long rem = len - fp;
        if ((long)n > rem) {
            n = (int)rem;
        }
        this.seek(fp + (long)n);
        return n;
    }
}

