/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.policy;

import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.extension.ConfigurationDetails;
import com.ibm.ram.extension.SelectBoxConfigurationDetails;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.policy.AssetPolicy;
import com.ibm.ram.policy.PendingPolicyExecutionInterval;
import com.ibm.ram.policy.Result;
import com.ibm.ram.policy.ResultDetail;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public abstract class PendingTimerPolicy
extends AssetPolicy {
    private static final String ATTR_INTERVAL_TYPE = "POL_ATTR_INTERVAL_TYPE";
    private static final String ATTR_INTERVAL_VALUE = "POL_ATTR_INTERVAL_VALUE";
    protected static String[] INTERVAL_TYPE_VALUES = new String[]{Intervals.RUN_IMMEDIATE.toString(), Intervals.MINS.toString(), Intervals.HOURS.toString(), Intervals.DAILY.toString(), Intervals.Sunday.toString(), Intervals.Monday.toString(), Intervals.Tuesday.toString(), Intervals.Wednesday.toString(), Intervals.Thursday.toString(), Intervals.Friday.toString(), Intervals.Saturday.toString()};
    private Result pendingResult;

    @Override
    public final Result test() {
        try {
            ResultDetail detail;
            this.setExecutionInterval();
            try {
                Result testResult = this.doTest();
                if (testResult != null) {
                    detail = new ResultDetail();
                    detail.setMessage(testResult.getMessage());
                    detail.setReturnCode(testResult.getReturnCode());
                    this.pendingResult.addDetail(detail);
                }
                if (testResult.getDetails() != null) {
                    ResultDetail[] resultDetailArray = testResult.getDetails();
                    int n = resultDetailArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResultDetail resultDetail = resultDetailArray[n2];
                        ResultDetail childDetail = new ResultDetail();
                        childDetail.setMessage(resultDetail.getMessage());
                        childDetail.setReturnCode(resultDetail.getReturnCode());
                        this.pendingResult.addDetail(childDetail);
                        ++n2;
                    }
                }
            }
            catch (Throwable t) {
                detail = new ResultDetail();
                detail.setMessage(t.getMessage());
                detail.setReturnCode(2);
                this.pendingResult.addDetail(detail);
            }
        }
        catch (Throwable t) {
            this.pendingResult.setMessage(t.getMessage());
            this.pendingResult.setReturnCode(2);
        }
        try {
            Result result = this.pendingResult;
            return result;
        }
        finally {
            this.pendingResult = null;
        }
    }

    public abstract Result doTest();

    @Override
    public final ConfigurationDetails[] getConfigurationDetails() {
        return this.getConfigurationDetails(Locale.getDefault());
    }

    @Override
    public final ConfigurationDetails[] getConfigurationDetails(Locale locale) {
        ArrayList<ConfigurationDetails> list = new ArrayList<ConfigurationDetails>();
        ConfigurationDetails[] configurationDetails = this.doGetConfigurationDetails(locale);
        if (configurationDetails != null) {
            list.addAll(Arrays.asList(configurationDetails));
        }
        SelectBoxConfigurationDetails intervalConfig = new SelectBoxConfigurationDetails(ATTR_INTERVAL_TYPE, CommonMessages.getString("PendingTimerPolicy.1", locale), INTERVAL_TYPE_VALUES, new String[]{CommonMessages.getString("PendingTimerPolicy.23", locale), CommonMessages.getString("PendingTimerPolicy.3", locale), CommonMessages.getString("PendingTimerPolicy.4", locale), CommonMessages.getString("PendingTimerPolicy.5", locale), CommonMessages.getString("PendingTimerPolicy.6", locale), CommonMessages.getString("PendingTimerPolicy.7", locale), CommonMessages.getString("PendingTimerPolicy.8", locale), CommonMessages.getString("PendingTimerPolicy.9", locale), CommonMessages.getString("PendingTimerPolicy.10", locale), CommonMessages.getString("PendingTimerPolicy.11", locale), CommonMessages.getString("PendingTimerPolicy.12", locale)}, CommonMessages.getString("PendingTimerPolicy.2", locale), Intervals.RUN_IMMEDIATE.toString());
        list.add(intervalConfig);
        ConfigurationDetails intervalValueConfig = new ConfigurationDetails(ATTR_INTERVAL_VALUE, CommonMessages.getString("PendingTimerPolicy.13", locale), CommonMessages.getString("PendingTimerPolicy.14", locale), false, false);
        list.add(intervalValueConfig);
        return list.toArray(new ConfigurationDetails[list.size()]);
    }

    public abstract ConfigurationDetails[] doGetConfigurationDetails(Locale var1);

    private void setExecutionInterval() throws RAMRuntimeException {
        Intervals intervalEnum;
        String intervalType = (String)this.getParameters().get(ATTR_INTERVAL_TYPE);
        try {
            intervalEnum = Intervals.valueOf(intervalType);
        }
        catch (Exception exception) {
            intervalEnum = null;
        }
        String intervalValue = (String)this.getParameters().get(ATTR_INTERVAL_VALUE);
        this.pendingResult = new Result();
        this.setExecutionInterval(intervalEnum, intervalValue);
    }

    protected void setExecutionInterval(Intervals intervalType, String intervalValue) {
        if (intervalType != null) {
            switch (intervalType) {
                case RUN_IMMEDIATE: {
                    this.pendingResult.setMessage(null);
                    this.pendingResult.setPendingExecutionInterval(null);
                    this.pendingResult.setReturnCode(0);
                    break;
                }
                case MINS: {
                    if (UtilitiesCommon.isEmptyString(intervalValue)) {
                        throw new RAMRuntimeException(CommonMessages.getString("PendingTimerPolicy.15"));
                    }
                    int mins = Integer.parseInt(intervalValue);
                    this.pendingResult.setMessage(MessageFormat.format(CommonMessages.getString("PendingTimerPolicy.16"), mins));
                    this.pendingResult.setPendingExecutionInterval(PendingPolicyExecutionInterval.createMinutelyExecutionInterval(mins));
                    this.pendingResult.setReturnCode(3);
                    break;
                }
                case HOURS: {
                    if (UtilitiesCommon.isEmptyString(intervalValue)) {
                        throw new RAMRuntimeException(CommonMessages.getString("PendingTimerPolicy.15"));
                    }
                    int hours = Integer.parseInt(intervalValue);
                    this.pendingResult.setMessage(MessageFormat.format(CommonMessages.getString("PendingTimerPolicy.17"), hours));
                    this.pendingResult.setPendingExecutionInterval(PendingPolicyExecutionInterval.createHourlyExecutionInterval(hours));
                    this.pendingResult.setReturnCode(3);
                    break;
                }
                default: {
                    if (UtilitiesCommon.isEmptyString(intervalValue)) {
                        throw new RAMRuntimeException(CommonMessages.getString("PendingTimerPolicy.18"));
                    }
                    String[] value = intervalValue.split(":");
                    if (value == null || value.length != 2) {
                        throw new RAMRuntimeException(CommonMessages.getString("PendingTimerPolicy.18"));
                    }
                    int hours = Integer.parseInt(value[0]);
                    int mins = Integer.parseInt(value[1]);
                    if (hours >= 24) {
                        throw new RAMRuntimeException(CommonMessages.getString("PendingTimerPolicy.19"));
                    }
                    if (mins >= 60) {
                        throw new RAMRuntimeException(CommonMessages.getString("PendingTimerPolicy.20"));
                    }
                    if (intervalType == Intervals.DAILY) {
                        this.pendingResult.setMessage(MessageFormat.format(CommonMessages.getString("PendingTimerPolicy.21"), intervalValue));
                        this.pendingResult.setPendingExecutionInterval(PendingPolicyExecutionInterval.createDailyExecutionInterval(hours, mins));
                        this.pendingResult.setReturnCode(3);
                        break;
                    }
                    int dayOfWeek = this.getDayOfWeek();
                    this.pendingResult.setMessage(MessageFormat.format(CommonMessages.getString("PendingTimerPolicy.22"), new Object[]{intervalType, intervalValue}));
                    this.pendingResult.setPendingExecutionInterval(PendingPolicyExecutionInterval.createDayOfWeekExecutionInterval(dayOfWeek, hours, mins));
                    this.pendingResult.setReturnCode(3);
                }
            }
        }
    }

    private int getDayOfWeek() {
        Intervals intervalEnum;
        String intervalType = (String)this.getParameters().get(ATTR_INTERVAL_TYPE);
        try {
            intervalEnum = Intervals.valueOf(intervalType);
        }
        catch (Exception exception) {
            intervalEnum = null;
        }
        switch (intervalEnum) {
            case Sunday: {
                return 1;
            }
            case Monday: {
                return 2;
            }
            case Tuesday: {
                return 3;
            }
            case Wednesday: {
                return 4;
            }
            case Thursday: {
                return 5;
            }
            case Friday: {
                return 6;
            }
            case Saturday: {
                return 7;
            }
        }
        throw new RAMRuntimeException("Day of Week is incorrect. Valid values are Sunday to Saturday. To run policy at a set time enter time, in format hh:mm, for e.g 22:15");
    }

    protected static enum Intervals {
        MINS,
        HOURS,
        DAILY,
        Sunday,
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday,
        RUN_IMMEDIATE;

    }
}

