/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.cli;

import com.ibm.ram.cli.CommandLineLogger;
import com.ibm.ram.cli.Logger;
import com.ibm.ram.common.util.TimestampOutputStream;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.command.Command;
import com.ibm.ram.internal.cli.command.ConfigCommand;
import com.ibm.ram.internal.cli.command.GetCommand;
import com.ibm.ram.internal.cli.command.MountCommand;
import com.ibm.ram.internal.cli.command.PublishCommand;
import com.ibm.ram.internal.cli.command.RetireCommand;
import com.ibm.ram.internal.cli.command.SearchCommand;
import com.ibm.ram.internal.cli.command.SetCommand;
import com.ibm.ram.internal.cli.configuration.Configuration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.IStatus;

public class Ram {
    public static final String HELP = "--help";
    private static Map<String, RAMCommands> commandMap;
    public static final String ERROR_LOG = "error.log";

    static {
        HashMap<String, RAMCommands> m = new HashMap<String, RAMCommands>();
        m.put("publish", RAMCommands.PUBLISH);
        m.put("get", RAMCommands.GET);
        m.put("mount", RAMCommands.MOUNT);
        m.put("retire", RAMCommands.RETIRE);
        m.put("mark", RAMCommands.SET);
        m.put("set", RAMCommands.SET);
        m.put("search", RAMCommands.SEARCH);
        m.put("config", RAMCommands.CONFIG);
        m.put(HELP, RAMCommands.HELP);
        commandMap = Collections.unmodifiableMap(m);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println(Messages.getString("Ram.1"));
            System.out.println();
            System.out.println(Messages.getString(commandMap.get(HELP).getHelpId()));
            return;
        }
        int exitStatus = 0;
        RAMCommands command = commandMap.get(args[0]);
        if (command == null) {
            command = RAMCommands.UNKNOWN;
        }
        if (command == RAMCommands.HELP || args.length > 1 && args[1].equalsIgnoreCase(HELP) || command == RAMCommands.UNKNOWN) {
            if (command == RAMCommands.UNKNOWN) {
                System.out.println(MessageFormat.format(Messages.getString("Ram.2"), args[0]));
                exitStatus = 1;
            }
            System.out.println(Messages.getString(command.getHelpId()));
            System.exit(exitStatus);
        }
        Command theCommand = null;
        switch (command) {
            case PUBLISH: {
                theCommand = new PublishCommand(args);
                break;
            }
            case GET: {
                theCommand = new GetCommand(args);
                break;
            }
            case MOUNT: {
                theCommand = new MountCommand(args);
                break;
            }
            case RETIRE: {
                theCommand = new RetireCommand(args);
                break;
            }
            case SET: {
                theCommand = new SetCommand(args);
                break;
            }
            case SEARCH: {
                theCommand = new SearchCommand(args);
                break;
            }
            case CONFIG: {
                theCommand = new ConfigCommand(args);
                break;
            }
            default: {
                exitStatus = 1;
            }
        }
        if (theCommand != null) {
            exitStatus = Ram.execute(theCommand);
        }
        System.exit(exitStatus);
    }

    public static int execute(Command command) {
        return Ram.execute(command, new CommandLineLogger());
    }

    public static int execute(Command command, Logger logger) {
        block14: {
            boolean showStatus = true;
            String sysErrLogFileName = Configuration.getDefaultFileName(ERROR_LOG);
            File sysErrLogFile = new File(sysErrLogFileName);
            if (!sysErrLogFile.exists()) {
                try {
                    sysErrLogFile.createNewFile();
                }
                catch (Exception exception) {}
            }
            try {
                System.setErr(new PrintStream((OutputStream)new TimestampOutputStream((OutputStream)new FileOutputStream(sysErrLogFile, true))));
            }
            catch (Exception exception) {}
            Ram.configureLog4j(sysErrLogFileName);
            try {
                IStatus status = command.validate();
                if (command instanceof SearchCommand) {
                    showStatus = SearchCommand.verbose;
                }
                if (status != null && showStatus) {
                    Ram.showStatus(status, logger);
                }
                if (status.isOK() && (status = command.execute()) != null && showStatus) {
                    Ram.showStatus(status, logger);
                }
                if (status == null) break block14;
                if (status.isOK() || status.matches(1)) {
                    if (showStatus) {
                        System.out.println(Messages.getString("Ram.3"));
                    }
                    break block14;
                }
                if (showStatus) {
                    System.out.println(Messages.getString("Ram.4"));
                }
                return 1;
            }
            finally {
                command.releaseRAMSession();
            }
        }
        return 0;
    }

    private static void configureLog4j(String logFileName) {
        try {
            org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
            FileAppender fileAppender = new FileAppender((Layout)new PatternLayout("%d{[MM/dd/yy HH:mm:ss z] }"), logFileName);
            logger.addAppender((Appender)fileAppender);
            ConsoleAppender consoleAppender = null;
            Enumeration e = logger.getAllAppenders();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof ConsoleAppender)) continue;
                consoleAppender = (ConsoleAppender)o;
            }
            if (consoleAppender != null) {
                logger.removeAppender(consoleAppender);
            }
        }
        catch (Exception exception) {}
    }

    public static void showStatus(IStatus status) {
        Ram.showStatus(status, new CommandLineLogger());
    }

    public static void showStatus(IStatus status, Logger logger) {
        if (status != null && logger != null) {
            if (status.isMultiStatus()) {
                IStatus[] allStatus;
                IStatus[] iStatusArray = allStatus = status.getChildren();
                int n = allStatus.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus aStatus = iStatusArray[n2];
                    Ram.showStatus(aStatus, logger);
                    ++n2;
                }
            } else {
                logger.log(status);
            }
        }
    }

    public static enum RAMCommands {
        PUBLISH("Help.Publish"),
        GET("Help.Get"),
        MOUNT("Help.Mount"),
        RETIRE("Help.Retire"),
        SET("Help.Set"),
        SEARCH("Help.Search"),
        CONFIG("Help.Config"),
        HELP("Help.Ram"),
        UNKNOWN("Help.Ram");

        private String helpId;

        private RAMCommands(String helpId) {
            this.helpId = helpId;
        }

        public String getHelpId() {
            return this.helpId;
        }
    }
}

