/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.command;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.status.RAMStatus;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.AssetType;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.command.Command;
import com.ibm.ram.internal.cli.command.SearchCommand;
import com.ibm.ram.internal.cli.commandline.CommandLine;
import com.ibm.ram.internal.cli.commandline.Option;
import com.ibm.ram.internal.cli.commandline.ParseException;
import com.ibm.ram.internal.cli.configuration.BuildEnvironment;
import com.ibm.ram.internal.cli.rampackage.Dependency;
import com.ibm.ram.internal.cli.rampackage.DescriptorParser;
import com.ibm.ram.internal.cli.rampackage.Package;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class PublishCommand
extends Command {
    public static final String NAME = "publish";
    public static final String OPTION_OVERWRITE = "-o";
    public static final String OPTION_CREATE_COMPONENT = "-c";
    public static final String OPTION_ID = "-id";
    private static final String COMPONENT_TYPE = "Component";
    private static final String ZIP_EXTENSION = ".zip";
    private ArrayList<String> packageDescriptors = new ArrayList();
    private String componentId = null;
    private String componentVersion = null;
    private boolean overwrite = false;

    public PublishCommand(String[] cmdArgs) {
        super(cmdArgs);
    }

    @Override
    public IStatus execute() {
        MultiStatus mStatus = new MultiStatus(this.getClass().getName(), 0, "", null);
        ArrayList<Package> packages = this.createPackages(this.packageDescriptors);
        for (Package aPackage : packages) {
            IStatus readStatus = aPackage.readPackageDescriptor();
            if (readStatus.isOK()) continue;
            mStatus.add(readStatus);
            String message = MessageFormat.format(Messages.getString("PublishCommand.5"), aPackage.getDescriptorName());
            mStatus.add((IStatus)new Status(4, this.getClass().getName(), message));
        }
        if (!mStatus.isOK()) {
            return mStatus;
        }
        if (packages.size() > 0) {
            String message;
            System.out.println(Messages.getString("PublishCommand.8"));
            for (Package aPackage : packages) {
                System.out.println(aPackage.getId());
            }
            Status aStatus = this.getRAMSession();
            if (!aStatus.isOK()) {
                mStatus.add((IStatus)aStatus);
                return mStatus;
            }
            HashMap<String, Package> assetMap = new HashMap<String, Package>();
            boolean processDependencies = false;
            for (Package aPackage : packages) {
                aStatus = aPackage.create(this.ramSession, this.config, this.overwrite);
                mStatus.add((IStatus)aStatus);
                if (aStatus.isOK()) {
                    assetMap.put(aPackage.getId(), aPackage);
                    if (!aPackage.hasDependencies()) continue;
                    processDependencies = true;
                    continue;
                }
                message = MessageFormat.format(Messages.getString("PublishCommand.6"), aPackage.getId());
                mStatus.add((IStatus)new Status(4, this.getClass().getName(), message));
            }
            if (mStatus.isOK() && processDependencies) {
                Iterator assetMapIterator = assetMap.entrySet().iterator();
                while (assetMapIterator.hasNext()) {
                    Package aPackage = (Package)assetMapIterator.next().getValue();
                    boolean dependencyMet = true;
                    for (Dependency dep : aPackage.getDependencies()) {
                        RAMAsset depAsset = null;
                        String depAssetId = dep.getId();
                        String depAssetVersion = dep.getVersion();
                        String depAssetQueryString = dep.getQueryString();
                        Package depPackage = (Package)assetMap.get(depAssetId);
                        if (depPackage != null && depPackage.getVersion().equals(depAssetVersion)) {
                            depAsset = depPackage.getAsset();
                        } else {
                            AssetIdentification assetId = SearchCommand.getAssetIdentification(this.ramSession, depAssetId, depAssetVersion, depAssetQueryString);
                            if (assetId != null) {
                                try {
                                    depAsset = this.ramSession.getAsset(assetId);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (depAsset != null) {
                            aPackage.getAsset().addRelatedAsset((Asset)depAsset, (RelationshipType)this.ramSession.getRelationshipType("Depends on"));
                            continue;
                        }
                        String message2 = MessageFormat.format(Messages.getString("PublishCommand.4"), aPackage.getId(), depAssetId);
                        mStatus.add((IStatus)new Status(4, this.getClass().getName(), message2));
                        dependencyMet = false;
                    }
                    if (dependencyMet) continue;
                    String message3 = MessageFormat.format(Messages.getString("PublishCommand.6"), aPackage.getId());
                    mStatus.add((IStatus)new Status(4, this.getClass().getName(), message3));
                }
            }
            RAMAsset componentAsset = null;
            if (mStatus.isOK() && this.componentId != null) {
                RAMAssetType componentType = this.ramSession.getAssetType(COMPONENT_TYPE);
                if (componentType != null) {
                    try {
                        AssetIdentification assetId = new AssetIdentification(this.componentId, this.componentVersion);
                        componentAsset = this.ramSession.getAsset(assetId);
                    }
                    catch (Exception exception) {}
                    if (componentAsset == null) {
                        componentAsset = this.ramSession.createAsset(this.componentId, this.componentVersion);
                        componentAsset.setAssetType((AssetType)componentType);
                        componentAsset.setName(this.componentId);
                        componentAsset.setCommunity((CommunityInformation)Package.getCommunity(this.ramSession, this.config.getCommunity(), ""));
                        componentAsset.setShortDescription(this.componentId);
                    }
                } else {
                    message = MessageFormat.format(Messages.getString("PublishCommand.10"), COMPONENT_TYPE);
                    mStatus.add((IStatus)new Status(4, this.getClass().getName(), message));
                }
            }
            if (mStatus.isOK()) {
                for (Map.Entry assetMapEntry : assetMap.entrySet()) {
                    RAMAsset anAsset = ((Package)assetMapEntry.getValue()).getAsset();
                    if (componentAsset != null) {
                        componentAsset.addRelatedAsset((Asset)anAsset, (RelationshipType)this.ramSession.getRelationshipType("Depends on"));
                    }
                    this.ramSession.queueAssetForPut(anAsset, this.overwrite);
                }
                if (componentAsset != null) {
                    this.ramSession.queueAssetForPut(componentAsset, this.overwrite);
                }
                try {
                    RAMStatus ramStatus = this.ramSession.putAssets((IProgressMonitor)new NullProgressMonitor());
                    mStatus.add((IStatus)ramStatus);
                }
                catch (Exception exception) {}
            }
            this.ramSession.release();
        }
        return mStatus;
    }

    private ArrayList<Package> createPackages(ArrayList<String> packageDescriptors) {
        ArrayList<Package> packages = new ArrayList<Package>();
        for (String descriptorName : packageDescriptors) {
            Package aPackage = new Package(descriptorName);
            packages.add(aPackage);
        }
        return packages;
    }

    @Override
    public IStatus validate() {
        String message;
        String componentValue;
        Status status = null;
        CommandLine commandLine = new CommandLine(this.cmdArgs);
        commandLine.addOption(new Option(OPTION_OVERWRITE));
        commandLine.addOption(new Option("-config", true));
        commandLine.addOption(new Option(OPTION_CREATE_COMPONENT, true));
        commandLine.addOption(new Option(OPTION_ID, true));
        try {
            commandLine.parse();
        }
        catch (ParseException pe) {
            return new Status(4, this.getClass().getName(), pe.getMessage());
        }
        List<String> values = commandLine.getValues();
        if (values.size() > 1) {
            String message2 = MessageFormat.format(Messages.getString("CommandLine.5"), values.get(1));
            return new Status(4, this.getClass().getName(), message2);
        }
        String id = commandLine.getOption(OPTION_ID).getValue();
        if (id != null && !id.isEmpty()) {
            BuildEnvironment.getInstance().setSnapshotID(id);
        }
        if ((componentValue = commandLine.getOption(OPTION_CREATE_COMPONENT).getValue()) != null) {
            String message3;
            int separator = componentValue.indexOf(":");
            if (separator == -1) {
                message3 = MessageFormat.format(Messages.getString("PublishCommand.7"), OPTION_CREATE_COMPONENT);
                status = new Status(4, this.getClass().getName(), message3);
            } else {
                this.componentId = componentValue.substring(0, separator).trim();
                this.componentVersion = componentValue.substring(separator + 1).trim();
                if (this.componentId.isEmpty() || this.componentVersion.isEmpty()) {
                    message3 = MessageFormat.format(Messages.getString("PublishCommand.7"), OPTION_CREATE_COMPONENT);
                    status = new Status(4, this.getClass().getName(), message3);
                }
                this.componentVersion = DescriptorParser.resolveVersion(this.componentVersion);
            }
        }
        if (status != null && !status.isOK()) {
            return status;
        }
        this.overwrite = commandLine.getOption(OPTION_OVERWRITE).isSet();
        this.createConfiguration(commandLine.getOption("-config").getValue());
        status = this.config.validate();
        if (!status.isOK()) {
            return status;
        }
        if (this.config.getCommunity() == null) {
            return new Status(4, this.getClass().getName(), Messages.getString("PublishCommand.9"));
        }
        String location = null;
        if (!values.isEmpty()) {
            location = values.get(0);
        }
        if (location == null) {
            location = new File(".").getAbsolutePath();
        }
        boolean badLocation = false;
        File fLocation = new File(location);
        if (location.endsWith(ZIP_EXTENSION)) {
            if (fLocation.isFile() && fLocation.exists() && fLocation.canRead()) {
                try {
                    ZipFile zf = new ZipFile(fLocation);
                    ZipEntry ze = Package.getDescriptorFromZip(zf);
                    if (ze != null) {
                        this.packageDescriptors.add(location);
                    }
                }
                catch (Exception exception) {
                    badLocation = true;
                }
            } else {
                badLocation = true;
            }
            if (badLocation) {
                message = MessageFormat.format(Messages.getString("PublishCommand.1"), location);
                status = new Status(4, this.getClass().getName(), message);
            }
        } else if (!fLocation.isDirectory()) {
            message = MessageFormat.format(Messages.getString("PublishCommand.2"), location);
            status = new Status(4, this.getClass().getName(), message);
        } else {
            this.findPackageDescriptors(fLocation);
        }
        if (status.isOK() && this.packageDescriptors.isEmpty()) {
            message = MessageFormat.format(Messages.getString("PublishCommand.3"), location);
            status = new Status(2, this.getClass().getName(), message);
        }
        return status;
    }

    private void findPackageDescriptors(File node) {
        try {
            if (node.isDirectory()) {
                File[] files;
                boolean descriptorFound = false;
                String nodePath = String.valueOf(node.getCanonicalPath()) + File.separator;
                String toFind = String.valueOf(nodePath) + "package.json";
                File f = new File(toFind);
                if (f.exists() && f.isFile() && f.canRead()) {
                    this.packageDescriptors.add(toFind);
                    descriptorFound = true;
                }
                if (!descriptorFound && (f = new File(toFind = String.valueOf(nodePath) + "pom.xml")).exists() && f.isFile() && f.canRead()) {
                    this.packageDescriptors.add(toFind);
                    descriptorFound = true;
                }
                if (!descriptorFound && (files = node.listFiles(new PomFilter())) != null && files.length > 0) {
                    this.packageDescriptors.add(files[0].getCanonicalPath());
                    descriptorFound = true;
                }
                if (!descriptorFound) {
                    String[] subNodes;
                    String[] stringArray = subNodes = node.list();
                    int n = subNodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ZipFile zf;
                        ZipEntry ze;
                        String fileName = stringArray[n2];
                        f = new File(String.valueOf(node.getCanonicalPath()) + File.separator + fileName);
                        if (f.exists() && f.isFile() && f.canRead() && fileName.endsWith(ZIP_EXTENSION) && (ze = Package.getDescriptorFromZip(zf = new ZipFile(f))) != null) {
                            this.packageDescriptors.add(f.getCanonicalPath());
                        }
                        if (f.isDirectory()) {
                            this.findPackageDescriptors(f);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Exception exception) {}
    }

    public class PomFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".pom") && pathname.exists() && pathname.isFile() && pathname.canRead();
        }
    }
}

