/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.common.util.CachedRAMURIConverter;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.RAMClient;
import com.ibm.ram.internal.client.RAMServiceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.util.URI;

public class ClientCachedRAMUriConverter
extends CachedRAMURIConverter {
    private static final Logger logger = Logger.getLogger(ClientCachedRAMUriConverter.class);
    private RAMClient client;
    private Map<String, Exception> urlToErrorMap = new HashMap<String, Exception>();
    private final boolean recordExceptions;

    public ClientCachedRAMUriConverter(String serverPath, RAMClient client, boolean recordExceptions) {
        super(serverPath);
        this.client = client;
        this.recordExceptions = recordExceptions;
    }

    protected InputStream createURLInputStream(URI uri) throws IOException {
        URL url = new URL(uri.toString());
        String urlString = url.toString();
        if (this.urlToErrorMap.containsKey(urlString)) {
            logger.log((Priority)Level.WARN, (Object)("Reusing past exception for url [" + urlString + "]"));
            Exception exception = this.urlToErrorMap.get(urlString);
            if (exception instanceof IOException) {
                IOException ioe = (IOException)exception;
                throw ioe;
            }
            throw new RuntimeException(exception);
        }
        if (url != null) {
            AbstractRAMClient.Response response;
            if (this.client == null) {
                this.client = new RAMClient(new URL(this.getServerPath()));
            }
            try {
                response = this.client.getURL(url, true, 120000);
            }
            catch (RAMServiceException e1) {
                if (logger.isDebugEnabled()) {
                    logger.log((Priority)Level.DEBUG, (Object)("Unable to get [" + urlString + "]"), (Throwable)e1);
                }
                IOException e2 = new IOException(e1.getMessage());
                this.urlToErrorMap.put(urlString, e2);
                throw e2;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.log((Priority)Level.DEBUG, (Object)("Unable to get [" + urlString + "]"), (Throwable)e);
                }
                if (this.recordExceptions) {
                    this.urlToErrorMap.put(urlString, e);
                }
                if (e instanceof IOException) {
                    IOException ioe = (IOException)e;
                    throw ioe;
                }
                throw new RuntimeException(e);
            }
            InputStream is = null;
            if (200 == response.code) {
                is = response.is;
            } else if (404 == response.code) {
                FileNotFoundException e = new FileNotFoundException(urlString);
                this.urlToErrorMap.put(urlString, e);
                throw e;
            }
            if (is != null) {
                return is;
            }
        }
        try {
            return super.createURLInputStream(uri);
        }
        catch (FileNotFoundException e) {
            this.urlToErrorMap.put(urlString, e);
            throw e;
        }
    }

    public void clearUrlErrorMap() {
        this.urlToErrorMap.clear();
    }
}

