/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.udeploy.repo.integration;

import com.ibm.ram.udeploy.repo.integration.RAMHelper;
import com.urbancode.air.plugin.command.PluginExecutionException;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.PropertyConfigurator;

public class RAMIntegrator {
    private Properties inputProperties;
    private Properties outputProperties;

    public RAMIntegrator(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int integrate() {
        int result = 0;
        RAMHelper ramClient = null;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            String repoUrl = this.inputProperties.getProperty("repositoryUrl");
            String RAMUsername = this.inputProperties.getProperty("user");
            String RAMPassword = this.inputProperties.getProperty("password");
            String uniqueId = this.inputProperties.getProperty("uniqueId");
            String versionPattern = this.inputProperties.getProperty("versionPattern");
            String state = this.inputProperties.getProperty("state");
            String query = this.inputProperties.getProperty("query");
            Integer latestBuildCount = Integer.valueOf(this.inputProperties.getProperty("latestBuildCount"));
            String revision = this.inputProperties.getProperty("specificVersion");
            String username = "PasswordIsAuthToken";
            String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI url = new URI(webUrl);
            VersionClient versionClient = new VersionClient(url, username, password);
            ComponentClient componentClient = new ComponentClient(url, username, password);
            ramClient = new RAMHelper(repoUrl, RAMUsername, RAMPassword, uniqueId, versionPattern, query, state);
            if (revision != null && revision.trim().length() > 0) {
                String ramVersion = ramClient.getVersion(revision);
                if (ramVersion == null) throw new PluginExecutionException(String.format("RAM does not contain the version %s", revision));
                this.integrate(ramVersion, ramClient, componentClient, versionClient);
                return result;
            } else {
                List<String> versions = ramClient.getLatestVersions(latestBuildCount);
                for (String version : versions) {
                    this.integrate(version, ramClient, componentClient, versionClient);
                }
                if (versions.size() >= 1) return result;
                System.out.println("Did not find any versions in RAM.");
            }
            return result;
        }
        catch (Exception e) {
            System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
            result = 1;
            return result;
        }
        finally {
            if (ramClient != null) {
                ramClient.release();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void integrate(String ramVersion, RAMHelper ramClient, ComponentClient componentClient, VersionClient versionClient) throws Exception {
        File tempDir;
        block14: {
            tempDir = null;
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            boolean preserveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
            boolean includeDependent = Boolean.valueOf(this.inputProperties.getProperty("includeDependent"));
            String componentName = this.inputProperties.getProperty("componentName");
            String[] includes = new String[]{"**/*"};
            String[] excludes = new String[]{};
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String extensionString = this.inputProperties.getProperty("extensions");
            String[] extensions = new String[]{};
            if (extensionString != null) {
                extensions = extensionString.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
            }
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            String versionId = null;
            try {
                List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                boolean hasVersion = versions.contains(ramVersion);
                System.out.println("Version from RAM: " + ramVersion);
                if (!hasVersion) {
                    System.out.println("Creating new version");
                    versionId = versionClient.createVersion(componentName, ramVersion, " ").toString();
                    this.outputProperties.setProperty("VersionID", versionId);
                    if (isUseVFS) {
                        System.out.println("Uploading files to VFS");
                        tempDir = ramClient.downloadFiles(ramVersion, includeDependent);
                        versionClient.addVersionFiles(componentName, versionId, tempDir, "", includes, excludes, preserveExecutePermissions, true, charset, extensions);
                        System.out.println("Upload complete.");
                        break block14;
                    } else {
                        System.out.println(String.format("Not uploading version %s to VFS because using VFS was not selected.", versionId));
                    }
                    break block14;
                }
                System.out.println(String.format("UCD already contains version %s. A duplicate will not be created.", ramVersion));
            }
            catch (Exception e) {
                try {
                    System.out.println(String.format("Error creating a new version: %s", e.getMessage()));
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    String stacktrace = sw.toString();
                    System.out.println(stacktrace);
                    if (versionId == null) throw e;
                    versionClient.deleteVersion(UUID.fromString(versionId));
                    throw e;
                }
                catch (Throwable throwable) {
                    try {
                        if (tempDir == null) throw throwable;
                        if (!tempDir.exists()) throw throwable;
                        IO.delete((File)tempDir);
                        throw throwable;
                    }
                    catch (IOException e2) {
                        System.out.println(String.format("Unable to delete download directory", e2.getMessage()));
                    }
                    throw throwable;
                }
            }
        }
        try {
            if (tempDir == null) return;
            if (!tempDir.exists()) return;
            IO.delete((File)tempDir);
            return;
        }
        catch (IOException e) {
            System.out.println(String.format("Unable to delete download directory", e.getMessage()));
            return;
        }
    }
}

