/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant;

import com.ibm.ram.cli.Logger;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IStatus;

public class AntLogger
implements Logger {
    private RAMTask task;

    public AntLogger(RAMTask task) {
        this.task = task;
    }

    @Override
    public void log(IStatus status) {
        String msg = status.getMessage();
        Throwable t = status.getException();
        switch (status.getSeverity()) {
            case 4: {
                this.log(msg, t, 0);
                break;
            }
            case 2: {
                this.log(msg, t, 1);
                break;
            }
            case 1: {
                this.log(msg, t, 2);
                break;
            }
            default: {
                this.log(msg, t, 4);
            }
        }
    }

    private void log(String msg, Throwable t, int level) {
        if (msg != null && t != null) {
            this.task.log(msg, t, level);
            if (level == 0 && this.task.isFailOnError()) {
                throw new BuildException(msg, t, this.task.getLocation());
            }
        } else if (msg != null) {
            this.task.log(msg, level);
            if (level == 0 && this.task.isFailOnError()) {
                throw new BuildException(msg, this.task.getLocation());
            }
        } else if (t != null) {
            this.task.log(t, level);
            if (level == 0 && this.task.isFailOnError()) {
                throw new BuildException(t, this.task.getLocation());
            }
        }
    }
}

