/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant;

import com.ibm.ram.internal.client.ant.ArtifactEntry;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DownloadUtil {
    public static final String RAM_BUILDER_CONTROL_XML = ".settings/rambuildercontrol.xml";
    private static final String COPYARTIFACTENTRY = "copyartifactentry";
    private static final String DESTINATION = "destination";
    private static final String CONNECTION = "connection";
    private static final String PRESERVE_ARTIFACT_PATH = "preserveArtifactPath";
    private static final String KEY = "key";

    public static List<ArtifactEntry> getArtifactsFromControlFile(File file) {
        if (file.isDirectory()) {
            file = new File(file, RAM_BUILDER_CONTROL_XML);
        }
        ArrayList<ArtifactEntry> entries = new ArrayList<ArtifactEntry>();
        if (file.exists()) {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = docBuilder.parse(new FileInputStream(file));
                Element docElement = doc.getDocumentElement();
                NodeList ramcopyartifacts = docElement.getElementsByTagName(COPYARTIFACTENTRY);
                int numNodes = ramcopyartifacts.getLength();
                int i = 0;
                while (i < numNodes) {
                    Element currentElement = (Element)ramcopyartifacts.item(i);
                    entries.add(DownloadUtil.createArtifactEntry(currentElement));
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return entries;
    }

    public static List<ArtifactEntry> getArtifactsFromControlFile(String basePath) {
        File controlFile;
        File baseDir = new File(basePath);
        if (baseDir.exists() && (controlFile = new File(baseDir, RAM_BUILDER_CONTROL_XML)).exists()) {
            return DownloadUtil.getArtifactsFromControlFile(controlFile);
        }
        return Collections.EMPTY_LIST;
    }

    public static String getElementTextValue(Element currentElement, String tagName) {
        Element element;
        Node node;
        NodeList nodes;
        String value = null;
        if (currentElement != null && (nodes = currentElement.getElementsByTagName(tagName)) != null && nodes.getLength() == 1 && (node = (element = (Element)nodes.item(0)).getFirstChild()) != null) {
            value = node.getNodeValue();
        }
        return value;
    }

    private static ArtifactEntry createArtifactEntry(Element currentElement) {
        ArtifactEntry entry = null;
        if (currentElement != null && currentElement.getTagName().equalsIgnoreCase(COPYARTIFACTENTRY)) {
            entry = new ArtifactEntry(DownloadUtil.getElementTextValue(currentElement, KEY));
            entry.setDestination(DownloadUtil.getElementTextValue(currentElement, DESTINATION));
            entry.setHost(DownloadUtil.getElementTextValue(currentElement, CONNECTION));
            entry.setPreservePath(Boolean.parseBoolean(DownloadUtil.getElementTextValue(currentElement, PRESERVE_ARTIFACT_PATH)));
        }
        return entry;
    }
}

