/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant;

import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.RAMPropertyUtil;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;

public class RAMPropertyHelper
extends PropertyHelper {
    protected static final String GET = "get";
    protected static final String SET = "set";
    protected static final String IS = "is";
    private Project project;

    public RAMPropertyHelper(Project project) {
        this.setProject(project);
    }

    public Object getPropertyHook(String ns, String name, boolean user) {
        return RAMPropertyUtil.getPropertyValue(this.getProject(), name);
    }

    public boolean setPropertyHook(String ns, String name, Object value, boolean inherited, boolean user, boolean isNew) {
        String[] parts = name.split("\\.");
        if (parts.length < 2) {
            return super.setPropertyHook(ns, name, value, inherited, user, isNew);
        }
        Object obj = this.project.getReference(parts[0]);
        if (obj instanceof RAMDataType) {
            obj = ((RAMDataType)((Object)obj)).getModel();
        }
        if (obj == null) {
            return super.setPropertyHook(ns, name, value, inherited, user, isNew);
        }
        String[] args = new String[parts.length - 1];
        System.arraycopy(parts, 1, args, 0, args.length);
        boolean result = this.setProperty(obj, args, value);
        if (!result) {
            return super.setPropertyHook(ns, name, value, inherited, user, isNew);
        }
        return result;
    }

    protected boolean setProperty(Object obj, String[] args, Object value) {
        if (obj == null || args == null || args.length == 0) {
            return false;
        }
        if (args.length == 1) {
            return this.invokeSetMethod(obj, args[0], value);
        }
        Object result = this.invokeGetMethod(obj, args[0]);
        String[] subargs = new String[args.length - 1];
        System.arraycopy(args, 1, subargs, 0, subargs.length);
        return this.setProperty(result, subargs, value);
    }

    protected String getMethodSuffix(String propName) {
        char[] chars = propName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    protected boolean invokeSetMethod(Object obj, String name, Object value) {
        try {
            this.invokeMethod(SET, obj, name, new Class[]{value.getClass()}, new Object[]{value});
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    protected Object invokeGetMethod(Object obj, String name) {
        Object result;
        int index;
        block12: {
            int j;
            index = -1;
            int i = name.indexOf(91);
            if (i > -1 && (j = name.indexOf(93, i)) > -1) {
                String indexString = name.substring(i + 1, j);
                try {
                    index = Integer.parseInt(indexString);
                }
                catch (NumberFormatException e) {
                    LoggingUtil.error(null, "Index is not a number: " + name, (Throwable)e);
                }
            }
            result = null;
            if (index > -1) {
                name = name.substring(0, i);
            }
            try {
                result = this.invokeMethod(GET, obj, name, new Class[0], new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    result = this.invokeMethod(IS, obj, name, new Class[0], new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    if (!"size".equals(name) && !"length".equals(name)) break block12;
                    if (obj.getClass().isArray()) {
                        result = Array.getLength(obj);
                        break block12;
                    }
                    if (!(obj instanceof Collection)) break block12;
                    result = ((Collection)obj).size();
                }
            }
        }
        if (index > -1 && result != null) {
            if (result instanceof Object[] && ((Object[])result).length > index) {
                return ((Object[])result)[index];
            }
            if (result instanceof List && ((List)result).size() > index) {
                return ((List)result).get(index);
            }
        }
        return result;
    }

    protected Object invokeMethod(String type, Object obj, String name, Class[] paramSig, Object[] params) throws NoSuchMethodException {
        try {
            Method method = obj.getClass().getMethod(String.valueOf(type) + this.getMethodSuffix(name), paramSig);
            return method.invoke(obj, params);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.project = project;
    }
}

