/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetValidation;
import com.ibm.ram.client.status.RAMStatusMonitor;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DuplicateTask
extends RAMTask {
    private Asset asset;
    private String guid;

    public void add(Asset asset) {
        if (this.asset != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)asset);
        } else {
            if (this.getSession() != null) {
                asset.setSession(this.getSession());
            }
            asset.setTask(this);
            this.asset = asset;
        }
    }

    @Override
    public void execute() throws BuildException {
        try {
            super.execute();
            if (this.asset == null) {
                LoggingUtil.errorAtLeastOneChild((ProjectComponent)this, (ProjectComponent)new Asset());
            }
            LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.DuplicateTask.DuplicatingAsset"), String.valueOf(this.asset.getName()) + " [" + this.asset.getVersion() + "]"));
            RAMAsset ramAsset = this.asset.getAsset();
            ramAsset = this.getSession().createAsset((com.ibm.ram.common.data.Asset)ramAsset, new RAMStatusMonitor());
            this.asset.setAsset(ramAsset);
            this.asset.commitModel();
            RAMAssetValidation[] errors = ramAsset.validate();
            if (errors != null && errors.length > 0) {
                StringBuffer buffer = new StringBuffer("\n");
                buffer.append(ClientMessages.getString((String)"Ant.ValidationErrorsExist"));
                buffer.append("\n");
                int i = 0;
                while (i < errors.length) {
                    buffer.append(errors[i].getMessage());
                    buffer.append("\n");
                    ++i;
                }
                LoggingUtil.error((ProjectComponent)this, buffer.toString());
            } else {
                this.getSession().queueAssetForPut(ramAsset);
                this.getSession().put((IRAMSessionObject)ramAsset, (IProgressMonitor)new NullProgressMonitor());
                if (this.getGuidProperty() != null) {
                    this.getProject().setProperty(this.getGuidProperty(), ramAsset.getIdentification().getGUID());
                }
            }
        }
        catch (Exception e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
    }

    public String getGuidProperty() {
        return this.guid;
    }

    public void setGuidProperty(String guid) {
        this.guid = guid;
    }

    @Override
    public List getChildren() {
        ArrayList<Asset> children = new ArrayList<Asset>();
        children.add(this.asset);
        return children;
    }
}

