/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.DefaultTypeAdapters;
import com.google.gson.DisjunctionExclusionStrategy;
import com.google.gson.ExclusionStrategy;
import com.google.gson.ExposeAnnotationDeserializationExclusionStrategy;
import com.google.gson.ExposeAnnotationSerializationExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.InnerClassExclusionStrategy;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonCompactFormatter;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonDeserializerExceptionWrapper;
import com.google.gson.JsonFormatter;
import com.google.gson.JsonPrintFormatter;
import com.google.gson.JsonSerializer;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.MappedObjectConstructor;
import com.google.gson.ModifierBasedExclusionStrategy;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.Preconditions;
import com.google.gson.SerializedNameAnnotationInterceptingNamingPolicy;
import com.google.gson.VersionExclusionStrategy;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;

public final class GsonBuilder {
    private static final InnerClassExclusionStrategy innerClassExclusionStrategy = new InnerClassExclusionStrategy();
    private static final ExposeAnnotationSerializationExclusionStrategy exposeAnnotationSerializationExclusionStrategy = new ExposeAnnotationSerializationExclusionStrategy();
    private static final ExposeAnnotationDeserializationExclusionStrategy exposeAnnotationDeserializationExclusionStrategy = new ExposeAnnotationDeserializationExclusionStrategy();
    private final Collection<ExclusionStrategy> exclusionStrategies = new HashSet<ExclusionStrategy>();
    private double ignoreVersionsAfter;
    private ModifierBasedExclusionStrategy modifierBasedExclusionStrategy;
    private boolean serializeInnerClasses;
    private boolean excludeFieldsWithoutExposeAnnotation;
    private LongSerializationPolicy longSerializationPolicy;
    private FieldNamingStrategy fieldNamingPolicy;
    private final ParameterizedTypeHandlerMap<InstanceCreator<?>> instanceCreators;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    private boolean serializeNulls;
    private NamespacePrefixMapper prefixMapper;
    private String datePattern;
    private int dateStyle;
    private int timeStyle;
    private boolean serializeSpecialFloatingPointValues;
    private boolean escapeHtmlChars;
    private boolean prettyPrinting;
    private boolean generateNonExecutableJson;

    public GsonBuilder() {
        this.exclusionStrategies.add(Gson.DEFAULT_ANON_LOCAL_CLASS_EXCLUSION_STRATEGY);
        this.exclusionStrategies.add(Gson.DEFAULT_SYNTHETIC_FIELD_EXCLUSION_STRATEGY);
        this.ignoreVersionsAfter = -1.0;
        this.serializeInnerClasses = true;
        this.prettyPrinting = false;
        this.escapeHtmlChars = true;
        this.modifierBasedExclusionStrategy = Gson.DEFAULT_MODIFIER_BASED_EXCLUSION_STRATEGY;
        this.excludeFieldsWithoutExposeAnnotation = false;
        this.longSerializationPolicy = LongSerializationPolicy.DEFAULT;
        this.fieldNamingPolicy = Gson.DEFAULT_NAMING_POLICY;
        this.instanceCreators = new ParameterizedTypeHandlerMap();
        this.serializers = new ParameterizedTypeHandlerMap();
        this.deserializers = new ParameterizedTypeHandlerMap();
        this.serializeNulls = false;
        this.prefixMapper = null;
        this.dateStyle = 2;
        this.timeStyle = 2;
        this.serializeSpecialFloatingPointValues = false;
        this.generateNonExecutableJson = false;
    }

    public GsonBuilder setVersion(double ignoreVersionsAfter) {
        this.ignoreVersionsAfter = ignoreVersionsAfter;
        return this;
    }

    public GsonBuilder excludeFieldsWithModifiers(int ... modifiers) {
        this.modifierBasedExclusionStrategy = new ModifierBasedExclusionStrategy(modifiers);
        return this;
    }

    public GsonBuilder generateNonExecutableJson() {
        this.generateNonExecutableJson = true;
        return this;
    }

    public GsonBuilder excludeFieldsWithoutExposeAnnotation() {
        this.excludeFieldsWithoutExposeAnnotation = true;
        return this;
    }

    public GsonBuilder serializeNulls() {
        this.serializeNulls = true;
        return this;
    }

    public GsonBuilder includePrefixes(NamespacePrefixMapper prefixMapper) {
        this.prefixMapper = prefixMapper;
        return this;
    }

    public GsonBuilder disableInnerClassSerialization() {
        this.serializeInnerClasses = false;
        return this;
    }

    public GsonBuilder setLongSerializationPolicy(LongSerializationPolicy serializationPolicy) {
        this.longSerializationPolicy = serializationPolicy;
        return this;
    }

    public GsonBuilder setFieldNamingPolicy(FieldNamingPolicy namingConvention) {
        return this.setFieldNamingStrategy(namingConvention.getFieldNamingPolicy());
    }

    public GsonBuilder setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingPolicy = new SerializedNameAnnotationInterceptingNamingPolicy(fieldNamingStrategy);
        return this;
    }

    public GsonBuilder setExclusionStrategies(ExclusionStrategy ... strategies) {
        ExclusionStrategy[] exclusionStrategyArray = strategies;
        int n = strategies.length;
        int n2 = 0;
        while (n2 < n) {
            ExclusionStrategy strategy = exclusionStrategyArray[n2];
            this.exclusionStrategies.add(strategy);
            ++n2;
        }
        return this;
    }

    public GsonBuilder setPrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }

    public GsonBuilder disableHtmlEscaping() {
        this.escapeHtmlChars = false;
        return this;
    }

    public GsonBuilder setDateFormat(String pattern) {
        this.datePattern = pattern;
        return this;
    }

    public GsonBuilder setDateFormat(int style) {
        this.dateStyle = style;
        this.datePattern = null;
        return this;
    }

    public GsonBuilder setDateFormat(int dateStyle, int timeStyle) {
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.datePattern = null;
        return this;
    }

    public GsonBuilder registerTypeAdapter(Type type, Object typeAdapter) {
        Preconditions.checkArgument(typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer || typeAdapter instanceof InstanceCreator);
        if (typeAdapter instanceof InstanceCreator) {
            this.registerInstanceCreator(type, (InstanceCreator)typeAdapter);
        }
        if (typeAdapter instanceof JsonSerializer) {
            this.registerSerializer(type, (JsonSerializer)typeAdapter);
        }
        if (typeAdapter instanceof JsonDeserializer) {
            this.registerDeserializer(type, (JsonDeserializer)typeAdapter);
        }
        return this;
    }

    private <T> GsonBuilder registerInstanceCreator(Type typeOfT, InstanceCreator<? extends T> instanceCreator) {
        this.instanceCreators.register(typeOfT, instanceCreator);
        return this;
    }

    private <T> GsonBuilder registerSerializer(Type typeOfT, JsonSerializer<T> serializer) {
        this.serializers.register(typeOfT, serializer);
        return this;
    }

    private <T> GsonBuilder registerDeserializer(Type typeOfT, JsonDeserializer<T> deserializer) {
        this.deserializers.register(typeOfT, new JsonDeserializerExceptionWrapper<T>(deserializer));
        return this;
    }

    public GsonBuilder serializeSpecialFloatingPointValues() {
        this.serializeSpecialFloatingPointValues = true;
        return this;
    }

    public Gson create() {
        LinkedList<ExclusionStrategy> serializationStrategies = new LinkedList<ExclusionStrategy>(this.exclusionStrategies);
        LinkedList<ExclusionStrategy> deserializationStrategies = new LinkedList<ExclusionStrategy>(this.exclusionStrategies);
        serializationStrategies.add(this.modifierBasedExclusionStrategy);
        deserializationStrategies.add(this.modifierBasedExclusionStrategy);
        if (!this.serializeInnerClasses) {
            serializationStrategies.add(innerClassExclusionStrategy);
            deserializationStrategies.add(innerClassExclusionStrategy);
        }
        if (this.ignoreVersionsAfter != -1.0) {
            serializationStrategies.add(new VersionExclusionStrategy(this.ignoreVersionsAfter));
            deserializationStrategies.add(new VersionExclusionStrategy(this.ignoreVersionsAfter));
        }
        if (this.excludeFieldsWithoutExposeAnnotation) {
            serializationStrategies.add(exposeAnnotationSerializationExclusionStrategy);
            deserializationStrategies.add(exposeAnnotationDeserializationExclusionStrategy);
        }
        DisjunctionExclusionStrategy serializationExclusionStrategy = new DisjunctionExclusionStrategy(serializationStrategies);
        DisjunctionExclusionStrategy deserializationExclusionStrategy = new DisjunctionExclusionStrategy(deserializationStrategies);
        ParameterizedTypeHandlerMap<JsonSerializer<?>> customSerializers = this.serializers.copyOf();
        ParameterizedTypeHandlerMap<JsonDeserializer<?>> customDeserializers = this.deserializers.copyOf();
        GsonBuilder.addTypeAdaptersForDate(this.datePattern, this.dateStyle, this.timeStyle, customSerializers, customDeserializers);
        customSerializers.registerIfAbsent(DefaultTypeAdapters.getDefaultSerializers(this.serializeSpecialFloatingPointValues, this.longSerializationPolicy));
        customDeserializers.registerIfAbsent(DefaultTypeAdapters.getDefaultDeserializers());
        ParameterizedTypeHandlerMap<InstanceCreator<?>> customInstanceCreators = this.instanceCreators.copyOf();
        customInstanceCreators.registerIfAbsent(DefaultTypeAdapters.getDefaultInstanceCreators());
        customSerializers.makeUnmodifiable();
        customDeserializers.makeUnmodifiable();
        this.instanceCreators.makeUnmodifiable();
        MappedObjectConstructor objConstructor = new MappedObjectConstructor(customInstanceCreators);
        JsonFormatter formatter = this.prettyPrinting ? new JsonPrintFormatter(this.escapeHtmlChars) : new JsonCompactFormatter(this.escapeHtmlChars);
        Gson gson = new Gson(serializationExclusionStrategy, deserializationExclusionStrategy, this.fieldNamingPolicy, objConstructor, formatter, this.serializeNulls, this.prefixMapper, customSerializers, customDeserializers, this.generateNonExecutableJson);
        return gson;
    }

    private static void addTypeAdaptersForDate(String datePattern, int dateStyle, int timeStyle, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers) {
        if (!serializers.hasSpecificHandlerFor((Type)((Object)Date.class)) && !deserializers.hasSpecificHandlerFor((Type)((Object)Date.class))) {
            DefaultTypeAdapters.DefaultDateTypeAdapter dateTypeAdapter = null;
            if (datePattern != null && !"".equals(datePattern.trim())) {
                dateTypeAdapter = new DefaultTypeAdapters.DefaultDateTypeAdapter(datePattern);
            } else if (dateStyle != 2 && timeStyle != 2) {
                dateTypeAdapter = new DefaultTypeAdapters.DefaultDateTypeAdapter(dateStyle, timeStyle);
            }
            if (dateTypeAdapter != null) {
                serializers.register((Type)((Object)Date.class), dateTypeAdapter);
                deserializers.register((Type)((Object)Date.class), dateTypeAdapter);
            }
        }
    }
}

