/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.common.emf.AttributeConstraint;
import com.ibm.ram.common.emf.EMFFactory;
import com.ibm.ram.defaultprofile.util.Utilities;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class RAMAttributeConstraint {
    private AttributeConstraint fAttributeConstraint;
    private RAMAssetAttribute fAssetAttribute;
    private RAMAssetType fAssetType;
    private String fURI;

    RAMAttributeConstraint(RAMAssetType assetType, AttributeConstraint constraint) {
        this.fAssetType = assetType;
        this.fAttributeConstraint = constraint;
    }

    RAMAttributeConstraint(RAMAssetType assetType, RAMAssetAttribute assetAttribute, boolean required) {
        this.fAssetType = assetType;
        this.fAssetAttribute = assetAttribute;
        this.fAttributeConstraint = EMFFactory.eINSTANCE.createAttributeConstraint();
        String URI2 = Utilities.getClassificationSchemaURIString(assetAttribute.getURI(), assetType.getSession().getResourceSet());
        this.fAttributeConstraint.setAttributeName(URI2);
        this.fAttributeConstraint.setRequired(required);
    }

    public RAMAssetAttribute getAssetAttribute() {
        if (this.fAssetAttribute == null) {
            this.fAssetAttribute = this.fAssetType.getSession().getAssetAttributeByURI(this.getAssetAttributeURI());
        }
        return this.fAssetAttribute;
    }

    public String getAssetAttributeURI() {
        if (this.fURI == null) {
            ResourceSet rset = this.fAssetType.getSession().getResourceSet();
            this.fURI = Utilities.createClassificationSchemaURIString(this.fAttributeConstraint.getAttributeName(), rset);
        }
        return this.fURI;
    }

    public boolean isRequired() {
        return this.fAttributeConstraint.isRequired();
    }

    AttributeConstraint getInternalAttributeConstraint() {
        return this.fAttributeConstraint;
    }
}

