/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMArtifactReference;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMURLArtifact;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.ArtifactReference;
import com.ibm.ram.common.data.FolderArtifact;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.emf.ArtifactDetail;
import com.ibm.ram.common.util.ManifestBuilder;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Reference;
import com.ibm.ram.defaultprofile.Solution;
import com.ibm.ram.internal.client.IRAMArtifact;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.AssetUtil;
import com.ibm.ram.io.zip.ZipEntry;
import com.ibm.ram.io.zip.ZipFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class RAMFolderArtifact
extends FolderArtifact
implements IRAMArtifact {
    private static final Logger LOGGER = Logger.getLogger((String)RAMFolderArtifact.class.getName());
    private RAMAsset fAsset;
    private Solution fSolution;
    private com.ibm.ram.defaultprofile.Artifact fArtifact;
    private ArtifactDetail fArtifactDetail;
    private ArtifactReference fArtifactReference;

    RAMFolderArtifact(RAMAsset asset, Solution internalSolution) {
        this.fAsset = asset;
        this.fSolution = internalSolution;
        this.setPath(null);
    }

    RAMFolderArtifact(RAMAsset asset, String path, com.ibm.ram.defaultprofile.Artifact internalArtifact) {
        this.fAsset = asset;
        this.setPath(path != null ? path : "");
        this.fArtifact = internalArtifact;
    }

    protected RAMFolderArtifact(String folderPath, String folderName) {
        this.fArtifact = DefaultprofileFactory.eINSTANCE.createArtifact();
        this.setPath(folderPath != null ? folderPath : "");
        this.setName(folderName);
        super.setChildren(new Artifact[0]);
    }

    public RAMFolderArtifact(String folderName) {
        this.fArtifact = DefaultprofileFactory.eINSTANCE.createArtifact();
        this.setName(folderName);
        super.setPath("");
        super.setChildren(new Artifact[0]);
    }

    public void addArtifact(Artifact artifact) throws RAMRuntimeException {
        this.addArtifact("", artifact);
    }

    public void addArtifact(String relativePath, Artifact artifactimpl) {
        if (!(artifactimpl instanceof IRAMArtifact)) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMFolderArtifact.1"), true);
        }
        IRAMArtifact artifact = (IRAMArtifact)((Object)artifactimpl);
        if (super.getChildren() == null && this.getAsset().isUpdate()) {
            this.getChildren();
        }
        String label = artifactimpl.getLabel();
        String mimeType = artifactimpl.getMimeType();
        String myPath = null;
        myPath = this.getPath() == null ? "" : (this.getPath().equals("") ? this.getName() : String.valueOf(this.getPath()) + "/" + this.getName());
        if (relativePath == null || relativePath.equals("")) {
            Artifact[] children;
            if (this.getAsset() != null) {
                Reference ref;
                artifact.setAsset(this.getAsset());
                String hack1028Path = "/" + myPath;
                com.ibm.ram.defaultprofile.Artifact internalArtifact = this.getAsset().getManifestBuilder().getArtifact(hack1028Path, artifactimpl.getName());
                com.ibm.ram.defaultprofile.Artifact storedArtifact = RAMFolderArtifact.getInternalArtifact(artifact);
                if (label == null) {
                    String string = label = storedArtifact != null ? this.getAsset().getManifestBuilder().getLabel(storedArtifact) : null;
                }
                if (mimeType == null) {
                    mimeType = storedArtifact != null ? this.getAsset().getManifestBuilder().getFormat(storedArtifact) : null;
                }
                Reference reference = ref = storedArtifact != null ? storedArtifact.getReference() : null;
                if (internalArtifact != null && !internalArtifact.equals(storedArtifact)) {
                    if (label == null) {
                        label = this.getAsset().getManifestBuilder().getLabel(internalArtifact);
                    }
                    if (mimeType == null) {
                        mimeType = this.getAsset().getManifestBuilder().getFormat(internalArtifact);
                    }
                    if (ref == null) {
                        ref = internalArtifact.getReference();
                    }
                    this.getAsset().getManifestBuilder().removeArtifact(internalArtifact);
                    internalArtifact = null;
                }
                if (internalArtifact == null) {
                    String path;
                    com.ibm.ram.defaultprofile.Artifact newArtifact = null;
                    String string = this.getPath() == null ? artifactimpl.getName() : (path = UtilitiesCommon.isEmptyString(this.getPath()) ? String.valueOf(this.getName()) + "/" + artifactimpl.getName() : String.valueOf(this.getPath()) + "/" + this.getName() + "/" + artifactimpl.getName());
                    if (artifact instanceof FolderArtifact) {
                        newArtifact = this.getAsset().getManifestBuilder().addArtifactFolder(this.getInternalArtifact(), artifactimpl.getName());
                        RAMFolderArtifact.setInternalArtifact(artifact, newArtifact);
                    } else if (artifact instanceof RAMURLArtifact) {
                        newArtifact = this.getAsset().getManifestBuilder().addArtifactUrl(this.getInternalArtifact(), artifactimpl.getName(), ((RAMURLArtifact)artifact).getURL());
                        RAMFolderArtifact.setInternalArtifact(artifact, newArtifact);
                    } else {
                        if (artifact instanceof LocalFileArtifact) {
                            try {
                                LocalFileArtifact localFileArtifact = (LocalFileArtifact)artifact;
                                File localFile = localFileArtifact.getFile();
                                this.getAsset().getDeltaAssetFileBuilder().addFileToDelta(localFile, path);
                            }
                            catch (IOException e) {
                                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                            }
                        }
                        newArtifact = this.getAsset().getManifestBuilder().addArtifact(this.getInternalArtifact(), artifactimpl.getName(), "", artifactimpl.getSize(), new Timestamp(artifactimpl.getCreationDate()));
                        RAMFolderArtifact.setInternalArtifact(artifact, newArtifact);
                        if (mimeType != null) {
                            this.getAsset().getManifestBuilder().setFormat(mimeType, newArtifact);
                        }
                    }
                    if (this.getAsset().getArtifactsToRemove().contains(path)) {
                        this.getAsset().getArtifactsToRemove().remove(path);
                    }
                    if (label != null) {
                        this.getAsset().getManifestBuilder().setLabel(label, newArtifact);
                    }
                    if (ref != null) {
                        newArtifact.setReference(ref);
                    }
                }
            }
            if ((children = super.getChildren()) == null) {
                children = new Artifact[]{artifactimpl};
            } else {
                boolean replace = false;
                int i = 0;
                while (i < children.length) {
                    if (artifactimpl.getName().equals(children[i].getName())) {
                        children[i] = artifactimpl;
                        replace = true;
                        break;
                    }
                    ++i;
                }
                if (!replace) {
                    Artifact[] tmp = children;
                    children = new Artifact[tmp.length + 1];
                    System.arraycopy(tmp, 0, children, 0, tmp.length);
                    children[tmp.length] = artifactimpl;
                }
            }
            artifactimpl.setPath(myPath);
            super.setChildren(children);
        } else {
            String subFolderName = relativePath;
            String relPath = "";
            int index = relativePath.indexOf("/");
            if (index != -1) {
                subFolderName = relativePath.substring(0, index);
                relPath = relativePath.substring(index + 1);
            }
            RAMFolderArtifact folder = null;
            Artifact[] children = super.getChildren();
            if (children == null) {
                children = new Artifact[]{};
            } else {
                Artifact[] kids = children;
                int i = 0;
                while (i < kids.length) {
                    if (subFolderName.equals(kids[i].getName())) {
                        folder = (RAMFolderArtifact)kids[i];
                        break;
                    }
                    ++i;
                }
            }
            if (folder == null) {
                Artifact[] tmp = children;
                children = new Artifact[tmp.length + 1];
                System.arraycopy(tmp, 0, children, 0, tmp.length);
                if (this.getAsset() != null) {
                    com.ibm.ram.defaultprofile.Artifact folderArtifact = this.getAsset().getManifestBuilder().addArtifactFolder(this.getInternalArtifact(), subFolderName);
                    folder = new RAMFolderArtifact(this.getAsset(), myPath, folderArtifact);
                } else {
                    folder = new RAMFolderArtifact(myPath, subFolderName);
                }
                children[tmp.length] = folder;
            }
            super.setChildren(children);
            folder.addArtifact(relPath, artifactimpl);
        }
        if (artifact instanceof RAMFolderArtifact) {
            RAMFolderArtifact folderArtifact = (RAMFolderArtifact)artifact;
            Artifact[] children = folderArtifact.getChildren();
            int i = 0;
            while (i < children.length) {
                folderArtifact.addArtifact(children[i]);
                ++i;
            }
        }
        if (this.getAsset() != null) {
            this.getAsset().setAssetDirty(true);
        }
    }

    public boolean removeArtifact(Artifact artifact) {
        String relPath = artifact.getPath();
        boolean ret = false;
        if (this.getPath() != null && !this.getPath().equals("")) {
            String path = this.getPath();
            if (!relPath.startsWith(path)) {
                return ret;
            }
            if ((relPath = relPath.substring(path.length())).length() > 0) {
                relPath = String.valueOf(relPath) + "/";
            }
        } else {
            relPath = "";
        }
        relPath = String.valueOf(relPath) + artifact.getName();
        ret = this.removeArtifact(relPath);
        return ret;
    }

    public boolean removeArtifact(String relativePath) {
        relativePath = this.stripFileDelims(relativePath);
        int index = relativePath.indexOf("/");
        String name = relativePath;
        String remainingPath = null;
        boolean isMyChild = index == -1;
        boolean ret = false;
        if (!isMyChild) {
            name = relativePath.substring(0, index);
            remainingPath = relativePath.substring(index + 1);
        }
        Object[] children = this.getChildren();
        ManifestBuilder builder = this.getAsset().getManifestBuilder();
        int i = 0;
        while (i < children.length) {
            Artifact child = children[i];
            if (name.equals(child.getName())) {
                if (isMyChild) {
                    com.ibm.ram.defaultprofile.Artifact internalArtifact = RAMFolderArtifact.getInternalArtifact((IRAMArtifact)((Object)child));
                    if ("folder".equals(child.getType()) && child instanceof FolderArtifact) {
                        FolderArtifact folderArtifact = (FolderArtifact)child;
                        this.markFolderChildrenForDeletion(folderArtifact);
                    } else {
                        this.getAsset().getArtifactsToRemove().add(this.getArtifactFullPath(child.getPath(), child.getName()));
                    }
                    builder.removeArtifact(internalArtifact);
                    Object[] newChildren = super.getChildren();
                    newChildren = new Artifact[children.length - 1];
                    AssetUtil.removeIth(children, newChildren, i);
                    super.setChildren((Artifact[])newChildren);
                    ret = true;
                    break;
                }
                ret = ((RAMFolderArtifact)child).removeArtifact(remainingPath);
                break;
            }
            ++i;
        }
        if (ret) {
            this.getAsset().setAssetDirty(true);
        }
        return ret;
    }

    private void markFolderChildrenForDeletion(FolderArtifact folderArtifact) {
        Artifact[] kids = folderArtifact.getChildren();
        int j = 0;
        while (j < kids.length) {
            Artifact kid = kids[j];
            if ("folder".equals(kid.getType()) && kid instanceof FolderArtifact) {
                FolderArtifact childFolder = (FolderArtifact)kid;
                this.markFolderChildrenForDeletion(childFolder);
            } else {
                this.getAsset().getArtifactsToRemove().add(this.getArtifactFullPath(kid.getPath(), kid.getName()));
            }
            ++j;
        }
    }

    protected String getArtifactFullPath(String path, String artifactName) {
        if ("/".equals(path) || UtilitiesCommon.isEmptyString(path)) {
            return artifactName;
        }
        if (path.charAt(0) == '/') {
            return String.valueOf(path.substring(1)) + "/" + artifactName;
        }
        return String.valueOf(path) + "/" + artifactName;
    }

    public Artifact getChild(String path) {
        boolean isMyChild;
        Artifact ret = null;
        path = this.stripFileDelims(path);
        int index = path.indexOf("/");
        String name = path;
        String remainingPath = null;
        boolean bl = isMyChild = index == -1;
        if (!isMyChild) {
            name = path.substring(0, index);
            remainingPath = path.substring(index + 1);
        }
        Artifact[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Artifact child = children[i];
            if (name.equals(child.getName())) {
                if (isMyChild) {
                    ret = child;
                    break;
                }
                ret = ((RAMFolderArtifact)child).getChild(remainingPath);
                break;
            }
            ++i;
        }
        return ret;
    }

    private String stripFileDelims(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    @Override
    public Artifact[] getChildren() {
        Artifact[] children = super.getChildren();
        if (children == null) {
            children = this.processSolutionChildren();
        }
        return children;
    }

    Artifact[] processSolutionChildren() {
        Artifact[] children = null;
        if (this.hasChildren()) {
            if (this.fSolution != null) {
                ArrayList<Artifact> ret = new ArrayList<Artifact>();
                int i = 0;
                while (i < this.fSolution.getArtifact().size()) {
                    com.ibm.ram.defaultprofile.Artifact artifact = (com.ibm.ram.defaultprofile.Artifact)this.fSolution.getArtifact().get(i);
                    if ("folder".equals(artifact.getType())) {
                        ret.add(new RAMFolderArtifact(this.getAsset(), "", artifact));
                    } else if (ManifestBuilder.isURLArtifact(artifact) || ManifestBuilder.isURLCacheArtifact(artifact)) {
                        ret.add(new RAMURLArtifact(this.getAsset(), "", artifact));
                    } else if (!ManifestBuilder.isFileCacheArtifact(artifact)) {
                        ret.add(new RAMArtifact(this.getAsset(), "", artifact));
                    }
                    ++i;
                }
                children = ret.toArray(new Artifact[ret.size()]);
            } else {
                ArrayList<Artifact> ret = new ArrayList<Artifact>();
                String subPath = this.getPath();
                subPath = subPath == null ? "" : (subPath.equals("") ? this.getName() : String.valueOf(subPath) + "/" + this.getName());
                int i = 0;
                while (i < this.getInternalArtifact().getArtifact().size()) {
                    com.ibm.ram.defaultprofile.Artifact artifact = (com.ibm.ram.defaultprofile.Artifact)this.getInternalArtifact().getArtifact().get(i);
                    if ("folder".equals(artifact.getType())) {
                        ret.add(new RAMFolderArtifact(this.getAsset(), subPath, artifact));
                    } else if (ManifestBuilder.isURLArtifact(artifact) || ManifestBuilder.isURLCacheArtifact(artifact)) {
                        ret.add(new RAMURLArtifact(this.getAsset(), subPath, artifact));
                    } else if (!ManifestBuilder.isFileCacheArtifact(artifact)) {
                        ret.add(new RAMArtifact(this.getAsset(), subPath, artifact));
                    }
                    children = ret.toArray(new Artifact[ret.size()]);
                    ++i;
                }
            }
        } else {
            children = new Artifact[]{};
        }
        super.setChildren(children);
        return children;
    }

    @Override
    public boolean hasChildren() {
        boolean ret = false;
        if (super.getChildren() != null) {
            ret = super.getChildren().length > 0;
        } else if (this.fSolution != null && this.fSolution.getArtifact() != null && this.fSolution.getArtifact().size() > 0) {
            ret = true;
        } else if (this.getInternalArtifact() != null && this.getInternalArtifact().getArtifact() != null && this.getInternalArtifact().getArtifact().size() > 0) {
            ret = true;
        }
        return ret;
    }

    void setAsRoot(RAMAsset asset, Solution internalSolution, boolean keepChildren) {
        this.fAsset = asset;
        this.fSolution = internalSolution;
        this.setPath(null);
        if (!keepChildren) {
            this.synchChildren(super.getChildren());
        }
    }

    void setAsRoot(RAMAsset asset, Solution internalSolution) {
        this.setAsRoot(asset, internalSolution, false);
    }

    private void synchChildren(Artifact[] children) throws RAMRuntimeException {
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                Artifact artifact = children[i];
                this.addArtifact(artifact);
                if (children[i] instanceof RAMFolderArtifact) {
                    RAMFolderArtifact folder = (RAMFolderArtifact)children[i];
                    folder.synchChildren(folder.getChildren());
                }
                ++i;
            }
        }
    }

    public Artifact[] computeArtifactsAsFlatList(IProgressMonitor monitor) {
        Artifact[] currentArtifacts = this.getChildren();
        ArrayList artifacts = new ArrayList();
        this.processArtifactChildren(currentArtifacts, artifacts, monitor);
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    private void processArtifactChildren(Artifact[] currentArtifacts, List artifacts, IProgressMonitor monitor) {
        if (currentArtifacts.length == 0) {
            monitor.beginTask(MessageFormat.format(ClientMessages.getString("RAMFolderArtifact.COMPUTE_CHILDREN"), this.getAsset().getName()), 1);
            monitor.worked(1);
        } else {
            monitor.beginTask(MessageFormat.format(ClientMessages.getString("RAMFolderArtifact.COMPUTE_CHILDREN"), this.getAsset().getName()), currentArtifacts.length);
            int i = 0;
            while (!monitor.isCanceled() && i < currentArtifacts.length) {
                Artifact artifact = currentArtifacts[i];
                monitor.subTask(artifact.getName());
                if ("folder".equals(artifact.getType())) {
                    FolderArtifact child = (FolderArtifact)artifact;
                    if (artifact != null && child.getChildren().length > 0) {
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                        this.processArtifactChildren(child.getChildren(), artifacts, (IProgressMonitor)subMonitor);
                    } else {
                        artifacts.add(currentArtifacts[i]);
                        monitor.worked(1);
                    }
                } else {
                    artifacts.add(currentArtifacts[i]);
                    monitor.worked(1);
                }
                ++i;
            }
        }
        monitor.done();
    }

    @Override
    public String getPath() {
        if (this.fSolution != null) {
            return null;
        }
        if (super.getPath() == null) {
            EObject parent = this.fArtifact.eContainer();
            if (parent instanceof com.ibm.ram.defaultprofile.Artifact) {
                this.setPath(((com.ibm.ram.defaultprofile.Artifact)parent).computePathInSolution("/"));
            } else {
                this.setPath("");
            }
        }
        return super.getPath();
    }

    @Override
    public void setPath(String path) {
        if (path != null && path.startsWith("/")) {
            super.setPath(path.substring(1));
        } else {
            super.setPath(path);
        }
    }

    com.ibm.ram.defaultprofile.Artifact getInternalArtifact() throws RAMRuntimeException {
        if (this.fSolution != null) {
            return null;
        }
        return this.fArtifact;
    }

    Solution getInternalSolution() throws RAMRuntimeException {
        return this.fSolution;
    }

    @Override
    public RAMAsset getAsset() {
        return this.fAsset;
    }

    @Override
    public void setAsset(RAMAsset asset) {
        this.fAsset = asset;
    }

    void setInternalArtifact(com.ibm.ram.defaultprofile.Artifact artifact) {
        this.fArtifact = artifact;
        super.setPath(null);
    }

    @Override
    public String getName() {
        if (this.fArtifact == null) {
            return super.getName();
        }
        return this.fArtifact.getName();
    }

    @Override
    public void setName(String name) {
        if (this.fArtifact != null) {
            this.fArtifact.setName(name);
        }
        super.setName(name);
    }

    @Override
    public long getCreationDate() {
        if (this.fArtifactDetail == null) {
            this.fecthArtifactDetail();
        }
        long time = -1L;
        if (this.fArtifactDetail != null) {
            time = this.fArtifactDetail.getCreationDate().getTime();
        }
        return time;
    }

    @Override
    public long getSize() {
        if (this.fArtifactDetail == null) {
            this.fecthArtifactDetail();
        }
        long size = -1L;
        if (this.fArtifactDetail != null) {
            size = this.fArtifactDetail.getSize();
        }
        return size;
    }

    private void fecthArtifactDetail() {
    }

    static com.ibm.ram.defaultprofile.Artifact getInternalArtifact(IRAMArtifact artifact) {
        if (artifact instanceof RAMArtifact) {
            return ((RAMArtifact)artifact).getInternalArtifact();
        }
        if (artifact instanceof RAMURLArtifact) {
            return ((RAMURLArtifact)artifact).getInternalArtifact();
        }
        if (artifact instanceof RAMFolderArtifact) {
            return ((RAMFolderArtifact)artifact).getInternalArtifact();
        }
        return null;
    }

    static void setInternalArtifact(IRAMArtifact iArtifact, com.ibm.ram.defaultprofile.Artifact artifact) {
        if (iArtifact instanceof RAMArtifact) {
            ((RAMArtifact)iArtifact).setInternalArtifact(artifact);
        } else if (iArtifact instanceof RAMURLArtifact) {
            ((RAMURLArtifact)iArtifact).setInternalArtifact(artifact);
        } else if (iArtifact instanceof RAMFolderArtifact) {
            ((RAMFolderArtifact)iArtifact).setInternalArtifact(artifact);
        }
    }

    @Override
    public void setChildren(Artifact[] children) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public String getLabel() {
        if (this.fAsset != null) {
            return this.getAsset().getManifestBuilder().getLabel(this.fArtifact);
        }
        return super.getLabel();
    }

    @Override
    public ArtifactReference getReference() {
        if (this.fArtifactReference == null) {
            this.fArtifactReference = new RAMArtifactReference(this);
        }
        return this.fArtifactReference;
    }

    @Override
    public void setCreationDate(long creationDate) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setLabel(String label) {
        if (this.fAsset != null) {
            this.getAsset().getManifestBuilder().setLabel(label, this.fArtifact);
        } else {
            super.setLabel(label);
        }
    }

    @Override
    public void setReference(ArtifactReference reference) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setSize(long size) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setType(String type) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMArtifact.METHOD_NOT_IMPLEMENTED"), true);
    }

    public void addZipFileContentAsArtifact(String path, File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration zipEntries = zipFile.entries();
            RAMAsset asset = this.getAsset();
            while (zipEntries.hasMoreElements()) {
                asset.getManifestBuilder().addArtifact((ZipEntry)zipEntries.nextElement(), path);
            }
            String pathToStrip = file.getParent();
            asset.getDeltaAssetFileBuilder().addZipFileToDelta(file, pathToStrip, path);
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)("NullPointerException  thrown while adding a zip artifact:" + file.getName()), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("FileNotFoundException thrown while adding a zip artifact:" + file.getName()), (Throwable)e);
        }
        catch (ZipException e) {
            LOGGER.error((Object)("FileNotFoundException thrown while adding a zip artifact:" + file.getName()), (Throwable)e);
        }
        catch (IOException iOException) {}
    }
}

