/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.emf.ArtifactDetail;
import com.ibm.ram.common.emf.ArtifactDetails;
import com.ibm.ram.common.emf.EMFPackage;
import com.ibm.ram.common.emf.util.ArtifactAdapter;
import com.ibm.ram.common.util.ArtifactCacheUtil;
import com.ibm.ram.common.util.ManifestBuilder;
import com.ibm.ram.common.util.RAMResourceSet;
import com.ibm.ram.common.util.RAMURIConverter;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.defaultprofile.ArtifactType;
import com.ibm.ram.defaultprofile.Asset;
import com.ibm.ram.defaultprofile.Classification;
import com.ibm.ram.defaultprofile.ClassificationSchema;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.DefaultprofilePackage;
import com.ibm.ram.defaultprofile.Description;
import com.ibm.ram.defaultprofile.Descriptor;
import com.ibm.ram.defaultprofile.DescriptorGroup;
import com.ibm.ram.defaultprofile.FreeFormDescriptor;
import com.ibm.ram.defaultprofile.FreeFormValue;
import com.ibm.ram.defaultprofile.NodeDescriptor;
import com.ibm.ram.defaultprofile.RelatedAsset;
import com.ibm.ram.defaultprofile.Solution;
import com.ibm.ram.defaultprofile.util.Utilities;
import com.ibm.ram.io.zip.ZipEntry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;

public class ManifestAccessor {
    public static final String SELF_DEFINED_ATTRIBUTE_ID_PREFIX = "ca.";
    protected static Logger LOGGER = Logger.getLogger(ManifestAccessor.class);
    public static final Map<Object, Object> SAVE_OPTIONS = new HashMap<Object, Object>();
    public static final Map<Object, Object> LOAD_OPTIONS = new HashMap<Object, Object>();
    protected Asset manifest;
    protected ArtifactDetails artifactDetails;
    protected Properties languageProps;
    public static final String NAME = "name";
    public static final String SHORT_DESCRIPTION = "shortDescription";
    public static final String DESCRIPTION = "longDescription";
    public static final String CLASSIFICATION_SCHEMA_URI_PATH_SEGMENT = "classif";
    public static final String CLASSIFICATION_SCHEMA_URI_PATH_PART = "classif/";
    public static final String REVISION_COUNT_FFD_NAME = "revisionCount";
    protected Map<URI, ClassificationInfo> schemaURIToInfo;
    protected Map<ClassificationSchema, ClassificationInfo> schemaToInfo;
    protected Map<URI, ClassificationInfo> unmodSchemaURIToInfo;
    protected boolean includeOtherSchemas;
    private static final ClassificationSchema DEAD_SCHEMA;
    public static final String SCALE_PERSON_HOURS = "person hours";
    public static final String SCALE_PERSON_DAYS = "person days";
    public static final String SCALE_PERSON_MONTHS = "person months";
    public static final String SCALE_PERSON_YEARS = "person years";
    public static final String SCALE_PERSON_HOURS_KEY = "person_hours";
    public static final String SCALE_PERSON_DAYS_KEY = "person_days";
    public static final String SCALE_PERSON_MONTHS_KEY = "person_months";
    public static final String SCALE_PERSON_YEARS_KEY = "person_years";
    protected Map<String, CustomAttribute> uriStringsToCustomAttributes;
    protected DescriptorGroup customAttributeGroup;
    protected Map<String, CustomAttribute> unmodUriStringToCustomAttributes;
    protected ArtifactAdapter artifactAdapter;
    protected boolean includeOtherCustomAttributes;
    protected Map<String, CustomAttribute> selfDefinedCustomAttributeNamesToCustomAttributes;
    protected CommunityInformation community;
    protected Integer assetDbid;
    protected String stateId;
    public static final String STANDARD_INFO_DESCRIPTORGROUP_NAME = "StandardInfo";
    public static final String ASSETTYPE_DESCRIPTORGROUP_NAME = "AssetType";
    public static final String CREATIONTIME_DESCRIPTORGROUP_NAME = "CreationTime";
    public static final String USAGETIME_DESCRIPTORGROUP_NAME = "UsageTime";
    public static final String CUSTOMATTRIBUTES_DESCRIPTORGROUP_NAME = "CustomAttributes";
    public static final String FOLDER_ARTIFACT_TYPE = "folder";
    public static final String URL_ARTIFACT_TYPE = "url";
    public static final String REFERENCE_KIND_URL = "url";
    public static final String URL_CACHE_ARTIFACT_TYPE = "url_cache";
    public static final String FILE_CACHE_ARTIFACT_TYPE = "com.ibm.ram.url.cache";
    public static final String MANIFEST_NAME = "manifest.rmd";
    public static final String RAM_METADATA_FOLDER = ".com.ibm.ram.data";
    public static final String RAM_METADATA_FOLDER_FULL_PATH = "/.com.ibm.ram.data";
    public static final String RAM_METADATA_FOLDER_TRANSIENT_PATH = ".com.ibm.ram.data/.transient";
    protected static final Set<String> STANDARD_GROUP_NAMES;

    static {
        SAVE_OPTIONS.put("ENCODING", "UTF-8");
        SAVE_OPTIONS.put("PROCESS_DANGLING_HREF", "DISCARD");
        SAVE_OPTIONS.put("LINE_WIDTH", new Integer(100));
        LOAD_OPTIONS.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        DEAD_SCHEMA = DefaultprofileFactory.eINSTANCE.createClassificationSchema();
        ((InternalEObject)DEAD_SCHEMA).eSetProxyURI(URI.createURI((String)"NO_GOOD_TO_RESOLVE"));
        STANDARD_GROUP_NAMES = new HashSet<String>();
        STANDARD_GROUP_NAMES.add(STANDARD_INFO_DESCRIPTORGROUP_NAME);
        STANDARD_GROUP_NAMES.add(CREATIONTIME_DESCRIPTORGROUP_NAME);
        STANDARD_GROUP_NAMES.add(USAGETIME_DESCRIPTORGROUP_NAME);
        STANDARD_GROUP_NAMES.add(CUSTOMATTRIBUTES_DESCRIPTORGROUP_NAME);
        STANDARD_GROUP_NAMES.add(ASSETTYPE_DESCRIPTORGROUP_NAME);
    }

    public static ResourceSet createResourceSet(String serverPath) {
        return ManifestAccessor.createResourceSet(new ManifestBuilderRAMURIConverter(serverPath));
    }

    public static boolean setServerPath(ResourceSet rset, String newServerPath) {
        URIConverter converter = rset.getURIConverter();
        if (converter instanceof SetServerPath) {
            ((SetServerPath)converter).setServerPath(newServerPath);
            return true;
        }
        return false;
    }

    public static String getServerPath(ResourceSet rset) {
        URIConverter converter = rset.getURIConverter();
        if (converter instanceof SetServerPath) {
            return ((SetServerPath)converter).getServerPath();
        }
        return null;
    }

    public static boolean isStandardDescriptorGroup(String descriptorGroupName) {
        return STANDARD_GROUP_NAMES.contains(descriptorGroupName);
    }

    public static boolean isFolder(Artifact artifact) {
        return artifact.getName() != null && (artifact.getArtifact().size() > 0 || FOLDER_ARTIFACT_TYPE.equals(artifact.getType()));
    }

    public static boolean isURLArtifact(Artifact artifact) {
        return artifact == null ? false : "url".equals(artifact.getType());
    }

    public static boolean isFileArtifact(Artifact artifact) {
        return !ManifestAccessor.isFolder(artifact) && !ManifestAccessor.isURLArtifact(artifact) && !ManifestAccessor.isURLCacheArtifact(artifact);
    }

    public static boolean isURLCacheArtifact(Artifact artifact) {
        return artifact == null ? false : URL_CACHE_ARTIFACT_TYPE.equals(artifact.getType());
    }

    public static boolean isFileCacheArtifact(Artifact artifact) {
        return artifact == null ? false : FILE_CACHE_ARTIFACT_TYPE.equals(ArtifactCacheUtil.getArtifactTypeFromDescription(artifact));
    }

    public static boolean isRAMMetadataArtifactFolder(Artifact artifact) {
        return artifact == null ? false : artifact.getName() != null && artifact.getName().startsWith(RAM_METADATA_FOLDER);
    }

    public static boolean isRAMMetadataArtifact(Artifact artifact) {
        EObject container;
        if (artifact != null && (container = artifact.eContainer()) instanceof Artifact) {
            return ManifestAccessor.isRAMMetadataArtifact(((Artifact)container).computePathInSolution("/"));
        }
        return false;
    }

    public static boolean isRAMMetadataArtifact(String path) {
        return path == null ? false : path.startsWith(RAM_METADATA_FOLDER_FULL_PATH);
    }

    public static String localizeManifest(Asset manifest) {
        String newPrefix;
        URIConverter uriCvtr;
        NodeDescriptor typeProxy;
        String uri;
        int typepart;
        DescriptorGroup dg;
        Iterator iterator;
        EList dgs;
        String oldPrefix = null;
        Classification cl = manifest.getClassification();
        if (cl != null && !(dgs = cl.getDescriptorGroup()).isEmpty() && (iterator = dgs.iterator()).hasNext() && ASSETTYPE_DESCRIPTORGROUP_NAME.equals((dg = (DescriptorGroup)iterator.next()).getName()) && !dg.getNodeDescriptor().isEmpty() && (typepart = (uri = EcoreUtil.getURI((EObject)(typeProxy = (NodeDescriptor)((InternalEList)dg.getNodeDescriptor()).basicGet(0))).toString()).indexOf(CLASSIFICATION_SCHEMA_URI_PATH_PART)) != -1 && (uriCvtr = manifest.eResource().getResourceSet().getURIConverter()) instanceof RAMURIConverter && !(newPrefix = ((RAMURIConverter)uriCvtr).getClassificationPrefix()).equals(oldPrefix = uri.substring(0, typepart + CLASSIFICATION_SCHEMA_URI_PATH_PART.length()))) {
            Set proxies = EcoreUtil.ProxyCrossReferencer.find((EObject)manifest).keySet();
            for (EObject eo : proxies) {
                InternalEObject proxy = (InternalEObject)eo;
                String uriString = EcoreUtil.getURI((EObject)proxy).toString();
                if (!uriString.startsWith(oldPrefix)) continue;
                int splitPoint = oldPrefix.length();
                String localURI = uriString.substring(splitPoint);
                String newURI = String.valueOf(newPrefix) + localURI;
                if (proxy.eIsProxy()) {
                    proxy.eSetProxyURI(URI.createURI((String)newURI));
                    continue;
                }
                proxy.eResource().unload();
                proxy.eSetProxyURI(URI.createURI((String)newURI));
            }
        }
        return oldPrefix;
    }

    public static ResourceSet createResourceSet(RAMURIConverter uriConverter) {
        return new RAMResourceSet(uriConverter);
    }

    public ManifestAccessor(Asset inputManifest, ArtifactDetails artifactDetails, CommunityInformation community) {
        if (inputManifest == null) {
            throw new IllegalArgumentException("Manifest cannot be null.");
        }
        XMLResource m = (XMLResource)inputManifest.eResource();
        if (m == null || m.getResourceSet() == null) {
            throw new IllegalArgumentException("Manifest must be contained in a resource and the resource must be in a resource set.");
        }
        if (artifactDetails != null && ((m = (XMLResource)artifactDetails.eResource()) == null || m.getResourceSet() == null)) {
            throw new IllegalArgumentException("ArtifactDetails must be contained in a resource and the resource must be in a resource set.");
        }
        this.community = community;
        this.setContents(inputManifest, artifactDetails);
    }

    public ManifestAccessor(Asset inputManifest, ArtifactDetails artifactDetails, CommunityInformation community, Integer assetDbid, String stateId) {
        this(inputManifest, artifactDetails, community);
        this.setAuxInfo(assetDbid, stateId);
    }

    protected void setAuxInfo(Integer assetDbid, String stateId) {
        this.assetDbid = assetDbid;
        this.stateId = stateId;
    }

    protected void setContents(Asset inputManifest, ArtifactDetails artifactDetails) {
        this.manifest = inputManifest;
        this.artifactDetails = artifactDetails;
        if (this.artifactDetails != null) {
            this.artifactDetails.setManifest(this.manifest);
        }
    }

    public ManifestAccessor(XMLResource res, XMLResource detailsResource, CommunityInformation community) {
        this((Asset)EcoreUtil.getObjectByType((Collection)res.getContents(), (EClassifier)DefaultprofilePackage.eINSTANCE.getAsset()), detailsResource != null ? (ArtifactDetails)EcoreUtil.getObjectByType((Collection)detailsResource.getContents(), (EClassifier)EMFPackage.eINSTANCE.getArtifactDetails()) : null, community);
    }

    public ManifestAccessor(XMLResource res, XMLResource detailsResource, CommunityInformation community, Integer assetDbid, String stateId) {
        this(res, detailsResource, community);
        this.setAuxInfo(assetDbid, stateId);
    }

    protected ManifestAccessor() {
    }

    public XMLResource getManifestResource() {
        return (XMLResource)this.manifest.eResource();
    }

    public ResourceSet getManifestResourceSet() {
        return this.getManifestResource().getResourceSet();
    }

    public Integer getAssetDBID() {
        return this.assetDbid;
    }

    public XMLResource getArtifactDetailsResource() {
        return (XMLResource)(this.artifactDetails != null ? this.artifactDetails.eResource() : null);
    }

    public ResourceSet getArtifactDetailsResourceSet() {
        XMLResource res = this.getArtifactDetailsResource();
        return res != null ? res.getResourceSet() : null;
    }

    public Asset getManifest() {
        return this.manifest;
    }

    public int getRevisionCount() {
        return ManifestAccessor.getRevisionCount(this.manifest);
    }

    public static int getRevisionCount(Asset manifest) {
        Classification cl = manifest.getClassification();
        if (cl != null) {
            for (DescriptorGroup group : cl.getDescriptorGroup()) {
                if (!STANDARD_INFO_DESCRIPTORGROUP_NAME.equals(group.getName())) continue;
                for (FreeFormValue ffv : group.getFreeFormValue()) {
                    if (ffv.getFreeFormDescriptor() == null || !REVISION_COUNT_FFD_NAME.equals(ffv.getFreeFormDescriptor().getName())) continue;
                    try {
                        return Integer.parseInt(ffv.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0;
                    }
                }
            }
        }
        return 0;
    }

    public String getName() {
        String shortDesc;
        if (this.languageProps != null && (shortDesc = (String)this.languageProps.get(NAME)) != null && shortDesc.length() > 0) {
            return shortDesc;
        }
        return this.manifest.getName();
    }

    public String getDate() {
        return this.manifest.getDate();
    }

    public Date getDateAsDate() {
        return this.manifest.getDataAsDate();
    }

    public String getDescription() {
        String description;
        if (this.languageProps != null && (description = (String)this.languageProps.get(DESCRIPTION)) != null && description.length() > 0) {
            return description;
        }
        Description d = this.manifest.getDescription();
        return d != null ? d.getValue() : null;
    }

    public String getId() {
        return this.manifest.getId();
    }

    public String getVersion() {
        return this.manifest.getVersion();
    }

    public String getState() {
        return this.manifest.getState();
    }

    public String getStateId() {
        return this.stateId;
    }

    public List<RelatedAsset> getRelatedAssets() {
        return this.manifest.getRelatedAsset();
    }

    public String getShortDescription() {
        String shortDesc;
        if (this.languageProps != null && (shortDesc = (String)this.languageProps.get(SHORT_DESCRIPTION)) != null && shortDesc.length() > 0) {
            return shortDesc;
        }
        return this.manifest.getShortDescription();
    }

    public String getAssetTypeLocalized() {
        return Utilities.getClassificationSchemaURIString(this.getAssetTypeURI(), this.getManifestResourceSet());
    }

    public URI getAssetTypeURI() {
        Classification cl = this.manifest.getClassification();
        if (cl != null) {
            EList descriptorGroups = cl.getDescriptorGroup();
            for (DescriptorGroup group : descriptorGroups) {
                List nodes;
                if (!ASSETTYPE_DESCRIPTORGROUP_NAME.equals(group.getName()) || (nodes = ((EcoreEList)group.getNodeDescriptor()).basicList()).isEmpty()) continue;
                return EcoreUtil.getURI((EObject)((EObject)nodes.get(0)));
            }
        }
        return null;
    }

    public Map<URI, ClassificationInfo> initializeClassifications(boolean includeOthers, Collection<URI> classificationSchemaURIs) throws IllegalStateException {
        return this.internalInitializeClassifications(includeOthers, classificationSchemaURIs);
    }

    protected Map<URI, ClassificationInfo> internalInitializeClassifications(boolean includeOthers, Collection<URI> classificationSchemaURIs) {
        this.includeOtherSchemas = includeOthers;
        if (this.schemaURIToInfo != null) {
            this.schemaURIToInfo.clear();
            this.schemaToInfo.clear();
        } else {
            this.schemaURIToInfo = new LinkedHashMap<URI, ClassificationInfo>(classificationSchemaURIs.size());
            this.unmodSchemaURIToInfo = Collections.unmodifiableMap(this.schemaURIToInfo);
            this.schemaToInfo = new HashMap<ClassificationSchema, ClassificationInfo>(classificationSchemaURIs.size());
        }
        if (!classificationSchemaURIs.isEmpty() || includeOthers) {
            for (URI uri : classificationSchemaURIs) {
                try {
                    ClassificationSchema schema = (ClassificationSchema)this.getManifestResourceSet().getEObject(uri, true);
                    if (schema == null) continue;
                    ClassificationInfo cinfo = this.createClassificationInfo(schema, uri, false);
                    this.schemaToInfo.put(schema, cinfo);
                    this.schemaURIToInfo.put(uri, cinfo);
                }
                catch (WrappedException e) {
                    if (e.exception() instanceof FileNotFoundException) continue;
                    throw e;
                }
            }
            Classification clsf = this.manifest.getClassification();
            if (clsf != null) {
                for (DescriptorGroup group : clsf.getDescriptorGroup()) {
                    if (STANDARD_GROUP_NAMES.contains(group.getName()) || !group.getContains().isEmpty() || group.getClassificationSchema().size() != 1 || !includeOthers && !this.schemaURIToInfo.containsKey(EcoreUtil.getURI((EObject)((EObject)((InternalEList.Unsettable)group.getClassificationSchema()).basicGet(0))))) continue;
                    ClassificationSchema schema = (ClassificationSchema)group.getClassificationSchema().get(0);
                    ClassificationInfo cinfo = this.schemaToInfo.get(schema);
                    if (cinfo == null && includeOthers) {
                        URI uri = EcoreUtil.getURI((EObject)schema);
                        cinfo = this.createClassificationInfo(schema, uri, true);
                        this.schemaURIToInfo.put(uri, cinfo);
                        this.schemaToInfo.put(schema, cinfo);
                    }
                    if (cinfo == null || cinfo.isSchemaSet()) continue;
                    cinfo.setDescriptorGroup(group);
                }
            }
        }
        return this.unmodSchemaURIToInfo;
    }

    protected ClassificationInfo createClassificationInfo(ClassificationSchema schema, URI uri, boolean other) {
        return new ClassificationInfo(schema, uri, other);
    }

    public Map<URI, ClassificationInfo> getClassificationInfos() {
        return this.unmodSchemaURIToInfo;
    }

    private void replaceInfo(ClassificationInfo ci, ClassificationSchema oldSchema, ClassificationSchema newSchema) {
        this.schemaToInfo.remove(oldSchema);
        this.schemaToInfo.put(newSchema, ci);
    }

    private void removeInfo(ClassificationInfo ci) {
        this.schemaToInfo.remove(ci.schema);
        ci.setDescriptorGroup(null);
        ci.schema = ManifestAccessor.DEAD_SCHEMA;
    }

    protected Descriptor resolveDescriptor(Descriptor descriptor) {
        if (descriptor.eIsProxy()) {
            try {
                descriptor = (Descriptor)EcoreUtil.resolve((EObject)descriptor, (ResourceSet)this.getManifestResourceSet());
                if (descriptor.eIsProxy()) {
                    return null;
                }
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return descriptor;
    }

    protected NodeDescriptor resolveDescriptor(NodeDescriptor descriptor) {
        if (descriptor.eIsProxy()) {
            try {
                descriptor = (NodeDescriptor)EcoreUtil.resolve((EObject)descriptor, (ResourceSet)this.getManifestResourceSet());
                if (descriptor.eIsProxy()) {
                    return null;
                }
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return descriptor;
    }

    protected FreeFormDescriptor resolveDescriptor(FreeFormDescriptor descriptor) {
        if (descriptor != null && descriptor.eIsProxy()) {
            try {
                descriptor = (FreeFormDescriptor)EcoreUtil.resolve((EObject)descriptor, (ResourceSet)this.getManifestResourceSet());
                if (descriptor.eIsProxy()) {
                    return null;
                }
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return descriptor;
    }

    protected ClassificationSchema getClassificationSchema(NodeDescriptor descriptor) {
        if ((descriptor = this.resolveDescriptor(descriptor)) == null) {
            return null;
        }
        NodeDescriptor parent = descriptor;
        while (parent.getGeneral() != null) {
            parent = parent.getGeneral();
        }
        return parent.getClassificationSchema();
    }

    protected ClassificationSchema getClassificationSchema(Descriptor descriptor) {
        return descriptor instanceof FreeFormDescriptor ? this.getClassificationSchema((FreeFormDescriptor)descriptor) : (descriptor instanceof NodeDescriptor ? this.getClassificationSchema((NodeDescriptor)descriptor) : null);
    }

    protected ClassificationSchema getClassificationSchema(FreeFormDescriptor ffd) {
        return (ffd = this.resolveDescriptor(ffd)) != null ? ffd.getClassificationSchema() : null;
    }

    public ClassificationInfo getClassificationInfo(NodeDescriptor desc) {
        if (!desc.eIsProxy()) {
            return this.getClassificationInfo(this.getClassificationSchema(desc), false);
        }
        ClassificationSchema cs = DefaultprofileFactory.eINSTANCE.createClassificationSchema();
        URI csuri = EcoreUtil.getURI((EObject)desc);
        if (csuri != null) {
            csuri = csuri.trimFragment().appendFragment("/");
            ((InternalEObject)cs).eSetProxyURI(csuri);
            return this.getClassificationInfo(cs);
        }
        return null;
    }

    protected ClassificationInfo getClassificationInfo(ClassificationSchema schema, boolean checkURI) {
        if (schema != null) {
            ClassificationInfo info = this.schemaToInfo.get(schema);
            if (info == null && checkURI) {
                info = this.schemaURIToInfo.get(EcoreUtil.getURI((EObject)schema));
            }
            if (info != null && checkURI) {
                info.reloadSchema();
            }
            return info;
        }
        return null;
    }

    public ClassificationInfo getClassificationInfo(ClassificationSchema schema) {
        return this.getClassificationInfo(schema, schema.eIsProxy());
    }

    public ClassificationInfo getClassificationInfo(FreeFormValue ffv) {
        FreeFormDescriptor ffd = ffv.getFreeFormDescriptor();
        return ffd != null ? this.getClassificationInfo(this.getClassificationSchema(ffd), ffd.eIsProxy()) : null;
    }

    public static String getNLSKey(String value) {
        if (value.equals(SCALE_PERSON_HOURS)) {
            return SCALE_PERSON_HOURS_KEY;
        }
        if (value.equals(SCALE_PERSON_DAYS)) {
            return SCALE_PERSON_DAYS_KEY;
        }
        if (value.equals(SCALE_PERSON_MONTHS)) {
            return SCALE_PERSON_MONTHS_KEY;
        }
        if (value.equals(SCALE_PERSON_YEARS)) {
            return SCALE_PERSON_YEARS_KEY;
        }
        return null;
    }

    public String[] getCreationTime() {
        Classification cl = this.manifest.getClassification();
        if (cl != null) {
            for (DescriptorGroup group : cl.getDescriptorGroup()) {
                if (!CREATIONTIME_DESCRIPTORGROUP_NAME.equals(group.getName())) continue;
                if (group.getFreeFormValue().size() == 2) {
                    return new String[]{((FreeFormValue)group.getFreeFormValue().get(0)).getValue(), ((FreeFormValue)group.getFreeFormValue().get(1)).getValue()};
                }
                return null;
            }
        }
        return null;
    }

    public String[] getUsageTime() {
        Classification cl = this.manifest.getClassification();
        if (cl != null) {
            for (DescriptorGroup group : cl.getDescriptorGroup()) {
                if (!USAGETIME_DESCRIPTORGROUP_NAME.equals(group.getName())) continue;
                if (!group.getFreeFormValue().isEmpty()) {
                    return new String[]{((FreeFormValue)group.getFreeFormValue().get(0)).getValue(), ((FreeFormValue)group.getFreeFormValue().get(1)).getValue()};
                }
                return null;
            }
        }
        return null;
    }

    public Map<String, CustomAttribute> initializeCustomAttributes(boolean includeOthers, Collection<String> customAttributeURIStrings) throws IllegalStateException {
        List<String> e = Collections.emptyList();
        return this.internalInitializeCustomAttributes(includeOthers, customAttributeURIStrings, e, Collections.<String, List<String>>emptyMap());
    }

    protected Map<String, CustomAttribute> internalInitializeCustomAttributes(boolean includeOthers, Collection<String> customAttributeURIStrings, Collection<String> requiredURIStrings, Map<String, List<String>> authorizedUsersMap) {
        this.includeOtherCustomAttributes = includeOthers;
        if (this.uriStringsToCustomAttributes != null) {
            this.uriStringsToCustomAttributes.clear();
        } else {
            this.uriStringsToCustomAttributes = new LinkedHashMap<String, CustomAttribute>(customAttributeURIStrings.size());
            this.unmodUriStringToCustomAttributes = Collections.unmodifiableMap(this.uriStringsToCustomAttributes);
        }
        if (this.selfDefinedCustomAttributeNamesToCustomAttributes != null) {
            this.selfDefinedCustomAttributeNamesToCustomAttributes.clear();
        } else {
            this.selfDefinedCustomAttributeNamesToCustomAttributes = new HashMap<String, CustomAttribute>();
        }
        if (!customAttributeURIStrings.isEmpty() || includeOthers) {
            CustomAttribute ca;
            for (String uriString : customAttributeURIStrings) {
                this.uriStringsToCustomAttributes.put(uriString, (CustomAttribute)this.createCustomAttribute(uriString, false, false, false));
            }
            for (String uriString : requiredURIStrings) {
                ca = this.uriStringsToCustomAttributes.get(uriString);
                if (ca == null) continue;
                ca.setRequired(true);
            }
            for (String uriString : authorizedUsersMap.keySet()) {
                List<String> authorizedUsers;
                ca = this.uriStringsToCustomAttributes.get(uriString);
                if (ca == null || (authorizedUsers = authorizedUsersMap.get(uriString)) == null) continue;
                ca.getAuthorizedUpdateUserIds().clear();
                ca.getAuthorizedUpdateUserIds().addAll(authorizedUsers);
            }
            Classification clsf = this.manifest.getClassification();
            XMLResource mres = this.getManifestResource();
            if (clsf != null) {
                for (DescriptorGroup group : clsf.getDescriptorGroup()) {
                    Object ca2;
                    String uriString;
                    if (!CUSTOMATTRIBUTES_DESCRIPTORGROUP_NAME.equals(group.getName())) continue;
                    this.customAttributeGroup = group;
                    if (includeOthers && !group.getFreeFormDescriptor().isEmpty()) {
                        for (FreeFormDescriptor ffd : group.getFreeFormDescriptor()) {
                            uriString = mres.getID((EObject)ffd);
                            if (uriString == null) {
                                uriString = this.createSelfDefinedURIString(ffd.getName(), mres);
                                mres.setID((EObject)ffd, uriString);
                            }
                            ca2 = this.createCustomAttribute(uriString, true, false, true);
                            ((CustomAttribute)ca2).setDescriptor(ffd);
                            this.uriStringsToCustomAttributes.put(uriString, (CustomAttribute)ca2);
                            this.selfDefinedCustomAttributeNamesToCustomAttributes.put(ffd.getName(), (CustomAttribute)ca2);
                        }
                    }
                    for (FreeFormValue ffv : group.getFreeFormValue()) {
                        CustomAttribute ca3;
                        FreeFormDescriptor ffdProxy = (FreeFormDescriptor)ffv.eGet((EStructuralFeature)DefaultprofilePackage.eINSTANCE.getFreeFormValue_FreeFormDescriptor(), false);
                        String uriString2 = null;
                        if (ffdProxy != null) {
                            if (!ffdProxy.eIsProxy() && ffdProxy.eContainer() == ffv.eContainer()) {
                                uriString2 = ((XMLResource)ffdProxy.eResource()).getID((EObject)ffdProxy);
                            }
                        } else {
                            uriString2 = this.createSelfDefinedURIString("unknown attribute", mres);
                            ffdProxy = DefaultprofileFactory.eINSTANCE.createFreeFormDescriptor();
                            ffdProxy.setName(uriString2);
                            group.getFreeFormDescriptor().add((Object)ffdProxy);
                            mres.setID((EObject)ffdProxy, uriString2);
                            ffv.setFreeFormDescriptor(ffdProxy);
                            ca3 = this.createCustomAttribute(uriString2, true, false, true);
                            ca3.setDescriptor(ffdProxy);
                            ca3.getFreeFormValues().add(ffv);
                            this.uriStringsToCustomAttributes.put(uriString2, ca3);
                            this.selfDefinedCustomAttributeNamesToCustomAttributes.put(ffdProxy.getName(), ca3);
                            continue;
                        }
                        if (uriString2 == null) {
                            uriString2 = EcoreUtil.getURI((EObject)ffdProxy).toString();
                        }
                        if ((ca3 = this.uriStringsToCustomAttributes.get(uriString2)) == null && includeOthers) {
                            ca3 = this.createCustomAttribute(uriString2, true, false, false);
                            ca3.setDescriptor(ffdProxy);
                            this.uriStringsToCustomAttributes.put(uriString2, ca3);
                        }
                        if (ca3 == null) continue;
                        ca3.getFreeFormValues().add(ffv);
                    }
                    for (NodeDescriptor node : group.getNodeDescriptor()) {
                        if (node.eIsProxy()) continue;
                        uriString = EcoreUtil.getURI((EObject)node.getGeneral()).toString();
                        ca2 = this.uriStringsToCustomAttributes.get(uriString);
                        if (ca2 == null && includeOthers) {
                            ca2 = this.createCustomAttribute(uriString, true, false, false);
                            this.uriStringsToCustomAttributes.put(uriString, (CustomAttribute)ca2);
                        }
                        if (ca2 == null) continue;
                        ((CustomAttribute)ca2).addNodeDescriptorSetting(node);
                    }
                }
            }
        }
        return this.unmodUriStringToCustomAttributes;
    }

    protected String createSelfDefinedURIString(String name, XMLResource xmlres) {
        return Utilities.makeUniqueID(Utilities.encoded(SELF_DEFINED_ATTRIBUTE_ID_PREFIX + name), xmlres);
    }

    protected <C extends CustomAttribute> C createCustomAttribute(String uriString, boolean other, boolean required, boolean selfDefined) {
        return (C)new CustomAttribute(uriString, other, required, selfDefined);
    }

    public Map<String, CustomAttribute> getCustomAttributes() {
        return this.unmodUriStringToCustomAttributes;
    }

    public CustomAttribute getSelfDefinedCustomAttribute(String name) {
        return this.selfDefinedCustomAttributeNamesToCustomAttributes.get(name);
    }

    public ArtifactAdapter getArtifactAdapter() {
        if (this.artifactAdapter == null) {
            this.artifactAdapter = ArtifactAdapter.getAdapter(this.getManifest());
            if (this.artifactDetails != null) {
                ArtifactAdapter.setupArtifactDetails(this.artifactDetails, this.getManifest());
            }
        }
        return this.artifactAdapter;
    }

    public Artifact getArtifact(String path, String name) {
        return this.getArtifactAdapter().getArtifact(path, name);
    }

    public Artifact getArtifact(ZipEntry ze) {
        return this.getArtifact(ze, null);
    }

    public Artifact getArtifact(ZipEntry ze, String path) {
        String[] pathName = this.getPathName(this.normalize(ze.getName()));
        if (path != null && path.length() > 0) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            pathName[0] = String.valueOf(path) + pathName[0];
        }
        return this.getArtifact(pathName[0] != null ? pathName[0] : "/", pathName[1]);
    }

    public Artifact getArtifact(String fullPathName) {
        String[] pathName = this.getPathName(this.normalize(fullPathName));
        return this.getArtifact(pathName[0], pathName[1]);
    }

    public Solution getSolution() {
        this.getArtifactAdapter();
        return this.manifest.getSolution();
    }

    public boolean isArtifactsEmpty() {
        if (this.manifest.getSolution() == null) {
            return true;
        }
        return this.manifest.getSolution().getArtifact().isEmpty();
    }

    public ArtifactDetails getArtifactDetails() {
        return this.artifactDetails;
    }

    public void destroyManifest() {
        Resource r = this.manifest.eResource();
        r.getResourceSet().getResources().remove((Object)r);
        if (this.artifactAdapter != null) {
            this.artifactAdapter.closeArtifactAdapter();
            this.artifactAdapter = null;
        }
        if (this.schemaURIToInfo != null) {
            this.schemaURIToInfo.clear();
        }
        if (this.uriStringsToCustomAttributes != null) {
            this.uriStringsToCustomAttributes.clear();
        }
        this.manifestCleared();
    }

    public ManifestAccessor(ManifestBuilder builder) {
        this.copyOver(builder);
        builder.manifestCleared();
    }

    public ManifestAccessor(ManifestAccessor accessor) {
        if (accessor.getClass() != ManifestAccessor.class) {
            throw new IllegalArgumentException("It must be a ManifestAccessor. ManifestBuilder is invalid.");
        }
        this.copyOver(accessor);
    }

    private void copyOver(ManifestAccessor accessor) {
        this.artifactAdapter = accessor.artifactAdapter;
        this.manifest = accessor.manifest;
        this.artifactDetails = accessor.artifactDetails;
        if (accessor.schemaToInfo != null) {
            Map<ClassificationInfo, ClassificationInfo> cloneCI = this.clonedClassificationInfo(accessor.schemaToInfo.values());
            this.schemaURIToInfo = new LinkedHashMap<URI, ClassificationInfo>(accessor.schemaURIToInfo.size());
            for (Map.Entry<URI, ClassificationInfo> entry : accessor.schemaURIToInfo.entrySet()) {
                this.schemaURIToInfo.put(entry.getKey(), cloneCI.get(entry.getValue()));
            }
            this.unmodSchemaURIToInfo = Collections.unmodifiableMap(this.schemaURIToInfo);
            this.schemaToInfo = new HashMap<ClassificationSchema, ClassificationInfo>(accessor.schemaToInfo.size());
            for (Map.Entry<Object, Object> entry : accessor.schemaToInfo.entrySet()) {
                this.schemaToInfo.put((ClassificationSchema)entry.getKey(), cloneCI.get(entry.getValue()));
            }
        }
        this.customAttributeGroup = accessor.customAttributeGroup;
        if (accessor.uriStringsToCustomAttributes != null) {
            Map<CustomAttribute, CustomAttribute> cloneCA = this.clonedCustomAttributes(accessor.uriStringsToCustomAttributes.values());
            this.uriStringsToCustomAttributes = new LinkedHashMap<String, CustomAttribute>(accessor.uriStringsToCustomAttributes.size());
            for (Map.Entry<Object, Object> entry : accessor.unmodUriStringToCustomAttributes.entrySet()) {
                this.uriStringsToCustomAttributes.put((String)entry.getKey(), cloneCA.get(entry.getValue()));
            }
            this.unmodUriStringToCustomAttributes = Collections.unmodifiableMap(this.uriStringsToCustomAttributes);
            this.selfDefinedCustomAttributeNamesToCustomAttributes = new HashMap<String, CustomAttribute>(accessor.selfDefinedCustomAttributeNamesToCustomAttributes.size());
            for (Map.Entry<Object, Object> entry : accessor.selfDefinedCustomAttributeNamesToCustomAttributes.entrySet()) {
                this.selfDefinedCustomAttributeNamesToCustomAttributes.put((String)entry.getKey(), cloneCA.get(entry.getValue()));
            }
        }
        this.includeOtherCustomAttributes = accessor.includeOtherCustomAttributes;
        this.includeOtherSchemas = accessor.includeOtherSchemas;
        this.community = accessor.getCommunity();
        this.assetDbid = accessor.getAssetDBID();
        this.stateId = accessor.getStateId();
    }

    private Map<CustomAttribute, CustomAttribute> clonedCustomAttributes(Collection<? extends CustomAttribute> customAttributes) {
        HashMap<CustomAttribute, CustomAttribute> clone = new HashMap<CustomAttribute, CustomAttribute>(customAttributes.size());
        for (CustomAttribute customAttribute : customAttributes) {
            clone.put(customAttribute, new CustomAttribute(customAttribute));
        }
        return clone;
    }

    private Map<ClassificationInfo, ClassificationInfo> clonedClassificationInfo(Collection<? extends ClassificationInfo> classificationInfos) {
        HashMap<ClassificationInfo, ClassificationInfo> clone = new HashMap<ClassificationInfo, ClassificationInfo>(classificationInfos.size());
        for (ClassificationInfo classificationInfo : classificationInfos) {
            clone.put(classificationInfo, new ClassificationInfo(classificationInfo));
        }
        return clone;
    }

    protected void manifestCleared() {
        this.artifactAdapter = null;
        this.artifactDetails = null;
        this.manifest = null;
        this.schemaURIToInfo = null;
        this.schemaToInfo = null;
        this.customAttributeGroup = null;
        this.uriStringsToCustomAttributes = null;
        this.unmodSchemaURIToInfo = null;
        this.unmodUriStringToCustomAttributes = null;
        this.selfDefinedCustomAttributeNamesToCustomAttributes = null;
    }

    protected String[] getPathName(String name) {
        int pathSep = name.lastIndexOf(47);
        String path = pathSep > 0 ? name.substring(0, pathSep) : "/";
        if (pathSep != -1) {
            name = name.substring(pathSep + 1);
        }
        return new String[]{path, name};
    }

    public String getPrimaryType(Artifact artifact) {
        return this.getFormat(artifact);
    }

    public String getFormat(Artifact artifact) {
        if (artifact != null) {
            String type = artifact.getType();
            return type != null ? type : "";
        }
        return "";
    }

    public String getPrimaryType(ArtifactDetail detail) {
        return this.getFormat(detail);
    }

    public String getFormat(ArtifactDetail detail) {
        return this.getFormat(detail.getArtifact());
    }

    public String getSecondaryType(Artifact artifact) {
        return this.getLabel(artifact);
    }

    public static String getArtifactLabel(Artifact artifact) {
        EList secTypes;
        if (artifact != null && !(secTypes = artifact.getArtifactType()).isEmpty()) {
            String type = ((ArtifactType)secTypes.get(0)).getType();
            return type != null ? type : "";
        }
        return "";
    }

    public String getLabel(Artifact artifact) {
        return ManifestAccessor.getArtifactLabel(artifact);
    }

    public String getSecondaryType(ArtifactDetail detail) {
        return this.getLabel(detail);
    }

    public String getLabel(ArtifactDetail detail) {
        return this.getLabel(detail.getArtifact());
    }

    protected String getZipEntryName(ZipEntry artifactZipEntry) {
        String zipname = artifactZipEntry.getName();
        if (zipname.charAt(0) != '/') {
            zipname = String.valueOf('/') + zipname;
        }
        if (zipname.charAt(zipname.length() - 1) == '/') {
            zipname = zipname.substring(0, zipname.length() - 1);
        }
        return zipname;
    }

    protected String normalize(String path) {
        if (UtilitiesCommon.isEmptyString(path)) {
            return "";
        }
        if ((path = path.replace('\\', '/')).length() == 0 || path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public CommunityInformation getCommunity() {
        return this.community;
    }

    public void setLanguageProperties(Properties props) {
        this.languageProps = props;
    }

    public Properties getLanguageProperties() {
        return this.languageProps;
    }

    public static abstract class BaseRAMURIConverterImpl
    extends URIConverterImpl
    implements RAMURIConverter {
        protected abstract String getServerPath();

        protected static URI createClassificationSchemaURI(String uriString, String serverPath) {
            return URI.createURI((String)BaseRAMURIConverterImpl.createClassificationSchemaURIString(uriString, serverPath));
        }

        protected static String createClassificationSchemaURIString(String uriString, String serverPath) {
            if (uriString.startsWith(ManifestAccessor.CLASSIFICATION_SCHEMA_URI_PATH_PART)) {
                return String.valueOf(serverPath) + uriString;
            }
            return uriString;
        }

        protected static String getClassificationSchemaURIString(URI uri, String serverPath) {
            return BaseRAMURIConverterImpl.getClassificationSchemaURIString(uri.toString(), serverPath);
        }

        protected static String getClassificationSchemaURIString(String uriString, String serverPath) {
            if (uriString.startsWith(serverPath) && ManifestAccessor.CLASSIFICATION_SCHEMA_URI_PATH_PART.regionMatches(0, uriString, serverPath.length(), ManifestAccessor.CLASSIFICATION_SCHEMA_URI_PATH_PART.length())) {
                return uriString.substring(serverPath.length());
            }
            return uriString;
        }

        @Override
        public String createClassificationSchemaURIString(String uriString) {
            return BaseRAMURIConverterImpl.createClassificationSchemaURIString(uriString, this.getServerPath());
        }

        @Override
        public String getClassificationSchemaURIString(URI uri) {
            return BaseRAMURIConverterImpl.getClassificationSchemaURIString(uri, this.getServerPath());
        }

        @Override
        public String getClassificationSchemaURIString(String uriString) {
            return BaseRAMURIConverterImpl.getClassificationSchemaURIString(uriString, this.getServerPath());
        }
    }

    public class ClassificationInfo {
        private ClassificationSchema schema;
        private final URI uri;
        private String localizedURIString;
        protected DescriptorGroup group;
        protected final Set<NodeDescriptor> nodeDescriptors;
        protected final Set<FreeFormValue> freeformValues;
        private Set<NodeDescriptor> unmodNodeDescriptors;
        private Set<FreeFormValue> unmodFreeformValues;
        private boolean other;

        ClassificationInfo(ClassificationInfo ci) {
            this.schema = ci.schema;
            this.uri = ci.uri;
            this.localizedURIString = ci.localizedURIString;
            this.group = ci.group;
            this.nodeDescriptors = ci.nodeDescriptors;
            this.freeformValues = ci.freeformValues;
            this.unmodNodeDescriptors = ci.unmodNodeDescriptors;
            this.unmodFreeformValues = ci.unmodFreeformValues;
            this.other = ci.other;
        }

        protected ClassificationInfo(ClassificationSchema schema, URI uri, boolean other) {
            this.schema = schema;
            this.uri = uri;
            this.other = other;
            this.nodeDescriptors = new HashSet<NodeDescriptor>();
            this.unmodNodeDescriptors = Collections.unmodifiableSet(this.nodeDescriptors);
            this.freeformValues = new HashSet<FreeFormValue>();
            this.unmodFreeformValues = Collections.unmodifiableSet(this.freeformValues);
        }

        protected void setDescriptorGroup(DescriptorGroup group) {
            this.group = group;
            this.nodeDescriptors.clear();
            this.freeformValues.clear();
            if (group != null) {
                this.nodeDescriptors.addAll((Collection<NodeDescriptor>)group.getNodeDescriptor());
                this.freeformValues.addAll((Collection<FreeFormValue>)group.getFreeFormValue());
            }
        }

        public void reloadSchema() {
            if (this.schema.eIsProxy() && this.schema != DEAD_SCHEMA) {
                try {
                    ClassificationSchema newSchema = (ClassificationSchema)EcoreUtil.resolve((EObject)this.schema, (ResourceSet)ManifestAccessor.this.getManifestResourceSet());
                    if (!newSchema.eIsProxy()) {
                        ClassificationSchema oldSchema = this.schema;
                        this.schema = newSchema;
                        this.setDescriptorGroup(this.group);
                        ManifestAccessor.this.replaceInfo(this, oldSchema, this.schema);
                    } else {
                        ManifestAccessor.this.removeInfo(this);
                    }
                }
                catch (ClassCastException classCastException) {
                    ManifestAccessor.this.removeInfo(this);
                }
            }
        }

        public boolean isValid() {
            if (this.schema.eIsProxy()) {
                this.reloadSchema();
                return this.schema.eIsProxy();
            }
            return true;
        }

        public Set<FreeFormValue> getFreeformValues() {
            this.getSchema();
            return this.unmodFreeformValues;
        }

        public Set<NodeDescriptor> getNodeDescriptors() {
            this.getSchema();
            return this.unmodNodeDescriptors;
        }

        public URI getURI() {
            return this.uri;
        }

        public String getURILocalized() {
            return this.localizedURIString != null ? this.localizedURIString : (this.localizedURIString = Utilities.getClassificationSchemaURIString(this.uri, (EObject)ManifestAccessor.this.manifest));
        }

        public boolean isSchemaSet() {
            return this.group != null;
        }

        public DescriptorGroup getGroup() {
            return this.group;
        }

        public ClassificationSchema getSchema() {
            if (this.schema.eIsProxy() && this.schema != DEAD_SCHEMA) {
                this.reloadSchema();
            }
            return this.schema;
        }

        public boolean isOtherSchema() {
            return this.other;
        }
    }

    public class CustomAttribute {
        protected boolean selfDefined;
        protected boolean other;
        protected boolean required;
        protected final String uriString;
        private List<String> authorizedUserIds;
        protected Descriptor descriptor;
        private boolean triedDescriptor;
        protected ArrayList<FreeFormValue> ffvSet;
        protected ValueList values;
        protected NodeDescriptor[] nodesSet;
        protected static final int REMOVE_ALL = -23;
        protected static final int ADD_AT_END = -1;

        CustomAttribute(CustomAttribute ca) {
            this.descriptor = ca.descriptor;
            this.ffvSet = ca.ffvSet;
            this.nodesSet = ca.nodesSet;
            this.other = ca.other;
            this.required = ca.required;
            this.selfDefined = ca.selfDefined;
            this.triedDescriptor = ca.triedDescriptor;
            this.uriString = ca.uriString;
        }

        protected CustomAttribute(String uriString, boolean other, boolean required, boolean selfDefined) {
            this.other = other;
            this.required = required;
            this.uriString = uriString;
            this.selfDefined = selfDefined;
        }

        protected String removeUnrestrictedSetting(int ndx, ValueList.Itr vItr) {
            throw new UnsupportedOperationException();
        }

        protected void addUnrestrictedSetting(int index, ListIterator<FreeFormValue> ffvItr, String value) {
            throw new UnsupportedOperationException();
        }

        protected String setUnrestrictedSetting(int index, String value) {
            throw new UnsupportedOperationException();
        }

        public boolean isSelfDefined() {
            return this.selfDefined;
        }

        public boolean isResolved() {
            Descriptor desc = this.getDescriptor();
            return desc != null && !desc.eIsProxy();
        }

        protected Descriptor getDescriptor() {
            Descriptor d;
            if (!this.triedDescriptor) {
                this.triedDescriptor = true;
                this.descriptor = (Descriptor)Utilities.loadClassificationSchemaObjectFromURI(Utilities.createClassificationSchemaURI(this.uriString, ManifestAccessor.this.manifest), ManifestAccessor.this.manifest);
            } else if (this.descriptor != null && this.descriptor.eIsProxy() && (d = ManifestAccessor.this.resolveDescriptor(this.descriptor)) != null) {
                this.descriptor = d;
            }
            return this.descriptor;
        }

        void setDescriptor(Descriptor descriptor) {
            this.triedDescriptor = true;
            this.descriptor = descriptor;
        }

        public boolean isRestrictedValues() {
            Descriptor desc = this.getDescriptor();
            if (desc != null && !desc.eIsProxy()) {
                return desc instanceof NodeDescriptor;
            }
            return false;
        }

        public String getName() {
            Descriptor desc = this.getDescriptor();
            return desc != null && !desc.eIsProxy() ? desc.getName() : this.uriString;
        }

        public String getDescription() {
            Description ds;
            Descriptor desc = this.getDescriptor();
            if (desc != null && !desc.eIsProxy() && (ds = desc.getDescription()) != null && !UtilitiesCommon.isEmptyString(ds.getValue())) {
                return ds.getValue();
            }
            return "";
        }

        public boolean isAttributeSet() {
            if (this.ffvSet != null) {
                if (!this.isRestrictedValues()) {
                    return !this.ffvSet.isEmpty();
                }
                if (!this.ffvSet.isEmpty()) {
                    this.primRemoveUnrestrictedSetting(-23, null);
                }
                return false;
            }
            if (this.nodesSet != null) {
                if (this.isRestrictedValues()) {
                    return true;
                }
                this.primRemoveRestrictedAttribute();
                return false;
            }
            return false;
        }

        protected final void primRemoveRestrictedAttribute() {
            ClassificationSchema schema = ManifestAccessor.this.getClassificationSchema(this.getDescriptor());
            if (ManifestAccessor.this.customAttributeGroup.getNodeDescriptor().removeAll(Arrays.asList(this.nodesSet))) {
                boolean noneFound = true;
                for (FreeFormValue ffv : ManifestAccessor.this.customAttributeGroup.getFreeFormValue()) {
                    if (ffv.getFreeFormDescriptor().getClassificationSchema() != schema) continue;
                    noneFound = false;
                    break;
                }
                if (noneFound) {
                    for (NodeDescriptor node : ManifestAccessor.this.customAttributeGroup.getNodeDescriptor()) {
                        while (node.getGeneral() != null) {
                            node = node.getGeneral();
                        }
                        if (node.getClassificationSchema() != schema) continue;
                        noneFound = false;
                        break;
                    }
                }
                if (noneFound) {
                    ManifestAccessor.this.customAttributeGroup.getClassificationSchema().remove((Object)schema);
                }
            }
            if (ManifestAccessor.this.customAttributeGroup.getFreeFormValue().isEmpty() && ManifestAccessor.this.customAttributeGroup.getNodeDescriptor().isEmpty()) {
                ManifestAccessor.this.manifest.getClassification().getDescriptorGroup().remove((Object)ManifestAccessor.this.customAttributeGroup);
                ManifestAccessor.this.customAttributeGroup = null;
            }
            this.nodesSet = null;
        }

        protected final String primRemoveUnrestrictedSetting(int ndx, ValueList.Itr vItr) {
            String result = null;
            Descriptor freeFormD = this.getDescriptor();
            ClassificationSchema schema = ManifestAccessor.this.getClassificationSchema(freeFormD);
            if (vItr == null) {
                if (ndx != -23) {
                    FreeFormValue ffv = this.ffvSet.remove(ndx);
                    result = ffv.getValue();
                    ManifestAccessor.this.customAttributeGroup.getFreeFormValue().remove((Object)ffv);
                } else {
                    ManifestAccessor.this.customAttributeGroup.getFreeFormValue().removeAll(this.ffvSet);
                    this.ffvSet.clear();
                    result = null;
                }
            } else {
                int position = vItr.lastRet();
                FreeFormValue ffv = this.ffvSet.get(position);
                ManifestAccessor.this.customAttributeGroup.getFreeFormValue().remove((Object)ffv);
                vItr.ffvItr.remove();
                result = ffv.getValue();
            }
            if (this.ffvSet.isEmpty()) {
                if (this.isSelfDefined()) {
                    ManifestAccessor.this.customAttributeGroup.getFreeFormDescriptor().remove((Object)freeFormD);
                }
                boolean noneFound = true;
                for (FreeFormValue ffv : ManifestAccessor.this.customAttributeGroup.getFreeFormValue()) {
                    if (ffv.getFreeFormDescriptor().getClassificationSchema() != schema) continue;
                    noneFound = false;
                    break;
                }
                if (noneFound) {
                    for (NodeDescriptor node : ManifestAccessor.this.customAttributeGroup.getNodeDescriptor()) {
                        while (node.getGeneral() != null) {
                            node = node.getGeneral();
                        }
                        if (node.getClassificationSchema() != schema) continue;
                        noneFound = false;
                        break;
                    }
                }
                if (noneFound) {
                    ManifestAccessor.this.customAttributeGroup.getClassificationSchema().remove((Object)schema);
                }
            }
            if (ManifestAccessor.this.customAttributeGroup.getFreeFormValue().isEmpty() && ManifestAccessor.this.customAttributeGroup.getNodeDescriptor().isEmpty()) {
                ManifestAccessor.this.manifest.getClassification().getDescriptorGroup().remove((Object)ManifestAccessor.this.customAttributeGroup);
                ManifestAccessor.this.customAttributeGroup = null;
            }
            return result;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean isOtherAttribute() {
            return this.other;
        }

        public String getURIString() {
            return this.uriString;
        }

        ArrayList<FreeFormValue> getFreeFormValues() {
            if (this.ffvSet == null) {
                this.ffvSet = new ArrayList(1);
            }
            return this.ffvSet;
        }

        public String getUnrestrictedAttributeValue() {
            this.isAttributeSet();
            return this.ffvSet != null && !this.ffvSet.isEmpty() ? this.getUnrestrictedAttributeValues().get(0) : null;
        }

        public boolean isSingleValueSet() {
            return !this.isRestrictedValues() ? this.ffvSet == null || this.ffvSet.size() <= 1 : this.nodesSet == null || this.nodesSet.length <= 1;
        }

        public List<String> getUnrestrictedAttributeValues() {
            if (this.isRestrictedValues()) {
                return null;
            }
            this.isAttributeSet();
            if (this.values == null) {
                if (this.ffvSet == null) {
                    this.getFreeFormValues();
                }
                this.values = new ValueList();
            }
            return this.values;
        }

        public List<String> getAuthorizedUpdateUserIds() {
            if (this.authorizedUserIds == null) {
                this.authorizedUserIds = new ArrayList<String>();
            }
            return this.authorizedUserIds;
        }

        public boolean isEditable(String userId) {
            if (this.getAuthorizedUpdateUserIds().isEmpty()) {
                return true;
            }
            for (String uid : this.getAuthorizedUpdateUserIds()) {
                if (!uid.equals(userId)) continue;
                return true;
            }
            return false;
        }

        public NodeDescriptor[] getRestrictedAttributeValues() {
            this.isAttributeSet();
            return this.nodesSet;
        }

        public NodeDescriptor[] getRestrictedValidAttributeValues() {
            Descriptor parent = this.getDescriptor();
            if (parent instanceof NodeDescriptor && !parent.eIsProxy()) {
                return (NodeDescriptor[])((NodeDescriptor)parent).getSpecific().toArray((Object[])new NodeDescriptor[((NodeDescriptor)parent).getSpecific().size()]);
            }
            return new NodeDescriptor[0];
        }

        void addNodeDescriptorSetting(NodeDescriptor setting) {
            if (this.nodesSet == null) {
                this.nodesSet = new NodeDescriptor[]{setting};
            } else {
                NodeDescriptor[] newGuy = new NodeDescriptor[this.nodesSet.length + 1];
                System.arraycopy(this.nodesSet, 0, newGuy, 0, this.nodesSet.length);
                newGuy[this.nodesSet.length] = setting;
                this.nodesSet = newGuy;
            }
        }

        public boolean isManySelect() {
            Descriptor parent = this.getDescriptor();
            if (parent instanceof NodeDescriptor && !parent.eIsProxy()) {
                return !((NodeDescriptor)parent).isExclusive();
            }
            return false;
        }

        class ValueList
        extends AbstractList<String>
        implements RandomAccess {
            ValueList() {
            }

            @Override
            public String get(int index) {
                return CustomAttribute.this.ffvSet.get(index).getValue();
            }

            @Override
            public int size() {
                return CustomAttribute.this.ffvSet.size();
            }

            @Override
            public void add(int index, String element) {
                CustomAttribute.this.addUnrestrictedSetting(index, null, element);
            }

            @Override
            public void clear() {
                CustomAttribute.this.removeUnrestrictedSetting(-23, null);
            }

            @Override
            public boolean contains(Object o) {
                int i = 0;
                while (i < CustomAttribute.this.ffvSet.size()) {
                    if (UtilitiesCommon.objectsEqual(o, CustomAttribute.this.ffvSet.get(i).getValue())) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            @Override
            public int indexOf(Object o) {
                int i = 0;
                while (i < CustomAttribute.this.ffvSet.size()) {
                    if (UtilitiesCommon.objectsEqual(CustomAttribute.this.ffvSet.get(i).getValue(), o)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            @Override
            public boolean isEmpty() {
                return CustomAttribute.this.ffvSet.isEmpty();
            }

            @Override
            public Iterator<String> iterator() {
                return new Itr(0);
            }

            @Override
            public int lastIndexOf(Object o) {
                int i = CustomAttribute.this.ffvSet.size() - 1;
                while (i >= 0) {
                    if (UtilitiesCommon.objectsEqual(CustomAttribute.this.ffvSet.get(i).getValue(), o)) {
                        return i;
                    }
                    --i;
                }
                return -1;
            }

            @Override
            public ListIterator<String> listIterator() {
                return new LItr(0);
            }

            @Override
            public ListIterator<String> listIterator(int index) {
                return new LItr(index);
            }

            @Override
            public boolean remove(Object o) {
                int ndx = this.indexOf(o);
                if (ndx == -1) {
                    return false;
                }
                CustomAttribute.this.removeUnrestrictedSetting(ndx, null);
                return true;
            }

            @Override
            public String remove(int index) {
                return CustomAttribute.this.removeUnrestrictedSetting(index, null);
            }

            @Override
            public String set(int index, String element) {
                return CustomAttribute.this.setUnrestrictedSetting(index, element);
            }

            protected class Itr
            implements Iterator<String> {
                protected ListIterator<FreeFormValue> ffvItr;
                protected int lastRet;

                public Itr(int i) {
                    this.ffvItr = ((ValueList)ValueList.this).CustomAttribute.this.ffvSet.listIterator(i);
                }

                @Override
                public boolean hasNext() {
                    return this.ffvItr.hasNext();
                }

                @Override
                public String next() {
                    this.lastRet = this.ffvItr.nextIndex();
                    return this.ffvItr.next().getValue();
                }

                @Override
                public void remove() {
                    CustomAttribute.this.removeUnrestrictedSetting(0, this);
                    this.lastRet = -2;
                }

                protected int lastRet() {
                    return this.lastRet;
                }
            }

            protected class LItr
            extends Itr
            implements ListIterator<String> {
                public LItr() {
                    super(0);
                }

                public LItr(int n) {
                    super(n);
                }

                @Override
                public void add(String o) {
                    CustomAttribute.this.addUnrestrictedSetting(0, this.ffvItr, o);
                    this.lastRet = -2;
                }

                @Override
                public int nextIndex() {
                    return this.ffvItr.nextIndex();
                }

                @Override
                public boolean hasPrevious() {
                    return this.ffvItr.hasPrevious();
                }

                @Override
                public String previous() {
                    this.lastRet = this.ffvItr.previousIndex();
                    return ((FreeFormValue)this.ffvItr.previous()).getValue();
                }

                @Override
                public int previousIndex() {
                    return this.ffvItr.previousIndex();
                }

                @Override
                public void set(String o) {
                    CustomAttribute.this.setUnrestrictedSetting(this.lastRet, o);
                    this.lastRet = -2;
                }
            }
        }
    }

    protected static class ManifestBuilderRAMURIConverter
    extends BaseRAMURIConverterImpl
    implements SetServerPath {
        private String serverPath;
        private String classificationPrefix;

        public ManifestBuilderRAMURIConverter(String serverPath) {
            this.serverPath = serverPath;
        }

        @Override
        public String getServerPath() {
            return this.serverPath;
        }

        @Override
        public void setServerPath(String serverPath) {
            this.serverPath = serverPath;
            this.classificationPrefix = null;
        }

        @Override
        public Resource delegatedGetResource(URI schemaURI, boolean loadOnDemand) {
            return null;
        }

        @Override
        public String getClassificationPrefix() {
            if (this.classificationPrefix == null) {
                this.classificationPrefix = String.valueOf(this.getServerPath()) + ManifestAccessor.CLASSIFICATION_SCHEMA_URI_PATH_PART;
            }
            return this.classificationPrefix;
        }
    }

    public static class RAMXMIDiagnosticException
    extends IOException {
        private static final long serialVersionUID = -7363297142091898951L;

        RAMXMIDiagnosticException(IOException exp) {
            super(exp.getMessage());
            this.initCause(exp);
        }
    }

    static class ResFactory
    implements Resource.Factory {
        ResFactory() {
        }

        public Resource createResource(URI uri) {
            return new RAMXMIResource(uri);
        }

        private static class RAMXMIResource
        extends XMIResourceImpl {
            public RAMXMIResource(URI uri) {
                super(uri);
                this.setEncoding("UTF-8");
                this.getDefaultSaveOptions().putAll(SAVE_OPTIONS);
                this.getDefaultLoadOptions().putAll(LOAD_OPTIONS);
            }

            protected boolean useIDAttributes() {
                return false;
            }

            protected XMLLoad createXMLLoad() {
                return new XMILoadImpl(this.createXMLHelper()){

                    protected void handleErrors() throws IOException {
                        try {
                            super.handleErrors();
                        }
                        catch (IOException e) {
                            throw new RAMXMIDiagnosticException(e);
                        }
                    }
                };
            }

            protected XMLSave createXMLSave() {
                return new XMISaveImpl(this.createXMLHelper()){

                    protected int sameDocSingle(EObject o, EStructuralFeature f) {
                        InternalEObject value = (InternalEObject)this.helper.getValue(o, f);
                        if (value == null || value.eResource() != null) {
                            return super.sameDocSingle(o, f);
                        }
                        return 2;
                    }
                };
            }
        }
    }

    public static interface SetServerPath {
        public void setServerPath(String var1);

        public String getServerPath();
    }
}

