/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampOutputStream
extends FilterOutputStream {
    public static final char NEWLINE_CHAR = '\n';
    public static final String DEFAULT_DATE_FORMAT_PATTERN = "[MM/dd/yy HH:mm:ss z] ";
    private SimpleDateFormat dateFormat = null;
    private boolean newLine = true;

    public TimestampOutputStream(OutputStream out) {
        this(out, null);
    }

    public TimestampOutputStream(OutputStream out, String dateFormatPattern) {
        super(out);
        if (dateFormatPattern == null || dateFormatPattern.length() == 0) {
            dateFormatPattern = DEFAULT_DATE_FORMAT_PATTERN;
        }
        this.dateFormat = new SimpleDateFormat(dateFormatPattern);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.newLine) {
            this.writeTimestamp();
        }
        this.out.write(b);
        this.newLine = b == 10;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int pos1 = off;
        int pos2 = off;
        block0: while (pos1 < len) {
            if (this.newLine) {
                this.writeTimestamp();
                this.newLine = false;
            }
            while (pos1 < len) {
                if (b[pos1++] != 10) continue;
                this.out.write(b, pos2, pos1 - pos2);
                pos2 = pos1;
                this.newLine = true;
                continue block0;
            }
        }
        if (pos1 > pos2) {
            this.out.write(b, pos2, pos1 - pos2);
        }
    }

    private void writeTimestamp() throws IOException {
        this.out.write(this.dateFormat.format(new Date()).getBytes());
    }
}

