/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.Apply;
import com.ibm.ram.fix.FileAccess;
import com.ibm.ram.fix.Loggable;
import com.ibm.ram.fix.PatchControl;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class Fixes
implements Closeable,
Loggable {
    private final FileAccess fa;

    protected Fixes(FileAccess fa) {
        this.fa = fa;
    }

    protected final Collection<String> getPatchControlFiles() {
        return this.fa.getFiles(new FileAccess.NameFilter(){

            @Override
            public boolean acceptName(FileAccess fa, String name) {
                return PatchControl.isFixControl(name, PatchControl.ControlType.eitherType, 0, null) || PatchControl.isDeprecatedTestFixControl(name, PatchControl.ControlType.eitherType, 0, null);
            }
        }, false);
    }

    /*
     * Loose catch block
     */
    public Collection<PatchControl> getInstalledFixes() {
        Collection<String> pcFiles = this.getPatchControlFiles();
        ArrayList<PatchControl> installed = new ArrayList<PatchControl>(pcFiles.size());
        for (String file : pcFiles) {
            BufferedReader rdr = null;
            InputStream fileIS = null;
            try {
                fileIS = this.fa.getIS(file);
                rdr = new BufferedReader(new InputStreamReader(fileIS, "UTF-8"));
                installed.add(PatchControl.loadXML(rdr));
                fileIS = null;
            }
            catch (IOException e) {
                this.warn("Problem reading " + file, e);
                Apply.close(rdr);
                Apply.close(fileIS);
                continue;
            }
            catch (ParserConfigurationException e) {
                this.warn("Problem reading " + file, e);
                Apply.close(rdr);
                Apply.close(fileIS);
                continue;
            }
            catch (SAXException e) {
                this.warn("Problem reading " + file, e);
                {
                    catch (Throwable throwable) {
                        Apply.close(rdr);
                        Apply.close(fileIS);
                        throw throwable;
                    }
                }
                Apply.close(rdr);
                Apply.close(fileIS);
                continue;
            }
            Apply.close(rdr);
            Apply.close(fileIS);
        }
        return installed;
    }

    public static void logFixes(Collection<PatchControl> pcs, Loggable loggable) {
        if (!pcs.isEmpty()) {
            loggable.info("Installed fixes:");
            for (PatchControl pc : pcs) {
                loggable.info(pc.getPatchName());
                for (PatchControl.Include included : pc.getIncludes()) {
                    loggable.info(included.getFix());
                }
            }
        } else {
            loggable.info("No fixes installed.");
        }
    }

    @Override
    public void close() {
        Apply.close(this.fa);
    }

    public static class FileIsDirectory
    extends FileNotFoundException {
        private static final long serialVersionUID = 1L;

        public FileIsDirectory(String msg) {
            super(msg);
        }
    }
}

