/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.bundles;

import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.common.bundles.NotFoundMessageClass;
import com.ibm.ram.internal.common.bundles.StoredMessage;
import com.ibm.ram.internal.common.util.RAMDateFormat;
import com.ibm.ram.internal.common.util.SessionHandler;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public abstract class AbstractMessages {
    private static final String UNKNOWN_MSG = "unknown msg";
    private static final Logger LOGGER = Logger.getLogger(AbstractMessages.class);
    public static final Map<String, Locale> SUPPORTED_LOCALES = new HashMap<String, Locale>();
    public static final Map<String, Locale> SUPPORTED_RFC5646_LOCALES = new HashMap<String, Locale>();
    private static final ConcurrentMap<ClassLoader, ConcurrentMap<String, AbstractMessages>> CLASSES_MAP;

    static {
        SUPPORTED_LOCALES.put(Locale.ENGLISH.toString(), Locale.ENGLISH);
        SUPPORTED_RFC5646_LOCALES.put(String.valueOf(Locale.ENGLISH.getLanguage()) + '-' + Locale.ENGLISH.getCountry(), Locale.ENGLISH);
        SUPPORTED_LOCALES.put("es", new Locale("es"));
        SUPPORTED_RFC5646_LOCALES.put("es", new Locale("es"));
        SUPPORTED_LOCALES.put(Locale.GERMAN.toString(), Locale.GERMAN);
        SUPPORTED_RFC5646_LOCALES.put(String.valueOf(Locale.GERMAN.getLanguage()) + '-' + Locale.GERMAN.getCountry(), Locale.GERMAN);
        SUPPORTED_LOCALES.put(Locale.FRENCH.toString(), Locale.FRENCH);
        SUPPORTED_RFC5646_LOCALES.put(String.valueOf(Locale.FRENCH.getLanguage()) + '-' + Locale.FRENCH.getCountry(), Locale.FRENCH);
        SUPPORTED_LOCALES.put(Locale.ITALIAN.toString(), Locale.ITALIAN);
        SUPPORTED_RFC5646_LOCALES.put(String.valueOf(Locale.ITALIAN.getLanguage()) + '-' + Locale.ITALIAN.getCountry(), Locale.ITALIAN);
        SUPPORTED_LOCALES.put(Locale.JAPANESE.toString(), Locale.JAPANESE);
        SUPPORTED_RFC5646_LOCALES.put(String.valueOf(Locale.JAPANESE.getLanguage()) + '-' + Locale.JAPANESE.getCountry(), Locale.JAPANESE);
        SUPPORTED_LOCALES.put(Locale.KOREAN.toString(), Locale.KOREAN);
        SUPPORTED_RFC5646_LOCALES.put(String.valueOf(Locale.KOREAN.getLanguage()) + '-' + Locale.KOREAN.getCountry(), Locale.KOREAN);
        SUPPORTED_LOCALES.put("pt_BR", new Locale("pt", "BR"));
        SUPPORTED_RFC5646_LOCALES.put("pt-BR", SUPPORTED_LOCALES.get("pt_BR"));
        SUPPORTED_LOCALES.put("ru", new Locale("ru"));
        SUPPORTED_RFC5646_LOCALES.put("ru", SUPPORTED_LOCALES.get("ru"));
        SUPPORTED_LOCALES.put(Locale.SIMPLIFIED_CHINESE.toString(), Locale.SIMPLIFIED_CHINESE);
        SUPPORTED_RFC5646_LOCALES.put(String.valueOf(Locale.SIMPLIFIED_CHINESE.getLanguage()) + '-' + Locale.SIMPLIFIED_CHINESE.getCountry(), Locale.SIMPLIFIED_CHINESE);
        SUPPORTED_LOCALES.put(Locale.TRADITIONAL_CHINESE.toString(), Locale.TRADITIONAL_CHINESE);
        SUPPORTED_RFC5646_LOCALES.put(String.valueOf(Locale.TRADITIONAL_CHINESE.getLanguage()) + '-' + Locale.TRADITIONAL_CHINESE.getCountry(), Locale.TRADITIONAL_CHINESE);
        CLASSES_MAP = new ConcurrentHashMap<ClassLoader, ConcurrentMap<String, AbstractMessages>>();
    }

    public static void releaseForContext() {
        CLASSES_MAP.remove(AbstractMessages.getCurrentContext());
    }

    private static ClassLoader getCurrentContext() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        return AbstractMessages.getClassClassLoader();
    }

    private static ClassLoader getClassClassLoader() {
        ClassLoader cl = AbstractMessages.class.getClassLoader();
        return cl != null ? cl : ClassLoader.getSystemClassLoader();
    }

    public static AbstractMessages getMessageClassInstance(Class<? extends AbstractMessages> msgClass) {
        ConcurrentMap<String, AbstractMessages> messageClasses = AbstractMessages.getMessageClasses();
        AbstractMessages msgInstance = (AbstractMessages)messageClasses.get(msgClass.getName());
        if (msgInstance == null) {
            try {
                msgInstance = msgClass.newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.warn((Object)("Could not construct message class " + msgClass.getName()), (Throwable)e);
                msgInstance = NotFoundMessageClass.INSTANCE;
            }
            catch (IllegalAccessException e) {
                LOGGER.warn((Object)("Could not construct message class " + msgClass.getName()), (Throwable)e);
                msgInstance = NotFoundMessageClass.INSTANCE;
            }
            messageClasses.put(msgClass.getName(), msgInstance);
        }
        return msgInstance;
    }

    private static ConcurrentMap<String, AbstractMessages> getMessageClasses() {
        ConcurrentHashMap nmsg;
        ClassLoader cl = AbstractMessages.getCurrentContext();
        ConcurrentHashMap msgClasses = (ConcurrentHashMap)CLASSES_MAP.get(cl);
        if (msgClasses == null && (msgClasses = (ConcurrentMap)CLASSES_MAP.putIfAbsent(cl, nmsg = new ConcurrentHashMap())) == null) {
            msgClasses = nmsg;
        }
        return msgClasses;
    }

    private static AbstractMessages getMessageClassInstance(String className) {
        ConcurrentMap<String, AbstractMessages> messageClasses = AbstractMessages.getMessageClasses();
        AbstractMessages msgClassInstance = (AbstractMessages)messageClasses.get(className);
        if (msgClassInstance != null) {
            return msgClassInstance;
        }
        ClassLoader currentContext = AbstractMessages.getCurrentContext();
        try {
            try {
                Class<?> msgClass = Class.forName(className, true, currentContext);
                return AbstractMessages.getMessageClassInstance(msgClass);
            }
            catch (ClassNotFoundException e) {
                try {
                    ClassLoader classLoader = AbstractMessages.getClassClassLoader();
                    if (classLoader != currentContext) {
                        Class<?> msgClass = Class.forName(className, true, classLoader);
                        return AbstractMessages.getMessageClassInstance(msgClass);
                    }
                    throw e;
                }
                catch (ClassNotFoundException e2) {
                    LOGGER.warn((Object)"", (Throwable)e2);
                    msgClassInstance = messageClasses.putIfAbsent(className, NotFoundMessageClass.INSTANCE);
                    if (msgClassInstance != null) {
                        return msgClassInstance;
                    }
                    return NotFoundMessageClass.INSTANCE;
                }
            }
        }
        catch (ClassCastException e) {
            LOGGER.warn((Object)"", (Throwable)e);
            msgClassInstance = messageClasses.putIfAbsent(className, NotFoundMessageClass.INSTANCE);
            if (msgClassInstance != null) {
                return msgClassInstance;
            }
            return NotFoundMessageClass.INSTANCE;
        }
    }

    public static Translate getTranslateForString(String string, Class<? extends AbstractMessages> msgsClass) {
        if (string == null || !string.startsWith("%nls.")) {
            return null;
        }
        int keyend = string.indexOf(32, "%nls.".length());
        String key = keyend != -1 ? string.substring("%nls.".length(), keyend) : string.substring("%nls.".length());
        return new Translate(key, string.substring(keyend + 1), msgsClass);
    }

    public abstract String getStringMethod(String var1);

    public abstract String getStringMethod(String var1, Locale var2);

    public abstract String getStringWithDefaultMethod(String var1, String var2, Locale var3);

    public static String getDefaultLanguage() {
        return Locale.getDefault().toString();
    }

    public static Locale getSupportedLocale(String locale) {
        if (UtilitiesCommon.isEmptyString(locale)) {
            locale = SessionHandler.getSessionHandler().getLocale().toString();
        }
        if (locale.indexOf(45) == -1) {
            return AbstractMessages.searchLocale(locale, SUPPORTED_LOCALES, '_');
        }
        return AbstractMessages.searchLocale(locale, SUPPORTED_RFC5646_LOCALES, '-');
    }

    public static Locale getAsLocale(String locale) {
        if (UtilitiesCommon.isEmptyString(locale)) {
            return null;
        }
        int sepNdx = locale.indexOf(45);
        int sep = sepNdx == -1 ? 95 : 45;
        String lang = locale;
        String country = "";
        String variant = "";
        if (sepNdx > -1) {
            int strt;
            lang = locale.substring(0, sepNdx);
            if ((sepNdx = lang.indexOf(sep, strt = sepNdx + 1)) > -1) {
                country = locale.substring(strt, sepNdx);
                variant = locale.substring(sepNdx + 1);
            } else {
                country = locale.substring(strt);
            }
        }
        return new Locale(lang, country, variant);
    }

    private static Locale searchLocale(String locale, Map<String, Locale> supported, char separator) {
        do {
            if (!supported.containsKey(locale)) continue;
            return supported.get(locale);
        } while ((locale = AbstractMessages.trimLocale(locale, separator)).length() > 0);
        return Locale.ENGLISH;
    }

    public static Locale getSupportedLocale(Locale locale) {
        String localeString = AbstractMessages.getSupportedLocale(locale.toString()).toString();
        String[] s = localeString.split("_");
        if (s.length == 2) {
            return new Locale(s[0], s[1]);
        }
        return new Locale(s[0]);
    }

    private static String trimLocale(String locale, char separator) {
        int lstSep = locale.lastIndexOf(separator);
        if (lstSep > 1) {
            return locale.substring(0, lstSep);
        }
        return "";
    }

    public static String[] formatStoredMessage(StoredMessage storedMessage) {
        Locale locale = SessionHandler.getSessionHandler().getLocale();
        return AbstractMessages.formatStoredMessage(storedMessage, locale, RAMDateFormat.getDateTimeInstance());
    }

    public static String formSingleString(String ... msgs) {
        return AbstractMessages.formSingleString(" ", msgs);
    }

    public static String formSingleString(String separator, String ... msgs) {
        if (msgs == null) {
            return "";
        }
        if (msgs.length == 0) {
            return "";
        }
        if (msgs.length == 1) {
            return msgs[0];
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(msg);
            ++n2;
        }
        return sb.toString();
    }

    public static String[] formatStoredMessage(StoredMessage storedMessage, Locale locale, DateFormat df) {
        if (df == null) {
            df = RAMDateFormat.getDateTimeInstance(locale);
        }
        String className = storedMessage.getBundleName();
        List<StoredMessage.Message> messages = storedMessage.getMessages();
        AbstractMessages mClass = !UtilitiesCommon.isEmptyString(className) ? AbstractMessages.getMessageClassInstance(className) : null;
        ArrayList<String> formattedMessages = new ArrayList<String>(messages.size());
        int i = 0;
        while (i < messages.size()) {
            block18: {
                AbstractMessages msgOverride;
                StoredMessage.Message message = messages.get(i);
                String msgBundleOverride = message.getRealizedBundleName();
                if (!UtilitiesCommon.isEmptyString(msgBundleOverride)) {
                    msgOverride = AbstractMessages.getMessageClassInstance(msgBundleOverride);
                    if (msgOverride instanceof NotFoundMessageClass) {
                        msgOverride = mClass;
                    }
                } else {
                    msgOverride = mClass;
                }
                String nlsKey = message.getNlsKey();
                if (msgOverride != null && !UtilitiesCommon.isEmptyString(nlsKey)) {
                    try {
                        String format;
                        String defValue = message.getDefaultValue();
                        if (defValue == null) {
                            defValue = UNKNOWN_MSG;
                        }
                        if (!UNKNOWN_MSG.equals(format = msgOverride.getStringWithDefaultMethod(nlsKey, defValue, locale))) {
                            formattedMessages.add(MessageFormat.format(format, AbstractMessages.getVariables(msgOverride, locale, df, message.getValues())));
                            break block18;
                        }
                        Object[] variables = AbstractMessages.getVariables(msgOverride, locale, df, message.getValues());
                        if (variables.length == 0) {
                            formattedMessages.add(MessageFormat.format(format, variables));
                            break block18;
                        }
                        StringBuilder sb = new StringBuilder(format);
                        sb.append(": variables - ");
                        int j = 0;
                        while (j < variables.length) {
                            if (j != 0) {
                                sb.append(", ");
                            }
                            sb.append('{');
                            sb.append(j);
                            sb.append('}');
                            ++j;
                        }
                        formattedMessages.add(MessageFormat.format(sb.toString(), variables));
                    }
                    catch (NullPointerException nullPointerException) {
                        LOGGER.error((Object)("Message " + i + ". Null key in StoredMessage " + storedMessage.toString()));
                    }
                } else {
                    List<Object> values = message.getValues();
                    if (values.size() == 1 && values.get(0) != null) {
                        if (!(values.get(0) instanceof StoredMessage)) {
                            formattedMessages.add(values.get(0).toString());
                        } else {
                            Collections.addAll(formattedMessages, AbstractMessages.formatStoredMessage((StoredMessage)values.get(0), locale, df));
                        }
                    } else {
                        formattedMessages.add("unknown");
                    }
                }
            }
            ++i;
        }
        return formattedMessages.toArray(new String[formattedMessages.size()]);
    }

    public static String[] formatStoredMessage(String databaseString, Locale locale) {
        StoredMessage storedMessage = StoredMessage.createFromSerializedStoredMessage(databaseString);
        DateFormat df = RAMDateFormat.getDateTimeInstance(locale);
        return AbstractMessages.formatStoredMessage(storedMessage, locale, df);
    }

    public static String[] formatStoredMessage(String databaseString) {
        return AbstractMessages.formatStoredMessage(databaseString, SessionHandler.getSessionHandler().getLocale());
    }

    static Object[] getVariables(AbstractMessages mClass, Locale locale, DateFormat df, List<?> list) {
        ArrayList<String> variables = new ArrayList<String>(list.size());
        for (Object o : list) {
            if (o instanceof StoredMessage.Message) {
                AbstractMessages msgOverride;
                StoredMessage.Message m = (StoredMessage.Message)o;
                String msgBundleOverride = m.getBundleName();
                if (!UtilitiesCommon.isEmptyString(msgBundleOverride)) {
                    msgOverride = AbstractMessages.getMessageClassInstance(msgBundleOverride);
                    if (msgOverride instanceof NotFoundMessageClass) {
                        msgOverride = mClass;
                    }
                } else {
                    msgOverride = mClass;
                }
                variables.add(MessageFormat.format(msgOverride.getStringWithDefaultMethod(m.getNlsKey(), m.getDefaultValue(), locale), AbstractMessages.getVariables(msgOverride, locale, df, m.getValues())));
                continue;
            }
            if (o instanceof StoredMessage) {
                Collections.addAll(variables, AbstractMessages.formatStoredMessage((StoredMessage)o, locale, df));
                continue;
            }
            if (o instanceof Date) {
                variables.add(df.format((Date)o));
                continue;
            }
            variables.add(o.toString());
        }
        return variables.toArray();
    }

    public static class Translate {
        private String key;
        private String defaultString;
        private AbstractMessages msgInstance;

        Translate(String key, String defaultString, Class<? extends AbstractMessages> msgClass) {
            this.key = key;
            this.defaultString = defaultString;
            this.msgInstance = AbstractMessages.getMessageClassInstance(msgClass);
        }

        public String getString() {
            return this.msgInstance.getStringWithDefaultMethod(this.key, this.defaultString, null);
        }

        public String getString(Locale locale) {
            return this.msgInstance.getStringWithDefaultMethod(this.key, this.defaultString, locale);
        }

        public StoredMessage.Message getMessage(StoredMessage storedMessage) {
            StoredMessage storedMessage2 = storedMessage;
            storedMessage2.getClass();
            return new StoredMessage.Message(storedMessage2, this.key, null, this.msgInstance.getClass().getName(), this.defaultString);
        }

        public static Object getMessageVariable(StoredMessage storedMessage, String definedString, Translate translate) {
            return translate == null ? definedString : translate.getMessage(storedMessage);
        }
    }
}

