/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.data;

import com.ibm.ram.internal.jaxb.Asset;
import com.ibm.ram.internal.jaxb.ConfigurationDetail;
import com.ibm.ram.internal.jaxb.EventConfiguration;
import com.ibm.ram.internal.jaxb.EventType;
import com.ibm.ram.internal.jaxb.User;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="event", namespace="http://jazz.net/xmlns/ecalm/ram/internal/v7.2")
public class Event {
    private EventConfiguration fEventConfiguration;
    private String fName;
    private String fDescription;
    private Asset fAsset;
    private User fUser;

    public Event() {
        this.fEventConfiguration = new EventConfiguration();
    }

    public Event(EventType type, String name, String description) {
        this();
        this.fEventConfiguration.setType(type);
        this.fName = name;
        this.fDescription = description;
    }

    public Event(EventConfiguration config, String name, String description) {
        this.fEventConfiguration = config;
        this.fName = name;
        this.fDescription = description;
    }

    public EventConfiguration getEventConfiguration() {
        return this.fEventConfiguration;
    }

    public void setEventConfiguration(EventConfiguration eventConfiguration) {
        this.fEventConfiguration = eventConfiguration;
    }

    @XmlAttribute(name="type", namespace="http://jazz.net/xmlns/ecalm/ram/internal/v7.2")
    public EventType getType() {
        return this.fEventConfiguration.getType();
    }

    public void setType(EventType type) {
        this.fEventConfiguration.setType(type);
    }

    @XmlElement(name="name", namespace="http://jazz.net/xmlns/ecalm/ram/internal/v7.2")
    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    @XmlElement(name="description", namespace="http://jazz.net/xmlns/ecalm/ram/internal/v7.2")
    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public Asset getAsset() {
        return this.fAsset;
    }

    public void setAsset(Asset asset) {
        this.fAsset = asset;
    }

    public User getUser() {
        return this.fUser;
    }

    public void setUser(User user) {
        this.fUser = user;
    }

    protected static String getConfigDetailValue(EventConfiguration eventConfig, String key) {
        String ret = null;
        int i = eventConfig.getConfigurationDetails().size() - 1;
        while (i >= 0) {
            ConfigurationDetail detail = eventConfig.getConfigurationDetails().get(i);
            if (key.equals(detail.getKey())) {
                if (detail.getValues().size() <= 0) break;
                ret = detail.getValues().get(detail.getValues().size() - 1);
                break;
            }
            --i;
        }
        return ret;
    }

    protected static List<String> getConfigDetailValues(EventConfiguration eventConfig, String key) {
        List<String> ret = null;
        int i = eventConfig.getConfigurationDetails().size() - 1;
        while (i >= 0) {
            ConfigurationDetail detail = eventConfig.getConfigurationDetails().get(i);
            if (key.equals(detail.getKey())) {
                ret = detail.getValues();
                break;
            }
            --i;
        }
        return ret;
    }

    protected static void setConfigDetailValue(EventConfiguration eventConfig, String key, String value) {
        ArrayList<String> vals = null;
        if (value != null) {
            vals = new ArrayList<String>();
            vals.add(value);
        }
        Event.setConfigDetailValues(eventConfig, key, vals);
    }

    protected static void setConfigDetailValues(EventConfiguration eventConfig, String key, List<String> values) {
        ConfigurationDetail cDetial = null;
        for (ConfigurationDetail detail : eventConfig.getConfigurationDetails()) {
            if (!key.equals(detail.getKey())) continue;
            cDetial = detail;
            break;
        }
        if (cDetial != null && values == null) {
            eventConfig.getConfigurationDetails().remove(cDetial);
        } else if (cDetial != null) {
            cDetial.getValues().clear();
            cDetial.getValues().addAll(values);
        } else {
            ConfigurationDetail detail;
            detail = new ConfigurationDetail();
            detail.setKey(key);
            detail.getValues().addAll(values);
            eventConfig.getConfigurationDetails().add(detail);
        }
    }
}

