/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.CircularReferenceException;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.ObjectTypePair;
import com.google.gson.Preconditions;
import com.google.gson.Primitives;
import com.google.gson.TypeInfo;
import com.google.gson.TypeInfoFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

final class ObjectNavigator {
    private final ExclusionStrategy exclusionStrategy;
    private final ObjectTypePair objTypePair;

    ObjectNavigator(ObjectTypePair objTypePair, ExclusionStrategy exclusionStrategy) {
        Preconditions.checkNotNull(exclusionStrategy);
        this.objTypePair = objTypePair;
        this.exclusionStrategy = exclusionStrategy;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void accept(Visitor visitor) {
        Object objectToVisit;
        TypeInfo objTypeInfo = new TypeInfo(this.objTypePair.getType());
        if (this.exclusionStrategy.shouldSkipClass(objTypeInfo.getRawClass())) {
            return;
        }
        boolean visitedWithCustomHandler = visitor.visitUsingCustomHandler(this.objTypePair);
        if (visitedWithCustomHandler) return;
        Object obj = this.objTypePair.getObject();
        Object object = objectToVisit = obj == null ? visitor.getTarget() : obj;
        if (objectToVisit == null) {
            return;
        }
        this.objTypePair.setObject(objectToVisit);
        try {
            visitor.start(this.objTypePair);
        }
        catch (CircularReferenceException circularReferenceException) {
            return;
        }
        try {
            block13: {
                Class<?> curr;
                block12: {
                    Class<?> topLevelClass;
                    if (objTypeInfo.isArray()) {
                        visitor.visitArray(objectToVisit, this.objTypePair.getType());
                        return;
                    }
                    if (objTypeInfo.getActualType() == Object.class && this.isPrimitiveOrString(objectToVisit)) {
                        visitor.visitPrimitive(objectToVisit);
                        objectToVisit = visitor.getTarget();
                        return;
                    }
                    visitor.startVisitingObject(objectToVisit);
                    ObjectTypePair currObjTypePair = this.objTypePair.toMoreSpecificType();
                    curr = topLevelClass = new TypeInfo(currObjTypePair.getType()).getRawClass();
                    if (!true) break block12;
                    if (curr == null) return;
                    if (curr.equals(Object.class)) break block13;
                }
                do {
                    if (!curr.isSynthetic()) {
                        this.navigateClassFields(objectToVisit, curr, visitor);
                    }
                    curr = curr.getSuperclass();
                    if (curr == null) return;
                } while (!curr.equals(Object.class));
            }
            return;
        }
        finally {
            visitor.end(this.objTypePair);
        }
    }

    private boolean isPrimitiveOrString(Object objectToVisit) {
        Class<?> realClazz = objectToVisit.getClass();
        return realClazz == Object.class || realClazz == String.class || Primitives.unwrap(realClazz).isPrimitive();
    }

    private void navigateClassFields(Object obj, Class<?> clazz, Visitor visitor) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        AccessibleObject[] accessibleObjectArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            TypeInfo fieldTypeInfo;
            Type declaredTypeOfField;
            boolean visitedWithCustomHandler;
            AccessibleObject f = accessibleObjectArray[n2];
            FieldAttributes fieldAttributes = new FieldAttributes((Field)f);
            if (!(this.exclusionStrategy.shouldSkipField(fieldAttributes) || this.exclusionStrategy.shouldSkipClass(fieldAttributes.getDeclaredClass()) || (visitedWithCustomHandler = visitor.visitFieldUsingCustomHandler((Field)f, declaredTypeOfField = (fieldTypeInfo = TypeInfoFactory.getTypeInfoForField((Field)f, this.objTypePair.getType())).getActualType(), obj)))) {
                if (fieldTypeInfo.isArray()) {
                    visitor.visitArrayField((Field)f, declaredTypeOfField, obj);
                } else {
                    visitor.visitObjectField((Field)f, declaredTypeOfField, obj);
                }
            }
            ++n2;
        }
    }

    public static interface Visitor {
        public void start(ObjectTypePair var1);

        public void end(ObjectTypePair var1);

        public void startVisitingObject(Object var1);

        public void visitArray(Object var1, Type var2);

        public void visitObjectField(Field var1, Type var2, Object var3);

        public void visitArrayField(Field var1, Type var2, Object var3);

        public boolean visitUsingCustomHandler(ObjectTypePair var1);

        public boolean visitFieldUsingCustomHandler(Field var1, Type var2, Object var3);

        public Object getTarget();

        public void visitPrimitive(Object var1);
    }
}

