/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.InputStreamInformation;
import com.ibm.ram.defaultprofile.Artifact;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class LocalFileArtifact
extends RAMArtifact {
    private File fLocalFile;

    public LocalFileArtifact(File file) {
        this.fLocalFile = file;
        if (file != null) {
            this.setName(file.getName());
        }
    }

    LocalFileArtifact(File file, RAMAsset asset, String path, Artifact internalServiceArtifact) {
        super(asset, path, internalServiceArtifact);
        this.fLocalFile = file;
    }

    public InputStream getContents() throws RAMRuntimeException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.getFile());
        }
        catch (Throwable e) {
            if (e instanceof RAMRuntimeException) {
                throw (RAMRuntimeException)e;
            }
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        return fis;
    }

    public InputStreamInformation getContents(boolean infoOnly) {
        try {
            InputStreamInformation isinfo = !infoOnly ? InputStreamInformation.create(this.getFile()) : InputStreamInformation.createInfoOnly(this.getFile());
            isinfo.setFilePath(null);
            return isinfo;
        }
        catch (Throwable e) {
            if (e instanceof RAMRuntimeException) {
                throw (RAMRuntimeException)e;
            }
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public File getFile() {
        return this.fLocalFile;
    }

    @Override
    public long getCreationDate() {
        return this.fLocalFile.lastModified();
    }

    @Override
    public long getSize() {
        return this.fLocalFile.length();
    }
}

