/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMCategorySchema;
import com.ibm.ram.client.RAMSubCategory;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.CategorySchema;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Descriptor;
import com.ibm.ram.defaultprofile.FreeFormDescriptor;
import com.ibm.ram.defaultprofile.FreeFormValue;
import com.ibm.ram.defaultprofile.NodeDescriptor;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.AssetUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;

public class RAMCategory
extends Category {
    private static final Logger logger = Logger.getLogger(RAMSubCategory.class.getName());
    private boolean fUpdate = true;
    private boolean fDirty = false;
    private boolean fDelete = false;
    private boolean fReadOnly = true;
    private Descriptor fDescriptor;
    private RAMCategorySchema fCategorySchema;
    private Map fSubCategoriesByName;
    boolean isNodeDescriptor;
    boolean isFreeFormDescriptor;

    RAMCategory(RAMCategorySchema schema, FreeFormValue freeFormValue) {
        this.fCategorySchema = schema;
        this.fDescriptor = freeFormValue.getFreeFormDescriptor();
        this.isFreeFormDescriptor = true;
        this.fReadOnly = true;
        SubCategory[] children = new RAMSubCategory[]{new RAMSubCategory(this, freeFormValue)};
        this.fSubCategoriesByName = new HashMap();
        this.fSubCategoriesByName.put(freeFormValue.getValue(), children[0]);
        super.setSubCategories(children);
    }

    RAMCategory(RAMCategorySchema schema, Descriptor internalDescriptor, boolean readOnly) {
        this.fCategorySchema = schema;
        this.fDescriptor = internalDescriptor;
        if (internalDescriptor instanceof NodeDescriptor) {
            this.isNodeDescriptor = true;
        } else if (internalDescriptor instanceof FreeFormDescriptor) {
            this.isFreeFormDescriptor = true;
        }
        this.fReadOnly = readOnly;
    }

    RAMCategory(RAMCategorySchema schema, String name) {
        this.fCategorySchema = schema;
        NodeDescriptor nodeDescriptor = DefaultprofileFactory.eINSTANCE.createNodeDescriptor();
        nodeDescriptor.setClassificationSchema(schema.getInternalClassificationSchema());
        nodeDescriptor.setName(name);
        schema.getInternalClassificationSchema().addDescriptor(nodeDescriptor);
        this.fDescriptor = nodeDescriptor;
        this.isNodeDescriptor = true;
        this.fReadOnly = false;
        this.fUpdate = false;
        this.fDirty = true;
    }

    public boolean isExclusive() {
        boolean ret = false;
        ret = this.fDescriptor instanceof NodeDescriptor ? ((NodeDescriptor)this.fDescriptor).isExclusive() : true;
        return ret;
    }

    public void setExclusive(boolean exclusive) {
        if (this.fDescriptor instanceof NodeDescriptor) {
            ((NodeDescriptor)this.fDescriptor).setExclusive(exclusive);
            this.setDirty(true);
        } else {
            logger.warning(this.fDescriptor + " has no exclusivity setting");
        }
    }

    public void delete() {
        this.fDelete = true;
        this.setDirty(true);
    }

    Descriptor getInternalDescriptor() {
        return this.fDescriptor;
    }

    NodeDescriptor getInternalNodeDescriptor() {
        return (NodeDescriptor)this.fDescriptor;
    }

    FreeFormDescriptor getInternalFreeFormDescriptor() {
        return (FreeFormDescriptor)this.fDescriptor;
    }

    public RAMSubCategory createSubCategory(String name) {
        if (this.fReadOnly) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMCategory.0"), true);
        }
        if (this.fSubCategoriesByName == null) {
            this.initCategoryCache();
        }
        RAMSubCategory ret = new RAMSubCategory(this, name);
        this.fSubCategoriesByName.put(name, ret);
        SubCategory[] subCategories = this.fSubCategoriesByName.values().toArray(new RAMSubCategory[this.fSubCategoriesByName.size()]);
        super.setSubCategories(subCategories);
        RAMCategorySchema schema = (RAMCategorySchema)this.getSchema();
        schema.getSession().cache(schema);
        this.setDirty(true);
        return ret;
    }

    @Override
    public SubCategory[] getSubCategories() {
        if (super.getSubCategories() == null) {
            this.initCategoryCache();
        }
        return super.getSubCategories();
    }

    @Override
    public SubCategory getSubCategory(String name) {
        int index;
        if (this.fSubCategoriesByName == null) {
            this.initCategoryCache();
        }
        if ((index = RAMSubCategory.hasSubCategory(name)) != -1) {
            String subCatName = RAMSubCategory.decodeSubCategoryName(name.substring(0, index));
            String remainingPath = name.substring(index + 1);
            RAMSubCategory subCat = (RAMSubCategory)this.fSubCategoriesByName.get(subCatName);
            if (subCat == null) {
                return null;
            }
            return subCat.getSubCategory(remainingPath);
        }
        RAMSubCategory subCat = (RAMSubCategory)this.fSubCategoriesByName.get(RAMSubCategory.decodeSubCategoryName(name));
        return subCat;
    }

    void addSubCategory(RAMSubCategory subCategory) {
        if (this.fSubCategoriesByName == null) {
            this.initCategoryCache();
        }
        RAMSubCategory[] curCats = (RAMSubCategory[])this.getSubCategories();
        SubCategory[] newCats = new RAMSubCategory[curCats.length + 1];
        System.arraycopy(curCats, 0, newCats, 0, curCats.length);
        newCats[curCats.length] = subCategory;
        this.fSubCategoriesByName.put(subCategory.getName(), subCategory);
        super.setSubCategories(newCats);
    }

    void removeSubCategory(RAMSubCategory subCategory) {
        if (this.fSubCategoriesByName == null) {
            this.initCategoryCache();
        }
        if (this.fSubCategoriesByName.containsKey(subCategory.getName())) {
            RAMSubCategory[] curCats = (RAMSubCategory[])this.getSubCategories();
            SubCategory[] newCats = new RAMSubCategory[curCats.length - 1];
            boolean found = false;
            int i = 0;
            while (i < curCats.length) {
                if (!found && subCategory.getName().equals(curCats[i].getName())) {
                    found = true;
                } else if (!found && !subCategory.getName().equals(curCats[i].getName()) && i - 1 < newCats.length) {
                    newCats[i] = curCats[i];
                } else if (i - 1 < newCats.length) {
                    newCats[i - 1] = curCats[i];
                }
                ++i;
            }
            if (!found) {
                throw new RAMRuntimeException("Sub Category " + subCategory.getName() + " was never found to delete");
            }
            this.fSubCategoriesByName.remove(subCategory.getName());
            if (this.fDescriptor instanceof NodeDescriptor && subCategory.getInternalNodeDescriptor() != null) {
                ((NodeDescriptor)this.fDescriptor).getSpecific().remove((Object)subCategory.getInternalNodeDescriptor());
            }
            super.setSubCategories(newCats);
        }
    }

    private void initCategoryCache() throws RAMRuntimeException {
        this.fSubCategoriesByName = new HashMap();
        if (this.fReadOnly) {
            super.setSubCategories(new RAMSubCategory[0]);
        } else if (this.isFreeFormDescriptor) {
            super.setSubCategories(new RAMSubCategory[0]);
        } else {
            EList internalDescriptors = this.getInternalNodeDescriptor().getSpecific();
            if (internalDescriptors != null) {
                SubCategory[] tmpArray = new RAMSubCategory[internalDescriptors.size()];
                int i = 0;
                while (i < internalDescriptors.size()) {
                    NodeDescriptor descriptor = (NodeDescriptor)internalDescriptors.get(i);
                    tmpArray[i] = new RAMSubCategory(this, this.getChildPath(descriptor), descriptor);
                    this.fSubCategoriesByName.put(((RAMSubCategory)tmpArray[i]).getName(), tmpArray[i]);
                    ++i;
                }
                super.setSubCategories(tmpArray);
            } else {
                super.setSubCategories(new RAMSubCategory[0]);
            }
        }
    }

    protected String getChildPath(Descriptor descriptor) {
        return RAMSubCategory.encodeSubCategoryName(descriptor.getName());
    }

    public CategorySchema getSchema() {
        return this.fCategorySchema;
    }

    @Override
    public String getName() {
        return this.fDescriptor.getName();
    }

    String getSessionKey() {
        return String.valueOf(this.getSchema().getURI()) + "#" + this.getName();
    }

    public String toString() {
        return this.getName();
    }

    void setDirty(boolean dirtyFlag) {
        this.fDirty = dirtyFlag;
        if (dirtyFlag) {
            ((RAMCategorySchema)this.getSchema()).setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    boolean isUpdate() {
        return this.fUpdate;
    }

    boolean isDelete() {
        return this.fDelete;
    }

    @Override
    public void setName(String name) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMCategory.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setSubCategories(SubCategory[] categories) {
        if (this.fReadOnly) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMCategory.0"), true);
        }
        SubCategory[] newSubCategories = new RAMSubCategory[categories.length];
        List<SubCategory> curSubCategories = AssetUtil.createList(this.getSubCategories());
        int i = 0;
        while (i < categories.length) {
            String name = categories[i].getName();
            RAMSubCategory existingSubCat = null;
            int j = 0;
            while (j < curSubCategories.size()) {
                RAMSubCategory curSubCat = (RAMSubCategory)curSubCategories.get(j);
                if (name.equals(curSubCat.getName())) {
                    existingSubCat = curSubCat;
                    curSubCategories.remove(curSubCat);
                    break;
                }
                ++j;
            }
            if (existingSubCat == null) {
                existingSubCat = this.createSubCategory(name);
            }
            SubCategory[] chlidren = categories[i].getSubCategories();
            existingSubCat.setSubCategories(chlidren);
            newSubCategories[i] = existingSubCat;
            ++i;
        }
        i = 0;
        while (i < curSubCategories.size()) {
            RAMSubCategory subCat = (RAMSubCategory)curSubCategories.get(i);
            this.removeSubCategory(subCat);
            ++i;
        }
        super.setSubCategories(newSubCategories);
        this.setDirty(true);
    }
}

