/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMCategory;
import com.ibm.ram.client.RAMCategorySchema;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Descriptor;
import com.ibm.ram.defaultprofile.FreeFormDescriptor;
import com.ibm.ram.defaultprofile.FreeFormValue;
import com.ibm.ram.defaultprofile.NodeDescriptor;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.AssetUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class RAMSubCategory
extends SubCategory {
    private static final Logger logger = Logger.getLogger(RAMSubCategory.class.getName());
    private NodeDescriptor fNodeDescriptor;
    private FreeFormValue fFreeFormValue;
    private Map fSubCategoriesByName;
    private RAMCategory fCategory;
    private String fCategorization;
    private boolean fDirty;
    private boolean fUpdate;
    private boolean fReadOnly;
    private static Pattern REMOVE_BACK_SLASH_REGEX = Pattern.compile("\\\\(.)");

    RAMSubCategory(RAMCategory category, String categorization, NodeDescriptor internalDescriptor) {
        this.fCategory = category;
        this.fNodeDescriptor = internalDescriptor;
        this.internalSetCategorization(categorization);
        this.fUpdate = true;
    }

    RAMSubCategory(RAMCategory category, FreeFormValue freeFormValue) {
        this.fCategory = category;
        this.fFreeFormValue = freeFormValue;
        this.internalSetCategorization(RAMSubCategory.encodeSubCategoryName(freeFormValue.getValue()));
        this.fReadOnly = true;
        super.setSet(true);
        this.fUpdate = true;
    }

    RAMSubCategory(NodeDescriptor internalDescriptor, boolean set) {
        this.fNodeDescriptor = internalDescriptor;
        super.setSet(set);
        this.fReadOnly = true;
        this.fUpdate = true;
    }

    RAMSubCategory(RAMCategory category, String name) {
        NodeDescriptor nodeDescriptor = DefaultprofileFactory.eINSTANCE.createNodeDescriptor();
        nodeDescriptor.setClassificationSchema(((RAMCategorySchema)category.getSchema()).getInternalClassificationSchema());
        nodeDescriptor.setName(name);
        category.getInternalNodeDescriptor().getSpecific().add((Object)nodeDescriptor);
        this.fNodeDescriptor = nodeDescriptor;
        this.fUpdate = false;
        this.setParent(category);
    }

    RAMSubCategory(RAMSubCategory subCategory, String name) {
        this.fCategory = (RAMCategory)subCategory.getCategory();
        NodeDescriptor nodeDescriptor = DefaultprofileFactory.eINSTANCE.createNodeDescriptor();
        nodeDescriptor.setClassificationSchema(((RAMCategorySchema)this.fCategory.getSchema()).getInternalClassificationSchema());
        nodeDescriptor.setName(name);
        subCategory.getInternalNodeDescriptor().getSpecific().add((Object)nodeDescriptor);
        this.fNodeDescriptor = nodeDescriptor;
        this.fUpdate = false;
        this.setParent(subCategory);
    }

    @Override
    public SubCategory[] getSubCategories() {
        if (super.getSubCategories() == null) {
            this.initCategoryCache();
        }
        return super.getSubCategories();
    }

    @Override
    public SubCategory getSubCategory(String name) {
        int index;
        if (this.fSubCategoriesByName == null) {
            this.initCategoryCache();
        }
        if ((index = RAMSubCategory.hasSubCategory(name)) != -1) {
            String subCatName = RAMSubCategory.decodeSubCategoryName(name.substring(0, index));
            String remainingPath = name.substring(index + 1);
            RAMSubCategory subCat = (RAMSubCategory)this.fSubCategoriesByName.get(subCatName);
            if (subCat == null) {
                return null;
            }
            return subCat.getSubCategory(remainingPath);
        }
        RAMSubCategory subCat = (RAMSubCategory)this.fSubCategoriesByName.get(RAMSubCategory.decodeSubCategoryName(name));
        if (subCat == null) {
            return null;
        }
        return subCat;
    }

    static int hasSubCategory(String name) {
        int curIndex = name.indexOf("/");
        int index = 0;
        boolean matchIsValid = false;
        String rest = name;
        while (!matchIsValid && curIndex != -1) {
            boolean bl = matchIsValid = curIndex == 0 || rest.charAt(curIndex - 1) != '\\';
            if (!matchIsValid) {
                index += curIndex + 1;
                rest = rest.substring(curIndex + 1);
                curIndex = rest.indexOf("/");
                continue;
            }
            index += curIndex;
        }
        if (!matchIsValid) {
            index = -1;
        }
        return index;
    }

    static String decodeSubCategoryName(String encodedName) {
        if (encodedName == null) {
            return null;
        }
        String ret = REMOVE_BACK_SLASH_REGEX.matcher(encodedName).replaceAll("$1");
        return ret;
    }

    static String encodeSubCategoryName(String encodedName) {
        if (encodedName == null) {
            return null;
        }
        encodedName = encodedName.replaceAll("\\\\", "\\\\\\\\");
        String ret = encodedName.replaceAll("/", "\\\\/");
        return ret;
    }

    public boolean isExclusive() {
        boolean ret = false;
        if (this.fNodeDescriptor != null) {
            ret = this.fNodeDescriptor.isExclusive();
        } else if (this.fFreeFormValue != null) {
            ret = true;
        }
        return ret;
    }

    public void setExclusive(boolean exclusive) {
        if (this.fNodeDescriptor != null) {
            this.fNodeDescriptor.setExclusive(exclusive);
            this.setDirty(true);
        } else if (this.fFreeFormValue != null) {
            logger.warning("Free form values have no exclusivity setting");
        }
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public Category getCategory() {
        return this.fCategory;
    }

    void setParent(Category category) {
        this.fCategory = (RAMCategory)category;
        this.internalSetCategorization(this.getEncodedName());
    }

    void setParent(RAMSubCategory subCatgeory) {
        this.fCategory = (RAMCategory)subCatgeory.getCategory();
        String cat = String.valueOf(subCatgeory.getCategorization()) + "/" + this.getEncodedName();
        this.internalSetCategorization(cat);
    }

    @Override
    public String getCategorization() {
        return this.fCategorization;
    }

    @Override
    public String getFullPath() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(((RAMCategory)this.getCategory()).getSchema().getName());
        buffer.append("/");
        buffer.append(this.getCategory().getName());
        buffer.append("/");
        buffer.append(this.getCategorization());
        return buffer.toString();
    }

    NodeDescriptor getInternalNodeDescriptor() {
        return this.fNodeDescriptor;
    }

    FreeFormValue getInternalFreeFormValue() {
        return this.fFreeFormValue;
    }

    protected String getChildPath(Descriptor descriptor) {
        return String.valueOf(this.getCategorization()) + "/" + RAMSubCategory.encodeSubCategoryName(descriptor.getName());
    }

    void addSubCategory(RAMSubCategory subCategory) {
        RAMSubCategory[] curCats = (RAMSubCategory[])this.getSubCategories();
        SubCategory[] newCats = new RAMSubCategory[curCats.length + 1];
        System.arraycopy(curCats, 0, newCats, 0, curCats.length);
        newCats[curCats.length] = subCategory;
        this.fSubCategoriesByName.put(subCategory.getName(), subCategory);
        super.setSubCategories(newCats);
    }

    public RAMSubCategory createSubCategory(String name) {
        if (this.fReadOnly) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMSubCategory.0"), true);
        }
        if (this.fSubCategoriesByName == null) {
            this.initCategoryCache();
        }
        RAMSubCategory ret = new RAMSubCategory(this, name);
        this.fSubCategoriesByName.put(name, ret);
        SubCategory[] subCategories = this.fSubCategoriesByName.values().toArray(new RAMSubCategory[this.fSubCategoriesByName.size()]);
        super.setSubCategories(subCategories);
        RAMCategorySchema schema = (RAMCategorySchema)((RAMCategory)this.getCategory()).getSchema();
        schema.getSession().cache(schema);
        this.setDirty(true);
        return ret;
    }

    void setDirty(boolean dirtyFlag) {
        this.fDirty = dirtyFlag;
        if (dirtyFlag) {
            ((RAMCategory)this.getCategory()).setDirty(true);
        }
    }

    void removeSubCategory(RAMSubCategory subCategory) {
        if (this.fSubCategoriesByName.containsKey(subCategory.getName())) {
            RAMSubCategory[] curCats = (RAMSubCategory[])this.getSubCategories();
            SubCategory[] newCats = new RAMSubCategory[curCats.length - 1];
            boolean found = false;
            int i = 0;
            while (i < curCats.length) {
                if (!found && subCategory.getName().equals(curCats[i].getName())) {
                    found = true;
                } else if (!found && !subCategory.getName().equals(curCats[i].getName()) && i - 1 < newCats.length) {
                    newCats[i] = curCats[i];
                } else if (i - 1 < newCats.length) {
                    newCats[i - 1] = curCats[i];
                }
                ++i;
            }
            if (!found) {
                throw new RAMRuntimeException("Sub Category " + subCategory.getName() + " was never found to delete");
            }
            this.fSubCategoriesByName.remove(subCategory.getName());
            if (subCategory.getInternalNodeDescriptor() != null) {
                this.fNodeDescriptor.getSpecific().remove((Object)subCategory.getInternalNodeDescriptor());
            }
            super.setSubCategories(newCats);
        }
    }

    private void initCategoryCache() throws RAMRuntimeException {
        this.fSubCategoriesByName = new HashMap();
        if (this.fReadOnly) {
            super.setSubCategories(new RAMSubCategory[0]);
        } else {
            EList internalDescriptors = this.getInternalNodeDescriptor().getSpecific();
            if (internalDescriptors != null) {
                SubCategory[] tmpArray = new RAMSubCategory[internalDescriptors.size()];
                int i = 0;
                while (i < internalDescriptors.size()) {
                    NodeDescriptor descriptor = (NodeDescriptor)internalDescriptors.get(i);
                    tmpArray[i] = new RAMSubCategory((RAMCategory)this.getCategory(), this.getChildPath(descriptor), descriptor);
                    this.fSubCategoriesByName.put(((RAMSubCategory)tmpArray[i]).getName(), tmpArray[i]);
                    ++i;
                }
                super.setSubCategories(tmpArray);
            } else {
                super.setSubCategories(new RAMSubCategory[0]);
            }
        }
    }

    @Override
    public String getName() {
        String ret = null;
        if (this.fNodeDescriptor != null) {
            ret = this.fNodeDescriptor.getName();
        } else if (this.fFreeFormValue != null) {
            ret = this.fFreeFormValue.getValue();
        }
        return ret;
    }

    public String getEncodedName() {
        return RAMSubCategory.encodeSubCategoryName(this.getName());
    }

    public String toString() {
        if (this.fCategorization == null) {
            String message = MessageFormat.format(ClientMessages.getString("RAMSubCategory.NOT_CATEGORIZED"), this.getName());
            return message;
        }
        return this.getCategorization();
    }

    @Override
    public void setFullPath(String fullPath) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMSubCategory.NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setName(String name) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMSubCategory.NOT_IMPLEMENTED"), true);
    }

    @Override
    public String getId() {
        if (super.getId() == null) {
            if (this.fNodeDescriptor != null) {
                String id = this.fNodeDescriptor.eResource().getURIFragment((EObject)this.fNodeDescriptor);
                super.setId(id);
            } else if (this.fFreeFormValue != null) {
                FreeFormDescriptor ffd = this.fFreeFormValue.getFreeFormDescriptor();
                String id = ffd.eResource().getURIFragment((EObject)ffd);
                super.setId(id);
            }
        }
        return super.getId();
    }

    boolean isUpdate() {
        return this.fUpdate;
    }

    @Override
    public void setCategorization(String categorization) {
        throw new RAMRuntimeException("The client cannot set the catgeorization path");
    }

    private void internalSetCategorization(String categorization) {
        this.fCategorization = categorization;
    }

    @Override
    public void setId(String id) {
        if (this.fReadOnly) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMSubCategory.0"), true);
        }
        if (this.isUpdate()) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMSubCategory.CANNOT_UPDATE_ID"), true);
        }
        if (this.fNodeDescriptor != null) {
            ((XMLResource)this.getResource()).setID((EObject)this.fNodeDescriptor, id);
            super.setId(id);
        } else if (this.fFreeFormValue != null) {
            FreeFormDescriptor ffd = this.fFreeFormValue.getFreeFormDescriptor();
            ((XMLResource)this.getResource()).setID((EObject)ffd, id);
            super.setId(id);
        }
    }

    Resource getResource() {
        Descriptor eObject = this.fFreeFormValue != null ? this.fFreeFormValue.getFreeFormDescriptor() : this.fNodeDescriptor;
        Resource ret = null;
        if (eObject != null) {
            if (eObject.eResource() == null) {
                RAMCategorySchema schema = (RAMCategorySchema)((RAMCategory)this.getCategory()).getSchema();
                schema.getResource();
            }
            ret = eObject.eResource();
        }
        return ret;
    }

    @Override
    public void setSubCategories(SubCategory[] categories) {
        if (this.fReadOnly) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMSubCategory.0"), true);
        }
        if (categories == null) {
            categories = new RAMSubCategory[]{};
        }
        SubCategory[] newSubCategories = new RAMSubCategory[categories.length];
        List<SubCategory> curSubCategories = AssetUtil.createList(this.getSubCategories());
        int i = 0;
        while (i < categories.length) {
            String name = categories[i].getName();
            RAMSubCategory existingSubCat = null;
            int j = 0;
            while (j < curSubCategories.size()) {
                RAMSubCategory curSubCat = (RAMSubCategory)curSubCategories.get(j);
                if (name.equals(curSubCat.getName())) {
                    existingSubCat = curSubCat;
                    curSubCategories.remove(curSubCat);
                    break;
                }
                ++j;
            }
            if (existingSubCat == null) {
                existingSubCat = this.createSubCategory(name);
            }
            SubCategory[] chlidren = categories[i].getSubCategories();
            existingSubCat.setSubCategories(chlidren);
            newSubCategories[i] = existingSubCat;
            ++i;
        }
        i = 0;
        while (i < curSubCategories.size()) {
            RAMSubCategory subCat = (RAMSubCategory)curSubCategories.get(i);
            this.removeSubCategory(subCat);
            ++i;
        }
        super.setSubCategories(newSubCategories);
        this.setDirty(true);
    }

    @Override
    public void setSet(boolean set) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMSubCategory.NOT_IMPLEMENTED"), true);
    }

    void internalMarkSet(boolean set) {
        super.setSet(set);
    }
}

